/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.factories;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.LightStubElementFactory;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodStubFactory
implements LightStubElementFactory<PsiMethodStubImpl, PsiMethod> {
    @NotNull
    public PsiMethodStubImpl createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            JavaMethodStubFactory.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JavaMethodStubFactory.$$$reportNull$$$0(1);
        }
        if (parentStub == null) {
            JavaMethodStubFactory.$$$reportNull$$$0(2);
        }
        String name = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String defValueText = null;
        boolean expectingDef = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (JavaDocElementType.DOC_COMMENT_TOKENS.contains(type)) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type == JavaElementType.PARAMETER_LIST) {
                LighterASTNode pType;
                List params = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)child, (IElementType)JavaElementType.PARAMETER);
                if (params.isEmpty() || (pType = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)((LighterASTNode)params.get(params.size() - 1)), (IElementType)JavaElementType.TYPE)) == null) continue;
                isVarArgs = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)pType, (IElementType)JavaTokenType.ELLIPSIS) != null;
                continue;
            }
            if (type == JavaTokenType.DEFAULT_KEYWORD) {
                expectingDef = true;
                continue;
            }
            if (!expectingDef || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) || type == JavaTokenType.SEMICOLON || type == JavaElementType.CODE_BLOCK) continue;
            defValueText = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)child, null);
            break;
        }
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create(tree, node, parentStub);
        boolean isAnno = node.getTokenType() == JavaElementType.ANNOTATION_METHOD;
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnno, isVarArgs, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiMethodStubImpl(parentStub, name, typeInfo, flags, defValueText);
    }

    public PsiMethod createPsi(@NotNull PsiMethodStubImpl stub) {
        if (stub == null) {
            JavaMethodStubFactory.$$$reportNull$$$0(3);
        }
        return JavaStubElementType.getFileStub(stub).getPsiFactory().createMethod(stub);
    }

    @NotNull
    public PsiMethodStubImpl createStub(@NotNull PsiMethod psi, @Nullable StubElement parentStub) {
        if (psi == null) {
            JavaMethodStubFactory.$$$reportNull$$$0(4);
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/java/stubs/factories/JavaMethodStubFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

