/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullabilitySource;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JavaTypeNullabilityUtil {
    @NotNull
    public static TypeNullability getTypeNullability(@NotNull PsiClassType type) {
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(0);
        }
        return JavaTypeNullabilityUtil.getTypeNullability(type, null, !JavaTypeNullabilityUtil.isLocal(type));
    }

    @NotNull
    private static TypeNullability getTypeNullability(@NotNull PsiClassType type, @Nullable Set<PsiClassType> visited, boolean checkContainer) {
        NullabilityAnnotationInfo typeUseNullability;
        NullableNotNullManager manager;
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(1);
        }
        if (visited != null && visited.contains(type)) {
            TypeNullability typeNullability = TypeNullability.UNKNOWN;
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(2);
            }
            return typeNullability;
        }
        TypeNullability fromAnnotations = JavaTypeNullabilityUtil.getNullabilityFromAnnotations(type.getAnnotations());
        if (!fromAnnotations.equals(TypeNullability.UNKNOWN)) {
            TypeNullability typeNullability = fromAnnotations;
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(3);
            }
            return typeNullability;
        }
        PsiElement context = type.getPsiContext();
        if (context != null && checkContainer && (manager = NullableNotNullManager.getInstance(context.getProject())) != null && (typeUseNullability = manager.findDefaultTypeUseNullability(context)) != null) {
            TypeNullability typeNullability = typeUseNullability.toTypeNullability();
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(4);
            }
            return typeNullability;
        }
        PsiClass target = type.resolve();
        if (target instanceof PsiTypeParameter && context != null) {
            NullableNotNullManager manager2;
            PsiTypeParameter typeParameter = (PsiTypeParameter)target;
            PsiReferenceList extendsList = typeParameter.getExtendsList();
            PsiClassType[] extendTypes = extendsList.getReferencedTypes();
            HashSet<PsiClassType> nextVisited = visited == null ? new HashSet<PsiClassType>() : visited;
            nextVisited.add(type);
            List nullabilities = ContainerUtil.map((Object[])typeParameter.getSuperTypes(), t -> JavaTypeNullabilityUtil.getTypeNullability(t, nextVisited, checkContainer));
            TypeNullability fromSuper = TypeNullability.intersect(nullabilities).inherited();
            if (fromSuper != TypeNullability.UNKNOWN) {
                TypeNullability typeNullability = fromSuper;
                if (typeNullability == null) {
                    JavaTypeNullabilityUtil.$$$reportNull$$$0(5);
                }
                return typeNullability;
            }
            if (extendTypes.length == 0 && checkContainer && (manager2 = NullableNotNullManager.getInstance(typeParameter.getProject())) != null) {
                NullabilityAnnotationInfo effective = manager2.findOwnNullabilityInfo(typeParameter);
                if (effective != null) {
                    TypeNullability typeNullability = effective.toTypeNullability().inherited();
                    if (typeNullability == null) {
                        JavaTypeNullabilityUtil.$$$reportNull$$$0(6);
                    }
                    return typeNullability;
                }
                NullabilityAnnotationInfo typeUseNullability2 = manager2.findDefaultTypeUseNullability(typeParameter);
                if (typeUseNullability2 != null) {
                    TypeNullability typeNullability = typeUseNullability2.toTypeNullability().inherited();
                    if (typeNullability == null) {
                        JavaTypeNullabilityUtil.$$$reportNull$$$0(7);
                    }
                    return typeNullability;
                }
            }
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(8);
        }
        return typeNullability;
    }

    private static boolean isLocal(PsiClassType classType) {
        PsiElement context = classType.getPsiContext();
        return context instanceof PsiJavaCodeReferenceElement && context.getParent() instanceof PsiTypeElement && JavaTypeNullabilityUtil.isLocalVariable(context.getParent().getParent());
    }

    private static boolean isLocalVariable(PsiElement element) {
        return element instanceof PsiLocalVariable || element instanceof PsiParameter && !(element.getParent() instanceof PsiParameterList);
    }

    @NotNull
    public static TypeNullability getNullabilityFromAnnotations(@NotNull @NotNull PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(9);
        }
        for (PsiAnnotation annotation : annotations) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager manager = NullableNotNullManager.getInstance(annotation.getProject());
            if (manager == null) {
                TypeNullability typeNullability = TypeNullability.UNKNOWN;
                if (typeNullability == null) {
                    JavaTypeNullabilityUtil.$$$reportNull$$$0(10);
                }
                return typeNullability;
            }
            Optional<Nullability> optionalNullability = manager.getAnnotationNullability(qualifiedName);
            if (!optionalNullability.isPresent()) continue;
            Nullability nullability = optionalNullability.get();
            return new TypeNullability(nullability, new NullabilitySource.ExplicitAnnotation(annotation));
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(11);
        }
        return typeNullability;
    }

    @NotNull
    public static NullabilityConflictContext getNullabilityConflictInAssignment(@Nullable PsiType leftType, @Nullable PsiType rightType, boolean checkNotNullToNull) {
        return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftType, rightType, checkNotNullToNull, false);
    }

    @NotNull
    private static NullabilityConflictContext getNullabilityConflictInAssignment(@Nullable PsiType leftType, @Nullable PsiType rightType, boolean checkNotNullToNull, boolean checkConflictInInitialType) {
        NullabilityConflictContext context;
        if (checkConflictInInitialType && JavaTypeNullabilityUtil.isAllowedNullabilityConflictType(checkNotNullToNull, context = JavaTypeNullabilityUtil.getNullabilityConflictTypeContext(leftType, rightType))) {
            NullabilityConflictContext nullabilityConflictContext = context;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(12);
            }
            return nullabilityConflictContext;
        }
        if (leftType == null || TypeConversionUtil.isNullType(leftType) || rightType == null || TypeConversionUtil.isNullType(rightType)) {
            NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(13);
            }
            return nullabilityConflictContext;
        }
        if (rightType instanceof PsiIntersectionType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInTypeArguments(leftType, rightType, checkNotNullToNull);
        }
        if (rightType instanceof PsiCapturedWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftType, ((PsiCapturedWildcardType)rightType).getUpperBound(true), checkNotNullToNull, false);
        }
        if (leftType instanceof PsiCapturedWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(((PsiCapturedWildcardType)leftType).getLowerBound(), rightType, checkNotNullToNull, false);
        }
        if (leftType instanceof PsiWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(GenericsUtil.getWildcardBound(leftType), rightType, checkNotNullToNull, false);
        }
        if (rightType instanceof PsiWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftType, GenericsUtil.getWildcardBound(rightType), checkNotNullToNull, false);
        }
        if (leftType instanceof PsiArrayType && rightType instanceof PsiArrayType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(((PsiArrayType)leftType).getComponentType(), ((PsiArrayType)rightType).getComponentType(), checkNotNullToNull, true);
        }
        if (!(leftType instanceof PsiClassType) || !(rightType instanceof PsiClassType)) {
            NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(14);
            }
            return nullabilityConflictContext;
        }
        return JavaTypeNullabilityUtil.getNullabilityConflictInTypeArguments(leftType, rightType, checkNotNullToNull);
    }

    @NotNull
    private static NullabilityConflictContext getNullabilityConflictInTypeArguments(@NotNull PsiType leftType, @NotNull PsiType rightType, boolean checkNotNullToNull) {
        if (leftType == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(15);
        }
        if (rightType == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(16);
        }
        if (JavaTypeNullabilityUtil.isRawType(leftType) || JavaTypeNullabilityUtil.isRawType(rightType)) {
            NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(17);
            }
            return nullabilityConflictContext;
        }
        PsiClass leftClass = PsiTypesUtil.getPsiClass(leftType);
        if (leftClass == null) {
            NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(18);
            }
            return nullabilityConflictContext;
        }
        List<PsiType> leftParameterTypeList = JavaTypeNullabilityUtil.getParentParameterTypeListFromDerivedType(leftType, leftClass);
        List<PsiType> rightParameterTypeList = JavaTypeNullabilityUtil.getParentParameterTypeListFromDerivedType(rightType, leftClass);
        if (leftParameterTypeList == null || rightParameterTypeList == null || leftParameterTypeList.size() != rightParameterTypeList.size()) {
            NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(19);
            }
            return nullabilityConflictContext;
        }
        for (int i = 0; i < leftParameterTypeList.size(); ++i) {
            PsiType rightParameterType;
            PsiType leftParameterType = leftParameterTypeList.get(i);
            NullabilityConflictContext context = JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftParameterType, rightParameterType = rightParameterTypeList.get(i), checkNotNullToNull, true);
            if (context.nullabilityConflict == NullabilityConflict.UNKNOWN) continue;
            NullabilityConflictContext nullabilityConflictContext = context;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(20);
            }
            return nullabilityConflictContext;
        }
        NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
        if (nullabilityConflictContext == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(21);
        }
        return nullabilityConflictContext;
    }

    private static boolean isRawType(@NotNull PsiType type) {
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(22);
        }
        return type instanceof PsiClassType && ((PsiClassType)type).isRaw();
    }

    private static @Nullable List<@NotNull PsiType> getParentParameterTypeListFromDerivedType(@NotNull PsiType derivedType, @NotNull PsiClass superClass) {
        if (derivedType == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(23);
        }
        if (superClass == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(24);
        }
        if (derivedType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)derivedType).getConjuncts()) {
                List<@NotNull PsiType> candidates = JavaTypeNullabilityUtil.getParentParameterTypeListFromDerivedType(conjunct, superClass);
                if (candidates == null) continue;
                return candidates;
            }
            return null;
        }
        return PsiUtil.substituteTypeParameters(derivedType, superClass, true);
    }

    private static boolean isAllowedNullabilityConflictType(boolean checkNotNullToNull, @NotNull NullabilityConflictContext context) {
        if (context == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(25);
        }
        return context.nullabilityConflict != NullabilityConflict.UNKNOWN && (checkNotNullToNull || context.nullabilityConflict != NullabilityConflict.NOT_NULL_TO_NULL);
    }

    @NotNull
    public static NullabilityConflictContext getNullabilityConflictTypeContext(@Nullable PsiType leftType, @Nullable PsiType rightType) {
        if (leftType == null || rightType == null) {
            NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
            if (nullabilityConflictContext == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(26);
            }
            return nullabilityConflictContext;
        }
        TypeNullability leftTypeNullability = leftType.getNullability();
        TypeNullability rightTypeNullability = rightType.getNullability();
        Nullability leftNullability = leftTypeNullability.nullability();
        Nullability rightNullability = rightTypeNullability.nullability();
        if (leftNullability == Nullability.NOT_NULL && rightNullability == Nullability.NULLABLE) {
            return new NullabilityConflictContext(NullabilityConflict.NULL_TO_NOT_NULL, leftType, rightType);
        }
        if (leftNullability == Nullability.NULLABLE && rightNullability == Nullability.NOT_NULL && !GenericsUtil.isWildcardWithExtendsBound(leftType)) {
            return new NullabilityConflictContext(NullabilityConflict.NOT_NULL_TO_NULL, leftType, rightType);
        }
        NullabilityConflictContext nullabilityConflictContext = NullabilityConflictContext.UNKNOWN;
        if (nullabilityConflictContext == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(27);
        }
        return nullabilityConflictContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JavaTypeNullabilityUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JavaTypeNullabilityUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNullability";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityFromAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictInAssignment";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictInTypeArguments";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictTypeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNullability";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityFromAnnotations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityConflictInTypeArguments";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isRawType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getParentParameterTypeListFromDerivedType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedNullabilityConflictType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NullabilityConflictContext {
        @NotNull
        private final NullabilityConflict nullabilityConflict;
        @Nullable
        private final PsiType expectedType;
        @Nullable
        private final PsiType actualType;
        public static final NullabilityConflictContext UNKNOWN = new NullabilityConflictContext(NullabilityConflict.UNKNOWN, null, null);

        public NullabilityConflictContext(@NotNull NullabilityConflict nullabilityConflict, @Nullable PsiType expectedType, @Nullable PsiType actualType) {
            if (nullabilityConflict == null) {
                NullabilityConflictContext.$$$reportNull$$$0(0);
            }
            this.nullabilityConflict = nullabilityConflict;
            this.expectedType = expectedType;
            this.actualType = actualType;
        }

        @NotNull
        public NullabilityConflict nullabilityConflict() {
            NullabilityConflict nullabilityConflict = this.nullabilityConflict;
            if (nullabilityConflict == null) {
                NullabilityConflictContext.$$$reportNull$$$0(1);
            }
            return nullabilityConflict;
        }

        public PsiType getType(@NotNull Side side) {
            if (side == null) {
                NullabilityConflictContext.$$$reportNull$$$0(2);
            }
            if (side == Side.EXPECTED) {
                return this.expectedType;
            }
            return this.actualType;
        }

        @Nullable
        public PsiElement getPlace(@NotNull Side side) {
            if (side == null) {
                NullabilityConflictContext.$$$reportNull$$$0(3);
            }
            PsiType type = this.getType(side);
            return NullabilityConflictContext.getPlace(type);
        }

        @Nullable
        public PsiAnnotation getAnnotation(@NotNull Side side) {
            PsiType type;
            if (side == null) {
                NullabilityConflictContext.$$$reportNull$$$0(4);
            }
            if ((type = this.getType(side)) == null) {
                return null;
            }
            TypeNullability nullability = type.getNullability();
            NullabilityAnnotationInfo info = nullability.toNullabilityAnnotationInfo();
            if (info == null) {
                return null;
            }
            return info.getAnnotation();
        }

        @Nullable
        private static PsiElement getPlace(PsiType placeHolder) {
            if (placeHolder instanceof PsiClassType) {
                return ((PsiClassType)placeHolder).getPsiContext();
            }
            if (placeHolder instanceof PsiCapturedWildcardType) {
                return NullabilityConflictContext.getPlace(((PsiCapturedWildcardType)placeHolder).getWildcard());
            }
            if (placeHolder instanceof PsiWildcardType) {
                return NullabilityConflictContext.getPlace(((PsiWildcardType)placeHolder).getBound());
            }
            if (placeHolder instanceof PsiArrayType) {
                return NullabilityConflictContext.getPlace(placeHolder.getDeepComponentType());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullabilityConflict";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/JavaTypeNullabilityUtil$NullabilityConflictContext";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/JavaTypeNullabilityUtil$NullabilityConflictContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nullabilityConflict";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPlace";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnnotation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum NullabilityConflict {
        NULL_TO_NOT_NULL,
        NOT_NULL_TO_NULL,
        UNKNOWN;

    }

    public static enum Side {
        EXPECTED,
        ACTUAL;

    }
}

