/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.VcsExecutablePathSelector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgExecutableManager;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/zmlx/hg4idea/HgProjectConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "testExecutable", "", "executable", "", "intellij.vcs.hg"})
public final class HgProjectConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;

    public HgProjectConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = HgBundle.message("hg4idea.mercurial", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "project.propVCSSupport.VCSs.Mercurial", "vcs.Mercurial");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DialogPanel createPanel() {
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        Disposable disposable2 = disposable;
        HgGlobalSettings globalSettings = HgGlobalSettings.getInstance();
        HgProjectSettings projectSettings = HgProjectSettings.getInstance(this.project);
        return BuilderKt.panel(arg_0 -> HgProjectConfigurable.createPanel$lambda$0(this, disposable2, globalSettings, projectSettings, arg_0));
    }

    private final void testExecutable(String executable) {
        Project project = this.project;
        String string = HgBundle.message("hg4idea.configuration.identifying.version", new Object[0]);
        new Task.Modal(executable, project, string){
            private HgVersion version;
            final /* synthetic */ String $executable;
            {
                this.$executable = $executable;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public final HgVersion getVersion() {
                return this.version;
            }

            public final void setVersion(HgVersion hgVersion) {
                this.version = hgVersion;
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Project project = this.myProject;
                Intrinsics.checkNotNull((Object)project);
                this.version = HgVersion.identifyVersion(project, this.$executable);
            }

            public void onSuccess() {
                Object[] objectArray = new Object[]{String.valueOf(this.version)};
                Messages.showInfoMessage((Project)this.getProject(), (String)HgBundle.message("hg4idea.configuration.version", objectArray), (String)HgBundle.message("hg4idea.run.success.title", new Object[0]));
            }

            public void onThrowable(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Messages.showErrorDialog((Project)this.getProject(), (String)error.getMessage(), (String)HgBundle.message("hg4idea.run.failed.title", new Object[0]));
            }
        }.queue();
    }

    private static final void createPanel$lambda$0$0$0(HgProjectConfigurable this$0, String executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        this$0.testExecutable(executable);
    }

    private static final Unit createPanel$lambda$0$0$1(VcsExecutablePathSelector $pathSelector, HgGlobalSettings $globalSettings, HgProjectSettings $projectSettings) {
        $pathSelector.setAutoDetectedPath(HgExecutableManager.getInstance().getDefaultExecutable());
        $pathSelector.reset($globalSettings.getHgExecutable(), $projectSettings.isHgExecutableOverridden(), $projectSettings.getHgExecutable());
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$0$2(VcsExecutablePathSelector $pathSelector, HgGlobalSettings $globalSettings, HgProjectSettings $projectSettings) {
        return $pathSelector.isModified($globalSettings.getHgExecutable(), $projectSettings.isHgExecutableOverridden(), $projectSettings.getHgExecutable());
    }

    private static final Unit createPanel$lambda$0$0$3(VcsExecutablePathSelector $pathSelector, HgProjectSettings $projectSettings, HgGlobalSettings $globalSettings, HgProjectConfigurable this$0) {
        if ($pathSelector.isOverridden()) {
            $projectSettings.setHgExecutable($pathSelector.getCurrentPath());
            $projectSettings.setHgExecutableOverridden($pathSelector.isOverridden());
        } else {
            $globalSettings.setHgExecutable($pathSelector.getCurrentPath());
            $projectSettings.setHgExecutable(null);
            $projectSettings.setHgExecutableOverridden($pathSelector.isOverridden());
        }
        HgVcs hgVcs = HgVcs.getInstance(this$0.project);
        Intrinsics.checkNotNull((Object)((Object)hgVcs));
        hgVcs.checkVersion();
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$3$0(HgProjectSettings $projectSettings) {
        return $projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    private static final Unit createPanel$lambda$0$3$1(HgProjectSettings $projectSettings, boolean isSelected) {
        $projectSettings.setSyncSetting(isSelected ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(Disposable $disposable, HgProjectConfigurable this$0, HgGlobalSettings $globalSettings, HgProjectSettings $projectSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        VcsExecutablePathSelector pathSelector = new VcsExecutablePathSelector(HgVcs.DISPLAY_NAME.get(), $disposable, arg_0 -> HgProjectConfigurable.createPanel$lambda$0$0$0(this$0, arg_0));
        JPanel jPanel = pathSelector.getMainPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getMainPanel(...)");
        $this$row.cell((JComponent)jPanel).align((Align)AlignX.FILL.INSTANCE).onReset(() -> HgProjectConfigurable.createPanel$lambda$0$0$1(pathSelector, $globalSettings, $projectSettings)).onIsModified(() -> HgProjectConfigurable.createPanel$lambda$0$0$2(pathSelector, $globalSettings, $projectSettings)).onApply(() -> HgProjectConfigurable.createPanel$lambda$0$0$3(pathSelector, $projectSettings, $globalSettings, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(HgProjectSettings $projectSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = HgBundle.message("hg4idea.configuration.check.incoming.outgoing", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$projectSettings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$projectSettings){

            public final Boolean invoke() {
                return ((HgProjectSettings)this.receiver).isCheckIncomingOutgoing();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$projectSettings){

            public final void invoke(boolean p0) {
                ((HgProjectSettings)this.receiver).setCheckIncomingOutgoing(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(HgProjectSettings $projectSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = HgBundle.message("hg4idea.configuration.ignore.whitespace.in.annotate", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$projectSettings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$projectSettings){

            public final Boolean invoke() {
                return ((HgProjectSettings)this.receiver).isWhitespacesIgnoredInAnnotations();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$projectSettings){

            public final void invoke(boolean p0) {
                ((HgProjectSettings)this.receiver).setIgnoreWhitespacesInAnnotations(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(HgProjectSettings $projectSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DvcsBundle.message((String)"sync.setting", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> HgProjectConfigurable.createPanel$lambda$0$3$0($projectSettings), arg_0 -> HgProjectConfigurable.createPanel$lambda$0$3$1($projectSettings, arg_0));
        Object[] objectArray = new Object[]{HgVcs.DISPLAY_NAME.get()};
        String string2 = DvcsBundle.message((String)"sync.setting.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell.contextHelp$default((Cell)cell, (String)string2, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(HgProjectConfigurable this$0, Disposable $disposable, HgGlobalSettings $globalSettings, HgProjectSettings $projectSettings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HgProjectConfigurable.createPanel$lambda$0$0($disposable, this$0, $globalSettings, $projectSettings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HgProjectConfigurable.createPanel$lambda$0$1($projectSettings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HgProjectConfigurable.createPanel$lambda$0$2($projectSettings, arg_0), (int)1, null);
        if (this$0.project.isDefault() || HgUtil.getRepositoryManager(this$0.project).moreThanOneRoot()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> HgProjectConfigurable.createPanel$lambda$0$3($projectSettings, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }
}

