/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class OrderEnumeratorBase
extends OrderEnumerator
implements OrderEnumeratorSettings {
    private static final Logger LOG = Logger.getInstance(OrderEnumeratorBase.class);
    private boolean myProductionOnly;
    private boolean myCompileOnly;
    private boolean myRuntimeOnly;
    private boolean myWithoutJdk;
    private boolean myWithoutLibraries;
    boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    boolean myRecursively;
    boolean myRecursivelyExportedOnly;
    private boolean myExportedOnly;
    private Condition<? super OrderEntry> myCondition;
    RootModelProvider myModulesProvider;
    private final Project myProject;
    private final OrderRootsCache myCache;
    private Map<String, Module> myModulesByNameMap;

    OrderEnumeratorBase(@NotNull Project project, @Nullable OrderRootsCache cache) {
        if (project == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCache = cache;
    }

    @NotNull
    static List<OrderEnumerationHandler> getCustomHandlers(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(1);
        }
        SmartList customHandlers = null;
        for (OrderEnumerationHandler.Factory handlerFactory : OrderEnumerationHandler.EP_NAME.getExtensionList()) {
            if (!handlerFactory.isApplicable(module)) continue;
            if (customHandlers == null) {
                customHandlers = new SmartList();
            }
            customHandlers.add(handlerFactory.createHandler(module));
        }
        List<Object> list = customHandlers == null ? Collections.emptyList() : customHandlers;
        if (list == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public OrderEnumerator productionOnly() {
        this.myProductionOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(3);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator compileOnly() {
        this.myCompileOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(4);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(5);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutSdk() {
        this.myWithoutJdk = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(6);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutLibraries() {
        this.myWithoutLibraries = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(7);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutDepModules() {
        this.myWithoutDepModules = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(8);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(9);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator recursively() {
        this.myRecursively = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(10);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(11);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator satisfying(@NotNull Condition<? super OrderEntry> condition) {
        if (condition == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(12);
        }
        this.myCondition = condition;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(13);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderEnumerator using(@NotNull RootModelProvider provider) {
        if (provider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(14);
        }
        this.myModulesProvider = provider;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(15);
        }
        return orderEnumeratorBase;
    }

    @NotNull
    public OrderRootsEnumerator classes() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.CLASSES);
    }

    @NotNull
    public OrderRootsEnumerator sources() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.SOURCES);
    }

    @NotNull
    public OrderRootsEnumerator roots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(16);
        }
        return new OrderRootsEnumeratorImpl(this, rootType);
    }

    @NotNull
    public OrderRootsEnumerator roots(@NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        if (rootTypeProvider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(17);
        }
        return new OrderRootsEnumeratorImpl(this, rootTypeProvider);
    }

    ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(18);
        }
        if (this.myModulesProvider != null) {
            return this.myModulesProvider.getRootModel(module);
        }
        return ModuleRootManager.getInstance((Module)module);
    }

    @NotNull
    OrderRootsCache getCache() {
        LOG.assertTrue(this.myCache != null, (Object)"Caching is not supported for ModifiableRootModel");
        LOG.assertTrue(this.myCondition == null, (Object)"Caching not supported for OrderEnumerator with 'satisfying(Condition)' option");
        LOG.assertTrue(this.myModulesProvider == null, (Object)"Caching not supported for OrderEnumerator with 'using(ModulesProvider)' option");
        OrderRootsCache orderRootsCache = this.myCache;
        if (orderRootsCache == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(19);
        }
        return orderRootsCache;
    }

    public int getFlags() {
        int flags = 0;
        if (this.myProductionOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myCompileOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRuntimeOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutJdk) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutLibraries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutDepModules) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutModuleSourceEntries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursively) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursivelyExportedOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myExportedOnly) {
            flags |= 1;
        }
        return flags;
    }

    public boolean shouldRecurse(@NotNull ModuleOrderEntry entry, @NotNull List<? extends OrderEnumerationHandler> handlers) {
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(20);
        }
        if (handlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(21);
        }
        this.updateModulesByNameMap();
        ProcessEntryAction action = this.shouldAddOrRecurse((OrderEntry)entry, true, handlers);
        return action.type == ProcessEntryActionType.RECURSE;
    }

    @NotNull
    private ProcessEntryAction shouldAddOrRecurse(@NotNull OrderEntry entry, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        ModuleOrderEntry moduleOrderEntry;
        Module depModule;
        boolean exported;
        OrderEnumerationHandler handler;
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(22);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(23);
        }
        if (this.myCondition != null && !this.myCondition.value((Object)entry)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(24);
            }
            return processEntryAction;
        }
        if (entry instanceof JdkOrderEntry && (this.myWithoutJdk || !firstLevel)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(25);
            }
            return processEntryAction;
        }
        if (this.myWithoutLibraries && entry instanceof LibraryOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(26);
            }
            return processEntryAction;
        }
        if (this.myWithoutDepModules) {
            if (!this.myRecursively && entry instanceof ModuleOrderEntry) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(27);
                }
                return processEntryAction;
            }
            if (entry instanceof ModuleSourceOrderEntry && !this.isRootModuleModel(((ModuleSourceOrderEntry)entry).getRootModel())) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(28);
                }
                return processEntryAction;
            }
        }
        if (this.myWithoutModuleSourceEntries && entry instanceof ModuleSourceOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(29);
            }
            return processEntryAction;
        }
        OrderEnumerationHandler.AddDependencyType shouldAdd = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        Iterator<? extends OrderEnumerationHandler> iterator = customHandlers.iterator();
        while (iterator.hasNext() && (shouldAdd = (handler = iterator.next()).shouldAddDependency(entry, (OrderEnumeratorSettings)this)) == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
        }
        if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(30);
            }
            return processEntryAction;
        }
        boolean bl = exported = !(entry instanceof JdkOrderEntry);
        if (entry instanceof ExportableOrderEntry) {
            ExportableOrderEntry exportableEntry = (ExportableOrderEntry)entry;
            if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
                boolean forTestCompile;
                DependencyScope scope = exportableEntry.getScope();
                boolean bl2 = forTestCompile = scope.isForTestCompile() || scope == DependencyScope.RUNTIME && OrderEnumeratorBase.shouldAddRuntimeDependenciesToTestCompilationClasspath(customHandlers);
                if (this.myCompileOnly && !scope.isForProductionCompile() && !forTestCompile) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(31);
                    }
                    return processEntryAction;
                }
                if (this.myRuntimeOnly && !scope.isForProductionRuntime() && !scope.isForTestRuntime()) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(32);
                    }
                    return processEntryAction;
                }
                if (this.myProductionOnly && (!scope.isForProductionCompile() && !scope.isForProductionRuntime() || this.myCompileOnly && !scope.isForProductionCompile() || this.myRuntimeOnly && !scope.isForProductionRuntime())) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(33);
                    }
                    return processEntryAction;
                }
            }
            exported = exportableEntry.isExported();
        }
        if (!exported) {
            if (this.myExportedOnly) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(34);
                }
                return processEntryAction;
            }
            if (this.myRecursivelyExportedOnly && !firstLevel) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(35);
                }
                return processEntryAction;
            }
        }
        if (this.myRecursively && entry instanceof ModuleOrderEntry && (depModule = this.myModulesByNameMap.get((moduleOrderEntry = (ModuleOrderEntry)entry).getModuleName())) != null && OrderEnumeratorBase.shouldProcessRecursively(customHandlers)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.RECURSE(depModule);
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(36);
            }
            return processEntryAction;
        }
        if (this.myWithoutDepModules && entry instanceof ModuleOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(37);
            }
            return processEntryAction;
        }
        ProcessEntryAction processEntryAction = ProcessEntryAction.PROCESS;
        if (processEntryAction == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(38);
        }
        return processEntryAction;
    }

    protected void processEntries(@NotNull ModuleRootModel rootModel, @Nullable Set<? super Module> processed, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers, @NotNull PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>> processor) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(39);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(41);
        }
        this.updateModulesByNameMap();
        this.doProcessEntries(rootModel, processed, firstLevel, customHandlers, processor);
    }

    private void updateModulesByNameMap() {
        ModuleManagerEx moduleManager = ModuleManagerEx.getInstanceEx(this.myProject);
        this.myModulesByNameMap = moduleManager.getModulesByNameMap();
    }

    private void doProcessEntries(@NotNull ModuleRootModel rootModel, @Nullable Set<? super Module> processed, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers, @NotNull PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>> processor) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(42);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(43);
        }
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(44);
        }
        ProgressManager.checkCanceled();
        if (processed != null && !processed.add((Module)rootModel.getModule())) {
            return;
        }
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            ProcessEntryAction action = this.shouldAddOrRecurse(entry, firstLevel, customHandlers);
            if (action.type == ProcessEntryActionType.SKIP) continue;
            if (action.type == ProcessEntryActionType.RECURSE) {
                this.doProcessEntries(this.getRootModel(action.recurseOnModule), processed, false, customHandlers, processor);
                continue;
            }
            assert (action.type == ProcessEntryActionType.PROCESS);
            if (processor.process((Object)entry, customHandlers)) continue;
            return;
        }
    }

    private static boolean shouldAddRuntimeDependenciesToTestCompilationClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(45);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (!orderEnumerationHandler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldProcessRecursively(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(46);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    public void forEach(@NotNull Processor<? super OrderEntry> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(47);
        }
        this.forEach((PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>>)((PairProcessor)(entry, __) -> processor.process(entry)));
    }

    protected abstract void forEach(@NotNull PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>> var1);

    public void forEachLibrary(@NotNull Processor<? super Library> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(48);
        }
        this.forEach((PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>>)((PairProcessor)(entry, __) -> {
            Library library;
            if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null) {
                return processor.process((Object)library);
            }
            return true;
        }));
    }

    public void forEachModule(@NotNull Processor<? super Module> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(49);
        }
        this.updateModulesByNameMap();
        this.forEach((PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            String moduleName;
            Module module;
            if (this.myRecursively && orderEntry instanceof ModuleSourceOrderEntry) {
                Module module2 = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
                return processor.process((Object)module2);
            }
            if (!(!(orderEntry instanceof ModuleOrderEntry) || this.myRecursively && OrderEnumeratorBase.shouldProcessRecursively(customHandlers) || (module = this.myModulesByNameMap.get(moduleName = ((ModuleOrderEntry)orderEntry).getModuleName())) == null)) {
                return processor.process((Object)module);
            }
            return true;
        }));
    }

    public <R> R process(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(50);
        }
        OrderEntryProcessor<R> processor = new OrderEntryProcessor<R>(policy, initialValue);
        this.forEach(processor);
        return processor.myValue;
    }

    static boolean shouldIncludeTestsFromDependentModulesToTestClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(51);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    static boolean addCustomRootUrlsForLibraryOrSdk(@NotNull LibraryOrSdkOrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<? super String> result, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(52);
        }
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(53);
        }
        if (result == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(54);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(55);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomRootsForLibraryOrSdk(forOrderEntry, type, urls);
            result.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    static void addCustomRootsUrlsForModule(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (type == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(56);
        }
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(57);
        }
        if (result == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(58);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(59);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            orderEnumerationHandler.addCustomModuleRoots(type, rootModel, result, includeProduction, includeTests);
        }
    }

    public boolean isRuntimeOnly() {
        return this.myRuntimeOnly;
    }

    public boolean isCompileOnly() {
        return this.myCompileOnly;
    }

    public boolean isProductionOnly() {
        return this.myProductionOnly;
    }

    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(60);
        }
        return false;
    }

    public abstract void processRootModules(@NotNull Processor<? super Module> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 19, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 23: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 39: 
            case 42: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOrderEntry";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHandlers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "productionOnly";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "compileOnly";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeOnly";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSdk";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutLibraries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutDepModules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutModuleSourceEntries";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "recursively";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "exportedOnly";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "satisfying";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "using";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldAddOrRecurse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCustomHandlers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "satisfying";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "using";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "roots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRootModel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecurse";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddOrRecurse";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processEntries";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doProcessEntries";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddRuntimeDependenciesToTestCompilationClasspath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessRecursively";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "forEachLibrary";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "forEachModule";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeTestsFromDependentModulesToTestClasspath";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootUrlsForLibraryOrSdk";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsUrlsForModule";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isRootModuleModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 19, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 -> new IllegalStateException(string);
        };
    }

    protected static final class ProcessEntryAction {
        @NotNull
        public ProcessEntryActionType type;
        @Nullable
        Module recurseOnModule;
        public static final ProcessEntryAction SKIP = new ProcessEntryAction(ProcessEntryActionType.SKIP);
        public static final ProcessEntryAction PROCESS = new ProcessEntryAction(ProcessEntryActionType.PROCESS);

        private ProcessEntryAction(@NotNull ProcessEntryActionType type) {
            if (type == null) {
                ProcessEntryAction.$$$reportNull$$$0(0);
            }
            this.type = type;
        }

        @NotNull
        static ProcessEntryAction RECURSE(@NotNull Module module) {
            if (module == null) {
                ProcessEntryAction.$$$reportNull$$$0(1);
            }
            ProcessEntryAction result = new ProcessEntryAction(ProcessEntryActionType.RECURSE);
            result.recurseOnModule = module;
            ProcessEntryAction processEntryAction = result;
            if (processEntryAction == null) {
                ProcessEntryAction.$$$reportNull$$$0(2);
            }
            return processEntryAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "RECURSE";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "RECURSE";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    protected static enum ProcessEntryActionType {
        SKIP,
        RECURSE,
        PROCESS;

    }

    private static final class OrderEntryProcessor<R>
    implements PairProcessor<OrderEntry, List<? extends OrderEnumerationHandler>> {
        private R myValue;
        private final RootPolicy<R> myPolicy;

        private OrderEntryProcessor(@NotNull RootPolicy<R> policy, R initialValue) {
            if (policy == null) {
                OrderEntryProcessor.$$$reportNull$$$0(0);
            }
            this.myPolicy = policy;
            this.myValue = initialValue;
        }

        public boolean process(OrderEntry orderEntry, List<? extends OrderEnumerationHandler> __) {
            this.myValue = orderEntry.accept(this.myPolicy, this.myValue);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/roots/impl/OrderEnumeratorBase$OrderEntryProcessor", "<init>"));
        }
    }
}

