/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters.meters;

import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import com.intellij.platform.diagnostic.telemetry.exporters.RollingFileSupplier;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.CsvMetricsExporterKt;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/CsvMetricsExporter;", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "writeToFileSupplier", "Lcom/intellij/platform/diagnostic/telemetry/exporters/RollingFileSupplier;", "<init>", "(Lcom/intellij/platform/diagnostic/telemetry/exporters/RollingFileSupplier;)V", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "instrumentType", "Lio/opentelemetry/sdk/metrics/InstrumentType;", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "metrics", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "flush", "shutdown", "Companion", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
public final class CsvMetricsExporter
implements MetricExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RollingFileSupplier writeToFileSupplier;
    @VisibleForTesting
    @NotNull
    public static final String HTML_PLOTTER_NAME = "open-telemetry-metrics-plotter.html";

    public CsvMetricsExporter(@NotNull RollingFileSupplier writeToFileSupplier) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)writeToFileSupplier, (String)"writeToFileSupplier");
        this.writeToFileSupplier = writeToFileSupplier;
        Path it = path = this.writeToFileSupplier.init$intellij_platform_diagnostic_telemetry_exporters(OpenTelemetryUtils.INSTANCE.csvHeadersLines());
        boolean bl = false;
        Path path2 = it.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        CsvMetricsExporterKt.access$copyHtmlPlotterToOutputDir(path2);
    }

    @NotNull
    public AggregationTemporality getAggregationTemporality(@NotNull InstrumentType instrumentType) {
        Intrinsics.checkNotNullParameter((Object)instrumentType, (String)"instrumentType");
        return AggregationTemporality.DELTA;
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends MetricData> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        if (metrics.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
            return completableResultCode;
        }
        CompletableResultCode result = new CompletableResultCode();
        Path writeToFile = this.writeToFileSupplier.get();
        List lines = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)metrics), CsvMetricsExporter::export$lambda$0));
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            Files.write(writeToFile, (Iterable<? extends CharSequence>)lines, openOptionArray);
            result.succeed();
        }
        catch (IOException e) {
            CsvMetricsExporterKt.access$getLOG().warn("Can't write metrics into " + writeToFile.toAbsolutePath(), (Throwable)e);
            result.fail();
        }
        return result;
    }

    @NotNull
    public CompletableResultCode flush() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode shutdown() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    private static final Sequence export$lambda$0(MetricData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return OpenTelemetryUtils.INSTANCE.toCsvStream(it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/CsvMetricsExporter$Companion;", "", "<init>", "()V", "HTML_PLOTTER_NAME", "", "intellij.platform.diagnostic.telemetry.exporters"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

