/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.core.fileIndex.impl.InfiniteProcessingReportingKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"reportInfiniteRecursion", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileIndex", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl;", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\ninfiniteProcessingReporting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 infiniteProcessingReporting.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/InfiniteProcessingReportingKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,22:1\n13#2:23\n*S KotlinDebug\n*F\n+ 1 infiniteProcessingReporting.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/InfiniteProcessingReportingKt\n*L\n21#1:23\n*E\n"})
public final class InfiniteProcessingReportingKt {
    public static final void reportInfiniteRecursion(@NotNull VirtualFile file, @NotNull WorkspaceFileIndexImpl fileIndex) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileIndex, (String)"fileIndex");
        String parentsData2 = (String)ActionsKt.runReadAction(() -> InfiniteProcessingReportingKt.reportInfiniteRecursion$lambda$0(file, fileIndex));
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceFileIndexImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Attachment[] attachmentArray = new Attachment[]{new Attachment("parent-directories.txt", parentsData2)};
        logger.error("Infinite recursion detected", attachmentArray);
    }

    private static final CharSequence reportInfiniteRecursion$lambda$0$0(WorkspaceFileIndexImpl $fileIndex, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkspaceFileInternalInfo fileInfo = $fileIndex.getFileInfo(file, true, true, true, false, false, false);
        String symlinkData = file.is(VFileProperty.SYMLINK) ? ", link to " + file.getCanonicalFile() + ", recursive=" + file.isRecursiveOrCircularSymlink() : "";
        return file.getName() + ", info=" + fileInfo + symlinkData;
    }

    private static final String reportInfiniteRecursion$lambda$0(VirtualFile $file, WorkspaceFileIndexImpl $fileIndex) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence((Object)$file, (Function1)reportInfiniteRecursion.parentsData.1.1.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> InfiniteProcessingReportingKt.reportInfiniteRecursion$lambda$0$0($fileIndex, arg_0), (int)30, null);
    }
}

