/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrarySourceRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0002H\u0002J0\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PlatformInternalWorkspaceFileIndexContributor;", "<init>", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "dependenciesOnOtherEntities", "", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription;", "getDependenciesOnOtherEntities", "()Ljava/util/List;", "registerArchivesUnderRoot", "root", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "data", "Lcom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileSetData;", "kind", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "registerArchivesUnderRootRecursively", "Util", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nlibraryRootContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n14060#2,2:116\n*S KotlinDebug\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor\n*L\n68#1:116,2\n*E\n"})
public final class LibraryRootFileIndexContributor
implements WorkspaceFileIndexContributor<LibraryEntity>,
PlatformInternalWorkspaceFileIndexContributor {
    @Override
    @NotNull
    public Class<LibraryEntity> getEntityClass() {
        return LibraryEntity.class;
    }

    @Override
    public void registerFileSets(@NotNull LibraryEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        LibraryId libraryId = entity.getSymbolicId();
        if (!(libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) && !storage.hasReferrers((SymbolicEntityId)libraryId)) {
            return;
        }
        LibraryRootFileSetData compiledRootsData = new LibraryRootFileSetData(libraryId);
        LibrarySourceRootFileSetData sourceRootFileSetData = new LibrarySourceRootFileSetData(libraryId);
        block5: for (LibraryRoot root : entity.getRoots()) {
            LibraryRootFileSetData data = null;
            WorkspaceFileKind kind = null;
            LibraryRootTypeId libraryRootTypeId = root.getType();
            if (Intrinsics.areEqual((Object)libraryRootTypeId, (Object)LibraryRootTypeId.Companion.getCOMPILED())) {
                data = compiledRootsData;
                kind = WorkspaceFileKind.EXTERNAL;
            } else {
                if (!Intrinsics.areEqual((Object)libraryRootTypeId, (Object)LibraryRootTypeId.Companion.getSOURCES())) continue;
                data = sourceRootFileSetData;
                kind = WorkspaceFileKind.EXTERNAL_SOURCE;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[root.getInclusionOptions().ordinal()]) {
                case 1: {
                    registrar.registerFileSet(root.getUrl(), kind, (WorkspaceEntity)entity, (WorkspaceFileSetData)data);
                    continue block5;
                }
                case 2: {
                    this.registerArchivesUnderRoot(root.getUrl(), registrar, data, kind, entity);
                    continue block5;
                }
                case 3: {
                    this.registerArchivesUnderRootRecursively(root.getUrl(), registrar, data, kind, entity);
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    @NotNull
    public List<DependencyDescription<LibraryEntity>> getDependenciesOnOtherEntities() {
        return CollectionsKt.listOf(new DependencyDescription.OnReference(LibraryId.class));
    }

    private final void registerArchivesUnderRoot(VirtualFileUrl root, WorkspaceFileSetRegistrar registrar, LibraryRootFileSetData data, WorkspaceFileKind kind, LibraryEntity entity) {
        block1: {
            VirtualFile[] virtualFileArray = VirtualFileUrls.getVirtualFile((VirtualFileUrl)root);
            if (virtualFileArray == null || (virtualFileArray = virtualFileArray.getChildren()) == null) break block1;
            VirtualFile[] $this$forEach$iv = virtualFileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile jarRoot;
                VirtualFile element$iv;
                VirtualFile file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (file.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(file.getPath() + "!/")) == null) continue;
                registrar.registerFileSet(jarRoot, kind, (WorkspaceEntity)entity, (WorkspaceFileSetData)data);
            }
        }
    }

    private final void registerArchivesUnderRootRecursively(VirtualFileUrl root, WorkspaceFileSetRegistrar registrar, LibraryRootFileSetData data, WorkspaceFileKind kind, LibraryEntity entity) {
        VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)root);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(registrar, kind, entity, data, optionArray){
            final /* synthetic */ WorkspaceFileSetRegistrar $registrar;
            final /* synthetic */ WorkspaceFileKind $kind;
            final /* synthetic */ LibraryEntity $entity;
            final /* synthetic */ LibraryRootFileSetData $data;
            {
                this.$registrar = $registrar;
                this.$kind = $kind;
                this.$entity = $entity;
                this.$data = $data;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file) {
                VirtualFile jarRoot;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file.getPath() + "!/")) != null) {
                    this.$registrar.registerFileSet(jarRoot, this.$kind, (WorkspaceEntity)this.$entity, (WorkspaceFileSetData)this.$data);
                    return false;
                }
                return true;
            }
        }));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u001f\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor$Util;", "", "<init>", "()V", "getLibraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "data", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "getLibraryId$intellij_platform_projectModel_impl", "getModuleLibraryId", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getModuleLibraryId$intellij_platform_projectModel_impl", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nlibraryRootContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor$Util\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,115:1\n19#2:116\n19#2:117\n*S KotlinDebug\n*F\n+ 1 libraryRootContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/LibraryRootFileIndexContributor$Util\n*L\n100#1:116\n104#1:117\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @Nullable
        public final LibraryId getLibraryId$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSetData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            WorkspaceFileSetData $this$asSafely$iv = data;
            boolean $i$f$asSafely = false;
            WorkspaceFileSetData workspaceFileSetData = $this$asSafely$iv;
            if (!(workspaceFileSetData instanceof LibraryRootFileSetData)) {
                workspaceFileSetData = null;
            }
            LibraryRootFileSetData libraryRootFileSetData = (LibraryRootFileSetData)workspaceFileSetData;
            return libraryRootFileSetData != null ? libraryRootFileSetData.getLibraryId$intellij_platform_projectModel_impl() : null;
        }

        @Nullable
        public final LibraryId getModuleLibraryId$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSet fileSet, @NotNull EntityStorage storage) {
            EntityPointer<WorkspaceEntity> entityPointer;
            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            WorkspaceFileSet $this$asSafely$iv = fileSet;
            boolean $i$f$asSafely = false;
            WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
            if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
                workspaceFileSet = null;
            }
            WorkspaceEntity $this$asSafely$iv2 = (entityPointer = (EntityPointer<WorkspaceEntity>)workspaceFileSet) != null && (entityPointer = entityPointer.getEntityPointer()) != null ? entityPointer.resolve(storage) : null;
            boolean $i$f$asSafely2 = false;
            WorkspaceEntity workspaceEntity = $this$asSafely$iv2;
            if (!(workspaceEntity instanceof LibraryEntity)) {
                workspaceEntity = null;
            }
            LibraryEntity libraryEntity = (LibraryEntity)workspaceEntity;
            return libraryEntity != null ? libraryEntity.getSymbolicId() : null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LibraryRoot.InclusionOptions.values().length];
            try {
                nArray[LibraryRoot.InclusionOptions.ROOT_ITSELF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

