/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelMessageDeliveryListener;", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "<init>", "()V", "messageDelivered", "", "topic", "Lcom/intellij/util/messages/Topic;", "messageName", "", "handler", "", "durationNanos", "", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceModelMessageDeliveryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelMessageDeliveryListener.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelMessageDeliveryListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,19:1\n23#2:20\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelMessageDeliveryListener.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelMessageDeliveryListener\n*L\n14#1:20\n*E\n"})
public final class WorkspaceModelMessageDeliveryListener
implements MessageDeliveryListener {
    @NotNull
    public static final WorkspaceModelMessageDeliveryListener INSTANCE = new WorkspaceModelMessageDeliveryListener();

    private WorkspaceModelMessageDeliveryListener() {
    }

    public void messageDelivered(@NotNull Topic<?> topic, @NotNull String messageName, @NotNull Object handler, long durationNanos) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)messageName, (String)"messageName");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (Intrinsics.areEqual(topic, (Object)WorkspaceModelTopics.CHANGED) && TimeUnit.NANOSECONDS.toMillis(durationNanos) > 200L) {
            WorkspaceModelMessageDeliveryListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(WorkspaceModelMessageDeliveryListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            String string = "Long WSM event processing. Topic=%s, offender=%s, message=%s, time=%dms";
            Object[] objectArray = new Object[]{topic.getDisplayName(), handler.getClass(), messageName, TimeUnit.NANOSECONDS.toMillis(durationNanos)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.warn(string2);
        }
    }
}

