/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.java.metrics;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.jvm.java.metrics.LineRange;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a0\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t\u001a\u001c\u0010\r\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\t\u001a\u0014\u0010\u000e\u001a\u00020\t*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"getStartLine", "", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "getEndLine", "getLineRange", "Lorg/jetbrains/qodana/jvm/java/metrics/LineRange;", "hasSiblingOnTheLine", "", "lineNumber", "forward", "ignoreWhitespace", "getNumberOfLinesWhereOnlyElementOnALine", "hasFirstAndLastChildOnTheSameLine", "intellij.qodana.jvm.java"})
public final class PsiKt {
    public static final int getStartLine(@Nullable PsiElement $this$getStartLine, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if ($this$getStartLine == null) {
            return -1;
        }
        int startOffset = PsiTreeUtilKt.getStartOffset((PsiElement)$this$getStartLine);
        int startLine = document.getLineNumber(startOffset);
        return startLine;
    }

    public static final int getEndLine(@Nullable PsiElement $this$getEndLine, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if ($this$getEndLine == null) {
            return -1;
        }
        int endOffset = PsiTreeUtilKt.getEndOffset((PsiElement)$this$getEndLine);
        int endLine = document.getLineNumber(endOffset);
        return endLine;
    }

    @NotNull
    public static final LineRange getLineRange(@Nullable PsiElement $this$getLineRange, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if ($this$getLineRange == null) {
            return LineRange.Companion.getEMPTY();
        }
        return new LineRange(PsiKt.getStartLine($this$getLineRange, document), PsiKt.getEndLine($this$getLineRange, document));
    }

    public static final boolean hasSiblingOnTheLine(@Nullable PsiElement $this$hasSiblingOnTheLine, @NotNull Document document, int lineNumber, boolean forward2, boolean ignoreWhitespace) {
        boolean hasSibling;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if ($this$hasSiblingOnTheLine == null) {
            return false;
        }
        PsiElement sibling = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)PsiTreeUtilKt.siblings((PsiElement)$this$hasSiblingOnTheLine, (boolean)forward2, (boolean)false), arg_0 -> PsiKt.hasSiblingOnTheLine$lambda$0(ignoreWhitespace, arg_0)));
        boolean bl = hasSibling = sibling != null;
        if (hasSibling) {
            int n;
            if (forward2) {
                PsiElement psiElement = sibling;
                Intrinsics.checkNotNull((Object)psiElement);
                n = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement);
            } else {
                PsiElement psiElement = sibling;
                Intrinsics.checkNotNull((Object)psiElement);
                n = PsiTreeUtilKt.getEndOffset((PsiElement)psiElement);
            }
            int offset = n;
            int siblingLine = document.getLineNumber(offset);
            return siblingLine == lineNumber;
        }
        return false;
    }

    public static /* synthetic */ boolean hasSiblingOnTheLine$default(PsiElement psiElement, Document document, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return PsiKt.hasSiblingOnTheLine(psiElement, document, n, bl, bl2);
    }

    public static final int getNumberOfLinesWhereOnlyElementOnALine(@Nullable PsiElement $this$getNumberOfLinesWhereOnlyElementOnALine, @NotNull Document document, boolean ignoreWhitespace) {
        boolean nextSiblingOnTheSameLine;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if ($this$getNumberOfLinesWhereOnlyElementOnALine == null) {
            return -1;
        }
        LineRange lineRange = PsiKt.getLineRange($this$getNumberOfLinesWhereOnlyElementOnALine, document);
        int elementStartLine = lineRange.component1();
        int elementEndLine = lineRange.component2();
        int elementLines = elementEndLine - elementStartLine + 1;
        boolean prevSiblingOnTheSameLine = PsiKt.hasSiblingOnTheLine($this$getNumberOfLinesWhereOnlyElementOnALine, document, elementStartLine, false, ignoreWhitespace);
        if (prevSiblingOnTheSameLine) {
            --elementLines;
        }
        if (nextSiblingOnTheSameLine = PsiKt.hasSiblingOnTheLine($this$getNumberOfLinesWhereOnlyElementOnALine, document, elementEndLine, true, ignoreWhitespace)) {
            --elementLines;
        }
        if (elementLines < 0) {
            elementLines = 0;
        }
        return elementLines;
    }

    public static final boolean hasFirstAndLastChildOnTheSameLine(@Nullable PsiElement $this$hasFirstAndLastChildOnTheSameLine, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if ($this$hasFirstAndLastChildOnTheSameLine == null) {
            return false;
        }
        PsiElement firstChild = $this$hasFirstAndLastChildOnTheSameLine.getFirstChild();
        PsiElement lastChild = $this$hasFirstAndLastChildOnTheSameLine.getLastChild();
        if (firstChild != null && lastChild != null) {
            return PsiKt.getStartLine(firstChild, document) == PsiKt.getEndLine(lastChild, document);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasSiblingOnTheLine$lambda$0(boolean $ignoreWhitespace, PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if ($ignoreWhitespace) {
            if (e instanceof PsiWhiteSpace) return true;
        }
        if (e instanceof PsiImportList) {
            PsiElement[] psiElementArray = ((PsiImportList)e).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            if (((Object[])psiElementArray).length == 0) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        if (!(e instanceof PsiPackageStatement)) return false;
        PsiElement[] psiElementArray = ((PsiPackageStatement)e).getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        if (((Object[])psiElementArray).length != 0) return false;
        return true;
    }
}

