/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif.fingerprints;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.jetbrains.qodana.sarif.model.Edge;
import com.jetbrains.qodana.sarif.model.Graph;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.Node;
import com.jetbrains.qodana.sarif.model.Result;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.CommonFingerprintsKt;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.FingerprintCalculator;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.SafeHasher;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c0\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/fingerprints/BaselineEqualityV1;", "Lorg/jetbrains/qodana/staticAnalysis/sarif/fingerprints/FingerprintCalculator;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "version", "", "getVersion", "()I", "calculate", "result", "Lcom/jetbrains/qodana/sarif/model/Result;", "equals", "", "other", "", "hashCode", "toString", "intellij.qodana"})
public final class BaselineEqualityV1
implements FingerprintCalculator {
    @NotNull
    public static final BaselineEqualityV1 INSTANCE = new BaselineEqualityV1();

    private BaselineEqualityV1() {
    }

    @Override
    @NotNull
    public String getName() {
        return "equalIndicator";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    @NotNull
    public String calculate(@NotNull Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        HashFunction hashFunction = Hashing.sha256();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction, (String)"sha256(...)");
        return CommonFingerprintsKt.hash(hashFunction, (Function1<? super SafeHasher, Unit>)((Function1)arg_0 -> BaselineEqualityV1.calculate$lambda$0(result2, arg_0)));
    }

    @NotNull
    public String toString() {
        return "BaselineEqualityV1";
    }

    public int hashCode() {
        return 745711270;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaselineEqualityV1)) {
            return false;
        }
        BaselineEqualityV1 cfr_ignored_0 = (BaselineEqualityV1)other;
        return true;
    }

    private static final Unit calculate$lambda$0$1$0(SafeHasher $hasher, Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonFingerprintsKt.hash(it, $hasher);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0$1$1(SafeHasher $hasher, Edge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonFingerprintsKt.hash(it, $hasher);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0$0(SafeHasher $hasher, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonFingerprintsKt.hash(it, $hasher);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0$1(SafeHasher $hasher, Graph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        CommonFingerprintsKt.forEachNotNull(graph.getNodes(), arg_0 -> BaselineEqualityV1.calculate$lambda$0$1$0($hasher, arg_0));
        CommonFingerprintsKt.forEachNotNull(graph.getEdges(), arg_0 -> BaselineEqualityV1.calculate$lambda$0$1$1($hasher, arg_0));
        Message message = graph.getDescription();
        $hasher.put(message != null ? message.getText() : null);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0(Result $result, SafeHasher hasher) {
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        CommonFingerprintsKt.forEachNotNull($result.getLocations(), arg_0 -> BaselineEqualityV1.calculate$lambda$0$0(hasher, arg_0));
        CommonFingerprintsKt.forEachNotNull($result.getGraphs(), arg_0 -> BaselineEqualityV1.calculate$lambda$0$1(hasher, arg_0));
        hasher.put($result.getRuleId());
        Message message = $result.getMessage();
        hasher.put(message != null ? message.getText() : null);
        return Unit.INSTANCE;
    }
}

