/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromStageDeclaration;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileDuplicatedStageNameInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "DuplicatedStageNameInspector", "intellij.clouds.docker.file.backend"})
public final class DockerFileDuplicatedStageNameInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.getFile() instanceof DockerPsiFile) {
            psiElementVisitor = (PsiElementVisitor)new DuplicatedStageNameInspector(holder, isOnTheFly);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001d\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u000b\u0010\u0012\u001a\u00070\n\u00a2\u0006\u0002\b\u0013H\u0002R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileDuplicatedStageNameInspection$DuplicatedStageNameInspector;", "Lcom/intellij/docker/dockerFile/inspections/DockerFileInspectorBase;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "usedNames", "", "", "Lcom/intellij/psi/PsiElement;", "visitFromStageDeclaration", "", "o", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileFromStageDeclaration;", "reportProblem", "nameElement", "name", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.clouds.docker.file.backend"})
    private static final class DuplicatedStageNameInspector
    extends DockerFileInspectorBase {
        @NotNull
        private final Map<String, PsiElement> usedNames;

        public DuplicatedStageNameInspector(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(holder, isOnTheFly);
            this.usedNames = new LinkedHashMap();
        }

        public void visitFromStageDeclaration(@NotNull DockerFileFromStageDeclaration o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            PsiElement psiElement = o.getDeclaredName();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDeclaredName(...)");
            PsiElement nameElement = psiElement;
            String name = nameElement.getText();
            if (this.usedNames.containsKey(name)) {
                Intrinsics.checkNotNull((Object)name);
                this.reportProblem(nameElement, name);
                PsiElement prevElem = this.usedNames.get(name);
                if (prevElem != null) {
                    this.reportProblem(prevElem, name);
                    this.usedNames.put(name, null);
                }
            } else {
                this.usedNames.put(name, nameElement);
            }
        }

        private final void reportProblem(PsiElement nameElement, String name) {
            Object[] objectArray = new Object[]{name};
            this.registerProblem(CollectionsKt.listOf((Object)nameElement), DockerBundle.message((String)"DockerFileDuplicatedStageNameInspection.problem", (Object[])objectArray), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
        }
    }
}

