/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.agent.util.UtilsKt;
import com.intellij.docker.dockerFile.DockerLanguage;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.inspections.DockerJsonFormStringLiteralsInspectionKt;
import com.intellij.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileParametersInJsonForm;
import com.intellij.docker.dockerFile.parser.psi.DockerFileStringLiteral;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "JsomFormInspector", "AddDoubleQuotesFix", "intellij.clouds.docker.file.backend"})
public final class DockerJsonFormStringLiteralsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.getFile() instanceof DockerPsiFile) {
            psiElementVisitor = (PsiElementVisitor)new JsomFormInspector(holder, isOnTheFly);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"EMPTY_VISITOR");
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection$AddDoubleQuotesFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "literals", "", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileStringLiteral;", "<init>", "(Ljava/util/List;)V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "intellij.clouds.docker.file.backend"})
    @SourceDebugExtension(value={"SMAP\nDockerJsonFormStringLiteralsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerJsonFormStringLiteralsInspection.kt\ncom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection$AddDoubleQuotesFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1915#2,2:67\n1586#2:69\n1661#2,3:70\n*S KotlinDebug\n*F\n+ 1 DockerJsonFormStringLiteralsInspection.kt\ncom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection$AddDoubleQuotesFix\n*L\n52#1:67,2\n63#1:69\n63#1:70,3\n*E\n"})
    private static final class AddDoubleQuotesFix
    implements LocalQuickFix {
        @NotNull
        private final List<DockerFileStringLiteral> literals;

        public AddDoubleQuotesFix(@NotNull List<? extends DockerFileStringLiteral> literals) {
            Intrinsics.checkNotNullParameter(literals, (String)"literals");
            this.literals = literals;
        }

        @NotNull
        public String getFamilyName() {
            String string = DockerBundle.message((String)"DockerJsonFormStringLiteralsInspection.quickfix", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Iterable $this$forEach$iv = this.literals;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerFileStringLiteral literal = (DockerFileStringLiteral)element$iv;
                boolean bl = false;
                String string = literal.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String unquoted = UtilsKt.unquote((String)string);
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)DockerLanguage.INSTANCE, (CharSequence)("ADD [\"" + unquoted + "\"]"));
                Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.docker.dockerFile.DockerPsiFile");
                DockerPsiFile content = (DockerPsiFile)psiFile;
                PsiElement psiElement = content.getFirstChild();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand");
                DockerFileParametersInJsonForm dockerFileParametersInJsonForm = ((DockerFileAddOrCopyCommand)psiElement).getParametersInJsonForm();
                Intrinsics.checkNotNull((Object)dockerFileParametersInJsonForm);
                List list = dockerFileParametersInJsonForm.getStringLiteralList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringLiteralList(...)");
                DockerFileStringLiteral element = (DockerFileStringLiteral)CollectionsKt.first((List)list);
                literal.replace((PsiElement)element);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Iterable $this$map$iv = this.literals;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DockerFileStringLiteral dockerFileStringLiteral = (DockerFileStringLiteral)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((DockerFileStringLiteral)PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)it), (PsiFile)target));
            }
            List list = (List)destination$iv$iv;
            return (FileModifier)new AddDoubleQuotesFix(list);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection$JsomFormInspector;", "Lcom/intellij/docker/dockerFile/inspections/DockerFileInspectorBase;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "visitParametersInJsonForm", "", "o", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileParametersInJsonForm;", "intellij.clouds.docker.file.backend"})
    @SourceDebugExtension(value={"SMAP\nDockerJsonFormStringLiteralsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerJsonFormStringLiteralsInspection.kt\ncom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection$JsomFormInspector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n777#2:67\n873#2,2:68\n*S KotlinDebug\n*F\n+ 1 DockerJsonFormStringLiteralsInspection.kt\ncom/intellij/docker/dockerFile/inspections/DockerJsonFormStringLiteralsInspection$JsomFormInspector\n*L\n33#1:67\n33#1:68,2\n*E\n"})
    private static final class JsomFormInspector
    extends DockerFileInspectorBase {
        public JsomFormInspector(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(holder, isOnTheFly);
        }

        /*
         * WARNING - void declaration
         */
        public void visitParametersInJsonForm(@NotNull DockerFileParametersInJsonForm o) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            List list = o.getStringLiteralList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringLiteralList(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerFileStringLiteral it = (DockerFileStringLiteral)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!DockerJsonFormStringLiteralsInspectionKt.access$isSingleQuoted(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List singleQuotedLiterals = (List)destination$iv$iv;
            if (!((Collection)singleQuotedLiterals).isEmpty()) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AddDoubleQuotesFix(singleQuotedLiterals)};
                this.registerProblem(singleQuotedLiterals, DockerBundle.message((String)"DockerJsonFormStringLiteralsInspection.problem", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, localQuickFixArray);
            }
        }
    }
}

