/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.microservices.diagrams.DiagramsUiBundle;
import com.intellij.microservices.diagrams.MsDiagramRelationship;
import com.intellij.microservices.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.diagrams.model.RequestToWebservice;
import com.intellij.microservices.diagrams.model.RequestsSearcher;
import com.intellij.microservices.diagrams.model.searchers.RequestsToEndpointUrlsSearcher;
import com.intellij.microservices.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.diagrams.utils.GraphUtilsKt;
import com.intellij.microservices.diagrams.utils.TaperingScope;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016JV\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016JJ\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\b0\u0012H\u0002J(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/microservices/diagrams/model/searchers/RequestsToInternalEndpointsSearcher;", "Lcom/intellij/microservices/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "<init>", "()V", "getIndicatorText", "", "Lorg/jetbrains/annotations/Nls;", "getEndpointTypesToSearch", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "findRequestsToEndpointUrls", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/diagrams/model/MsDiagramRequest;", "clientModules", "", "Lcom/intellij/openapi/module/Module;", "moduleToEndpoints", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "project", "Lcom/intellij/openapi/project/Project;", "searchParams", "Lcom/intellij/microservices/diagrams/model/RequestsSearcher$SearchParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createRequestsGraph", "", "serverModules", "moduleToRequests", "Lcom/intellij/microservices/diagrams/model/searchers/RequestsToInternalEndpointsSearcher$RequestToModule;", "searchForRequestsFormingAnEdge", "edge", "Lcom/intellij/microservices/diagrams/presentation/MsDiagramEdge;", "Companion", "RequestToModule", "intellij.microservices.diagrams"})
@SourceDebugExtension(value={"SMAP\nRequestsToInternalEndpointsSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToInternalEndpointsSearcher.kt\ncom/intellij/microservices/diagrams/model/searchers/RequestsToInternalEndpointsSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,137:1\n1234#2,2:138\n1266#2,4:140\n1586#2:150\n1661#2,3:151\n1234#2,2:156\n1266#2,4:158\n1586#2:162\n1661#2,3:163\n91#3:144\n115#3,5:145\n37#4,2:154\n1#5:166\n1#5:169\n72#6,2:167\n*S KotlinDebug\n*F\n+ 1 RequestsToInternalEndpointsSearcher.kt\ncom/intellij/microservices/diagrams/model/searchers/RequestsToInternalEndpointsSearcher\n*L\n57#1:138,2\n57#1:140,4\n63#1:150\n63#1:151,3\n102#1:156,2\n102#1:158,4\n103#1:162\n103#1:163,3\n58#1:144\n58#1:145,5\n63#1:154,2\n79#1:169\n79#1:167,2\n*E\n"})
public final class RequestsToInternalEndpointsSearcher
extends RequestsToEndpointUrlsSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<EndpointType> SERVER_ENDPOINT_TYPES;
    @NotNull
    private static final Set<MsDiagramRelationship> SUPPORTED_RELATIONSHIPS;

    @Override
    @NotNull
    public String getIndicatorText() {
        return DiagramsUiBundle.message("microservices.diagrams.webservices.searching.internal.http.requests", new Object[0]);
    }

    @Override
    @NotNull
    public Set<EndpointType> getEndpointTypesToSearch() {
        return SERVER_ENDPOINT_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> clientModules, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> moduleToEndpoints, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Module target;
        void $this$flatMapTo$iv$iv;
        Object it;
        boolean bl;
        Map<Module, ? extends List<? extends UrlTargetInfo>> $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(clientModules, (String)"clientModules");
        Intrinsics.checkNotNullParameter(moduleToEndpoints, (String)"moduleToEndpoints");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Iterable $this$associateBy$iv = moduleToEndpoints.keySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            Module module = (Module)t;
            Map map = destination$iv$iv;
            bl = false;
            it = (Module)t;
            void var20_28 = it;
            boolean bl2 = false;
            TaperingScope taperingScope = new TaperingScope(project, (Iterable<? extends Module>)clientModules);
            map.put(var20_28, taperingScope);
        }
        Map scopes = destination$iv$iv;
        Map<Module, ? extends List<? extends UrlTargetInfo>> $this$flatMap$iv = moduleToEndpoints;
        boolean $i$f$flatMapSequence232 = false;
        $this$associateByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo232 = false;
        for (Map.Entry entry : $this$flatMapTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            target = (Module)it.getKey();
            List declarations = (List)it.getValue();
            Sequence list$iv$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)declarations), arg_0 -> RequestsToInternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$2$0(project, target, arg_0));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        List elementsToSearchFor = (List)destination$iv$iv;
        Iterable $this$map$iv = elementsToSearchFor;
        boolean $i$f$map = false;
        Iterable $i$f$flatMapSequenceTo232 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            target = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add((NavigatablePsiElement)it2.getFirst());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        NavigatablePsiElement[] $i$f$flatMapSequence232 = thisCollection$iv.toArray(new NavigatablePsiElement[0]);
        PsiElement[] psiElementArray = (PsiElement[])Arrays.copyOf($i$f$flatMapSequence232, $i$f$flatMapSequence232.length);
        SearchSession searchSession = new SearchSession(psiElementArray);
        SearchRequestCollector searchRequestCollector = new SearchRequestCollector(searchSession);
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        ConcurrentMap moduleToRequests = concurrentMap;
        for (Triple triple : elementsToSearchFor) {
            NavigatablePsiElement searchable = (NavigatablePsiElement)triple.component1();
            Module target2 = (Module)triple.component2();
            UrlTargetInfo urlTargetInfo = (UrlTargetInfo)triple.component3();
            Object v = scopes.get(target2);
            Intrinsics.checkNotNull(v);
            TaperingScope searchScope = (TaperingScope)((Object)v);
            ReferencesSearch.searchOptimized((PsiElement)((PsiElement)searchable), (SearchScope)((SearchScope)searchScope), (boolean)true, (SearchRequestCollector)searchRequestCollector, (boolean)false, (arg_0, arg_1) -> RequestsToInternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$4(this, searchParams, moduleToRequests, urlTargetInfo, target2, searchScope, arg_0, arg_1));
        }
        PsiSearchHelper.getInstance((Project)project).processRequests(searchRequestCollector, RequestsToInternalEndpointsSearcher::findRequestsToEndpointUrls$lambda$5);
        return this.createRequestsGraph((Iterable<? extends Module>)clientModules, (Iterable<? extends Module>)moduleToEndpoints.keySet(), moduleToRequests);
    }

    /*
     * WARNING - void declaration
     */
    private final Network<MsDiagramEndpoint, MsDiagramRequest> createRequestsGraph(Iterable<? extends Module> clientModules, Iterable<? extends Module> serverModules, Map<Module, ? extends Set<RequestToModule>> moduleToRequests) {
        void $this$mapTo$iv$iv;
        Module it;
        boolean bl;
        Object object;
        Iterable<? extends Module> $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = CollectionsKt.plus(clientModules, serverModules);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object requestToModule : $this$associateByTo$iv$iv) {
            Module module = (Module)requestToModule;
            object = destination$iv$iv;
            bl = false;
            it = (Module)requestToModule;
            void var18_24 = it;
            boolean bl2 = false;
            MsDiagramWebservice msDiagramWebservice = new MsDiagramWebservice(it);
            object.put(var18_24, msDiagramWebservice);
        }
        Map moduleToWebservice = destination$iv$iv;
        Iterable<? extends Module> $this$map$iv = serverModules;
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (Module)t;
            object = destination$iv$iv;
            bl = false;
            object.add((MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)it));
        }
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf((List)destination$iv$iv);
        for (Map.Entry<Module, ? extends Set<RequestToModule>> entry : moduleToRequests.entrySet()) {
            Module sourceModule = entry.getKey();
            Set<RequestToModule> requests = entry.getValue();
            MsDiagramWebservice source = (MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)sourceModule);
            for (RequestToModule requestToModule : requests) {
                UrlPathReference ref = requestToModule.component1();
                UrlTargetInfo url = requestToModule.component2();
                Module targetModule = requestToModule.component3();
                MsDiagramWebservice target = (MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)targetModule);
                requestsGraph.addEdge((Object)source, (Object)target, (Object)new RequestToWebservice(source, target, url, ref));
            }
        }
        return (Network)requestsGraph;
    }

    @Override
    @NotNull
    public Iterable<MsDiagramRequest> searchForRequestsFormingAnEdge(@NotNull MsDiagramEdge edge, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramEndpoint source = edge.getSource().getIdentifyingElement();
        MsDiagramEndpoint target = edge.getTarget().getIdentifyingElement();
        if (!(source instanceof MsDiagramWebservice && target instanceof MsDiagramWebservice && SUPPORTED_RELATIONSHIPS.contains((Object)edge.getRelationship()))) {
            return CollectionsKt.emptyList();
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWebservice)target).getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Map<Module, List<UrlTargetInfo>> moduleToRequestDeclarations = this.findModulesEndpointUrls(CollectionsKt.listOf((Object)((MsDiagramWebservice)target).getModule()), this.getEndpointTypesToSearch(), project2, searchParams);
        Set set = this.findRequestsToEndpointUrls(CollectionsKt.listOf((Object)((MsDiagramWebservice)source).getModule()), moduleToRequestDeclarations, project2, searchParams, indicator).edges();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"edges(...)");
        return set;
    }

    private static final NavigatablePsiElement findRequestsToEndpointUrls$lambda$2$0$0(Project $project, UrlTargetInfo $declaration) {
        return UrlPathReference.Companion.createSearchableElement($project, $declaration);
    }

    private static final Triple findRequestsToEndpointUrls$lambda$2$0(Project $project, Module $target, UrlTargetInfo declaration) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)ActionsKt.runReadAction(() -> RequestsToInternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$2$0$0($project, declaration));
        if (navigatablePsiElement != null) {
            NavigatablePsiElement it = navigatablePsiElement;
            boolean bl = false;
            triple = new Triple((Object)it, (Object)$target, (Object)declaration);
        } else {
            triple = null;
        }
        return triple;
    }

    private static final Module findRequestsToEndpointUrls$lambda$4$0(PsiReference $reference) {
        return ModuleUtil.findModuleForPsiElement((PsiElement)$reference.getElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean findRequestsToEndpointUrls$lambda$4(RequestsToInternalEndpointsSearcher this$0, RequestsSearcher.SearchParams $searchParams, ConcurrentMap $moduleToRequests, UrlTargetInfo $mapping, Module $target, TaperingScope $searchScope, PsiReference reference, SearchRequestCollector searchRequestCollector) {
        Module source;
        Intrinsics.checkNotNull((Object)reference);
        if (this$0.isAppropriateReference(reference, $searchParams) && (source = (Module)ActionsKt.runReadAction(() -> RequestsToInternalEndpointsSearcher.findRequestsToEndpointUrls$lambda$4$0(reference))) != null) {
            void $this$getOrPut$iv;
            Object object = $moduleToRequests;
            Module key$iv = source;
            boolean $i$f$getOrPut = false;
            Object object2 = $this$getOrPut$iv.get(key$iv);
            if (object2 == null) {
                boolean bl = false;
                Set default$iv = ConcurrentCollectionFactory.createConcurrentIdentitySet();
                boolean bl2 = false;
                object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object2 == null) {
                    object2 = default$iv;
                }
            }
            ((Set)object2).add(new RequestToModule((UrlPathReference)reference, $mapping, $target));
            object = $searchScope;
            synchronized (object) {
                boolean bl = false;
                $searchScope.removeFromConsideration(source);
                Unit unit = Unit.INSTANCE;
            }
        }
        return true;
    }

    private static final boolean findRequestsToEndpointUrls$lambda$5(PsiReference it) {
        return true;
    }

    static {
        Object[] objectArray = new EndpointType[]{EndpointTypes.HTTP_SERVER_TYPE, EndpointTypes.WEBSOCKET_SERVER_TYPE};
        SERVER_ENDPOINT_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new MsDiagramRelationship[]{MsDiagramRelationshipsKt.BASE_HTTP_REQUEST_RELATIONSHIP, MsDiagramRelationshipsKt.WEBSOCKET_REQUEST_RELATIONSHIP};
        SUPPORTED_RELATIONSHIPS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/diagrams/model/searchers/RequestsToInternalEndpointsSearcher$Companion;", "", "<init>", "()V", "SERVER_ENDPOINT_TYPES", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "SUPPORTED_RELATIONSHIPS", "Lcom/intellij/microservices/diagrams/MsDiagramRelationship;", "intellij.microservices.diagrams"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/microservices/diagrams/model/searchers/RequestsToInternalEndpointsSearcher$RequestToModule;", "", "reference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "target", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/microservices/url/references/UrlPathReference;Lcom/intellij/microservices/url/UrlTargetInfo;Lcom/intellij/openapi/module/Module;)V", "getReference", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "getTargetInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "getTarget", "()Lcom/intellij/openapi/module/Module;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.microservices.diagrams"})
    private static final class RequestToModule {
        @NotNull
        private final UrlPathReference reference;
        @NotNull
        private final UrlTargetInfo targetInfo;
        @NotNull
        private final Module target;

        public RequestToModule(@NotNull UrlPathReference reference, @NotNull UrlTargetInfo targetInfo, @NotNull Module target) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.reference = reference;
            this.targetInfo = targetInfo;
            this.target = target;
        }

        @NotNull
        public final UrlPathReference getReference() {
            return this.reference;
        }

        @NotNull
        public final UrlTargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        @NotNull
        public final Module getTarget() {
            return this.target;
        }

        @NotNull
        public final UrlPathReference component1() {
            return this.reference;
        }

        @NotNull
        public final UrlTargetInfo component2() {
            return this.targetInfo;
        }

        @NotNull
        public final Module component3() {
            return this.target;
        }

        @NotNull
        public final RequestToModule copy(@NotNull UrlPathReference reference, @NotNull UrlTargetInfo targetInfo, @NotNull Module target) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new RequestToModule(reference, targetInfo, target);
        }

        public static /* synthetic */ RequestToModule copy$default(RequestToModule requestToModule, UrlPathReference urlPathReference, UrlTargetInfo urlTargetInfo, Module module, int n, Object object) {
            if ((n & 1) != 0) {
                urlPathReference = requestToModule.reference;
            }
            if ((n & 2) != 0) {
                urlTargetInfo = requestToModule.targetInfo;
            }
            if ((n & 4) != 0) {
                module = requestToModule.target;
            }
            return requestToModule.copy(urlPathReference, urlTargetInfo, module);
        }

        @NotNull
        public String toString() {
            return "RequestToModule(reference=" + this.reference + ", targetInfo=" + this.targetInfo + ", target=" + this.target + ")";
        }

        public int hashCode() {
            int result = this.reference.hashCode();
            result = result * 31 + this.targetInfo.hashCode();
            result = result * 31 + this.target.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestToModule)) {
                return false;
            }
            RequestToModule requestToModule = (RequestToModule)other;
            if (!Intrinsics.areEqual((Object)this.reference, (Object)requestToModule.reference)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetInfo, (Object)requestToModule.targetInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)requestToModule.target);
        }
    }
}

