/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.backend.gotourl;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u00060\u0011R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher;", "", "compositeSegment", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "<init>", "(Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;)V", "patternSegments", "", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "lengthOfPresentationBefore", "", "tryMatch", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "segmentPart", "", "matchFrom", "Lcom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher$SegmentCharCursor;", "fromSegment", "fromCharIndex", "SegmentCharCursor", "Companion", "intellij.microservices.backend"})
@SourceDebugExtension(value={"SMAP\nUrlSearchMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlSearchMatcher.kt\ncom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,364:1\n1#2:365\n1484#3,14:366\n*S KotlinDebug\n*F\n+ 1 UrlSearchMatcher.kt\ncom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher\n*L\n211#1:366,14\n*E\n"})
final class CompositeSegmentPatternMatcher {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPath.PathSegment.Composite compositeSegment;
    @NotNull
    private final List<UrlPath.PathSegment> patternSegments;
    @NotNull
    private final List<Integer> lengthOfPresentationBefore;

    public CompositeSegmentPatternMatcher(@NotNull UrlPath.PathSegment.Composite compositeSegment) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)compositeSegment, (String)"compositeSegment");
        this.compositeSegment = compositeSegment;
        Object object = (Object[])new ArrayList();
        Object[] objectArray = object;
        CompositeSegmentPatternMatcher compositeSegmentPatternMatcher = this;
        boolean bl = false;
        Companion.flatten((UrlPath.PathSegment)this.compositeSegment, (List<UrlPath.PathSegment>)it);
        compositeSegmentPatternMatcher.patternSegments = object;
        object = new Integer[]{0};
        it = object = CollectionsKt.mutableListOf((Object[])object);
        compositeSegmentPatternMatcher = this;
        boolean bl2 = false;
        int i = 1;
        int n = CollectionsKt.getLastIndex(this.patternSegments);
        if (i <= n) {
            while (true) {
                ((Collection)it).add(((Number)it.get(i - 1)).intValue() + UrlPath.FULL_PATH_VARIABLE_PRESENTATION.patternMatch(this.patternSegments.get(i - 1)).length());
                if (i == n) break;
                ++i;
            }
        }
        compositeSegmentPatternMatcher.lengthOfPresentationBefore = object;
    }

    @Nullable
    public final Pair<TextRange, Integer> tryMatch(@NotNull String segmentPart) {
        Pair pair;
        Object v0;
        Intrinsics.checkNotNullParameter((Object)segmentPart, (String)"segmentPart");
        Sequence $this$maxByOrNull$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, CollectionsKt.getLastIndex(this.patternSegments)))), arg_0 -> CompositeSegmentPatternMatcher.tryMatch$lambda$0(this, segmentPart, arg_0));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                SegmentCharCursor it = (SegmentCharCursor)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getExactMatchCount();
                do {
                    Object e$iv = iterator$iv.next();
                    SegmentCharCursor it2 = (SegmentCharCursor)e$iv;
                    $i$a$-maxByOrNull-CompositeSegmentPatternMatcher$tryMatch$2 = false;
                    int v$iv = it2.getExactMatchCount();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        SegmentCharCursor segmentCharCursor = v0;
        if (segmentCharCursor != null) {
            SegmentCharCursor cursor = segmentCharCursor;
            boolean bl = false;
            TextRange textRange = cursor.toPresentationTextRange();
            if (textRange != null) {
                TextRange it = textRange;
                boolean bl2 = false;
                pair = TuplesKt.to((Object)it, (Object)cursor.getExactMatchCount());
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    private final SegmentCharCursor matchFrom(int fromSegment, int fromCharIndex, String segmentPart) {
        char c;
        SegmentCharCursor cursor = new SegmentCharCursor(fromSegment, fromCharIndex);
        int n = segmentPart.length();
        for (int i = 0; i < n && cursor.accept(c = segmentPart.charAt(i)); ++i) {
        }
        return cursor;
    }

    private static final SegmentCharCursor tryMatch$lambda$0$0(CompositeSegmentPatternMatcher this$0, int $segmentIndex, String $segmentPart, int it) {
        return this$0.matchFrom($segmentIndex, it, $segmentPart);
    }

    private static final Sequence tryMatch$lambda$0(CompositeSegmentPatternMatcher this$0, String $segmentPart, int segmentIndex) {
        Sequence sequence;
        UrlPath.PathSegment currentSegment = this$0.patternSegments.get(segmentIndex);
        if (currentSegment instanceof UrlPath.PathSegment.Exact) {
            sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, StringsKt.getLastIndex((CharSequence)((UrlPath.PathSegment.Exact)currentSegment).getValue())))), arg_0 -> CompositeSegmentPatternMatcher.tryMatch$lambda$0$0(this$0, segmentIndex, $segmentPart, arg_0));
        } else if (Intrinsics.areEqual((Object)currentSegment, (Object)UrlPath.PathSegment.Undefined.INSTANCE) || currentSegment instanceof UrlPath.PathSegment.Variable) {
            sequence = SequencesKt.sequenceOf((Object)this$0.matchFrom(segmentIndex, 0, $segmentPart));
        } else {
            if (currentSegment instanceof UrlPath.PathSegment.Composite) {
                throw new IllegalStateException("'patternSegments' List should be flattened".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return sequence;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a8\u0006\n"}, d2={"Lcom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher$Companion;", "", "<init>", "()V", "flatten", "", "segment", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "collector", "", "intellij.microservices.backend"})
    @SourceDebugExtension(value={"SMAP\nUrlSearchMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlSearchMatcher.kt\ncom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,364:1\n1915#2,2:365\n*S KotlinDebug\n*F\n+ 1 UrlSearchMatcher.kt\ncom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher$Companion\n*L\n287#1:365,2\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        public final void flatten(@NotNull UrlPath.PathSegment segment, @NotNull List<UrlPath.PathSegment> collector) {
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            Intrinsics.checkNotNullParameter(collector, (String)"collector");
            UrlPath.PathSegment pathSegment = segment;
            if (pathSegment instanceof UrlPath.PathSegment.Composite) {
                Iterable $this$forEach$iv = ((UrlPath.PathSegment.Composite)segment).getSegments();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UrlPath.PathSegment it = (UrlPath.PathSegment)element$iv;
                    boolean bl = false;
                    Companion.flatten(it, collector);
                }
            } else if (pathSegment instanceof UrlPath.PathSegment.Exact) {
                ((Collection)collector).add(segment);
            } else if (Intrinsics.areEqual((Object)pathSegment, (Object)UrlPath.PathSegment.Undefined.INSTANCE)) {
                ((Collection)collector).add(segment);
            } else if (pathSegment instanceof UrlPath.PathSegment.Variable) {
                ((Collection)collector).add(segment);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher$SegmentCharCursor;", "", "segment", "", "charIndex", "<init>", "(Lcom/intellij/microservices/backend/gotourl/CompositeSegmentPatternMatcher;II)V", "beginSegment", "beginCharIndex", "value", "exactMatchCount", "getExactMatchCount", "()I", "accept", "", "char", "", "toPresentationTextRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.microservices.backend"})
    private final class SegmentCharCursor {
        private int segment;
        private int charIndex;
        private final int beginSegment;
        private final int beginCharIndex;
        private int exactMatchCount;

        public SegmentCharCursor(int segment, int charIndex) {
            this.segment = segment;
            this.charIndex = charIndex;
            this.beginSegment = this.segment;
            this.beginCharIndex = this.charIndex;
        }

        public final int getExactMatchCount() {
            return this.exactMatchCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final boolean accept(char c) {
            int n;
            if (this.segment > CollectionsKt.getLastIndex((List)CompositeSegmentPatternMatcher.this.patternSegments)) {
                return false;
            }
            UrlPath.PathSegment currentSegment = (UrlPath.PathSegment)CompositeSegmentPatternMatcher.this.patternSegments.get(this.segment);
            if (currentSegment instanceof UrlPath.PathSegment.Exact) {
                if (((UrlPath.PathSegment.Exact)currentSegment).getValue().charAt(this.charIndex) != c) {
                    return false;
                }
                int n2 = this.exactMatchCount;
                this.exactMatchCount = n2 + 1;
                if (StringsKt.getLastIndex((CharSequence)((UrlPath.PathSegment.Exact)currentSegment).getValue()) > this.charIndex) {
                    n2 = this.charIndex;
                    this.charIndex = n2 + 1;
                    return true;
                }
                n2 = this.segment;
                this.segment = n2 + 1;
                this.charIndex = 0;
                return true;
            }
            if (!(currentSegment instanceof UrlPath.PathSegment.Variable) && !(currentSegment instanceof UrlPath.PathSegment.Undefined)) {
                if (!(currentSegment instanceof UrlPath.PathSegment.Composite)) throw new NoWhenBranchMatchedException();
                throw new IllegalStateException("'patternSegments' List should be flattened".toString());
            }
            UrlPath.PathSegment nextSegment = (UrlPath.PathSegment)CollectionsKt.getOrNull((List)CompositeSegmentPatternMatcher.this.patternSegments, (int)(this.segment + 1));
            if (nextSegment instanceof UrlPath.PathSegment.Exact) {
                Character c2 = StringsKt.firstOrNull((CharSequence)((UrlPath.PathSegment.Exact)nextSegment).getValue());
                n = c;
                if (c2 != null && c2.charValue() == n) {
                    n = this.exactMatchCount;
                    this.exactMatchCount = n + 1;
                    if (((UrlPath.PathSegment.Exact)nextSegment).getValue().length() > 1) {
                        n = this.segment;
                        this.segment = n + 1;
                        this.charIndex = 1;
                        return true;
                    }
                    this.segment += 2;
                    this.charIndex = 0;
                    return true;
                }
            }
            n = this.charIndex;
            this.charIndex = n + 1;
            return true;
        }

        @Nullable
        public final TextRange toPresentationTextRange() {
            if (this.exactMatchCount == 0) {
                return null;
            }
            int lastIndex = CompositeSegmentPatternMatcher.this.patternSegments.get(this.segment) instanceof UrlPath.PathSegment.Exact ? ((Number)CompositeSegmentPatternMatcher.this.lengthOfPresentationBefore.get(this.segment)).intValue() + this.charIndex : ((Number)CompositeSegmentPatternMatcher.this.lengthOfPresentationBefore.get(this.segment)).intValue() + (this.charIndex == 0 ? 0 : UrlPath.FULL_PATH_VARIABLE_PRESENTATION.patternMatch((UrlPath.PathSegment)CompositeSegmentPatternMatcher.this.patternSegments.get(this.segment)).length());
            return new TextRange(((Number)CompositeSegmentPatternMatcher.this.lengthOfPresentationBefore.get(this.beginSegment)).intValue() + this.beginCharIndex, lastIndex);
        }
    }
}

