/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.telephony;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.telephony.TelephonyManager;
import com.intellij.cwm.plugin.common.telephony.TelephonySession;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.cwm.plugin.following.FollowMeManager;
import com.intellij.cwm.plugin.join.BackendJoinLinkManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.session.CodeWithMeSessionListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.split.connection.SessionEndedReason;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.RdUserId;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.codeWithMe.model.TelephonyModel;
import com.jetbrains.codeWithMe.model.TelephonyModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.TelephonyProperties;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/cwm/plugin/telephony/BackendTelephonyManager;", "Lcom/intellij/cwm/plugin/common/telephony/TelephonyManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "monitoringLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "startSession", "", "startSession$intellij_cwm_plugin", "stopSession", "stopSession$intellij_cwm_plugin", "isTelephonyEnabled", "Lcom/jetbrains/rd/util/reactive/Property;", "", "()Lcom/jetbrains/rd/util/reactive/Property;", "getUserCount", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "", "getJitsiRoomUrl", "", "Companion", "MyLinkListener", "MyRemoteClientListener", "MyListener", "intellij.cwm.plugin"})
public final class BackendTelephonyManager
extends TelephonyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LifetimeDefinition monitoringLifetime;
    @NotNull
    private final Property<Boolean> isTelephonyEnabled;
    @NotNull
    private static final String enabledByDefaultKey = "codeWithMe.voiceChat.enabledByDefault";

    /*
     * WARNING - void declaration
     */
    public BackendTelephonyManager(@NotNull Project project) {
        void $this$isTelephonyEnabled_u24lambda_u240;
        Property property;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.monitoringLifetime = this.getServiceLifetime().createNested();
        Property property2 = property = new Property((Object)PropertiesComponent.getInstance((Project)project).getBoolean(enabledByDefaultKey, true));
        BackendTelephonyManager backendTelephonyManager = this;
        boolean bl = false;
        $this$isTelephonyEnabled_u24lambda_u240.advise(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> BackendTelephonyManager.isTelephonyEnabled$lambda$0$0(project, arg_0));
        backendTelephonyManager.isTelephonyEnabled = property;
    }

    public final void startSession$intellij_cwm_plugin() {
        this.monitoringLifetime = this.getServiceLifetime().createNested();
        this.monitoringLifetime.onTermination(() -> BackendTelephonyManager.startSession$lambda$0(this));
        if (this.getJoinCallOnStart()) {
            BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.isTelephonyEnabled), (Lifetime)((Lifetime)this.monitoringLifetime), arg_0 -> BackendTelephonyManager.startSession$lambda$1(this, arg_0));
        }
        InterfacesKt.viewNotNull((IViewable)((IViewable)this.getTelephonySessionView()), (Lifetime)((Lifetime)this.monitoringLifetime), (arg_0, arg_1) -> BackendTelephonyManager.startSession$lambda$2(this, arg_0, arg_1));
    }

    public final void stopSession$intellij_cwm_plugin() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.monitoringLifetime, (boolean)false, (int)1, null);
    }

    @NotNull
    public final Property<Boolean> isTelephonyEnabled() {
        return this.isTelephonyEnabled;
    }

    @NotNull
    public IOptPropertyView<Integer> getUserCount() {
        return (IOptPropertyView)FollowMeManager.Companion.getInstance(this.getProject()).getTelephonyUsersCounter();
    }

    @Nullable
    protected String getJitsiRoomUrl() {
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.getProject()).getJoinLinkData();
        return joinLinkData != null ? joinLinkData.getTelephonyUrl() : null;
    }

    private static final Pair startSession$lambda$2$1$0$0(RdUserModel $user, boolean it) {
        return TuplesKt.to((Object)it, (Object)$user);
    }

    private static final Pair startSession$lambda$2$1$0$1(RdUserModel $user, boolean it) {
        return TuplesKt.to((Object)it, (Object)$user);
    }

    private static final Unit startSession$lambda$2$1$0(BackendTelephonyManager this$0, TelephonySession $session, RdUserModel $user, TelephonyProperties properties) {
        block1: {
            TelephonyProperties telephonyProperties;
            TelephonyProperties telephonyProperties2 = properties;
            if (telephonyProperties2 != null && (telephonyProperties2 = telephonyProperties2.isCameraEnabled()) != null) {
                SourceExKt.flowInto((ISource)((ISource)telephonyProperties2), (Lifetime)this$0.getServiceLifetime(), (ISignal)((ISignal)$session.getUserEnabledCamera()), arg_0 -> BackendTelephonyManager.startSession$lambda$2$1$0$0($user, arg_0));
            }
            if ((telephonyProperties = properties) == null || (telephonyProperties = telephonyProperties.isSharingEnabled()) == null) break block1;
            SourceExKt.flowInto((ISource)((ISource)telephonyProperties), (Lifetime)this$0.getServiceLifetime(), (ISignal)((ISignal)$session.getUserEnabledSharing()), arg_0 -> BackendTelephonyManager.startSession$lambda$2$1$0$1($user, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void startSession$lambda$2$0(BackendTelephonyManager this$0, TelephonySession $session, Lifetime $sessionLifetime) {
        RdUserProperties rdUserProperties = FollowMeManager.Companion.getInstance(this$0.getProject()).getUserProperties(new RdUserId(ClientId.Companion.getLocalId().getValue()));
        if (rdUserProperties == null) {
            throw new IllegalStateException("Can not find user for local user".toString());
        }
        RdUserProperties user = rdUserProperties;
        TelephonyProperties telephonyProperties = new TelephonyProperties();
        user.getTelephonyProperty().set((Object)telephonyProperties);
        SourceExKt.flowInto((ISource)((ISource)$session.getConferenceJoined()), (Lifetime)$sessionLifetime, (IMutablePropertyBase)((IMutablePropertyBase)telephonyProperties.isJoinedToCall()));
        SourceExKt.flowInto((ISource)((ISource)$session.getMicrophoneEnabled()), (Lifetime)$sessionLifetime, (IMutablePropertyBase)((IMutablePropertyBase)telephonyProperties.isMicrophoneEnabled()));
        SourceExKt.flowInto((ISource)((ISource)$session.getCameraEnabled()), (Lifetime)$sessionLifetime, (IMutablePropertyBase)((IMutablePropertyBase)telephonyProperties.isCameraEnabled()));
        SourceExKt.flowInto((ISource)((ISource)$session.getScreenSharingEnabled()), (Lifetime)$sessionLifetime, (IMutablePropertyBase)((IMutablePropertyBase)telephonyProperties.isSharingEnabled()));
    }

    private static final Unit startSession$lambda$2$1(FollowMeManager $manager, BackendTelephonyManager this$0, TelephonySession $session, IViewableMap.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdUserModel rdUserModel = (RdUserModel)it.getNewValueOpt();
        if (rdUserModel == null) {
            return Unit.INSTANCE;
        }
        RdUserModel user = rdUserModel;
        RdUserProperties rdUserProperties = $manager.getUserProperties(user.getUserId());
        if (rdUserProperties == null) {
            throw new IllegalStateException(("Can not find user for RdUserId=" + user.getUserId()).toString());
        }
        RdUserProperties userProperties = rdUserProperties;
        if (!UserManagerKt.isMe((RdUserModel)user)) {
            userProperties.getTelephonyProperty().advise(this$0.getServiceLifetime(), arg_0 -> BackendTelephonyManager.startSession$lambda$2$1$0(this$0, $session, user, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit startSession$lambda$0(BackendTelephonyManager this$0) {
        this$0.terminateSession();
        return Unit.INSTANCE;
    }

    private static final Unit startSession$lambda$1(BackendTelephonyManager this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createSession(it);
        return Unit.INSTANCE;
    }

    private static final Unit startSession$lambda$2(BackendTelephonyManager this$0, Lifetime sessionLifetime, TelephonySession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ApplicationKt.getApplication().invokeLater(() -> BackendTelephonyManager.startSession$lambda$2$0(this$0, session, sessionLifetime));
        FollowMeManager manager = FollowMeManager.Companion.getInstance(this$0.getProject());
        manager.getUsers().advise(this$0.getServiceLifetime(), arg_0 -> BackendTelephonyManager.startSession$lambda$2$1(manager, this$0, session, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit isTelephonyEnabled$lambda$0$0(Project $project, boolean it) {
        PropertiesComponent.getInstance((Project)$project).setValue(enabledByDefaultKey, it, true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/telephony/BackendTelephonyManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/plugin/telephony/BackendTelephonyManager;", "project", "Lcom/intellij/openapi/project/Project;", "enabledByDefaultKey", "", "intellij.cwm.plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendTelephonyManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            TelephonyManager telephonyManager = TelephonyManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)telephonyManager, (String)"null cannot be cast to non-null type com.intellij.cwm.plugin.telephony.BackendTelephonyManager");
            return (BackendTelephonyManager)telephonyManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/cwm/plugin/telephony/BackendTelephonyManager$MyLinkListener;", "Lcom/intellij/cwm/plugin/session/CodeWithMeSessionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionCreated", "", "joinLinkData", "Lcom/intellij/cwm/plugin/join/JoinLinkData;", "sessionEnded", "reason", "Lcom/intellij/platform/split/connection/SessionEndedReason;", "intellij.cwm.plugin"})
    public static final class MyLinkListener
    implements CodeWithMeSessionListener {
        @NotNull
        private final Project project;

        public MyLinkListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void sessionCreated(@NotNull JoinLinkData joinLinkData) {
            Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
            Companion.getInstance(this.project).startSession$intellij_cwm_plugin();
        }

        @Override
        public void sessionEnded(@NotNull SessionEndedReason reason, @NotNull JoinLinkData joinLinkData) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
            Companion.getInstance(this.project).stopSession$intellij_cwm_plugin();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/cwm/plugin/telephony/BackendTelephonyManager$MyListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/TelephonyModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.cwm.plugin"})
    public static final class MyListener
    implements SolutionExtListener<TelephonyModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull TelephonyModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            model2.getGuestUserTelephonyProperties().view(lifetime, (arg_0, arg_1) -> MyListener.extensionCreated$lambda$0(session, arg_0, arg_1));
            OptProperty<Integer> telephonyUsersCounter = FollowMeManager.Companion.getInstance(session.getProject()).getTelephonyUsersCounter();
            telephonyUsersCounter.advise(lifetime, arg_0 -> MyListener.extensionCreated$lambda$1(model2, arg_0));
            Companion.getInstance(session.getProject()).adviseOnCount();
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, Lifetime guestUserTelephonyPropertiesLifetime, TelephonyProperties guestUserTelephonyProperties) {
            Intrinsics.checkNotNullParameter((Object)guestUserTelephonyPropertiesLifetime, (String)"guestUserTelephonyPropertiesLifetime");
            RdUserProperties userProperties = FollowMeManager.Companion.getInstance($session.getProject()).getUserProperties($session.getClientId());
            if (guestUserTelephonyProperties != null) {
                TelephonyProperties telephonyProperty = new TelephonyProperties();
                userProperties.getTelephonyProperty().set((Object)telephonyProperty);
                RdBindableBase.synchronizeWith$default((RdBindableBase)((RdBindableBase)guestUserTelephonyProperties), (Lifetime)guestUserTelephonyPropertiesLifetime, (RdBindableBase)((RdBindableBase)telephonyProperty), null, (int)4, null);
            } else {
                userProperties.getTelephonyProperty().set(null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(TelephonyModel $model, int it) {
            $model.getTelephonyUsersCounter().set((Object)it);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/telephony/BackendTelephonyManager$MyRemoteClientListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "projectSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.cwm.plugin"})
    public static final class MyRemoteClientListener
    implements RemoteClientSessionListener {
        public void projectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Companion.getInstance(session.getProject()).isTelephonyEnabled().advise(lifetime, arg_0 -> MyRemoteClientListener.projectSessionInitialized$lambda$0(session, arg_0));
        }

        private static final Unit projectSessionInitialized$lambda$0(ClientProjectSession $session, boolean it) {
            TelephonyModel_GeneratedKt.getTelephonyModel((Solution)RemoteSessionKt.getProtocolModel((ClientProjectSession)$session)).getTelephonyEnabled().set((Object)it);
            return Unit.INSTANCE;
        }
    }
}

