/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.users;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.CodeWithMeBackendBundle;
import com.intellij.cwm.plugin.common.BaseCwmNotifications;
import com.intellij.cwm.plugin.common.users.ConnectableUser;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.cwm.plugin.following.BackendUserOperations;
import com.intellij.cwm.plugin.following.FollowMeManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.session.CodeWithMeSessionListener;
import com.intellij.cwm.plugin.ui.CWMHostNotifications;
import com.intellij.cwm.plugin.users.BackendUserActionsKt;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.split.connection.SessionEndedReason;
import com.jetbrains.codeWithMe.model.RdUserId;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/cwm/plugin/users/BackendUserManager;", "Lcom/intellij/cwm/plugin/common/users/UserManager;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "showClientJoinedNotification", "", "user", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "showClientLeftNotification", "jumpTo", "startFollowing", "stopFollowing", "requestFollowing", "force", "", "requestStopFollowing", "getUserById", "id", "Lcom/jetbrains/codeWithMe/model/RdUserId;", "getUserProperties", "Lcom/jetbrains/codeWithMe/model/RdUserProperties;", "createUserActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "BackendUserManagerJoinLinkListener", "Listener", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nBackendUserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendUserManager.kt\ncom/intellij/cwm/plugin/users/BackendUserManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n23#2:205\n*S KotlinDebug\n*F\n+ 1 BackendUserManager.kt\ncom/intellij/cwm/plugin/users/BackendUserManager\n*L\n43#1:205\n*E\n"})
final class BackendUserManager
extends UserManager {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger logger;

    public BackendUserManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, this, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ BackendUserManager this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FollowMeManager followMeManager = FollowMeManager.Companion.getInstance(this.$project);
                        followMeManager.getConnectableUsers().view(this.this$0.getServiceLifetime(), (arg_0, arg_1, arg_2) -> 1.invokeSuspend$lambda$0(this.this$0, this.$project, arg_0, arg_1, arg_2));
                        followMeManager.getFollowers().view(this.this$0.getServiceLifetime(), (arg_0, arg_1, arg_2) -> 1.invokeSuspend$lambda$1(followMeManager, this.this$0, arg_0, arg_1, arg_2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0$0(RdUserModel $followMeManagerRdUser, IProperty $followMeManagerConnectedProperty, Lifetime $followMeManagerUserLifetime, IViewableList.Event event) {
                ConnectableUser connectableUser = (ConnectableUser)event.getNewValueOpt();
                if (connectableUser == null) {
                    return Unit.INSTANCE;
                }
                ConnectableUser userManagerConnectableUser = connectableUser;
                if (Intrinsics.areEqual((Object)userManagerConnectableUser.getUser(), (Object)$followMeManagerRdUser)) {
                    SourceExKt.flowInto((ISource)((ISource)$followMeManagerConnectedProperty), (Lifetime)$followMeManagerUserLifetime, (IMutablePropertyBase)((IMutablePropertyBase)userManagerConnectableUser.getConnected()));
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$0$1(Project $project, ClientId $followMeManagerClientId, BackendUserManager this$0, RdUserModel $followMeManagerRdUser, ConnectableUser $followMeManagerConnectableUser, boolean connected) {
                Logger $this$debug_u24default$iv = logger;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Connected state for user (name: " + $followMeManagerConnectableUser.getUser().getName() + ") has been changed to: " + connected, t$iv);
                }
                if (ClientSessionsUtil.session((Project)$project, (ClientId)$followMeManagerClientId).isOwner()) {
                    return Unit.INSTANCE;
                }
                if (connected) {
                    this$0.showClientJoinedNotification($followMeManagerRdUser);
                } else {
                    this$0.showClientLeftNotification($followMeManagerRdUser);
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$0$2(ClientId $followMeManagerClientId) {
                Logger $this$debug_u24default$iv = logger;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Terminate connectable user lifetime for: " + $followMeManagerClientId.getValue(), t$iv);
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$0(BackendUserManager this$0, Project $project, Lifetime followMeManagerUserLifetime, ClientId followMeManagerClientId, ConnectableUser followMeManagerConnectableUser) {
                RdUserModel followMeManagerRdUser = followMeManagerConnectableUser.getUser();
                IProperty followMeManagerConnectedProperty = followMeManagerConnectableUser.getConnected();
                this$0.getConnectableUsers().advise(followMeManagerUserLifetime, arg_0 -> 1.invokeSuspend$lambda$0$0(followMeManagerRdUser, followMeManagerConnectedProperty, followMeManagerUserLifetime, arg_0));
                this$0.registerUser(followMeManagerUserLifetime, followMeManagerRdUser);
                followMeManagerConnectableUser.getConnected().advise(followMeManagerUserLifetime, arg_0 -> 1.invokeSuspend$lambda$0$1($project, followMeManagerClientId, this$0, followMeManagerRdUser, followMeManagerConnectableUser, arg_0));
                followMeManagerUserLifetime.onTermination(() -> 1.invokeSuspend$lambda$0$2(followMeManagerClientId));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(FollowMeManager $followMeManager, BackendUserManager this$0, Lifetime lt, ClientId who, ClientId whom) {
                RdUserModel user;
                if (Intrinsics.areEqual((Object)who, (Object)ClientId.Companion.getLocalId())) {
                    user = $followMeManager.getUser(whom);
                    InterfacesKt.setValue((IProperty)((IProperty)this$0.getLeadProperty()), (Lifetime)lt, (Object)user);
                }
                if (Intrinsics.areEqual((Object)whom, (Object)ClientId.Companion.getLocalId())) {
                    user = $followMeManager.getUser(who);
                    CollectionExKt.addUnique((Collection)((Collection)this$0.getFollowersList()), (Lifetime)lt, (Object)user);
                }
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    private final void showClientJoinedNotification(RdUserModel user) {
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> BackendUserManager.showClientJoinedNotification$lambda$0(user, this));
    }

    private final void showClientLeftNotification(RdUserModel user) {
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> BackendUserManager.showClientLeftNotification$lambda$0(user, this));
    }

    public void jumpTo(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        ClientProjectSession localSession = (ClientProjectSession)CollectionsKt.single((List)ClientSessionsManager.Companion.getProjectSessions(this.getProject(), ClientKind.LOCAL));
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this.getProject(), UserManagerKt.getClientId((RdUserModel)user));
        Intrinsics.checkNotNull((Object)clientProjectSession);
        ClientProjectSession guestSession = clientProjectSession;
        BackendUserOperations.INSTANCE.jump(localSession, guestSession);
    }

    public void startFollowing(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        FollowMeManager.Companion.getInstance(this.getProject()).registerFollower(ClientId.Companion.getLocalId(), UserManagerKt.getClientId((RdUserModel)user));
        this.setRecentLead((IPropertyView)new Property(this.getLead().getValue()));
    }

    public void stopFollowing() {
        IPropertyView tmpLead = (IPropertyView)new Property(this.getLead().getValue());
        FollowMeManager.Companion.getInstance(this.getProject()).unregisterFollower(ClientId.Companion.getLocalId());
        this.setRecentLead(tmpLead);
    }

    public void requestFollowing(@NotNull RdUserModel user, boolean force) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        ClientProjectSession localSession = (ClientProjectSession)CollectionsKt.single((List)ClientSessionsManager.Companion.getProjectSessions(this.getProject(), ClientKind.LOCAL));
        ClientProjectSession userSession = ClientSessionsUtil.session((Project)this.getProject(), (ClientId)UserManagerKt.getClientId((RdUserModel)user));
        BackendUserOperations.INSTANCE.requestFollowing(localSession, userSession, force);
    }

    public void requestStopFollowing(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        ClientProjectSession localSession = (ClientProjectSession)CollectionsKt.single((List)ClientSessionsManager.Companion.getProjectSessions(this.getProject(), ClientKind.LOCAL));
        ClientProjectSession userSession = ClientSessionsUtil.session((Project)this.getProject(), (ClientId)UserManagerKt.getClientId((RdUserModel)user));
        BackendUserOperations.INSTANCE.requestStopFollowing(localSession, userSession);
    }

    @Nullable
    public RdUserModel getUserById(@NotNull RdUserId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return FollowMeManager.Companion.getInstance(this.getProject()).getUser(new ClientId(id.getClientIdValue()));
    }

    @Nullable
    public RdUserProperties getUserProperties(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return FollowMeManager.Companion.getInstance(this.getProject()).getUserProperties(user.getUserId());
    }

    @NotNull
    public List<AnAction> createUserActions(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object[] objectArray = new AnAction[3];
        objectArray[0] = new Separator();
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this.getProject(), UserManagerKt.getClientId((RdUserModel)user));
        if (clientProjectSession == null) {
            return CollectionsKt.emptyList();
        }
        objectArray[1] = BackendUserActionsKt.createPermissionsAction(this.getProject(), clientProjectSession);
        objectArray[2] = BackendUserActionsKt.createKickAction(user);
        return CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)super.createUserActions(user), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    private static final Unit showClientJoinedNotification$lambda$0(RdUserModel $user, BackendUserManager this$0) {
        Object[] objectArray = new Object[]{$user.getName()};
        BaseCwmNotifications.createNotification$default((BaseCwmNotifications)CWMHostNotifications.INSTANCE, (String)CWMHostNotifications.DisplayId.USER_JOINED.getValue(), (String)PlatformSplitBundle.INSTANCE.message("product.name", new Object[0]), (String)CodeWithMeBackendBundle.INSTANCE.message("notification.user.joined", objectArray), null, (Icon)AllIcons.CodeWithMe.CwmAccess, (int)8, null).notify(this$0.getProject());
        return Unit.INSTANCE;
    }

    private static final Unit showClientLeftNotification$lambda$0(RdUserModel $user, BackendUserManager this$0) {
        Object[] objectArray = new Object[]{$user.getName()};
        BaseCwmNotifications.createNotification$default((BaseCwmNotifications)CWMHostNotifications.INSTANCE, (String)CWMHostNotifications.DisplayId.USER_LEFT.getValue(), (String)PlatformSplitBundle.INSTANCE.message("product.name", new Object[0]), (String)CodeWithMeBackendBundle.INSTANCE.message("notification.user.left", objectArray), null, (Icon)AllIcons.CodeWithMe.CwmAccess, (int)8, null).notify(this$0.getProject());
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendUserManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/cwm/plugin/users/BackendUserManager$BackendUserManagerJoinLinkListener;", "Lcom/intellij/cwm/plugin/session/CodeWithMeSessionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionCreated", "", "joinLinkData", "Lcom/intellij/cwm/plugin/join/JoinLinkData;", "sessionEnded", "reason", "Lcom/intellij/platform/split/connection/SessionEndedReason;", "intellij.cwm.plugin"})
    public static final class BackendUserManagerJoinLinkListener
    implements CodeWithMeSessionListener {
        @NotNull
        private final Project project;

        public BackendUserManagerJoinLinkListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void sessionCreated(@NotNull JoinLinkData joinLinkData) {
            Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
            Companion.getInstance(this.project).getSessionEnabledProperty().set((Object)true);
        }

        @Override
        public void sessionEnded(@NotNull SessionEndedReason reason, @NotNull JoinLinkData joinLinkData) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
            Companion.getInstance(this.project).getSessionEnabledProperty().set((Object)false);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/users/BackendUserManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/plugin/users/BackendUserManager;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.plugin"})
    @SourceDebugExtension(value={"SMAP\nBackendUserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendUserManager.kt\ncom/intellij/cwm/plugin/users/BackendUserManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,204:1\n30#2,2:205\n*S KotlinDebug\n*F\n+ 1 BackendUserManager.kt\ncom/intellij/cwm/plugin/users/BackendUserManager$Companion\n*L\n41#1:205,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendUserManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UserManager> serviceClass$iv = UserManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.cwm.plugin.users.BackendUserManager");
            return (BackendUserManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/cwm/plugin/users/BackendUserManager$Listener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "beforeAppSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "beforeProjectSessionInitialized", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.cwm.plugin"})
    @SourceDebugExtension(value={"SMAP\nBackendUserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendUserManager.kt\ncom/intellij/cwm/plugin/users/BackendUserManager$Listener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
    public static final class Listener
    implements RemoteClientSessionListener {
        public void beforeAppSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            SourceExKt.adviseOnce((ISource)((ISource)RemoteSessionKt.getProtocol((ClientAppSession)session).getOutOfSyncModels()), (Lifetime)lifetime, arg_0 -> Listener.beforeAppSessionInitialized$lambda$0(session, arg_0));
        }

        public void beforeProjectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            ConnectableUser user;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            FollowMeManager manager = FollowMeManager.Companion.getInstance(session.getProject());
            manager.registerUser(lifetime, session.getClientId(), session.getName());
            ConnectableUser connectableUser = user = manager.getConnectedUsers().get(session.getClientId());
            if (connectableUser == null) {
                boolean bl = false;
                String string = "Unable to find registered user with client id: " + session.getClientId();
                throw new IllegalStateException(string.toString());
            }
            ConnectableUser registeredUser = connectableUser;
            SourceExKt.flowInto((ISource)((ISource)RemoteSessionKt.isConnected((ClientAppSession)session.getAppSession())), (Lifetime)lifetime, (IMutablePropertyBase)((IMutablePropertyBase)registeredUser.getConnected()));
        }

        private static final Unit beforeAppSessionInitialized$lambda$0$0(ClientAppSession $session) {
            Object[] objectArray = new Object[]{$session.getName()};
            ClientProjectSession clientProjectSession = (ClientProjectSession)CollectionsKt.firstOrNull((List)$session.getProjectSessions());
            BaseCwmNotifications.createNotification$default((BaseCwmNotifications)CWMHostNotifications.INSTANCE, (String)CWMHostNotifications.DisplayId.VERSION_MISMATCH_ERROR.getValue(), (String)PlatformSplitBundle.INSTANCE.message("product.name", new Object[0]), (String)CodeWithMeBackendBundle.INSTANCE.message("notification.version.mismatch", objectArray), (NotificationType)NotificationType.ERROR, null, (int)16, null).notify((Project)(clientProjectSession != null ? clientProjectSession.getProject() : null));
            return Unit.INSTANCE;
        }

        private static final Unit beforeAppSessionInitialized$lambda$0(ClientAppSession $session, IViewableSet.Event it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> Listener.beforeAppSessionInitialized$lambda$0$0($session));
            return Unit.INSTANCE;
        }
    }
}

