/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.AggregateHttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfo;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.httpClient.executor.util.ResultsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0002\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u0004\u0012\b\u0012\u00060\u0001j\u0002`\u00060\u0003\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0007*\u00020\b*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\u00030\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004H\u0000*\f\b\u0002\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006\u000e"}, d2={"Errors", "Lcom/intellij/httpClient/actions/generation/AggregateHttpRequestPresentableError;", "aggregateErrors", "Lcom/intellij/httpClient/executor/util/PartialResult;", "", "R", "Lcom/intellij/httpClient/actions/generation/Errors;", "E", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "", "getRequestsPresentation", "", "requests", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlsGenerationRequest;", "intellij.restClient"})
@JvmName(name="HttpRequestGenerationUtil")
@SourceDebugExtension(value={"SMAP\nHttpRequestGenerationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/HttpRequestGenerationUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,349:1\n13#2:350\n*S KotlinDebug\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/HttpRequestGenerationUtil\n*L\n336#1:350\n*E\n"})
public final class HttpRequestGenerationUtil {
    @NotNull
    public static final <R, E extends HttpRequestPresentableError> PartialResult<List<R>, AggregateHttpRequestPresentableError> aggregateErrors(@NotNull Iterable<? extends PartialResult<? extends R, ? extends E>> $this$aggregateErrors) {
        Intrinsics.checkNotNullParameter($this$aggregateErrors, (String)"<this>");
        Pair pair = ResultsKt.partitionBySuccessAndErrors($this$aggregateErrors);
        List results = (List)pair.component1();
        List errors = (List)pair.component2();
        if (errors.isEmpty()) {
            return new PartialResult.Success<List>(results);
        }
        AggregateHttpRequestPresentableError error = new AggregateHttpRequestPresentableError(errors);
        if (results.isEmpty()) {
            return new PartialResult.Error<AggregateHttpRequestPresentableError>(error);
        }
        return new PartialResult.PartialSuccess<List, AggregateHttpRequestPresentableError>(results, error);
    }

    @NotNull
    public static final String getRequestsPresentation(@NotNull List<HttpRequestUrlsGenerationRequest> requests2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(requests2, (String)"requests");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HttpRequestUrlsGenerationRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(requests2.size() == 1);
        if (requests2.size() != 1) {
            return "";
        }
        HttpRequestUrlsGenerationRequest request = requests2.get(0);
        StringBuilder $this$getRequestsPresentation_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (request.getUrls().size() > 1) {
            $this$getRequestsPresentation_u24lambda_u240.append("\n");
        }
        CollectionsKt.joinTo$default((Iterable)request.getUrls(), (Appendable)$this$getRequestsPresentation_u24lambda_u240, (CharSequence)"\n", null, null, (int)0, null, HttpRequestGenerationUtil::getRequestsPresentation$lambda$0$0, (int)60, null);
        return stringBuilder.toString();
    }

    private static final CharSequence getRequestsPresentation$lambda$0$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence getRequestsPresentation$lambda$0$0(HttpRequestUrlPathInfo url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CollectionsKt.joinToString$default((Iterable)url.getMethods(), (CharSequence)"|", (CharSequence)"[", (CharSequence)"]", (int)0, null, HttpRequestGenerationUtil::getRequestsPresentation$lambda$0$0$0, (int)24, null) + " " + url.getUrl();
    }
}

