/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl;

import com.intellij.httpClient.converters.curl.Utils;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.converters.curl.parser.CurlParser;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\"\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"checkCurlConversion", "", "curlText", "", "convertToCurl", "offset", "", "isSeparatorNeeded", "", "createSeparatorIfNeeded", "createFormattedRequest", "request", "Lcom/intellij/httpClient/execution/RestClientRequest;", "separator", "hasSeparator", "httpFile", "Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "isSeparator", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.restClient"})
public final class CurlConversionUtilsKt {
    public static final void checkCurlConversion(@NotNull String curlText) throws CurlParseException {
        Intrinsics.checkNotNullParameter((Object)curlText, (String)"curlText");
        CurlConversionUtilsKt.convertToCurl$default(curlText, 0, false, 4, null);
    }

    @NotNull
    public static final String convertToCurl(@NotNull String curlText, int offset, boolean isSeparatorNeeded) throws CurlParseException {
        Intrinsics.checkNotNullParameter((Object)curlText, (String)"curlText");
        CurlParser curlParser = new CurlParser(curlText);
        RestClientRequest restClientRequest = curlParser.parseToRestClientRequest();
        Intrinsics.checkNotNullExpressionValue((Object)restClientRequest, (String)"parseToRestClientRequest(...)");
        RestClientRequest request = restClientRequest;
        return CurlConversionUtilsKt.createFormattedRequest(curlText, request, CurlConversionUtilsKt.createSeparatorIfNeeded(offset, isSeparatorNeeded));
    }

    public static /* synthetic */ String convertToCurl$default(String string, int n, boolean bl, int n2, Object object) throws CurlParseException {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return CurlConversionUtilsKt.convertToCurl(string, n, bl);
    }

    private static final String createSeparatorIfNeeded(int offset, boolean isSeparatorNeeded) {
        String string = HttpRequestPsiConverter.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        String separator = string;
        return offset == 0 && isSeparatorNeeded ? separator + "\n" : (isSeparatorNeeded ? "\n" + separator + "\n" : "\n");
    }

    private static final String createFormattedRequest(String curlText, RestClientRequest request, String separator) {
        String string = Utils.createCurlStringComment(curlText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createCurlStringComment(...)");
        String comment = string;
        String string2 = HttpRequestPsiConverter.toPsiHttpRequest(request);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPsiHttpRequest(...)");
        String requestText = string2;
        return ((Object)StringsKt.trimEnd((CharSequence)(separator + comment + requestText))).toString();
    }

    public static final boolean hasSeparator(@NotNull HttpRequestPsiFile httpFile, int offset) {
        Intrinsics.checkNotNullParameter((Object)((Object)httpFile), (String)"httpFile");
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)((PsiFile)httpFile), (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement caretPsiElement = psiElement;
        if (CurlConversionUtilsKt.isSeparator(caretPsiElement)) {
            return true;
        }
        PsiElement prevElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)caretPsiElement);
        return CurlConversionUtilsKt.isSeparator(prevElement);
    }

    private static final boolean isSeparator(PsiElement psiElement) {
        return psiElement != null && HttpRequestPsiUtils.isOfType(psiElement, HttpRequestElementTypes.REQUEST_SEPARATOR);
    }
}

