/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.intellij.httpClient.examples.server.GraphQLBody;
import com.intellij.httpClient.examples.server.GraphQLCall;
import com.intellij.httpClient.examples.server.GraphQLQuery;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J0\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0016H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/httpClient/examples/server/GraphQLParser;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "tokens", "Lcom/intellij/util/text/StringTokenizer;", "currentToken", "token", "next", "", "skipSpaces", "nextNotSpace", "identifier", "parseQuery", "Lcom/intellij/httpClient/examples/server/GraphQLQuery;", "parseParams", "", "nameWithDollar", "", "valueParser", "Lkotlin/Function0;", "parseCall", "Lcom/intellij/httpClient/examples/server/GraphQLCall;", "parseBody", "Lcom/intellij/httpClient/examples/server/GraphQLBody;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/GraphQLParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,611:1\n1#2:612\n1088#3,2:613\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/GraphQLParser\n*L\n471#1:613,2\n*E\n"})
final class GraphQLParser {
    @NotNull
    private final StringTokenizer tokens;
    @Nullable
    private String currentToken;

    public GraphQLParser(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.tokens = new StringTokenizer(text2, " \t\n\r$:(){},\"", true);
    }

    private final String token() {
        String string = this.currentToken;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (this.tokens.hasMoreTokens()) {
            String newToken;
            String string2 = this.tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextToken(...)");
            this.currentToken = newToken = string2;
            return newToken;
        }
        return null;
    }

    private final void next() {
        this.currentToken = null;
    }

    private final void skipSpaces() {
        while (true) {
            String string = this.token();
            boolean bl = string != null ? StringsKt.isBlank((CharSequence)string) : false;
            if (!bl) break;
            this.next();
        }
    }

    private final void nextNotSpace() {
        this.next();
        this.skipSpaces();
    }

    @Nullable
    public final String identifier() {
        String string;
        String string2 = this.token();
        if (string2 != null) {
            boolean bl;
            String string3;
            block3: {
                String it = string3 = string2;
                boolean bl2 = false;
                CharSequence $this$all$iv = it;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(i);
                    boolean bl3 = false;
                    if (Character.isLetterOrDigit(c)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            string = bl ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final GraphQLQuery parseQuery() {
        Pair pair;
        String name;
        GraphQLQuery.Operation operation;
        String string = this.token();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 865637033: {
                if (string.equals("mutation")) {
                    n = 1;
                }
                break;
            }
            case 107944136: {
                if (string.equals("query")) {
                    n = 2;
                }
                break;
            }
            case 341203229: {
                if (string.equals("subscription")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                operation = GraphQLQuery.Operation.QUERY;
                break;
            }
            case 1: {
                operation = GraphQLQuery.Operation.MUTATION;
                break;
            }
            case 3: {
                operation = GraphQLQuery.Operation.SUBSCRIPTION;
                break;
            }
            default: {
                return null;
            }
        }
        GraphQLQuery.Operation operation2 = operation;
        this.nextNotSpace();
        if (this.identifier() != null) {
            name = this.identifier();
            this.nextNotSpace();
            Map map2 = GraphQLParser.parseParams$default(this, true, null, 2, null);
            if (map2 == null) {
                return null;
            }
            pair = TuplesKt.to((Object)name, (Object)map2);
        } else {
            pair = TuplesKt.to(null, (Object)MapsKt.emptyMap());
        }
        string = pair;
        name = (String)string.component1();
        Map params = (Map)string.component2();
        if (!Intrinsics.areEqual((Object)this.currentToken, (Object)"{")) {
            return null;
        }
        GraphQLCall graphQLCall = this.parseCall();
        if (graphQLCall == null) {
            return null;
        }
        GraphQLCall call2 = graphQLCall;
        return new GraphQLQuery(operation2, name, params, call2);
    }

    private final Map<String, String> parseParams(boolean nameWithDollar, Function0<String> valueParser) {
        Map map2;
        if (!Intrinsics.areEqual((Object)this.token(), (Object)"(")) {
            return null;
        }
        this.nextNotSpace();
        Map $this$parseParams_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        while (this.token() != null && !Intrinsics.areEqual((Object)this.token(), (Object)")")) {
            String value2;
            String name;
            if (nameWithDollar) {
                if (!Intrinsics.areEqual((Object)this.token(), (Object)"$")) {
                    return null;
                }
                this.nextNotSpace();
            }
            if (this.identifier() == null) {
                return null;
            }
            this.nextNotSpace();
            if (!Intrinsics.areEqual((Object)this.token(), (Object)":")) {
                return null;
            }
            this.nextNotSpace();
            if ((String)valueParser.invoke() == null) {
                return null;
            }
            $this$parseParams_u24lambda_u240.put(name, value2);
            this.nextNotSpace();
            if (!Intrinsics.areEqual((Object)this.token(), (Object)",")) continue;
            this.nextNotSpace();
        }
        if (Intrinsics.areEqual((Object)this.token(), (Object)")")) {
            this.nextNotSpace();
        }
        return map2;
    }

    static /* synthetic */ Map parseParams$default(GraphQLParser graphQLParser, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = (Function0)new Function0<String>((Object)graphQLParser){

                public final String invoke() {
                    return GraphQLParser.access$token((GraphQLParser)this.receiver);
                }
            };
        }
        return graphQLParser.parseParams(bl, (Function0<String>)function0);
    }

    private final GraphQLCall parseCall() {
        GraphQLBody body2;
        String string;
        Map<String, String> map2;
        if (!Intrinsics.areEqual((Object)this.currentToken, (Object)"{")) {
            return null;
        }
        this.nextNotSpace();
        String string2 = this.identifier();
        if (string2 == null) {
            return null;
        }
        String name = string2;
        this.nextNotSpace();
        if (Intrinsics.areEqual((Object)this.token(), (Object)"(")) {
            map2 = this.parseParams(false, (Function0<String>)((Function0)() -> GraphQLParser.parseCall$lambda$0(this)));
            if (map2 == null) {
                return null;
            }
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map<String, String> params = map2;
        String it = string = this.token();
        boolean bl = false;
        String string3 = Intrinsics.areEqual((Object)it, (Object)"{") ? string : null;
        if (string3 != null) {
            it = string3;
            boolean bl2 = false;
            v3 = this.parseBody();
        } else {
            v3 = body2 = null;
        }
        if (!Intrinsics.areEqual((Object)this.token(), (Object)"}")) {
            return null;
        }
        this.nextNotSpace();
        return new GraphQLCall(name, params, body2);
    }

    private final GraphQLBody parseBody() {
        List list2;
        if (!Intrinsics.areEqual((Object)this.token(), (Object)"{")) {
            return null;
        }
        this.nextNotSpace();
        List $this$parseBody_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        while (this.token() != null && !Intrinsics.areEqual((Object)this.token(), (Object)"}")) {
            String field;
            if (this.identifier() == null) {
                return null;
            }
            this.nextNotSpace();
            GraphQLBody body2 = Intrinsics.areEqual((Object)this.token(), (Object)"{") ? this.parseBody() : null;
            $this$parseBody_u24lambda_u240.add(TuplesKt.to((Object)field, (Object)body2));
        }
        List fields = list2;
        if (!Intrinsics.areEqual((Object)this.token(), (Object)"}")) {
            return null;
        }
        this.nextNotSpace();
        return new GraphQLBody(fields);
    }

    private static final String parseCall$lambda$0(GraphQLParser this$0) {
        Object object;
        String string = this$0.token();
        if (Intrinsics.areEqual((Object)string, (Object)"$")) {
            this$0.next();
            String string2 = this$0.token();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                object = "$" + it;
            } else {
                object = null;
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"\"")) {
            StringBuilder stringBuilder;
            StringBuilder $this$parseCall_u24lambda_u240_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$parseCall_u24lambda_u240_u241.append("\"");
            this$0.next();
            while (this$0.token() != null && !Intrinsics.areEqual((Object)this$0.token(), (Object)"\"")) {
                $this$parseCall_u24lambda_u240_u241.append(this$0.token());
                this$0.next();
            }
            if (!Intrinsics.areEqual((Object)this$0.token(), (Object)"\"")) {
                return null;
            }
            this$0.next();
            $this$parseCall_u24lambda_u240_u241.append("\"");
            object = stringBuilder.toString();
        } else {
            object = this$0.token();
        }
        return object;
    }

    public static final /* synthetic */ String access$token(GraphQLParser $this) {
        return $this.token();
    }
}

