/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.codeWithMe.ClientId;
import com.intellij.httpClient.execution.HttpClientDnsResolverProvider;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerUtil;
import com.intellij.httpClient.execution.impl.engineV2.CustomizedDnsResolverNettyGroup;
import com.intellij.httpClient.execution.impl.engineV2.HttpClientContentLengthHeaderCleanedTestMark;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import com.intellij.httpClient.execution.impl.engineV2.NettyProtocolConfigurator;
import com.intellij.httpClient.execution.impl.engineV2.NettySslConfigurationTarget;
import com.intellij.httpClient.execution.impl.engineV2.RawResponseInfoHolder;
import com.intellij.httpClient.execution.impl.engineV2.RedirectionChecker;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.http.request.HttpClientEventLoopHolder;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpResponseDecoderSpec;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ClientTransport;
import reactor.netty.transport.ProxyProvider;
import reactor.netty.transport.Transport;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u000b\u001a\u00060\u0001j\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u001aC\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172'\u0010\u0018\u001a#\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00140\u0019\u001a\u001c\u0010\u001d\u001a\u00060\u0001j\u0002`\f*\u00060\u0001j\u0002`\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a6\u0010\u001e\u001a\u00060\u0001j\u0002`\f*\u00060\u0001j\u0002`\f2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0012H\u0002\u001a\u0014\u0010%\u001a\u00060\u0001j\u0002`\f*\u00060\u0001j\u0002`\fH\u0002\u001a\u001c\u0010&\u001a\u00060\u0001j\u0002`\f*\u00060\u0001j\u0002`\f2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n*\n\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006+"}, d2={"ReactorHttpClient", "Lreactor/netty/http/client/HttpClient;", "HTTP_2", "Lio/netty/handler/codec/http/HttpVersion;", "HTTP_CLIENT_RESPONSE_LISTENER", "", "HTTP_CLIENT_REQUEST_CLEANER", "METHODS_FOR_CONTENT_LENGTH_CHECK", "", "getMETHODS_FOR_CONTENT_LENGTH_CHECK", "()Ljava/util/Set;", "createReactorNettyClient", "Lcom/intellij/httpClient/execution/impl/engineV2/ReactorHttpClient;", "request", "Lcom/intellij/httpClient/execution/RestClientRequest;", "url", "Ljava/net/URL;", "forceLegacy", "", "withLegacyRetry", "Lreactor/core/publisher/Flux;", "T", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "requestFactory", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isLegacyMode", "configureProxy", "configureSsl", "protocols", "Lcom/intellij/httpClient/execution/impl/engineV2/NettyProtocolConfigurator;", "sslConfiguration", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "host", "forceLegacyTls", "configureDefaultResolver", "configureTimeouts", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "normalizedProtocolPresentation", "protocol", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nNettyHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyHttpClient.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyHttpClientKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,329:1\n1#2:330\n42#3,3:331\n13#4:334\n*S KotlinDebug\n*F\n+ 1 NettyHttpClient.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyHttpClientKt\n*L\n68#1:331,3\n73#1:334\n*E\n"})
public final class NettyHttpClientKt {
    @NotNull
    private static final HttpVersion HTTP_2;
    @NotNull
    private static final String HTTP_CLIENT_RESPONSE_LISTENER = "IntelliJHttpClientResponseListener";
    @NotNull
    private static final String HTTP_CLIENT_REQUEST_CLEANER = "IntelliJHttpClientRequestCleaner";
    @NotNull
    private static final Set<String> METHODS_FOR_CONTENT_LENGTH_CHECK;

    @NotNull
    public static final Set<String> getMETHODS_FOR_CONTENT_LENGTH_CHECK() {
        return METHODS_FOR_CONTENT_LENGTH_CHECK;
    }

    @NotNull
    public static final HttpClient createReactorNettyClient(@NotNull RestClientRequest request, @NotNull URL url, boolean forceLegacy) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        NettyProtocolConfigurator protocolsConfigurator = new NettyProtocolConfigurator(Intrinsics.areEqual((Object)url.getProtocol(), (Object)"https"), request.protocol);
        HttpClient it = HttpClient.create((ConnectionProvider)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"IJ HTTP Client").maxConnections(1)).build()).disableRetry(true).httpResponseDecoder(NettyHttpClientKt::createReactorNettyClient$lambda$0);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        HttpClient httpClient = protocolsConfigurator.configureProtocols(it, forceLegacy).compress(true);
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"compress(...)");
        boolean $i$f$service = false;
        Class<HttpClientEventLoopHolder> serviceClass$iv = HttpClientEventLoopHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Transport transport = NettyHttpClientKt.configureDefaultResolver(httpClient).runOn((EventLoopGroup)((HttpClientEventLoopHolder)object).eventLoop);
        Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"runOn(...)");
        HttpClient httpClient2 = NettyHttpClientKt.configureProxy((HttpClient)transport, url);
        SslConfiguration sslConfiguration = request.sslConfiguration;
        String string = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        HttpClient httpClient3 = NettyHttpClientKt.configureSsl(httpClient2, protocolsConfigurator, sslConfiguration, string, forceLegacy);
        HttpRequestConfig httpRequestConfig = request.config;
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestConfig, (String)"config");
        HttpClient httpClient4 = NettyHttpClientKt.configureTimeouts(httpClient3, httpRequestConfig).doOnResponseError((arg_0, arg_1) -> NettyHttpClientKt.createReactorNettyClient$lambda$3(NettyHttpClientKt::createReactorNettyClient$lambda$2, arg_0, arg_1)).doOnRequest((arg_0, arg_1) -> NettyHttpClientKt.createReactorNettyClient$lambda$5(NettyHttpClientKt::createReactorNettyClient$lambda$4, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)httpClient4, (String)"doOnRequest(...)");
        return httpClient4;
    }

    public static /* synthetic */ HttpClient createReactorNettyClient$default(RestClientRequest restClientRequest, URL uRL, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return NettyHttpClientKt.createReactorNettyClient(restClientRequest, uRL, bl);
    }

    @NotNull
    public static final <T> Flux<T> withLegacyRetry(@NotNull Logger logger, @NotNull Function1<? super Boolean, ? extends Flux<T>> requestFactory) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
        Flux flux = ((Flux)requestFactory.invoke((Object)false)).onErrorResume(arg_0 -> NettyHttpClientKt.withLegacyRetry$lambda$1(arg_0 -> NettyHttpClientKt.withLegacyRetry$lambda$0(logger, requestFactory, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"onErrorResume(...)");
        return flux;
    }

    private static final HttpClient configureProxy(HttpClient $this$configureProxy, URL url) {
        ProxyProvider.Proxy proxy;
        Proxy proxy2;
        HttpRequestExecutionHelperService executionHelperService;
        URI uri = url.toURI();
        HttpRequestExecutionHelperService httpRequestExecutionHelperService = executionHelperService = HttpRequestExecutionHelperService.getInstance();
        List list2 = httpRequestExecutionHelperService != null ? httpRequestExecutionHelperService.getProxy(uri) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((proxy2 = (Proxy)CollectionsKt.firstOrNull(list2)) == null) {
            return $this$configureProxy;
        }
        if (Intrinsics.areEqual((Object)proxy2, (Object)Proxy.NO_PROXY)) {
            return $this$configureProxy;
        }
        Proxy.Type type = proxy2.type();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                proxy = ProxyProvider.Proxy.HTTP;
                break;
            }
            case 2: {
                proxy = ProxyProvider.Proxy.SOCKS5;
                break;
            }
            case 3: {
                return $this$configureProxy;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ProxyProvider.Proxy type2 = proxy;
        SocketAddress socketAddress = proxy2.address();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress proxyAddress = (InetSocketAddress)socketAddress;
        HttpRequestExecutionHelperService httpRequestExecutionHelperService2 = executionHelperService;
        if (httpRequestExecutionHelperService2 != null) {
            httpRequestExecutionHelperService2.initProxy();
        }
        PasswordAuthentication usernameAndPassword = type2 == ProxyProvider.Proxy.SOCKS5 ? Authenticator.requestPasswordAuthentication(proxyAddress.getHostString(), proxyAddress.getAddress(), proxyAddress.getPort(), "SOCKS5", "SOCKS authentication", null) : Authenticator.requestPasswordAuthentication(proxyAddress.getHostString(), null, proxyAddress.getPort(), "http", "Authentication for http proxy", null, url, Authenticator.RequestorType.PROXY);
        ClientTransport clientTransport = ((HttpClient)$this$configureProxy.proxy(arg_0 -> NettyHttpClientKt.configureProxy$lambda$1(arg_0 -> NettyHttpClientKt.configureProxy$lambda$0(type2, proxyAddress, usernameAndPassword, arg_0), arg_0))).resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"resolver(...)");
        return (HttpClient)clientTransport;
    }

    private static final HttpClient configureSsl(HttpClient $this$configureSsl, NettyProtocolConfigurator protocols, SslConfiguration sslConfiguration, String host, boolean forceLegacyTls) {
        if (!protocols.isSecure()) {
            return $this$configureSsl;
        }
        if (forceLegacyTls) {
            HttpClient httpClient = $this$configureSsl.secure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$1(arg_0 -> NettyHttpClientKt.configureSsl$lambda$0(host, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
            return httpClient;
        }
        HttpRequestExecutionHelperService executionHelperService = HttpRequestExecutionHelperService.getInstance();
        if (sslConfiguration == null) {
            Pair<KeyManager[], TrustManager> defaultConfiguration;
            HttpRequestExecutionHelperService httpRequestExecutionHelperService = executionHelperService;
            Object object = defaultConfiguration = httpRequestExecutionHelperService != null ? httpRequestExecutionHelperService.getDefaultSslConfiguration() : null;
            if (defaultConfiguration != null) {
                HttpClient httpClient = $this$configureSsl.secure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$3(arg_0 -> NettyHttpClientKt.configureSsl$lambda$2(protocols, defaultConfiguration, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
                return httpClient;
            }
            return $this$configureSsl;
        }
        kotlin.Pair pair = (kotlin.Pair)sslConfiguration.applyTo(new NettySslConfigurationTarget());
        KeyManagerFactory keyManager = (KeyManagerFactory)pair.component1();
        TrustManagerFactory trustManager = (TrustManagerFactory)pair.component2();
        HttpClient httpClient = $this$configureSsl.secure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$5(arg_0 -> NettyHttpClientKt.configureSsl$lambda$4(protocols, keyManager, trustManager, host, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
        return httpClient;
    }

    private static final HttpClient configureDefaultResolver(HttpClient $this$configureDefaultResolver) {
        HttpClientDnsResolverProvider resolverProvider = HttpClientDnsResolverProvider.Companion.getInstance();
        if (resolverProvider == null) {
            ClientTransport clientTransport = $this$configureDefaultResolver.resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"resolver(...)");
            return (HttpClient)clientTransport;
        }
        ClientTransport clientTransport = $this$configureDefaultResolver.resolver((AddressResolverGroup)new CustomizedDnsResolverNettyGroup(resolverProvider.getDnsResolveFunction()));
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"resolver(...)");
        return (HttpClient)clientTransport;
    }

    private static final HttpClient configureTimeouts(HttpClient $this$configureTimeouts, HttpRequestConfig config) {
        HttpRequestExecutionHelperService executionHelperService = HttpRequestExecutionHelperService.getInstance();
        if (executionHelperService == null) {
            return $this$configureTimeouts;
        }
        Integer n = config.getSocketTimeoutMs();
        Integer n2 = config.getConnectionTimeoutMs();
        Transport transport = $this$configureTimeouts.responseTimeout(Duration.ofMillis(n != null ? (long)n.intValue() : (long)executionHelperService.getSocketTimeout())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(n2 != null ? n2.intValue() : executionHelperService.getConnectionTimeout()));
        Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"option(...)");
        return (HttpClient)transport;
    }

    @NotNull
    public static final String normalizedProtocolPresentation(@NotNull HttpVersion protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        if (Intrinsics.areEqual((Object)protocol, (Object)HTTP_2)) {
            return "HTTP/2";
        }
        String string = protocol.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final HttpResponseDecoderSpec createReactorNettyClient$lambda$0(HttpResponseDecoderSpec it) {
        return (HttpResponseDecoderSpec)it.maxHeaderSize(Integer.MAX_VALUE);
    }

    private static final Unit createReactorNettyClient$lambda$2(HttpClientResponse resp, Throwable e) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HttpRequestHandlerV2.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error(e);
        return Unit.INSTANCE;
    }

    private static final void createReactorNettyClient$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit createReactorNettyClient$lambda$4(HttpClientRequest req, Connection con) {
        RawResponseInfoHolder rawResponseInfoHolder = (RawResponseInfoHolder)req.currentContextView().get((Object)RawResponseInfoHolder.Key);
        RedirectionChecker redirectionChecker = (RedirectionChecker)req.currentContextView().get((Object)RedirectionChecker.Key);
        String method = req.method().name();
        if (con.channel() instanceof Http2StreamChannel) {
            rawResponseInfoHolder.setProtocol(HTTP_2);
        }
        if (!con.channel().pipeline().names().contains(HTTP_CLIENT_RESPONSE_LISTENER)) {
            con.channel().pipeline().addBefore("reactor.left.httpDecompressor", HTTP_CLIENT_RESPONSE_LISTENER, (ChannelHandler)new ChannelInboundHandlerAdapter(method, redirectionChecker, rawResponseInfoHolder){
                final /* synthetic */ String $method;
                final /* synthetic */ RedirectionChecker $redirectionChecker;
                final /* synthetic */ RawResponseInfoHolder $rawResponseInfoHolder;
                {
                    this.$method = $method;
                    this.$redirectionChecker = $redirectionChecker;
                    this.$rawResponseInfoHolder = $rawResponseInfoHolder;
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    if (msg instanceof HttpResponse) {
                        if (((HttpResponse)msg).status().code() == 302 && RedirectionChecker.Key.getLaxRedirectionMethods().contains(this.$method) && this.$redirectionChecker.redirectAvailable()) {
                            ((HttpResponse)msg).setStatus(HttpResponseStatus.valueOf((int)303));
                        }
                        this.$rawResponseInfoHolder.setHeaders(((HttpResponse)msg).headers().entries());
                    }
                    ctx.fireChannelRead(msg);
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                        this.$rawResponseInfoHolder.setProtocol(NettyHttpClientKt.access$getHTTP_2$p());
                    }
                    super.userEventTriggered(ctx, evt);
                }
            });
        }
        if (!con.channel().pipeline().names().contains(HTTP_CLIENT_REQUEST_CLEANER)) {
            con.channel().pipeline().addLast(HTTP_CLIENT_REQUEST_CLEANER, (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                    if (msg instanceof DefaultHttpRequest && NettyHttpClientKt.getMETHODS_FOR_CONTENT_LENGTH_CHECK().contains(((DefaultHttpRequest)msg).method().name()) && Intrinsics.areEqual((Object)((DefaultHttpRequest)msg).headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Object)"0")) {
                        ((DefaultHttpRequest)msg).headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                        HttpClientContentLengthHeaderCleanedTestMark.INSTANCE.hit();
                    }
                    super.write(ctx, msg, promise);
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final void createReactorNettyClient$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * Unable to fully structure code
     */
    private static final Publisher withLegacyRetry$lambda$0(Logger $logger, Function1 $requestFactory, Throwable error) {
        block5: {
            if (!(error instanceof SocketException)) break block5;
            v0 = ((SocketException)error).getMessage();
            if (v0 != null ? StringsKt.contains$default((CharSequence)v0, (CharSequence)"reset", (boolean)false, (int)2, null) : false) ** GOTO lbl-1000
        }
        if (error instanceof SSLException) {
            v1 = ((SSLException)error).getMessage();
            v2 = v1 != null ? StringsKt.contains((CharSequence)v1, (CharSequence)"handshake", (boolean)true) : false;
            ** if (!v2) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v3 = true;
            ** GOTO lbl13
        }
lbl-1000:
        // 2 sources

        {
            v3 = isHandshakeError = false;
        }
lbl13:
        // 2 sources

        if (isHandshakeError) {
            $logger.warn("Connection failure detected (" + ((IOException)error).getMessage() + "). Retrying with Legacy Mode (TLS 1.2 / HTTP 1.1).");
            v4 = (Publisher)$requestFactory.invoke((Object)true);
        } else {
            v4 = (Publisher)Flux.error((Throwable)error);
        }
        return v4;
    }

    private static final Publisher withLegacyRetry$lambda$1(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final String configureProxy$lambda$0$0(PasswordAuthentication $usernameAndPassword, String it) {
        char[] cArray = $usernameAndPassword.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        char[] cArray2 = cArray;
        return new String(cArray2);
    }

    private static final String configureProxy$lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit configureProxy$lambda$0(ProxyProvider.Proxy $type, InetSocketAddress $proxyAddress, PasswordAuthentication $usernameAndPassword, ProxyProvider.TypeSpec spec) {
        ProxyProvider.Builder spec2 = spec.type($type).address($proxyAddress);
        if ($usernameAndPassword != null) {
            spec2.username($usernameAndPassword.getUserName()).password(arg_0 -> NettyHttpClientKt.configureProxy$lambda$0$1(arg_0 -> NettyHttpClientKt.configureProxy$lambda$0$0($usernameAndPassword, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void configureProxy$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureSsl$lambda$2$0(Pair $defaultConfiguration, SslContextBuilder builder) {
        block0: {
            builder.sslProvider(SslProvider.JDK).trustManager((TrustManager)$defaultConfiguration.second);
            Object object = (KeyManager[])$defaultConfiguration.first;
            if (object == null || (object = (KeyManager)ArraysKt.firstOrNull((Object[])object)) == null) break block0;
            Object keyManager = object;
            boolean bl = false;
            builder.keyManager((KeyManager)keyManager);
        }
    }

    private static final void configureSsl$lambda$4$0(KeyManagerFactory $keyManager, TrustManagerFactory $trustManager, SslContextBuilder builder) {
        builder.sslProvider(SslProvider.JDK);
        if ($keyManager != null) {
            builder.keyManager($keyManager);
        }
        if ($trustManager != null) {
            builder.trustManager($trustManager);
        }
    }

    private static final Unit configureSsl$lambda$0(String $host, SslProvider.SslContextSpec spec) {
        block0: {
            String[] stringArray = new String[]{"TLSv1.2"};
            SslProvider.Builder it = spec.sslContext(SslContextBuilder.forClient().protocols(stringArray).build());
            boolean bl = false;
            if (HttpRequestHandlerUtil.isLocalhost($host)) break block0;
            SNIServerName[] sNIServerNameArray = new SNIServerName[]{new SNIHostName($host)};
            it.serverNames(sNIServerNameArray);
        }
        return Unit.INSTANCE;
    }

    private static final void configureSsl$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureSsl$lambda$2(NettyProtocolConfigurator $protocols, Pair $defaultConfiguration, SslProvider.SslContextSpec spec) {
        spec.sslContext((SslProvider.ProtocolSslContextSpec)$protocols.getSslContextSpec().configure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$2$0($defaultConfiguration, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void configureSsl$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureSsl$lambda$4(NettyProtocolConfigurator $protocols, KeyManagerFactory $keyManager, TrustManagerFactory $trustManager, String $host, SslProvider.SslContextSpec spec) {
        SslProvider.Builder it = spec.sslContext((SslProvider.ProtocolSslContextSpec)$protocols.getSslContextSpec().configure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$4$0($keyManager, $trustManager, arg_0)));
        boolean bl = false;
        if (HttpRequestHandlerUtil.isLocalhost($host)) {
            SNIServerName[] sNIServerNameArray = new SNIServerName[]{new SNIHostName($host)};
            it.serverNames(sNIServerNameArray);
        }
        return Unit.INSTANCE;
    }

    private static final void configureSsl$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpVersion access$getHTTP_2$p() {
        return HTTP_2;
    }

    static {
        HttpVersion httpVersion = HttpVersion.valueOf((String)"HTTP/2.0");
        Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"valueOf(...)");
        HTTP_2 = httpVersion;
        Object[] objectArray = new String[]{"GET", "HEAD", "TRACE"};
        METHODS_FOR_CONTENT_LENGTH_CHECK = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.DIRECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

