/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.graphql;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.execution.common.RunContext;
import com.intellij.httpClient.execution.impl.HttpRequestConverter;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import com.intellij.httpClient.executor.graphql.request.GraphQLClientRequest;
import com.intellij.httpClient.executor.graphql.request.GraphQLOverWsClientRequest;
import com.intellij.httpClient.executor.graphql.request.GraphQLRestClientRequest;
import com.intellij.httpClient.executor.websocket.WebSocketClientRequestRequestHandler;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/executor/graphql/GraphQLClientRequestExecutionSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/executor/graphql/request/GraphQLClientRequest;", "<init>", "()V", "supportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "canProcess", "", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "needsScheme", "getNeedsScheme", "()Z", "supportedSchemes", "", "getSupportedSchemes", "()Ljava/util/List;", "Companion", "intellij.httpClient.executor"})
public final class GraphQLClientRequestExecutionSupport
implements RequestExecutionSupport<GraphQLClientRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GRAPH_QL_METHOD = "GRAPHQL";
    @NotNull
    private static final List<String> HTTP_SCHEMES;
    @NotNull
    private static final List<String> WS_SCHEMES;
    @NotNull
    private static final List<String> SCHEMES;

    @Override
    @NotNull
    public Collection<String> supportedMethods(@Nullable Project project) {
        return CollectionsKt.listOf((Object)GRAPH_QL_METHOD);
    }

    @Override
    @NotNull
    public Collection<String> supportedMethods() {
        return this.supportedMethods(null);
    }

    @Override
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && Intrinsics.areEqual((Object)requestContext.getMethod(), (Object)GRAPH_QL_METHOD) && CollectionsKt.contains((Iterable)SCHEMES, (Object)requestContext.getScheme());
    }

    @Override
    @NotNull
    public RequestHandler<GraphQLClientRequest> getRequestHandler() {
        return new RequestHandler<GraphQLClientRequest>(){

            public void prepareExecutionEnvironment(GraphQLClientRequest request, RunContext runContext) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
            }

            public CommonClientResponse execute(GraphQLClientRequest request, RunContext runContext) {
                CommonClientResponse commonClientResponse;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
                GraphQLClientRequest graphQLClientRequest = request;
                if (graphQLClientRequest instanceof GraphQLRestClientRequest) {
                    commonClientResponse = (CommonClientResponse)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CommonClientResponse>, Object>(request, runContext, null){
                        int label;
                        final /* synthetic */ GraphQLClientRequest $request;
                        final /* synthetic */ RunContext $runContext;
                        {
                            this.$request = $request;
                            this.$runContext = $runContext;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = new HttpRequestHandlerV2().executeSuspend(((GraphQLRestClientRequest)this.$request).getDelegate(), this.$runContext, (Continuation<? super CommonClientResponse>)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super CommonClientResponse> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                } else if (graphQLClientRequest instanceof GraphQLOverWsClientRequest) {
                    WebSocketClientRequestRequestHandler webSocketClientRequestRequestHandler = new WebSocketClientRequestRequestHandler();
                    CommonClientResponse response2 = webSocketClientRequestRequestHandler.execute(((GraphQLOverWsClientRequest)request).getDelegate(), runContext);
                    commonClientResponse = GraphQLOverWsClientRequest.Companion.modifyResponse((GraphQLOverWsClientRequest)request, response2, webSocketClientRequestRequestHandler, runContext);
                } else {
                    throw new IllegalStateException("Check all inheritors of GraphQLClientRequest and update `when` block");
                }
                return commonClientResponse;
            }
        };
    }

    @Override
    @NotNull
    public RequestConverter<GraphQLClientRequest> getRequestConverter() {
        return new RequestConverter<GraphQLClientRequest>(){

            protected Class<GraphQLClientRequest> getRequestType() {
                return GraphQLClientRequest.class;
            }

            public GraphQLClientRequest psiToCommonRequest(SmartPsiElementPointer<HttpRequest> requestPsiPointer, HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
                GraphQLClientRequest graphQLClientRequest;
                String it;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                String url;
                HttpRequest request;
                block12: {
                    Intrinsics.checkNotNullParameter(requestPsiPointer, (String)"requestPsiPointer");
                    Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
                    HttpRequest httpRequest = (HttpRequest)requestPsiPointer.getElement();
                    if (httpRequest == null) {
                        throw new HttpRequestValidationException("");
                    }
                    request = httpRequest;
                    url = request.getHttpUrl(substitutor2);
                    $this$any$iv = GraphQLClientRequestExecutionSupport.Companion.getHTTP_SCHEMES$intellij_httpClient_executor();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl2 = false;
                            String string = url;
                            boolean bl3 = string != null ? StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null) : false;
                            if (!bl3) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    CommonClientRequest restRequest = new HttpRequestConverter().psiToCommonRequest((SmartPsiElementPointer)requestPsiPointer, substitutor2);
                    graphQLClientRequest = new GraphQLRestClientRequest((RestClientRequest)restRequest);
                } else {
                    boolean bl4;
                    block13: {
                        $this$any$iv = GraphQLClientRequestExecutionSupport.Companion.getWS_SCHEMES$intellij_httpClient_executor();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl5 = false;
                                String string = url;
                                boolean bl6 = string != null ? StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null) : false;
                                if (!bl6) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        graphQLClientRequest = GraphQLOverWsClientRequest.Companion.create(request, substitutor2);
                    } else {
                        Object object = request.getRequestTarget();
                        if (object == null || (object = object.getScheme()) == null || (object = object.getText()) == null) {
                            object = "";
                        }
                        throw new HttpRequestValidationException((String)object);
                    }
                }
                return graphQLClientRequest;
            }

            protected String toExternalFormInner(GraphQLClientRequest request, String fileName) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return "";
            }
        };
    }

    @Override
    public boolean getNeedsScheme() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getSupportedSchemes() {
        return SCHEMES;
    }

    static {
        Object[] objectArray = new String[]{"http://", "https://"};
        HTTP_SCHEMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"ws://", "wss://"};
        WS_SCHEMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http", "https", "ws", "wss"};
        SCHEMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/executor/graphql/GraphQLClientRequestExecutionSupport$Companion;", "", "<init>", "()V", "GRAPH_QL_METHOD", "", "HTTP_SCHEMES", "", "getHTTP_SCHEMES$intellij_httpClient_executor", "()Ljava/util/List;", "WS_SCHEMES", "getWS_SCHEMES$intellij_httpClient_executor", "SCHEMES", "intellij.httpClient.executor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getHTTP_SCHEMES$intellij_httpClient_executor() {
            return HTTP_SCHEMES;
        }

        @NotNull
        public final List<String> getWS_SCHEMES$intellij_httpClient_executor() {
            return WS_SCHEMES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

