/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js;

import com.intellij.httpClient.http.request.run.js.JsonPathException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/run/js/HttpClientHandlerJsonPathSupport;", "", "convert", "Lkotlin/Function2;", "Lcom/jayway/jsonpath/Configuration;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "applyJsonPath", "json", "", "jsonPath", "intellij.httpClient.executor"})
public final class HttpClientHandlerJsonPathSupport {
    @NotNull
    private final Function2<Object, Configuration, Object> convert;

    public HttpClientHandlerJsonPathSupport(@NotNull Function2<Object, ? super Configuration, ? extends Object> convert2) {
        Intrinsics.checkNotNullParameter(convert2, (String)"convert");
        this.convert = convert2;
    }

    @NotNull
    public final Object applyJsonPath(@NotNull String json, @NotNull String jsonPath) {
        DocumentContext documentContext;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        JsonPath path = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        Configuration configuration = Configuration.defaultConfiguration().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider());
        try {
            documentContext = JsonPath.parse((String)json, (Configuration)configuration);
        }
        catch (InvalidJsonException ij) {
            if (!Intrinsics.areEqual((Object)ij.getCause(), (Object)((Object)ij))) {
                String string;
                Throwable throwable;
                String string2 = ij.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"ParseException", (boolean)false, (int)2, null) && (throwable = ij.getCause()) != null && (string = throwable.getLocalizedMessage()) != null) {
                    String it = string;
                    boolean bl = false;
                    throw new JsonPathException(it);
                }
            }
            throw ij;
        }
        DocumentContext file = documentContext;
        Object result2 = file.read(path);
        Intrinsics.checkNotNull((Object)result2);
        Intrinsics.checkNotNull((Object)configuration);
        return this.convert.invoke(result2, (Object)configuration);
    }
}

