/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class XLineBreakpointType<P extends XBreakpointProperties>
extends XBreakpointType<XLineBreakpoint<P>, P> {
    protected XLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            XLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (title == null) {
            XLineBreakpointType.$$$reportNull$$$0(1);
        }
        super(id, title);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            XLineBreakpointType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            XLineBreakpointType.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Nullable
    public abstract P createBreakpointProperties(@NotNull VirtualFile var1, int var2);

    @Override
    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        return this.getDisplayTextDefaultWithPathAndLine(breakpoint);
    }

    @ApiStatus.Internal
    @Nls
    @NotNull
    public final String getDisplayTextDefaultWithPathAndLine(XLineBreakpoint<P> breakpoint) {
        String path = breakpoint.getPresentableFilePath();
        String shortenedPath = StringUtil.shortenPathWithEllipsis((String)path, (int)50);
        String string = this.filePositionDisplayText(shortenedPath, breakpoint);
        if (string == null) {
            XLineBreakpointType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    private String filePositionDisplayText(String path, XLineBreakpoint<P> breakpoint) {
        int line = breakpoint.getLine();
        int column = this.getColumn(breakpoint);
        if (column <= 0) {
            return XDebuggerBundle.message("xbreakpoint.default.display.text", line + 1, path);
        }
        return XDebuggerBundle.message("xbreakpoint.default.display.text.with.column", line + 1, column + 1, path);
    }

    public int getColumn(XLineBreakpoint<P> breakpoint) {
        return (Integer)ReadAction.compute(() -> {
            TextRange range = ((XLineBreakpointType)breakpoint.getType()).getHighlightRange(breakpoint);
            if (range == null) {
                return 0;
            }
            int offset = range.getStartOffset();
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(breakpoint.getFileUrl());
            if (file == null) {
                return -1;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return -1;
            }
            if (!XDebuggerUtil.areInlineBreakpointsEnabled(file)) {
                return -1;
            }
            if (0 > offset || offset > document.getTextLength()) {
                return -1;
            }
            return offset - document.getLineStartOffset(document.getLineNumber(offset));
        });
    }

    @Override
    @NotNull
    @Nls
    protected String getGeneralDescription(XLineBreakpointVariant variant) {
        String string = variant.getText();
        if (string == null) {
            XLineBreakpointType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<P> breakpoint) {
        if (breakpoint == null) {
            XLineBreakpointType.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    public String getShortText(XLineBreakpoint<P> breakpoint) {
        return this.filePositionDisplayText(breakpoint.getShortFilePath(), breakpoint);
    }

    @Override
    public final XLineBreakpoint<P> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<P> creator) {
        if (creator == null) {
            XLineBreakpointType.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Override
    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<P> breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            XLineBreakpointType.$$$reportNull$$$0(8);
        }
        return super.getAdditionalPopupMenuActions(breakpoint, currentSession);
    }

    public Icon getTemporaryIcon() {
        return AllIcons.Debugger.Db_set_breakpoint;
    }

    public int getPriority() {
        return 0;
    }

    public boolean canBeHitInOtherPlaces() {
        return false;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<P> breakpoint) {
        return null;
    }

    @NotNull
    public List<? extends XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            XLineBreakpointType.$$$reportNull$$$0(9);
        }
        if (position == null) {
            XLineBreakpointType.$$$reportNull$$$0(10);
        }
        List list = Collections.emptyList();
        if (list == null) {
            XLineBreakpointType.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public Promise<List<? extends XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            XLineBreakpointType.$$$reportNull$$$0(12);
        }
        if (position == null) {
            XLineBreakpointType.$$$reportNull$$$0(13);
        }
        Promise promise = Promises.resolvedPromise(this.computeVariants(project, position));
        if (promise == null) {
            XLineBreakpointType.$$$reportNull$$$0(14);
        }
        return promise;
    }

    public boolean variantAndBreakpointMatch(@NotNull XLineBreakpoint<P> breakpoint, @NotNull XLineBreakpointVariant variant) {
        if (breakpoint == null) {
            XLineBreakpointType.$$$reportNull$$$0(15);
        }
        if (variant == null) {
            XLineBreakpointType.$$$reportNull$$$0(16);
        }
        TextRange r1 = this.getHighlightRange(breakpoint);
        TextRange r2 = variant.getHighlightRange();
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 != null && r2 != null) {
            return r1.getStartOffset() == r2.getStartOffset();
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean lineShouldBeChanged(@NotNull XLineBreakpoint<P> breakpoint, int newLine, @NotNull Project project) {
        if (breakpoint == null) {
            XLineBreakpointType.$$$reportNull$$$0(17);
        }
        if (project == null) {
            XLineBreakpointType.$$$reportNull$$$0(18);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayTextDefaultWithPathAndLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariantsAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupMenuActions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeVariantsAsync";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "variantAndBreakpointMatch";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lineShouldBeChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 11, 14 -> new IllegalStateException(string);
        };
    }

    public abstract class XLineBreakpointVariant {
        @NotNull
        @Nls
        public abstract String getText();

        @Nullable
        public abstract Icon getIcon();

        @Nullable
        public abstract TextRange getHighlightRange();

        public int getPriority(@NotNull Project project) {
            if (project == null) {
                XLineBreakpointVariant.$$$reportNull$$$0(0);
            }
            return this.getType().getPriority();
        }

        public boolean isMultiVariant() {
            return false;
        }

        public boolean shouldUseAsInlineVariant() {
            return !this.isMultiVariant();
        }

        @Nullable
        public abstract P createProperties();

        public final XLineBreakpointType<P> getType() {
            return XLineBreakpointType.this;
        }

        @NotNull
        @Nls
        public final String getTooltipDescription() {
            String string = this.getType().getGeneralDescription(this);
            if (string == null) {
                XLineBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return String.valueOf(this.getType()) + ": " + this.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPriority";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public class XLinePsiElementBreakpointVariant
    extends XLineBreakpointAllVariant {
        private final PsiElement myElement;

        public XLinePsiElementBreakpointVariant(@NotNull XLineBreakpointType this$0, XSourcePosition position, PsiElement element) {
            if (position == null) {
                XLinePsiElementBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(position);
            this.myElement = element;
        }

        @Override
        public Icon getIcon() {
            return this.myElement.getIcon(0);
        }

        @Override
        @NotNull
        public String getText() {
            String string = StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0);
            if (string == null) {
                XLinePsiElementBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public TextRange getHighlightRange() {
            return this.myElement.getTextRange();
        }

        @Override
        public boolean isMultiVariant() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLinePsiElementBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLinePsiElementBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public class XLineBreakpointAllVariant
    extends XLineBreakpointVariant {
        protected final XSourcePosition mySourcePosition;

        public XLineBreakpointAllVariant(XSourcePosition position) {
            if (position == null) {
                XLineBreakpointAllVariant.$$$reportNull$$$0(0);
            }
            this.mySourcePosition = position;
        }

        @Override
        @NotNull
        public String getText() {
            String string = XDebuggerBundle.message("breakpoint.variant.text.all", new Object[0]);
            if (string == null) {
                XLineBreakpointAllVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Debugger.MultipleBreakpoints;
        }

        @Override
        @Nullable
        public TextRange getHighlightRange() {
            return null;
        }

        @Override
        public boolean isMultiVariant() {
            return true;
        }

        @Override
        @Nullable
        public P createProperties() {
            return XLineBreakpointType.this.createBreakpointProperties(this.mySourcePosition.getFile(), this.mySourcePosition.getLine());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointAllVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointAllVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

