/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.SqlFormatterHelper;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.EndExcElementContinuePattern;
import com.intellij.sql.formatter.model.EndIncElementContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonExpandPattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlInsertMatrixAligner;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedListBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPhraseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock$patchFormattingAttributesForChildren$;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.model.StartStopPattern;
import com.intellij.sql.formatter.model.StartUntilPattern;
import com.intellij.sql.formatter.model.TypePattern;
import com.intellij.sql.formatter.model.UntilPattern;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlSelectModifierClause;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\u0018\u0000 -2\u00020\u0001:%-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0014J\b\u0010\u001c\u001a\u00020\u0015H\u0014J\b\u0010\u001d\u001a\u00020\u0015H\u0014J\b\u0010\u001e\u001a\u00020\u0015H\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020\u0005H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020)H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006R"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "isSubQuery", "", "isInsert", "isUnion", "commonFirstWordRightAlign", "Lcom/intellij/formatting/Alignment;", "getCommonFirstWordRightAlign", "()Lcom/intellij/formatting/Alignment;", "setCommonFirstWordRightAlign", "(Lcom/intellij/formatting/Alignment;)V", "whetherToFlatten", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "handleWhetherIsSubquery", "", "handleWhetherIsInsert", "detectWhetherIntoSeparated", "checkIsSubquery", "userWrapSetting", "", "allowedToCollapse", "tuneNestedNodesAfterAnalysis", "configureFormattingAttributes", "patchFormattingAttributesForChildren", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "tailFormed", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getDebugName", "Companion", "QuerySection", "WordAndListSection", "InsertSection", "ValuesSection", "SqlCortegeLikeParenthesizedListBlock", "UpdateSection", "DeleteSection", "OnSection", "SetSection", "WithSection", "SelectSection", "FromSection", "WhereSection", "GroupOrderSection", "OneLineSection", "ReturningSection", "OutputSection", "LimitSection", "UnionSection", "WindowSection", "WindowEntry", "UnknownSection", "SectionElement", "SetAssignment", "CTE", "SelectSeparatedPrefix", "SelectElement", "SelectElementEssence", "SelectModifier", "PrimaryTableElement", "SecondaryTableElement", "ParenthesizedJoinTableExpression", "LateralFunctionCall", "JoinPhrase", "JoinCondition", "PredicateElement", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1732:1\n296#2,2:1733\n296#2,2:1735\n1915#2,2:1740\n1915#2,2:1745\n468#3,3:1737\n468#3,3:1742\n479#4:1747\n184#4,2:1748\n479#4:1750\n184#4,2:1751\n1#5:1753\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock\n*L\n209#1:1733,2\n210#1:1735,2\n270#1:1740,2\n271#1:1745,2\n270#1:1737,3\n271#1:1742,3\n295#1:1747\n295#1:1748,2\n296#1:1750\n296#1:1751,2\n*E\n"})
public final class SqlQueryBlock
extends SqlNodeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isSubQuery;
    private boolean isInsert;
    private boolean isUnion;
    @Nullable
    private Alignment commonFirstWordRightAlign;
    @NotNull
    private static final Set<IElementType> nodesToFlatten;
    @NotNull
    private static final Set<IElementType> sectionMarkers;
    @NotNull
    private static final Set<IElementType> tableJoinWords;
    @NotNull
    private static final Set<IElementType> unionStartWords;
    @NotNull
    private static final Set<IElementType> unionGluedWords;
    @NotNull
    private static final Set<IElementType> limitStopMarker;
    @NotNull
    private static final List<FlowPattern> commonPatterns;
    @NotNull
    private static final List<FlowPattern> insertIntoTogetherPatterns;
    @NotNull
    private static final List<FlowPattern> insertIntoSeparatedPatterns;
    @NotNull
    private static final List<FlowPattern> postgresQueryPatterns;

    @Nullable
    public final Alignment getCommonFirstWordRightAlign() {
        return this.commonFirstWordRightAlign;
    }

    public final void setCommonFirstWordRightAlign(@Nullable Alignment alignment) {
        this.commonFirstWordRightAlign = alignment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (nodesToFlatten.contains(type)) return true;
        if (!Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION)) return false;
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_COMMA");
        if (!SqlUtilFun.hasChildNode(node, (IElementType)sqlTokenType)) return false;
        return true;
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        List<FlowPattern> list;
        this.handleWhetherIsSubquery();
        this.handleWhetherIsInsert();
        boolean bl = this.isInsert;
        if (!bl) {
            list = this.getContext().getDialect().getDbms().isPostgres() ? postgresQueryPatterns : commonPatterns;
        } else if (bl) {
            boolean separate;
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    boolean bl2 = true;
                    break;
                }
                case 2: {
                    boolean bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = separate = this.detectWhetherIntoSeparated();
                }
            }
            list = separate ? insertIntoSeparatedPatterns : insertIntoTogetherPatterns;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final void handleWhetherIsSubquery() {
        this.isSubQuery = this.checkIsSubquery();
    }

    private final void handleWhetherIsInsert() {
        IElementType iElementType = SqlUtilFun.firstLeaf(this.getBlockNode()).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType firstType = iElementType;
        this.isInsert = Intrinsics.areEqual((Object)firstType, (Object)SqlTokens.SQL_INSERT) || Intrinsics.areEqual((Object)firstType, (Object)SqlTokens.SQL_REPLACE);
    }

    private final boolean detectWhetherIntoSeparated() {
        Object v1;
        ASTNode insertNode;
        block4: {
            Object v0;
            JBIterable<ASTNode> children;
            block3: {
                children = SqlUtilFun.children(this.getBlockNode());
                Iterable $this$firstOrNull$iv = (Iterable)children;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl = false;
                    if (!(it.getElementType() == SqlTokens.SQL_INSERT)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            insertNode = v0;
            Iterable $this$firstOrNull$iv = (Iterable)children;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!(it.getElementType() == SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION || it.getElementType() == SqlTokens.SQL_INTO)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ASTNode intoNode = v1;
        if (insertNode == null || intoNode == null) {
            return false;
        }
        return this.getContext().textContains(insertNode.getTextRange().getEndOffset(), intoNode.getStartOffset(), '\n');
    }

    private final boolean checkIsSubquery() {
        for (SqlBlock p2 = this.getParent(); p2 != null; p2 = p2.getParent()) {
            if (p2 instanceof SqlQueryBlock) {
                return true;
            }
            if (!(p2 instanceof SqlCodeFlowBlock) || p2 instanceof SqlBatchBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public int userWrapSetting() {
        return switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 1 -> 1;
            case 2 -> {
                if (this.isSubQuery) {
                    yield 2;
                }
                yield 1;
            }
            case 3 -> 2;
            default -> 0;
        };
    }

    @Override
    protected boolean allowedToCollapse() {
        return switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 1 -> false;
            case 2 -> this.isSubQuery;
            case 3 -> true;
            default -> !this.getHasUserBreaks();
        };
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        super.tuneNestedNodesAfterAnalysis();
        if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) >= 0) {
            for (SqlBlock b : this.getNestedBlocks()) {
                boolean toExpand;
                if (b instanceof UnionSection) {
                    this.isUnion = true;
                }
                if (!(b instanceof WordAndListSection) || !(toExpand = ((WordAndListSection)b).userWrapSetting() == 1 && (((WordAndListSection)b).getCountOfElements() > ((WordAndListSection)b).userNumberOfElementsToKeepCollapsed() || ((WordAndListSection)b).userElementsLineSetting() == 101)) || b.getShape().compareTo((Enum)this.getShape()) >= 0) continue;
                b.setShape(this.getShape());
            }
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings q = this.getContext().getSql();
        boolean decidedToWrap = this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS || !this.allowedToCollapse();
        Wrap w = SqlFlowBlock.makeWrap$default(this, decidedToWrap ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
        for (SqlBlock b : this.nestedBlocksIter().skip(1)) {
            b.setMyWrap(w);
        }
        switch (q.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 2: {
                Indent i2 = Indent.getNormalIndent((boolean)true);
                for (SqlBlock b : this.getNestedBlocks()) {
                    if (!(b instanceof QuerySection) || !((QuerySection)b).whetherSectionToIndent()) continue;
                    b.setMyIndent(i2);
                }
                break;
            }
            case 8: {
                QuerySection it;
                Iterator<SqlBlock> $this$forEach$iv;
                int thePrefixLength = 0;
                thePrefixLength = 6;
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterator $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)((Object)$this$jbi$iv$iv));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(QuerySection.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                $this$filter$iv = (Iterable)jBIterable2;
                boolean $i$f$forEach = false;
                $this$jbi$iv$iv = $this$forEach$iv.iterator();
                while ($this$jbi$iv$iv.hasNext()) {
                    Object element$iv = $this$jbi$iv$iv.next();
                    it = (QuerySection)element$iv;
                    boolean bl = false;
                    if (it.getFirstWordLength$intellij_database_sql_core_impl() <= thePrefixLength) continue;
                    thePrefixLength = it.getFirstWordLength$intellij_database_sql_core_impl();
                }
                $this$filter$iv = this.getNestedBlocks();
                $i$f$filter = false;
                $this$jbi$iv$iv = $this$filter$iv;
                $i$f$getJbi = false;
                JBIterable jBIterable3 = JBIterable.from((Iterable)((Object)$this$jbi$iv$iv));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"from(...)");
                JBIterable jBIterable4 = jBIterable3.filter(QuerySection.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
                $this$filter$iv = (Iterable)jBIterable4;
                $i$f$forEach = false;
                $this$jbi$iv$iv = $this$forEach$iv.iterator();
                while ($this$jbi$iv$iv.hasNext()) {
                    Object element$iv = $this$jbi$iv$iv.next();
                    it = (QuerySection)element$iv;
                    boolean bl = false;
                    if (it.getFirstWordLength$intellij_database_sql_core_impl() >= thePrefixLength) continue;
                    it.setMyIndent(Indent.getSpaceIndent((int)(thePrefixLength - it.getFirstWordLength$intellij_database_sql_core_impl())));
                }
                break;
            }
        }
        switch (q.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: {
                Alignment a = SqlFormattingModelFun.makeLeftAlignment();
                for (SqlBlock b : this.getNestedBlocks()) {
                    b.setMyAlign(a);
                }
                break;
            }
            case 2: {
                Alignment a1 = SqlFormattingModelFun.makeLeftAlignment();
                Alignment a2 = SqlFormattingModelFun.makeLeftAlignment();
                for (SqlBlock b : this.getNestedBlocks()) {
                    b.setMyAlign(b instanceof QuerySection && ((QuerySection)b).whetherSectionToIndent() ? a2 : a1);
                }
                break;
            }
            case 8: {
                this.commonFirstWordRightAlign = SqlFormattingModelFun.makeRightAlignment();
                for (SqlBlock b : this.getNestedBlocks()) {
                    SqlLeafBlock sqlLeafBlock = b.getFirstLeafBlock();
                    if (sqlLeafBlock == null) continue;
                    sqlLeafBlock.setMyAlign(this.commonFirstWordRightAlign);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void patchFormattingAttributesForChildren() {
        SqlCodeStyleSettings q = this.getContext().getSql();
        if (this.isInsert && q.INSERT_MATRIX_ALIGN) {
            Object v3;
            InsertSection theHeader;
            block5: {
                void $this$firstOrNull$iv;
                Object v1;
                block4: {
                    Sequence $this$filterIsInstance$iv = (Sequence)SequenceFun.asSequence((Collection)this.getNestedBlocks());
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)patchFormattingAttributesForChildren$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    Sequence $this$firstOrNull$iv2 = sequence;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv2) {
                        InsertSection it = (InsertSection)element$iv;
                        boolean bl = false;
                        if (!(it.getCountOfFields() > 0)) continue;
                        v1 = element$iv;
                        break block4;
                    }
                    v1 = null;
                }
                theHeader = v1;
                Sequence $this$filterIsInstance$iv = (Sequence)SequenceFun.asSequence((Collection)this.getNestedBlocks());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)patchFormattingAttributesForChildren$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = sequence;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValuesSection it = (ValuesSection)element$iv;
                    boolean bl = false;
                    if (!(it.getCountOfRows$intellij_database_sql_core_impl() >= 2)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            ValuesSection theMatrix = v3;
            if (theMatrix != null) {
                InsertSection insertSection;
                boolean includeHeader = q.INSERT_MATRIX_INCLUDING_HEADER;
                int percentile = q.INSERT_MATRIX_MODE;
                int breakThreshold = q.INSERT_MATRIX_BREAK_THRESHOLD;
                int minWideningThreshold = q.INSERT_MATRIX_MIN_WIDENING_THRESHOLD;
                InsertSection it = insertSection = theHeader;
                boolean bl = false;
                SqlInsertMatrixAligner.alignTheMatrix(includeHeader ? insertSection : null, theMatrix, percentile, minWideningThreshold, breakThreshold);
            }
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (block1 instanceof InsertSection && block2 instanceof InsertSection) {
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                case 2: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean tailFormed() {
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        if (sqlBlock == null) {
            return false;
        }
        SqlBlock lastBlock = sqlBlock;
        SqlBlock sqlBlock2 = lastBlock;
        return sqlBlock2 instanceof SelectSection ? ((SelectSection)lastBlock).canBeSelectSectionOnly$intellij_database_sql_core_impl() : !(sqlBlock2 instanceof UnionSection);
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        SqlBlock block1;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock sqlBlock = block1 = blocks.getBlock1();
        if (sqlBlock != null) {
            sqlBlock.grow();
        }
        return block1 instanceof QuerySection ? (((QuerySection)block1).tailFormed() ? SqlFormattingContext.currIndentOf$default(this.getContext(), block1, true, false, false, 12, null) : ((QuerySection)block1).getNewLineIndent(new AdjacentBlocks(((QuerySection)block1).getLastNestedSqlBlock(), null))) : SqlFormattingContext.currIndentOf$default(this.getContext(), this, false, false, false, 14, null);
    }

    @Override
    @NotNull
    public String getDebugName() {
        return super.getDebugName() + (this.isSubQuery ? "(sub)" : "");
    }

    private static final boolean commonPatterns$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SqlUtilFun.firstLeaf(it).getElementType() == SqlTokens.SQL_RETURNING;
    }

    private static final boolean commonPatterns$lambda$1(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SqlUtilFun.firstLeaf(it).getElementType() == SqlTokens.SQL_OUTPUT;
    }

    static {
        Object[] objectArray = new SqlElementType[]{SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, SqlCompositeElementTypes.SQL_SET_CLAUSE, SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_WITH_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_INTO_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_INTO_NEW_TABLE_CLAUSE, SqlCompositeElementTypes.SQL_TABLE_EXPRESSION, SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST, SqlCompositeElementTypes.SQL_REFERENCE_LIST, SqlCompositeElementTypes.SQL_FROM_CLAUSE, SqlCompositeElementTypes.SQL_WHERE_CLAUSE, SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE, SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE, SqlCompositeElementTypes.SQL_HAVING_CLAUSE, SqlCompositeElementTypes.SQL_QUALIFY_CLAUSE, SqlCompositeElementTypes.SQL_UNION_EXPRESSION, SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE, SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, SqlCompositeElementTypes.SQL_CONFLICT_ACTION_CLAUSE, SqlCompositeElementTypes.SQL_CLAUSE};
        nodesToFlatten = SetsKt.setOf((Object[])objectArray);
        objectArray = new IElementType[]{SqlTokens.SQL_INSERT, SqlTokens.SQL_REPLACE, SqlTokens.SQL_INTO, SqlTokens.SQL_ON, SqlTokens.SQL_UPDATE, SqlTokens.SQL_DELETE, SqlTokens.SQL_SET, SqlTokens.SQL_VALUES, SqlTokens.SQL_WITH, SqlTokens.SQL_SELECT, SqlTokens.SQL_FROM, SqlTokens.SQL_WHERE, SqlTokens.SQL_START, SqlTokens.SQL_CONNECT, SqlTokens.SQL_GROUP, SqlTokens.SQL_HAVING, SqlTokens.SQL_QUALIFY, SqlTokens.SQL_UNION, SqlTokens.SQL_INTERSECT, SqlTokens.SQL_MINUS, SqlTokens.SQL_EXCEPT, SqlTokens.SQL_ORDER, SqlTokens.SQL_OPTION, SqlCompositeElementTypes.SQL_RETURNING_CLAUSE, SqlTokens.SQL_OFFSET, SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, SqlTokens.SQL_LIMIT, SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, SqlCompositeElementTypes.SQL_LIMIT_OFFSET_CLAUSE, SqlCompositeElementTypes.SQL_WINDOW_CLAUSE, SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE};
        sectionMarkers = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_NATURAL, SqlTokens.SQL_LEFT, SqlTokens.SQL_RIGHT, SqlTokens.SQL_FULL, SqlTokens.SQL_INNER, SqlTokens.SQL_OUTER, SqlTokens.SQL_CROSS, SqlTokens.SQL_LOOP, SqlTokens.SQL_HASH, SqlTokens.SQL_MERGE, SqlTokens.SQL_REMOTE, SqlTokens.SQL_LOOP, SqlTokens.SQL_REDUCE, SqlTokens.SQL_REPLICATE, SqlTokens.SQL_REDISTRIBUTE, SqlTokens.SQL_ARRAY, SqlTokens.SQL_APPLY, SqlTokens.SQL_JOIN, SqlTokens.SQL_LATERAL};
        tableJoinWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_UNION, SqlTokens.SQL_INTERSECT, SqlTokens.SQL_MINUS, SqlTokens.SQL_EXCEPT};
        unionStartWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_UNION, SqlTokens.SQL_INTERSECT, SqlTokens.SQL_MINUS, SqlTokens.SQL_EXCEPT, SqlTokens.SQL_ALL};
        unionGluedWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_OFFSET, SqlTokens.SQL_LIMIT};
        limitStopMarker = SetsKt.minus(sectionMarkers, (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new FlowPattern[21];
        SqlTokenType sqlTokenType = SqlTokens.SQL_INTO;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_INTO");
        objectArray[0] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
        SqlTokenType sqlTokenType2 = SqlTokens.SQL_ON;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_ON");
        Object[] objectArray2 = new SqlTokenType[]{SqlTokens.SQL_ON, SqlTokens.SQL_UPDATE, SqlTokens.SQL_SET};
        objectArray[1] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), NodeMatcherKt.matchType(SetsKt.minus(sectionMarkers, (Iterable)SetsKt.setOf((Object[])objectArray2))), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlTokens.SQL_UPDATE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_UPDATE");
        objectArray[2] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType3), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
        SqlTokenType sqlTokenType4 = SqlTokens.SQL_DELETE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_DELETE");
        objectArray[3] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
        SqlTokenType sqlTokenType5 = SqlTokens.SQL_SET;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_SET");
        objectArray[4] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType5), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.5.INSTANCE));
        SqlTokenType sqlTokenType6 = SqlTokens.SQL_VALUES;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType6, (String)"SQL_VALUES");
        objectArray[5] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType6), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.6.INSTANCE));
        SqlTokenType sqlTokenType7 = SqlTokens.SQL_WITH;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType7, (String)"SQL_WITH");
        objectArray[6] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType7), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.7.INSTANCE));
        SqlTokenType sqlTokenType8 = SqlTokens.SQL_SELECT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType8, (String)"SQL_SELECT");
        objectArray[7] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType8), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.8.INSTANCE));
        SqlTokenType sqlTokenType9 = SqlTokens.SQL_FROM;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType9, (String)"SQL_FROM");
        objectArray[8] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType9), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.9.INSTANCE));
        objectArray2 = new IElementType[4];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_WHERE, (String)"SQL_WHERE");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_HAVING, (String)"SQL_HAVING");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_CONNECT, (String)"SQL_CONNECT");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_QUALIFY, (String)"SQL_QUALIFY");
        objectArray[9] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.10.INSTANCE));
        SqlTokenType sqlTokenType10 = SqlTokens.SQL_START;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType10, (String)"SQL_START");
        objectArray[10] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType10), NodeMatcherKt.matchType(SetsKt.minus(sectionMarkers, (Object)SqlTokens.SQL_WITH)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.11.INSTANCE));
        objectArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_GROUP, (String)"SQL_GROUP");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_ORDER, (String)"SQL_ORDER");
        objectArray[11] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.12.INSTANCE));
        objectArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_OFFSET, (String)"SQL_OFFSET");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_LIMIT, (String)"SQL_LIMIT");
        objectArray[12] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), NodeMatcherKt.matchType(limitStopMarker), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.13.INSTANCE));
        objectArray[13] = new SimplePattern(null, null, NodeMatcherKt.matchType(unionStartWords), NodeMatcherKt.matchType(unionGluedWords), false, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.14.INSTANCE));
        SqlTokenType sqlTokenType11 = SqlTokens.SQL_OPTION;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType11, (String)"SQL_OPTION");
        objectArray[14] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType11), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.15.INSTANCE));
        objectArray2 = new IElementType[3];
        Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, (String)"SQL_OFFSET_CLAUSE");
        Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, (String)"SQL_LIMIT_CLAUSE");
        Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_LIMIT_OFFSET_CLAUSE, (String)"SQL_LIMIT_OFFSET_CLAUSE");
        objectArray[15] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.16.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_RETURNING_CLAUSE");
        objectArray[16] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType, "first leaf is RETURNING", (Function1<? super ASTNode, Boolean>)((Function1)SqlQueryBlock::commonPatterns$lambda$0)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.18.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_RETURNING_CLAUSE");
        objectArray[17] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType2, "first leaf is OUTPUT", (Function1<? super ASTNode, Boolean>)((Function1)SqlQueryBlock::commonPatterns$lambda$1)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.20.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_RETURNING_CLAUSE");
        objectArray[18] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.21.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType4 = SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType4, (String)"SQL_QUERY_FLATTEN_CLAUSE");
        objectArray[19] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType4), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.22.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType5 = SqlCompositeElementTypes.SQL_WINDOW_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType5, (String)"SQL_WINDOW_CLAUSE");
        objectArray[20] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType5), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.23.INSTANCE));
        commonPatterns = CollectionsKt.listOf((Object[])objectArray);
        Collection collection = commonPatterns;
        objectArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_INSERT, (String)"SQL_INSERT");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_REPLACE, (String)"SQL_REPLACE");
        insertIntoTogetherPatterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray), NodeMatcherKt.matchType(SetsKt.minus(sectionMarkers, (Object)SqlTokens.SQL_INTO)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.insertIntoTogetherPatterns.1.INSTANCE))));
        Collection collection2 = commonPatterns;
        objectArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_INSERT, (String)"SQL_INSERT");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_REPLACE, (String)"SQL_REPLACE");
        insertIntoSeparatedPatterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.insertIntoSeparatedPatterns.1.INSTANCE))));
        Collection collection3 = commonPatterns;
        SqlTokenType sqlTokenType12 = SqlTokens.SQL_PERFORM;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType12, (String)"SQL_PERFORM");
        postgresQueryPatterns = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType12), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.postgresQueryPatterns.1.INSTANCE))));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "countRole", "", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "configureFormattingAttributes", "Companion", "intellij.database.sql.core.impl"})
    private static final class CTE
    extends SqlNodeBlock {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                SqlFlowBlock sqlFlowBlock = sqlBlock instanceof SqlFlowBlock ? (SqlFlowBlock)sqlBlock : null;
                if (sqlFlowBlock == null) break block0;
                sqlFlowBlock.countRole$intellij_database_sql_core_impl(role);
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block0: {
                SqlBlock sqlBlock;
                this.setInnerWrap(SqlFlowBlock.makeWrap$default(this, WrapType.NORMAL, false, 2, null));
                Iterable iterable = this.getNestedBlocks();
                SqlTokenType sqlTokenType = SqlTokens.SQL_AS;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
                SqlBlock sqlBlock2 = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)iterable, (IElementType)sqlTokenType);
                if (sqlBlock2 == null) break block0;
                SqlBlock it = sqlBlock = sqlBlock2;
                boolean bl = false;
                it.setMyWrap(this.getInnerWrap());
            }
        }

        static {
            Object[] objectArray = new FlowPattern[3];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_IDENTIFIER");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlTokens.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
            objectArray[1] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
            objectArray[2] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), BlockRole.BODY, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$Companion;", "", "<init>", "()V", "nodesToFlatten", "", "Lcom/intellij/psi/tree/IElementType;", "sectionMarkers", "tableJoinWords", "unionStartWords", "unionGluedWords", "limitStopMarker", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "insertIntoTogetherPatterns", "insertIntoSeparatedPatterns", "postgresQueryPatterns", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$DeleteSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "userElementsLineSetting", "", "intellij.database.sql.core.impl"})
    private static final class DeleteSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0005H\u0014J\b\u0010\u0015\u001a\u00020\u0013H\u0014J\b\u0010\u0016\u001a\u00020\u0005H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "hasJoins", "", "getHasJoins", "()Z", "setHasJoins", "(Z)V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "whetherSectionToIndent", "userElementsLineSetting", "", "userWrapSetting", "userCommaSetting", "tuneNestedNodesAfterAnalysis", "", "toAlignElements", "configureFormattingAttributes", "userRequiresExpand", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$FromSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 3 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1732:1\n248#2:1733\n468#3,3:1734\n468#3,3:1739\n468#3,3:1742\n1915#4,2:1737\n1915#4,2:1745\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$FromSection\n*L\n1099#1:1733\n1105#1:1734,3\n1121#1:1739,3\n1124#1:1742,3\n1105#1:1737,2\n1126#1:1745,2\n*E\n"})
    private static final class FromSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private boolean hasJoins;
        @NotNull
        private static final Set<SqlCompositeElementType> elementTypes;
        @NotNull
        private static final List<FlowPattern> patterns;

        public final boolean getHasJoins() {
            return this.hasJoins;
        }

        public final void setHasJoins(boolean bl) {
            this.hasJoins = bl;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().FROM_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().FROM_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().FROM_EL_COMMA;
        }

        @Override
        protected void tuneNestedNodesAfterAnalysis() {
            super.tuneNestedNodesAfterAnalysis();
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrimaryTableElement it = (PrimaryTableElement)element$iv;
                boolean bl = false;
                this.hasJoins = this.hasJoins || it.getCountOfJoins() > 0;
            }
            if (this.getCountOfElements() > 1 && this.hasJoins) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected boolean toAlignElements() {
            return this.getContext().getSql().FROM_ONLY_JOIN_INDENT > -1 && this.getCountOfElements() + this.getCountOfDelimiters() <= 1 ? false : super.toAlignElements();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            if (this.getContext().getSql().FROM_ALIGN_ALIASES) {
                void $this$filter$iv;
                void $this$filter$iv2;
                Alignment a1 = SqlFormattingModelFun.makeLeftAlignmentBS();
                Alignment a2 = SqlFormattingModelFun.makeLeftAlignmentBS();
                Iterable iterable = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                boolean $i$f$filter = false;
                void $this$jbi$iv$iv = $this$filter$iv2;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                JBIterable jBIterable3 = jBIterable2.flatten(arg_0 -> FromSection.configureFormattingAttributes$lambda$1(FromSection::configureFormattingAttributes$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"flatten(...)");
                Iterable iterable2 = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable3), BlockRole.ELEMENT);
                boolean $i$f$filter2 = false;
                void $this$jbi$iv$iv2 = $this$filter$iv;
                boolean $i$f$getJbi2 = false;
                JBIterable jBIterable4 = JBIterable.from((Iterable)$this$jbi$iv$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"from(...)");
                JBIterable jBIterable5 = jBIterable4.filter(SecondaryTableElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"filter(...)");
                JBIterable jBIterable6 = jBIterable5.flatten(arg_0 -> FromSection.configureFormattingAttributes$lambda$3(FromSection::configureFormattingAttributes$lambda$2, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"flatten(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable6;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it = (SqlBlock)element$iv;
                    boolean bl = false;
                    if (it.getRole() == BlockRole.AS) {
                        it.setMyAlign(a1);
                    }
                    if (it.getRole() != BlockRole.ALIAS2) continue;
                    it.setMyAlign(a2);
                }
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            return this.getCountOfElements() >= 2 && (this.hasJoins || this.userWrapSetting() == 1);
        }

        private static final Iterable configureFormattingAttributes$lambda$0(PrimaryTableElement it) {
            return it.getNestedBlocks();
        }

        private static final Iterable configureFormattingAttributes$lambda$1(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        private static final Iterable configureFormattingAttributes$lambda$2(SecondaryTableElement it) {
            return it.getNestedBlocks();
        }

        private static final Iterable configureFormattingAttributes$lambda$3(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        static {
            Object[] objectArray = new SqlCompositeElementType[]{SqlCompositeElementTypes.SQL_TABLE_REFERENCE, SqlCompositeElementTypes.SQL_AS_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_EXPLICIT_TABLE_EXPRESSION, SqlCompositeElementTypes.SQL_JOIN_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION};
            elementTypes = SetsKt.setOf((Object[])objectArray);
            patterns = CollectionsKt.plus((Collection)WordAndListSection.Companion.getCommonPatterns(), (Iterable)CollectionsKt.listOf((Object)new SingletonPattern((byte)1, null, NodeMatcherKt.matchType(elementTypes), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection$Companion;", "", "<init>", "()V", "elementTypes", "", "Lcom/intellij/sql/psi/SqlCompositeElementType;", "kotlin.jvm.PlatformType", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "whetherSectionToIndent", "", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "patchFormattingAttributesForChildren", "", "userElementsLineSetting", "", "userWrapSetting", "userCommaSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 3 NodeMatcher.kt\ncom/intellij/sql/formatter/model/NodeMatcherKt\n*L\n1#1,1732:1\n248#2:1733\n38#3:1734\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection\n*L\n1205#1:1733\n1186#1:1734\n*E\n"})
    private static final class GroupOrderSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean whetherSectionToIndent() {
            if (!this.getThisQuery$intellij_database_sql_core_impl().isUnion) return true;
            ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if ((aSTNode != null ? aSTNode.getElementType() : null) == SqlTokens.SQL_ORDER) return false;
            return true;
        }

        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_ASC) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_DESC) ? BlockRole.AMENDMENT : super.determineRole(node);
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().ORDER_ALIGN_ASC_DESC) {
                this.tabify(BlockRole.AMENDMENT);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().ORDER_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().ORDER_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().ORDER_EL_COMMA;
        }

        static {
            boolean $i$f$matchElementClass = false;
            patterns = CollectionsKt.plus((Collection)WordAndListSection.Companion.getCommonPatterns(), (Iterable)CollectionsKt.listOf((Object)new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "fieldsBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "getFieldsBlock", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "setFieldsBlock", "(Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;)V", "fields", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getFields", "()Lcom/intellij/util/containers/JBIterable;", "countOfFields", "", "getCountOfFields", "()I", "userElementsLineSetting", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "considerBlock", "", "block", "whetherSectionToIndent", "", "configureFormattingAttributes", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1732:1\n248#2:1733\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection\n*L\n751#1:1733\n*E\n"})
    public static final class InsertSection
    extends QuerySection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlCortegeLikeParenthesizedListBlock fieldsBlock;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Nullable
        public final SqlCortegeLikeParenthesizedListBlock getFieldsBlock() {
            return this.fieldsBlock;
        }

        public final void setFieldsBlock(@Nullable SqlCortegeLikeParenthesizedListBlock sqlCortegeLikeParenthesizedListBlock) {
            this.fieldsBlock = sqlCortegeLikeParenthesizedListBlock;
        }

        @NotNull
        public final JBIterable<SqlBlock> getFields() {
            JBIterable<SqlBlock> jBIterable = this.fieldsBlock;
            if (jBIterable == null || (jBIterable = jBIterable.getNestedBlocks()) == null || (jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable), BlockRole.ELEMENT)) == null) {
                JBIterable jBIterable2 = JBIterable.empty();
                jBIterable = jBIterable2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
            }
            return jBIterable;
        }

        public final int getCountOfFields() {
            SqlCortegeLikeParenthesizedListBlock sqlCortegeLikeParenthesizedListBlock = this.fieldsBlock;
            return sqlCortegeLikeParenthesizedListBlock != null ? sqlCortegeLikeParenthesizedListBlock.getCountOfElements$intellij_database_sql_core_impl() : 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_TABLE_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block instanceof SqlCortegeLikeParenthesizedListBlock) {
                this.fieldsBlock = (SqlCortegeLikeParenthesizedListBlock)block;
            }
        }

        @Override
        public boolean whetherSectionToIndent() {
            return this.getFirstWord$intellij_database_sql_core_impl() == SqlTokens.SQL_INTO;
        }

        @Override
        protected void configureFormattingAttributes() {
            block4: {
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2 = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ALIAS1);
                if (sqlBlock2 == null) break block4;
                SqlBlock it = sqlBlock = sqlBlock2;
                boolean bl = false;
                it.setMyWrap(switch (this.userElementsLineSetting()) {
                    case 1 -> Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                    case 101 -> this.makeWrap(WrapType.ALWAYS, true);
                    default -> null;
                });
            }
        }

        static {
            Object[] objectArray = new FlowPattern[3];
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_TABLE_REFERENCE");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_HINT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_HINT_CLAUSE");
            objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "keyBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getKeyBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setKeyBlock", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "considerBlock", "", "block", "configureFormattingAttributes", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,1732:1\n112#2,4:1733\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition\n*L\n1700#1:1733,4\n*E\n"})
    private static final class JoinCondition
    extends SqlNodeBlock {
        @Nullable
        private SqlBlock keyBlock;

        @Nullable
        public final SqlBlock getKeyBlock() {
            return this.keyBlock;
        }

        public final void setKeyBlock(@Nullable SqlBlock sqlBlock) {
            this.keyBlock = sqlBlock;
        }

        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType t = iElementType;
            return t == SqlTokens.SQL_ON || t == SqlTokens.SQL_USING ? BlockRole.PREFIX : BlockRole.NOTHING;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block.getRole() == BlockRole.PREFIX && this.keyBlock == null) {
                this.keyBlock = block;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void configureFormattingAttributes() {
            block5: {
                void indent$iv;
                void wrap$iv;
                void this_$iv;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2 = this.keyBlock;
                if (sqlBlock2 == null) break block5;
                SqlBlock kb = sqlBlock = sqlBlock2;
                boolean bl = false;
                SqlCodeStyleSettings s = this.getContext().getSql();
                Indent i = switch (s.FROM_PLACE_ON) {
                    case 10 -> SqlFormattingFunKt.getNONE_INDENT();
                    case 11 -> SqlFormattingFunKt.getNORMAL_INDENT();
                    case 12 -> SqlFormattingFunKt.getCONTINUATION_INDENT();
                    default -> SqlFormattingFunKt.getNONE_INDENT();
                };
                SqlBlock sqlBlock3 = kb;
                Object var7_7 = null;
                Indent indent = i;
                Alignment align$iv = null;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent((Indent)indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinPhrase;", "Lcom/intellij/sql/formatter/model/SqlPhraseBlock;", "<init>", "()V", "intellij.database.sql.core.impl"})
    private static final class JoinPhrase
    extends SqlPhraseBlock {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$LateralFunctionCall;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "intellij.database.sql.core.impl"})
    private static final class LateralFunctionCall
    extends SqlRangeBlock {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$LimitSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "<init>", "()V", "intellij.database.sql.core.impl"})
    private static final class LimitSection
    extends OneLineSection {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OnSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "Companion", "intellij.database.sql.core.impl"})
    private static final class OnSection
    extends QuerySection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        static {
            Object[] objectArray = new FlowPattern[5];
            SqlTokenType sqlTokenType = SqlTokens.SQL_ON;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_ON");
            Object[] objectArray2 = new SqlTokenType[]{SqlTokens.SQL_DUPLICATE, SqlTokens.SQL_KEY, SqlTokens.SQL_CONFLICT, SqlTokens.SQL_CONSTRAINT};
            objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])objectArray2), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_DO;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_DO");
            objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_UPDATE), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_UPDATE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_UPDATE");
            objectArray[2] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new EndExcElementContinuePattern(SetsKt.emptySet(), SetsKt.setOf((Object)SqlTokens.SQL_ON), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)));
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_SET;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_SET");
            objectArray[3] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType4), new EndExcElementContinuePattern(SetsKt.emptySet(), SetsKt.setOf((Object)SqlTokens.SQL_ON), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.4.INSTANCE)));
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SET_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SET_CLAUSE");
            objectArray[4] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OnSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "userElementsLineSetting", "", "userRequiresExpand", "", "whetherSectionToIndent", "preserveUserLineBreaks", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
    private static class OneLineSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        @Override
        protected boolean userRequiresExpand() {
            return false;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        protected boolean preserveUserLineBreaks() {
            return false;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return OneLineSection.decideSpacing$preserve(block1) ? super.decideSpacing(block1, block2) : (OneLineSection.decideSpacing$preserve(block2) ? super.decideSpacing(block1, block2) : this.getContext().makeSafeSpacing(false));
        }

        private static final boolean decideSpacing$preserve(SqlBlock b) {
            return b instanceof SqlCommentBlock || b instanceof SqlErrorNodeBlock || b instanceof SqlErrorNodeBlock;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "userWrapSetting", "userCommaSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1732:1\n248#2:1733\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection\n*L\n1262#1:1733\n*E\n"})
    private static final class OutputSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new FlowPattern[2];
            objectArray[0] = new SimplePattern((byte)0, (byte)1, NodeMatcherKt.matchAnyKeyword(), NodeMatcherKt.matchAnyKeyword(), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_COLUMN_REFERENCE");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ParenthesizedJoinTableExpression;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "openingBlock", "Lcom/intellij/sql/formatter/model/SqlSymbol;", "closingBlock", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "considerBlock", "", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "Companion", "intellij.database.sql.core.impl"})
    private static final class ParenthesizedJoinTableExpression
    extends SqlRangeBlock {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlSymbol openingBlock;
        @Nullable
        private SqlSymbol closingBlock;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    if (this.openingBlock != null || !(block instanceof SqlSymbol)) break;
                    this.openingBlock = (SqlSymbol)block;
                    break;
                }
                case 2: {
                    if (this.closingBlock != null || !(block instanceof SqlSymbol)) break;
                    this.closingBlock = (SqlSymbol)block;
                }
            }
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return Intrinsics.areEqual((Object)block1, (Object)this.openingBlock) || Intrinsics.areEqual((Object)block2, (Object)this.closingBlock) ? this.getContext().makeSpace(this.getContext().getSql().SUBQUERY_PAR_SPACE_INSIDE) : super.decideSpacing(block1, block2);
        }

        static {
            Object[] objectArray = new FlowPattern[6];
            Byte by = 0;
            Byte by2 = 1;
            SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[0] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by3 = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARENTHESIZED_JOIN_EXPRESSION");
            objectArray[1] = new SingletonExpandPattern(by3, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            Byte by4 = 1;
            SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_JOIN_EXPRESSION");
            objectArray[2] = new SingletonExpandPattern(by4, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType2), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            Byte by5 = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_TABLE_REFERENCE");
            objectArray[3] = new SingletonExpandPattern(by5, null, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            Byte by6 = 1;
            SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_JOIN_CONDITION_CLAUSE");
            objectArray[4] = new SingletonExpandPattern(by6, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            Byte by7 = 1;
            Byte by8 = 9;
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_RIGHT_PAREN");
            objectArray[5] = new SingletonPattern(by7, by8, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.SUFFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ParenthesizedJoinTableExpression$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.PREFIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.SUFFIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PredicateElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "<init>", "()V", "isEgyptian", "", "blockIsEgyptian", "b", "Lcom/intellij/sql/formatter/model/SqlBlock;", "intellij.database.sql.core.impl"})
    private static final class PredicateElement
    extends SqlRangeBlock
    implements SectionElement {
        @Override
        public boolean isEgyptian() {
            if (this.getContext().getSql().SUBQUERY_CONTENT != 2) {
                return false;
            }
            SqlBlock b1 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
            SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
            if (this.blockIsEgyptian(b1)) {
                return true;
            }
            return b1 != b2 && this.blockIsEgyptian(b2);
        }

        private final boolean blockIsEgyptian(SqlBlock b) {
            if (b == null) {
                return false;
            }
            return b instanceof SqlParenthesizedSubqueryBlock || b instanceof SqlBinaryExpressionBlock && (this.blockIsEgyptian(((SqlBinaryExpressionBlock)b).getFirstNestedSqlBlock()) || this.blockIsEgyptian(((SqlBinaryExpressionBlock)b).getLastNestedSqlBlock()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001dH\u0014J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u0015\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020!H\u0014J\b\u0010,\u001a\u00020\u0016H\u0014J\b\u0010-\u001a\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "<init>", "()V", "parentSection", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "getParentSection", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "countOfJoins", "", "getCountOfJoins", "()I", "setCountOfJoins", "(I)V", "joinAlign", "Lcom/intellij/formatting/Alignment;", "getJoinAlign", "()Lcom/intellij/formatting/Alignment;", "setJoinAlign", "(Lcom/intellij/formatting/Alignment;)V", "forceWrap1", "", "getForceWrap1", "()Z", "forceWrap2", "getForceWrap2", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "whetherToFlatten", "node", "produceNestedBlocks", "", "nodes", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureFormattingAttributes", "userRequiresExpand", "isEgyptian", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement\n+ 2 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1732:1\n433#2:1733\n433#2:1734\n248#3:1735\n1915#4,2:1736\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement\n*L\n1474#1:1733\n1477#1:1734\n1494#1:1735\n1527#1:1736,2\n*E\n"})
    private static final class PrimaryTableElement
    extends SqlNodeBlock
    implements SectionElement {
        private int countOfJoins;
        @Nullable
        private Alignment joinAlign;

        @NotNull
        public final FromSection getParentSection() {
            SqlBlock sqlBlock = this.getParent();
            Intrinsics.checkNotNull((Object)sqlBlock, (String)"null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlQueryBlock.FromSection");
            return (FromSection)sqlBlock;
        }

        public final int getCountOfJoins() {
            return this.countOfJoins;
        }

        public final void setCountOfJoins(int n) {
            this.countOfJoins = n;
        }

        @Nullable
        public final Alignment getJoinAlign() {
            return this.joinAlign;
        }

        public final void setJoinAlign(@Nullable Alignment alignment) {
            this.joinAlign = alignment;
        }

        public final boolean getForceWrap1() {
            return this.getContext().getSql().FROM_WRAP_JOIN_1 && this.countOfJoins >= 1;
        }

        public final boolean getForceWrap2() {
            return this.getContext().getSql().FROM_WRAP_JOIN_2 && this.countOfJoins >= 2;
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            IElementType iElementType = this.getBlockNode().getElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION) ? CollectionsKt.listOf((Object)this.getBlockNode()) : super.listTheChildren();
        }

        @Override
        protected boolean whetherToFlatten(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return node.getElementType() == SqlCompositeElementTypes.SQL_JOIN_EXPRESSION;
        }

        @Override
        protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            SqlFormatterHelper dialectHelper = this.getContext().getDialectHelper();
            int n = nodes.size();
            int p2 = 0;
            while (p2 < n) {
                int e;
                IntRange join;
                IntRange intRange = join = SqlFormattingModelFun.findConsequence(nodes, p2, (Function1<? super ASTNode, Boolean>)((Function1)arg_0 -> PrimaryTableElement.produceNestedBlocks$lambda$0(dialectHelper, arg_0)));
                int n2 = e = intRange != null ? intRange.getStart() : n;
                if (p2 < e) {
                    List<? extends ASTNode> subList = nodes.subList(p2, e);
                    SecondaryTableElement elementBlock = new SecondaryTableElement();
                    elementBlock.setup(this, subList);
                    elementBlock.setRole(BlockRole.ELEMENT);
                    this.addNestedBlock$intellij_database_sql_core_impl(elementBlock);
                }
                if (join == null) break;
                JoinPhrase joinBlock = new JoinPhrase();
                IntRange $this$finish$iv = join;
                boolean $i$f$getFinish = false;
                joinBlock.setup(this, nodes.subList(join.getFirst(), $this$finish$iv.getEndInclusive() + 1));
                joinBlock.setRole(BlockRole.DELIMITER);
                this.addNestedBlock$intellij_database_sql_core_impl(joinBlock);
                $this$finish$iv = join;
                $i$f$getFinish = false;
                p2 = $this$finish$iv.getEndInclusive() + 1;
            }
        }

        @Override
        public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            if (role == BlockRole.DELIMITER) {
                int n = this.countOfJoins;
                this.countOfJoins = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Indent defaultChildIndent(@NotNull SqlBlock block) {
            Indent indent;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block.getRole() == BlockRole.ELEMENT) {
                void what$iv;
                void $this$change$iv;
                int n = this.getContext().getSql().FROM_EL_LINE;
                int n2 = -1;
                int with$iv = this.getContext().getSql().QUERY_EL_LINE;
                boolean $i$f$change = false;
                if (($this$change$iv == what$iv ? with$iv : n) == 1) {
                    indent = SqlFormattingFunKt.getNONE_INDENT();
                    return indent;
                }
            }
            indent = super.defaultChildIndent(block);
            return indent;
        }

        @Override
        protected void configureFormattingAttributes() {
            if (this.countOfJoins == 0) {
                return;
            }
            SqlCodeStyleSettings s = this.getContext().getSql();
            Wrap w1 = null;
            Wrap w2 = null;
            if (this.getForceWrap1() == this.getForceWrap2()) {
                Wrap wrap = SqlFlowBlock.makeWrap$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap);
                w2 = w1 = wrap;
            } else {
                Wrap wrap = SqlFlowBlock.makeWrap$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap);
                w1 = wrap;
                Wrap wrap2 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap2() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap2);
                w2 = wrap2;
            }
            boolean unindentJoins = s.FROM_ONLY_JOIN_INDENT > -1 && this.getParentSection().getCountOfElements() == 1;
            Indent i = unindentJoins && s.FROM_ONLY_JOIN_INDENT == 1 ? SqlFormattingFunKt.getNORMAL_INDENT() : (unindentJoins && s.FROM_ONLY_JOIN_INDENT == 2 ? SqlFormattingFunKt.getNONE_INDENT() : (s.FROM_INDENT_JOIN ? Indent.getNormalIndent((boolean)true) : Indent.getSpaceIndent((int)0, (boolean)true)));
            this.joinAlign = s.QUERY_ALIGN_ELEMENTS && !unindentJoins ? SqlFormattingModelFun.makeLeftAlignment() : null;
            JBIterable<SqlBlock> joinWords = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            Iterator iterator = ((Iterable)joinWords).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                SqlBlock jw = (SqlBlock)iterator.next();
                if (index == 0) {
                    jw.setMyWrap(w1);
                }
                if (index >= 1) {
                    jw.setMyWrap(w2);
                }
                jw.setMyIndent(i);
                jw.setMyAlign(this.joinAlign);
            }
            if (s.FROM_ALIGN_JOIN_TABLES) {
                Alignment a2 = SqlFormattingModelFun.makeLeftAlignmentBS();
                JBIterable jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"skip(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it = (SqlBlock)element$iv;
                    boolean bl = false;
                    it.setMyAlign(a2);
                }
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            return this.getForceWrap1() || this.getForceWrap2();
        }

        @Override
        public boolean isEgyptian() {
            if (this.getContext().getSql().SUBQUERY_CONTENT != 2) {
                return false;
            }
            SqlBlock b1 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
            SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
            if (b1 instanceof SecondaryTableElement && ((SecondaryTableElement)b1).isEgyptian$intellij_database_sql_core_impl()) {
                return true;
            }
            return b2 instanceof SecondaryTableElement && ((SecondaryTableElement)b2).isEgyptian$intellij_database_sql_core_impl();
        }

        private static final boolean produceNestedBlocks$isJoinWord(SqlFormatterHelper dialectHelper, IElementType elementType) {
            return tableJoinWords.contains(elementType) || dialectHelper != null && dialectHelper.getSpecificTableJoinWords().contains(elementType);
        }

        private static final boolean produceNestedBlocks$lambda$0(SqlFormatterHelper $dialectHelper, ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            IElementType iElementType = it.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            return PrimaryTableElement.produceNestedBlocks$isJoinWord($dialectHelper, iElementType);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\tH&J\b\u0010\u001f\u001a\u00020\u001dH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\r\u00a8\u0006 "}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "thisQuery", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "getThisQuery$intellij_database_sql_core_impl", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "prefixSize", "", "getPrefixSize$intellij_database_sql_core_impl", "()I", "setPrefixSize$intellij_database_sql_core_impl", "(I)V", "prefixLength", "getPrefixLength$intellij_database_sql_core_impl", "setPrefixLength$intellij_database_sql_core_impl", "firstWord", "Lcom/intellij/psi/tree/IElementType;", "getFirstWord$intellij_database_sql_core_impl", "()Lcom/intellij/psi/tree/IElementType;", "setFirstWord$intellij_database_sql_core_impl", "(Lcom/intellij/psi/tree/IElementType;)V", "firstWordLength", "getFirstWordLength$intellij_database_sql_core_impl", "setFirstWordLength$intellij_database_sql_core_impl", "adjustNestedNodes", "", "whetherSectionToIndent", "", "userElementsLineSetting", "userRequiresExpand", "intellij.database.sql.core.impl"})
    public static abstract class QuerySection
    extends SqlRangeBlock {
        private int prefixSize;
        private int prefixLength;
        @Nullable
        private IElementType firstWord;
        private int firstWordLength;

        @NotNull
        public final SqlQueryBlock getThisQuery$intellij_database_sql_core_impl() {
            SqlQueryBlock sqlQueryBlock;
            SqlBlock p2 = this.getParent();
            if (p2 instanceof SqlQueryBlock) {
                sqlQueryBlock = (SqlQueryBlock)p2;
            } else if (p2 instanceof QuerySection) {
                sqlQueryBlock = ((QuerySection)p2).getThisQuery$intellij_database_sql_core_impl();
            } else {
                throw new IllegalStateException("The parent of QuerySection must be Query or QuerySection, but it is " + p2);
            }
            return sqlQueryBlock;
        }

        public final int getPrefixSize$intellij_database_sql_core_impl() {
            return this.prefixSize;
        }

        public final void setPrefixSize$intellij_database_sql_core_impl(int n) {
            this.prefixSize = n;
        }

        public final int getPrefixLength$intellij_database_sql_core_impl() {
            return this.prefixLength;
        }

        public final void setPrefixLength$intellij_database_sql_core_impl(int n) {
            this.prefixLength = n;
        }

        @Nullable
        public final IElementType getFirstWord$intellij_database_sql_core_impl() {
            return this.firstWord;
        }

        public final void setFirstWord$intellij_database_sql_core_impl(@Nullable IElementType iElementType) {
            this.firstWord = iElementType;
        }

        public final int getFirstWordLength$intellij_database_sql_core_impl() {
            return this.firstWordLength;
        }

        public final void setFirstWordLength$intellij_database_sql_core_impl(int n) {
            this.firstWordLength = n;
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            ASTNode firstNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if (firstNode != null) {
                this.firstWord = firstNode.getElementType();
                this.firstWordLength = firstNode.getTextLength();
            }
        }

        public boolean whetherSectionToIndent() {
            return false;
        }

        @Override
        public abstract int userElementsLineSetting();

        @Override
        protected boolean userRequiresExpand() {
            return (this.userElementsLineSetting() == 101 || this.userWrapSetting() == 1) && !this.getThisQuery$intellij_database_sql_core_impl().allowedToCollapse();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0014J\b\u0010\t\u001a\u00020\u0007H\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ReturningSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "<init>", "()V", "theIntoBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "considerBlock", "", "block", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "intellij.database.sql.core.impl"})
    private static final class ReturningSection
    extends OneLineSection {
        @Nullable
        private SqlBlock theIntoBlock;

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (SqlFormattingModelFun.primaryElementType(block) == SqlTokens.SQL_INTO && this.theIntoBlock == null) {
                this.theIntoBlock = block;
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block0: {
                super.configureFormattingAttributes();
                SqlBlock sqlBlock = this.theIntoBlock;
                if (sqlBlock == null) break block0;
                sqlBlock.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
            }
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return this.getContext().makeSafeSpacing(true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0005H\u0014J\b\u0010\u001b\u001a\u00020\u0011H\u0014J\b\u0010\u001c\u001a\u00020\u000bH\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0016J\r\u0010!\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\"R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "body", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getBody", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setBody", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "hasCondition", "", "getHasCondition", "()Z", "setHasCondition", "(Z)V", "adjustNestedNodes", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "considerBlock", "block", "configureFormattingAttributes", "userRequiresExpand", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "isEgyptian", "isEgyptian$intellij_database_sql_core_impl", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1732:1\n1915#2,2:1733\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement\n*L\n1605#1:1733,2\n*E\n"})
    private static final class SecondaryTableElement
    extends SqlRangeBlock {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlBlock body;
        private boolean hasCondition;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Nullable
        public final SqlBlock getBody() {
            return this.body;
        }

        public final void setBody(@Nullable SqlBlock sqlBlock) {
            this.body = sqlBlock;
        }

        public final boolean getHasCondition() {
            return this.hasCondition;
        }

        public final void setHasCondition(boolean bl) {
            this.hasCondition = bl;
        }

        @Override
        protected void adjustNestedNodes() {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)SecondaryTableElement::adjustNestedNodes$lambda$0));
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            BlockRole blockRole;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_AS)) {
                blockRole = BlockRole.AS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                blockRole = BlockRole.ALIAS2;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_USING_CLAUSE)) {
                blockRole = BlockRole.AMENDMENT;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_PERIOD)) {
                blockRole = BlockRole.NOTHING;
            } else {
                void var3_3;
                BlockRole r = super.determineRole(node);
                if (r == BlockRole.NOTHING || r == BlockRole.ELEMENT) {
                    r = BlockRole.BODY;
                }
                blockRole = var3_3;
            }
            return blockRole;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    this.body = block;
                    break;
                }
                case 2: {
                    this.hasCondition = true;
                }
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            SqlCodeStyleSettings s = this.getContext().getSql();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.AMENDMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                SqlBlock it = (SqlBlock)element$iv;
                boolean bl = false;
                it.setMyWrap(SqlFlowBlock.makeWrap$default(this, s.FROM_WRAP_ON ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null));
                it.setMyIndent(switch (s.FROM_PLACE_ON) {
                    case 10 -> {
                        if (s.FROM_ONLY_JOIN_INDENT == 1) {
                            yield SqlFormattingFunKt.getNORMAL_INDENT();
                        }
                        yield SqlFormattingFunKt.getNONE_INDENT();
                    }
                    case 11 -> {
                        if (s.FROM_ONLY_JOIN_INDENT == 1) {
                            yield SqlFormattingFunKt.getNORMAL_INDENT();
                        }
                        yield SqlFormattingFunKt.getNONE_INDENT();
                    }
                    case 12 -> {
                        if (s.FROM_ONLY_JOIN_INDENT == 1) {
                            yield SqlFormattingFunKt.getNORMAL_INDENT();
                        }
                        yield SqlFormattingFunKt.getNONE_INDENT();
                    }
                    case 20 -> Indent.getSpaceIndent((int)0, (boolean)true);
                    case 21 -> Indent.getNormalIndent((boolean)true);
                    default -> this.getMyIndent();
                });
                if (s.FROM_PLACE_ON == 10) {
                    SqlBlock sqlBlock = this.getParent();
                    PrimaryTableElement primaryTableElement = sqlBlock instanceof PrimaryTableElement ? (PrimaryTableElement)sqlBlock : null;
                    object = primaryTableElement != null ? primaryTableElement.getJoinAlign() : null;
                } else {
                    object = null;
                }
                it.setMyAlign((Alignment)object);
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            return this.hasCondition && this.getContext().getSql().FROM_WRAP_ON;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            return (r1 == BlockRole.BODY || r1 == BlockRole.AS) && r2 == BlockRole.ALIAS2 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing(block1, block2);
        }

        public final boolean isEgyptian$intellij_database_sql_core_impl() {
            return this.body instanceof SqlParenthesizedSubqueryBlock && this.getContext().getSql().SUBQUERY_CONTENT == 2;
        }

        private static final boolean adjustNestedNodes$lambda$0(ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            IElementType iElementType = it.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType elementType = iElementType;
            return elementType == SqlCompositeElementTypes.SQL_AS_EXPRESSION || elementType == SqlCompositeElementTypes.SQL_TABLE_PROCEDURE_CALL_EXPRESSION;
        }

        static {
            Object[] objectArray = new FlowPattern[6];
            SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LATERAL;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LATERAL");
            NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_FUNCTION_CALL;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_FUNCTION_CALL");
            objectArray[1] = new SimplePattern(null, null, nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), true, BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            objectArray[2] = new StartStopPattern(null, null, NodeMatcherKt.matchTypeName("BQ_DELIMITED_TOKEN_START"), NodeMatcherKt.matchTypeName("BQ_DELIMITED_TOKEN_END"), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE, (String)"SQL_JOIN_CONDITION_CLAUSE");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_USING_CLAUSE, (String)"SQL_USING_CLAUSE");
            objectArray[3] = new SingletonPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_PARENTHESIZED_JOIN_EXPRESSION");
            objectArray[4] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType2, "empty", (Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>((Object)Companion){

                public final Boolean invoke(ASTNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Companion.access$emptyPar((Companion)this.receiver, p0);
                }
            })), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_PARENTHESIZED_JOIN_EXPRESSION");
            objectArray[5] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType3, "not empty", (Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>((Object)Companion){

                public final Boolean invoke(ASTNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Companion.access$notEmptyPar((Companion)this.receiver, p0);
                }
            })), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.8.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "emptyPar", "", "node", "Lcom/intellij/lang/ASTNode;", "notEmptyPar", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private final boolean emptyPar(ASTNode node) {
                for (ASTNode c = node.getFirstChildNode(); c != null; c = c.getTreeNext()) {
                    IElementType t;
                    boolean nothing;
                    Intrinsics.checkNotNullExpressionValue((Object)c.getElementType(), (String)"getElementType(...)");
                    boolean bl = nothing = t == SqlTokens.SQL_LEFT_PAREN || t == SqlTokens.SQL_RIGHT_PAREN || SqlTokens.WS_OR_COMMENTS.contains(t) || c instanceof PsiErrorElement;
                    if (nothing) continue;
                    return false;
                }
                return true;
            }

            private final boolean notEmptyPar(ASTNode node) {
                return !this.emptyPar(node);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            public static final /* synthetic */ boolean access$emptyPar(Companion $this, ASTNode node) {
                return $this.emptyPar(node);
            }

            public static final /* synthetic */ boolean access$notEmptyPar(Companion $this, ASTNode node) {
                return $this.notEmptyPar(node);
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.BODY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.AMENDMENT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "", "isEgyptian", "", "intellij.database.sql.core.impl"})
    private static interface SectionElement {
        default public boolean isEgyptian() {
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0014J\u0015\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\fH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "<init>", "()V", "essence", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getEssence$intellij_database_sql_core_impl", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setEssence$intellij_database_sql_core_impl", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "isAsterisk", "", "isAsterisk$intellij_database_sql_core_impl", "()Z", "setAsterisk$intellij_database_sql_core_impl", "(Z)V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "considerBlock", "", "block", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "isEgyptian", "getDebugNameSuffix", "", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n*L\n1#1,1732:1\n831#2,2:1733\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement\n*L\n1395#1:1733,2\n*E\n"})
    private static final class SelectElement
    extends SqlRangeBlock
    implements SectionElement {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlBlock essence;
        private boolean isAsterisk;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Nullable
        public final SqlBlock getEssence$intellij_database_sql_core_impl() {
            return this.essence;
        }

        public final void setEssence$intellij_database_sql_core_impl(@Nullable SqlBlock sqlBlock) {
            this.essence = sqlBlock;
        }

        public final boolean isAsterisk$intellij_database_sql_core_impl() {
            return this.isAsterisk;
        }

        public final void setAsterisk$intellij_database_sql_core_impl(boolean bl) {
            this.isAsterisk = bl;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SqlBlock makeBlock(@NotNull ASTNode node) {
            SqlBlock sqlBlock;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof SqlExpression) {
                void parent$iv;
                void $this$withSetup$iv;
                SqlNodeBlock sqlNodeBlock = new SelectElementEssence();
                SqlBlock sqlBlock2 = this;
                ASTNode mainNode$iv = node;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl((SqlBlock)parent$iv, mainNode$iv);
                sqlBlock = SqlBlockKt.withRole((SqlBlock)sqlNodeBlock, BlockRole.BODY);
            } else {
                sqlBlock = super.makeBlock(node);
            }
            return sqlBlock;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            SqlBlock sqlBlock = block;
            if (sqlBlock instanceof SelectElementEssence) {
                this.essence = block;
                this.isAsterisk = this.isAsterisk || ((SelectElementEssence)block).isAsterisk$intellij_database_sql_core_impl();
            } else if (sqlBlock instanceof SqlAliasBlock) {
                block.setRole(this.essence == null ? BlockRole.ALIAS1 : BlockRole.ALIAS2);
            }
        }

        @Override
        public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                SqlFlowBlock sqlFlowBlock = sqlBlock instanceof SqlFlowBlock ? (SqlFlowBlock)sqlBlock : null;
                if (sqlFlowBlock == null) break block0;
                sqlFlowBlock.countRole$intellij_database_sql_core_impl(role);
            }
        }

        @Override
        public boolean isEgyptian() {
            SqlBlock sqlBlock = this.essence;
            IElementType t = sqlBlock != null ? SqlFormattingModelFun.primaryElementType(sqlBlock) : null;
            return Intrinsics.areEqual((Object)t, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) && this.getContext().getSql().SUBQUERY_CONTENT == 2;
        }

        @Override
        @Nullable
        protected String getDebugNameSuffix() {
            return this.isAsterisk ? "*" : null;
        }

        static {
            Object[] objectArray = new SingletonPattern[6];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_IDENTIFIER");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlTokens.SQL_OP_EQ;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_OP_EQ");
            objectArray[1] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.EQ, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_AS");
            objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_COLUMN_REFERENCE");
            objectArray[3] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            SqlReferenceElementType sqlReferenceElementType2 = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType2, (String)"SQL_COLUMN_SHORT_REFERENCE");
            objectArray[4] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType2), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
            objectArray[5] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElementEssence;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "isAsterisk", "", "isAsterisk$intellij_database_sql_core_impl", "()Z", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.core.impl"})
    private static final class SelectElementEssence
    extends SqlNodeBlock {
        public final boolean isAsterisk$intellij_database_sql_core_impl() {
            char[] cArray = new char[]{'*'};
            return SqlUtilFun.isSymbol(this.getBlockNode(), cArray);
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            return this.isAsterisk$intellij_database_sql_core_impl() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.getBlockNode());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectModifier;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "intellij.database.sql.core.impl"})
    private static final class SelectModifier
    extends SqlNodeBlock {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0005H\u0014J\b\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u000e\u001a\u00020\u0005H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\r\u0010\u0019\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "firstIsAsterisk", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "produceNestedBlocks", "", "determineWrapFirstElement", "keepFirstAsteriskInline", "patchFormattingAttributesForChildren", "userRequiresExpand", "userNumberOfElementsToKeepCollapsed", "", "userElementsLineSetting", "userWrapSetting", "userCommaSetting", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "canBeSelectSectionOnly", "canBeSelectSectionOnly$intellij_database_sql_core_impl", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 NodeMatcher.kt\ncom/intellij/sql/formatter/model/NodeMatcherKt\n*L\n1#1,1732:1\n1915#2,2:1733\n248#3:1735\n38#4:1736\n38#4:1737\n38#4:1738\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection\n*L\n1017#1:1733,2\n1056#1:1735\n982#1:1736\n985#1:1737\n986#1:1738\n*E\n"})
    private static final class SelectSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private boolean firstIsAsterisk;
        @NotNull
        private static final List<TypePattern> patterns1phrases;
        @NotNull
        private static final List<TypePattern> patterns2phrases;
        @NotNull
        private static final List<FlowPattern> commonPatterns;
        @NotNull
        private static final List<FlowPattern> patterns1;
        @NotNull
        private static final List<FlowPattern> patterns2;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return this.userElementsLineSetting() == 101 || !this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT ? patterns1 : patterns2;
        }

        @Override
        protected void produceNestedBlocks() {
            super.produceNestedBlocks();
            SqlBlock b1e = (SqlBlock)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).first();
            if (b1e instanceof SelectElement) {
                ((SelectElement)b1e).grow();
                this.firstIsAsterisk = ((SelectElement)b1e).isAsterisk$intellij_database_sql_core_impl();
            }
        }

        @Override
        protected boolean determineWrapFirstElement() {
            return !this.keepFirstAsteriskInline() && super.determineWrapFirstElement();
        }

        private final boolean keepFirstAsteriskInline() {
            return this.firstIsAsterisk && !this.getContext().getSql().SELECT_ASTERISK_REGULAR;
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            SqlCodeStyleSettings s = this.getContext().getSql();
            if (s.SELECT_ALIGN_AS && s.SELECT_EL_WRAP != 3) {
                boolean hasAliases1 = false;
                boolean hasAliases2 = false;
                JBIterable jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).filter(SqlFlowBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlFlowBlock it = (SqlFlowBlock)element$iv;
                    boolean bl = false;
                    hasAliases1 = hasAliases1 || SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)it.getNestedBlocks(), BlockRole.ALIAS1).isNotEmpty();
                    hasAliases2 = hasAliases2 || SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)it.getNestedBlocks(), BlockRole.ALIAS2).isNotEmpty();
                }
                if (hasAliases1) {
                    if (!s.QUERY_ALIGN_ELEMENTS) {
                        this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS1);
                    }
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
                }
                if (hasAliases1 && hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.BODY);
                }
                if (hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS2);
                }
                for (SqlBlock b : this.getNestedBlocks()) {
                    SqlBlock inn;
                    if (b.getMyAlign() == null || b.isLeaf() || b.getFirstNestedSqlBlock() == null || inn.getMyAlign() == null) continue;
                    b.setMyAlign(null);
                }
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_core_impl().allowedToCollapse() && this.getMinLength() < this.getContext().getLengthThresholdMin()) {
                return false;
            }
            return this.getContext().getSql().SELECT_EL_WRAP == 1 && this.getCountOfElements() > this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            return Math.max(this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE, this.userElementsLineSetting() == 101 ? SqlUtilFun.toInt(this.firstIsAsterisk) : 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SELECT_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SELECT_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SELECT_EL_COMMA;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return block1 instanceof SelectSeparatedPrefix ? (this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT && this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null)) : (block2.getRole() == BlockRole.AMENDMENT ? this.getContext().makeSafeSpaceOrBreak() : super.decideSpacing(block1, block2));
        }

        public final boolean canBeSelectSectionOnly$intellij_database_sql_core_impl() {
            return true;
        }

        static {
            Byte by = 0;
            Byte by2 = 1;
            Object[] objectArray = new IElementType[3];
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_SELECT, (String)"SQL_SELECT");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_SELECT_OPTION, (String)"SQL_SELECT_OPTION");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_TOP_CLAUSE, (String)"SQL_TOP_CLAUSE");
            patterns1phrases = CollectionsKt.listOf((Object)new TypePattern(by, by2, NodeMatcherKt.matchType((IElementType[])objectArray), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1phrases.1.INSTANCE)));
            objectArray = new TypePattern[2];
            Byte by3 = 0;
            Byte by4 = 1;
            SqlTokenType sqlTokenType = SqlTokens.SQL_SELECT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_SELECT");
            objectArray[0] = new TypePattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2phrases.1.INSTANCE));
            Byte by5 = 1;
            Byte by6 = 1;
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_SELECT_OPTION, (String)"SQL_SELECT_OPTION");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_TOP_CLAUSE, (String)"SQL_TOP_CLAUSE");
            objectArray[1] = new TypePattern(by5, by6, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2phrases.2.INSTANCE));
            patterns2phrases = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new FlowPattern[7];
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LINE_COMMENT");
            objectArray[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
            Byte by7 = 1;
            Byte by8 = 2;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_AS_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_AS_EXPRESSION");
            objectArray[1] = new SingletonExpandPattern(by7, by8, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
            boolean $i$f$matchElementClass = false;
            objectArray[2] = new SingletonPattern((byte)1, (byte)2, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
            Byte by9 = 2;
            Byte by10 = 1;
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
            objectArray[3] = new SingletonPattern(by9, by10, NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
            Byte by11 = 1;
            Byte by12 = 1;
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_COMMA");
            objectArray[4] = new SingletonPattern(by11, by12, NodeMatcherKt.matchType((IElementType)sqlTokenType4), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.5.INSTANCE));
            $i$f$matchElementClass = false;
            objectArray[5] = new SingletonPattern((byte)2, (byte)3, NodeMatcherKt.matchElementClass(SqlSelectModifierClause.class), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.6.INSTANCE));
            $i$f$matchElementClass = false;
            objectArray[6] = new SingletonPattern((byte)3, (byte)3, NodeMatcherKt.matchElementClass(SqlSelectModifierClause.class), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.7.INSTANCE));
            commonPatterns = CollectionsKt.listOf((Object[])objectArray);
            patterns1 = CollectionsKt.plus((Collection)patterns1phrases, (Iterable)commonPatterns);
            patterns2 = CollectionsKt.plus((Collection)patterns2phrases, (Iterable)commonPatterns);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection$Companion;", "", "<init>", "()V", "patterns1phrases", "", "Lcom/intellij/sql/formatter/model/TypePattern;", "getPatterns1phrases", "()Ljava/util/List;", "patterns2phrases", "getPatterns2phrases", "commonPatterns", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getCommonPatterns", "patterns1", "getPatterns1", "patterns2", "getPatterns2", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<TypePattern> getPatterns1phrases() {
                return patterns1phrases;
            }

            @NotNull
            public final List<TypePattern> getPatterns2phrases() {
                return patterns2phrases;
            }

            @NotNull
            public final List<FlowPattern> getCommonPatterns() {
                return commonPatterns;
            }

            @NotNull
            public final List<FlowPattern> getPatterns1() {
                return patterns1;
            }

            @NotNull
            public final List<FlowPattern> getPatterns2() {
                return patterns2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSeparatedPrefix;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
    private static final class SelectSeparatedPrefix
    extends SqlRangeBlock {
        @Override
        @NotNull
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return this.getContext().makeSafeSpacing(false);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetAssignment;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "intellij.database.sql.core.impl"})
    private static final class SetAssignment
    extends SqlNodeBlock {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "patchFormattingAttributesForChildren", "", "userElementsLineSetting", "", "userWrapSetting", "userCommaSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SetSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1732:1\n248#2:1733\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SetSection\n*L\n908#1:1733\n*E\n"})
    private static final class SetSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Set<SqlTokenType> additionalPrefixWords;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().SET_ALIGN_EQUAL_SIGN) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Object[] objectArray = new SqlTokenType[]{SqlTokens.SQL_ON, SqlTokens.SQL_DUPLICATE, SqlTokens.SQL_KEY, SqlTokens.SQL_UPDATE};
            additionalPrefixWords = SetsKt.setOf((Object[])objectArray);
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            objectArray = new FlowPattern[2];
            Object[] objectArray2 = new NodeMatcher[]{NodeMatcherKt.matchAnyKeyword(), NodeMatcherKt.matchType(additionalPrefixWords)};
            objectArray[0] = new RowPattern((byte)0, (byte)1, CollectionsKt.listOf((Object[])objectArray2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SET_ASSIGNMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SET_ASSIGNMENT");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection$Companion;", "", "<init>", "()V", "additionalPrefixWords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0014J\b\u0010\u0012\u001a\u00020\nH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedListBlock;", "<init>", "()V", "fields", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getFields", "()Lcom/intellij/util/containers/JBIterable;", "countOfFields", "", "getCountOfFields", "()I", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "userOpeningSetting", "userContentSetting", "userClosingSetting", "userWrapSetting", "userDelimiterSetting", "userSpaceWithinParentheses", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1732:1\n249#2:1733\n248#2:1734\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock\n*L\n829#1:1733\n835#1:1734\n*E\n"})
    public static final class SqlCortegeLikeParenthesizedListBlock
    extends SqlParenthesizedListBlock {
        @NotNull
        public final JBIterable<SqlBlock> getFields() {
            return SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
        }

        public final int getCountOfFields() {
            return this.getCountOfElements$intellij_database_sql_core_impl();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            void what$iv;
            void $this$change$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            BlockRole blockRole = super.determineRole(node);
            BlockRole blockRole2 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            boolean $i$f$change = false;
            return Intrinsics.areEqual((Object)$this$change$iv, (Object)what$iv) ? with$iv : blockRole;
        }

        @Override
        protected int userOpeningSetting() {
            return this.getContext().getSql().INSERT_OPENING;
        }

        @Override
        protected int userContentSetting() {
            return this.getContext().getSql().INSERT_CONTENT;
        }

        @Override
        protected int userClosingSetting() {
            return this.getContext().getSql().INSERT_CLOSING;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().INSERT_EL_WRAP;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userDelimiterSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_EL_COMMA;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_COMMA;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public boolean userSpaceWithinParentheses() {
            return this.getContext().getSql().INSERT_SPACE_WITHIN_PARENTHESES;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return block2.getRole() == BlockRole.ELEMENT && block1.getRole() == BlockRole.DELIMITER && this.getContext().getSql().INSERT_MATRIX_ALIGN ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing(block1, block2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnionSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "userElementsLineSetting", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
    private static final class UnionSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        @NotNull
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnknownSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "userElementsLineSetting", "", "whetherSectionToIndent", "", "intellij.database.sql.core.impl"})
    private static final class UnknownSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UpdateSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "userElementsLineSetting", "", "intellij.database.sql.core.impl"})
    private static final class UpdateSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "rows", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "getRows$intellij_database_sql_core_impl", "()Lcom/intellij/util/containers/JBIterable;", "countOfRows", "", "getCountOfRows$intellij_database_sql_core_impl", "()I", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "whetherSectionToIndent", "", "userNumberOfElementsToKeepCollapsed", "userElementsLineSetting", "userWrapSetting", "userCommaSetting", "tailFormed", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection\n+ 2 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1732:1\n468#2,3:1733\n248#3:1736\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection\n*L\n785#1:1733,3\n798#1:1736\n*E\n"})
    public static final class ValuesSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @NotNull
        public final JBIterable<SqlCortegeLikeParenthesizedListBlock> getRows$intellij_database_sql_core_impl() {
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable jBIterable2 = jBIterable.filter(SqlCortegeLikeParenthesizedListBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            return jBIterable2;
        }

        public final int getCountOfRows$intellij_database_sql_core_impl() {
            return this.getCountOfElements();
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            return this.getContext().getSql().INSERT_COLLAPSE_MULTI_ROW_VALUES ? (this.getContext().getLengthThresholdMax() - 7) / 4 : 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_VALUES_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getCountOfElements() <= this.userNumberOfElementsToKeepCollapsed() ? 2 : 1;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().INSERT_CLOSING >= 3 && this.getContext().getSql().INSERT_OPENING == 1 ? 4 : this.getContext().getSql().INSERT_EL_COMMA;
        }

        @Override
        public boolean tailFormed() {
            SqlBlock sqlBlock = this.getLastNestedSqlBlock();
            if (sqlBlock == null) {
                return false;
            }
            SqlBlock last = sqlBlock;
            return switch (WhenMappings.$EnumSwitchMapping$0[last.getRole().ordinal()]) {
                case 1, 2, 3 -> false;
                default -> true;
            };
        }

        static {
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARENTHESIZED_EXPRESSION");
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new SingletonExpandPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.DELIMITER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.PREFIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0014R\u001a\u0010\t\u001a\u00020\nX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "whetherSectionToIndent", "", "delimiterType", "Lcom/intellij/sql/psi/SqlTokenType;", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "setDelimiterType", "(Lcom/intellij/sql/psi/SqlTokenType;)V", "delimiterLength", "", "getDelimiterLength", "()I", "adjustNestedNodes", "", "determinePrimaryDelimiter", "userElementsLineSetting", "userWrapSetting", "userCommaSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 NodeMatcher.kt\ncom/intellij/sql/formatter/model/NodeMatcherKt\n*L\n1#1,1732:1\n1#2:1733\n248#3:1734\n38#4:1735\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection\n*L\n1174#1:1734\n1144#1:1735\n*E\n"})
    private static final class WhereSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private SqlTokenType delimiterType;
        @NotNull
        private static final List<FlowPattern> patterns;

        public WhereSection() {
            SqlTokenType sqlTokenType = SqlTokens.SQL_NO;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_NO");
            this.delimiterType = sqlTokenType;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        @NotNull
        protected SqlTokenType getDelimiterType() {
            return this.delimiterType;
        }

        protected void setDelimiterType(@NotNull SqlTokenType sqlTokenType) {
            Intrinsics.checkNotNullParameter((Object)sqlTokenType, (String)"<set-?>");
            this.delimiterType = sqlTokenType;
        }

        @Override
        protected int getDelimiterLength() {
            SqlTokenType sqlTokenType = this.getDelimiterType();
            return Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlTokens.SQL_OR) ? 2 : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlTokens.SQL_AND) ? 3 : 1);
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            this.determinePrimaryDelimiter();
            if (this.getDelimiterType() != SqlTokens.SQL_NO) {
                this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)arg_0 -> WhereSection.adjustNestedNodes$lambda$0(this, arg_0)));
            }
        }

        private final void determinePrimaryDelimiter() {
            Object v0;
            block3: {
                Iterable iterable = this.getNestedNodes();
                for (Object t : iterable) {
                    ASTNode it = (ASTNode)t;
                    boolean bl = false;
                    if (!SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(it.getElementType())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ASTNode aSTNode = v0;
            if (aSTNode == null) {
                return;
            }
            ASTNode conditionNode = aSTNode;
            for (ASTNode child : SqlUtilFun.children(conditionNode)) {
                IElementType type;
                Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"getElementType(...)");
                if (type != SqlTokens.SQL_OR && type != SqlTokens.SQL_AND) continue;
                this.setDelimiterType((SqlTokenType)type);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().WHERE_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WHERE_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WHERE_EL_BOUND;
        }

        private static final boolean adjustNestedNodes$lambda$0(WhereSection this$0, ASTNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(it.getElementType()) && SqlUtilFun.hasChildNode(it, (IElementType)this$0.getDelimiterType());
        }

        static {
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new SingletonPattern[2];
            boolean $i$f$matchElementClass = false;
            objectArray[0] = new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_OR, (String)"SQL_OR");
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_AND, (String)"SQL_AND");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u00012\u00020\u0002:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowEntry;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.core.impl"})
    private static final class WindowEntry
    extends SqlNodeBlock
    implements SectionElement {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        static {
            Object[] objectArray = new FlowPattern[4];
            Byte by = 0;
            Byte by2 = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_WINDOW_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_WINDOW_REFERENCE");
            objectArray[0] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by3 = 1;
            Byte by4 = 2;
            SqlTokenType sqlTokenType = SqlTokens.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
            objectArray[1] = new SingletonPattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            Byte by5 = 2;
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
            NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_RIGHT_PAREN");
            objectArray[2] = new StartStopPattern(by5, null, nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            Byte by6 = 2;
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_LEFT_PAREN");
            objectArray[3] = new UntilPattern(by6, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), true, BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowEntry$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "userDelimiterSetting", "configureFormattingAttributes", "", "Companion", "intellij.database.sql.core.impl"})
    private static final class WindowSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public int userElementsLineSetting() {
            return -1;
        }

        @Override
        public int userDelimiterSetting() {
            return 0;
        }

        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            this.getNestedBlocks();
        }

        static {
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_GENERIC_DEFINITION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_GENERIC_DEFINITION");
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "analyseOriginalCodeStyle", "", "patchFormattingAttributesForChildren", "userElementsLineSetting", "", "userWrapSetting", "userCommaSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WithSection\n+ 2 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1732:1\n468#2,3:1733\n468#2,3:1736\n248#3:1739\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WithSection\n*L\n947#1:1733,3\n948#1:1736,3\n961#1:1739\n*E\n"})
    private static final class WithSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void analyseOriginalCodeStyle() {
            super.analyseOriginalCodeStyle();
            if (this.getCountOfElements() >= 2 && this.getContext().getSql().WITH_EL_WRAP == 1) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            boolean toAlignClosingParen;
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().WITH_ALIGN_AS) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
            }
            SqlCodeStyleSettings s = this.getContext().getSql();
            boolean toAlignInnerQueries = s.SUBQUERY_CONTENT >= 2;
            boolean bl = toAlignClosingParen = s.SUBQUERY_CLOSING >= 2;
            if (this.getCountOfElements() >= 2 && (toAlignInnerQueries || toAlignClosingParen) && s.QUERY_ALIGN_ELEMENTS) {
                Alignment closingParenAlignment;
                Alignment innerQueriesAlignment = toAlignInnerQueries ? SqlFormattingModelFun.makeLeftAlignment() : null;
                Object object = closingParenAlignment = toAlignClosingParen ? SqlFormattingModelFun.makeLeftAlignment() : null;
                if (toAlignInnerQueries && toAlignClosingParen && s.SUBQUERY_CLOSING == 6) {
                    closingParenAlignment = innerQueriesAlignment;
                }
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterable $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(CTE.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                for (CTE cte : jBIterable2) {
                    Iterable $this$filter$iv2 = cte.getNestedBlocks();
                    boolean $i$f$filter2 = false;
                    Iterable $this$jbi$iv$iv2 = $this$filter$iv2;
                    boolean $i$f$getJbi2 = false;
                    JBIterable jBIterable3 = JBIterable.from((Iterable)$this$jbi$iv$iv2);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"from(...)");
                    JBIterable jBIterable4 = jBIterable3.filter(SqlParenthesizedSubqueryBlock.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
                    for (SqlParenthesizedSubqueryBlock pb : jBIterable4) {
                        for (SqlBlock b : pb.getNestedBlocks()) {
                            switch (WhenMappings.$EnumSwitchMapping$0[b.getRole().ordinal()]) {
                                case 1: {
                                    b.setMyAlign(innerQueriesAlignment);
                                    break;
                                }
                                case 2: {
                                    b.setMyAlign(closingParenAlignment);
                                }
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().WITH_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WITH_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WITH_EL_COMMA;
        }

        static {
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_NAMED_QUERY_DEFINITION");
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.BODY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.SUFFIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 H$J\b\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005H\u0014J\b\u0010'\u001a\u00020\u000bH\u0015J\b\u00101\u001a\u00020%H\u0014J\b\u00102\u001a\u00020%H\u0014J\b\u00103\u001a\u00020%H\u0014J\b\u00104\u001a\u00020#H\u0014J\b\u00105\u001a\u00020#H\u0014J\b\u00106\u001a\u00020\u000bH\u0016J\b\u00107\u001a\u00020#H\u0014J\u001a\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0005H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020#H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR$\u0010(\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b)\u0010\u0003\u001a\u0004\b*\u0010\r\"\u0004\b+\u0010\u000fR\u0014\u0010,\u001a\u00020#8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020#8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.\u00a8\u0006F"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "<init>", "()V", "prefix", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getPrefix", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setPrefix", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "countOfElements", "", "getCountOfElements", "()I", "setCountOfElements", "(I)V", "countOfDelimiters", "getCountOfDelimiters", "setCountOfDelimiters", "countOfLineComments", "getCountOfLineComments", "setCountOfLineComments", "countOfAmendments", "getCountOfAmendments", "setCountOfAmendments", "delimiterType", "Lcom/intellij/sql/psi/SqlTokenType;", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "delimiterLength", "getDelimiterLength", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "flowToProduceCommentsFlowBlocks", "", "considerBlock", "", "block", "userCommaSetting", "commaPlace", "getCommaPlace$annotations", "getCommaPlace", "setCommaPlace", "comma1st", "getComma1st", "()Z", "commaLast", "getCommaLast", "analyseOriginalCodeStyle", "configureFormattingAttributes", "patchFormattingAttributesForChildren", "determineWrapFirstElement", "toAlignElements", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "getChildAttributesForNewElementAtTheEnd", "Lcom/intellij/formatting/ChildAttributes;", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "computeElementIndent", "offset", "trueIndent", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n*L\n1#1,1732:1\n1#2:1733\n1915#3,2:1734\n1915#3,2:1736\n1915#3,2:1738\n1915#3,2:1740\n1915#3,2:1742\n1915#3,2:1744\n1915#3,2:1746\n1915#3,2:1748\n1915#3,2:1753\n1915#3,2:1755\n1915#3,2:1760\n468#4,3:1750\n468#4,3:1757\n474#4:1762\n474#4:1763\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection\n*L\n537#1:1734,2\n540#1:1736,2\n541#1:1738,2\n549#1:1740,2\n555#1:1742,2\n558#1:1744,2\n579#1:1746,2\n592#1:1748,2\n593#1:1753,2\n597#1:1755,2\n610#1:1760,2\n593#1:1750,3\n608#1:1757,3\n682#1:1762\n683#1:1763\n*E\n"})
    public static abstract class WordAndListSection
    extends QuerySection {
        @NotNull
        protected static final Companion Companion = new Companion(null);
        @Nullable
        private SqlBlock prefix;
        private int countOfElements;
        private int countOfDelimiters;
        private int countOfLineComments;
        private int countOfAmendments;
        private int commaPlace;
        @NotNull
        private static final List<FlowPattern> commonPatterns;

        @Nullable
        public final SqlBlock getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(@Nullable SqlBlock sqlBlock) {
            this.prefix = sqlBlock;
        }

        public final int getCountOfElements() {
            return this.countOfElements;
        }

        public final void setCountOfElements(int n) {
            this.countOfElements = n;
        }

        public final int getCountOfDelimiters() {
            return this.countOfDelimiters;
        }

        public final void setCountOfDelimiters(int n) {
            this.countOfDelimiters = n;
        }

        public final int getCountOfLineComments() {
            return this.countOfLineComments;
        }

        public final void setCountOfLineComments(int n) {
            this.countOfLineComments = n;
        }

        public final int getCountOfAmendments() {
            return this.countOfAmendments;
        }

        public final void setCountOfAmendments(int n) {
            this.countOfAmendments = n;
        }

        @NotNull
        protected SqlTokenType getDelimiterType() {
            SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_COMMA");
            return sqlTokenType;
        }

        protected int getDelimiterLength() {
            return 1;
        }

        @Override
        @Nullable
        protected abstract List<FlowPattern> flowPatterns();

        @Override
        protected boolean flowToProduceCommentsFlowBlocks() {
            return false;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    this.prefix = block;
                    break;
                }
                case 2: {
                    int n = this.countOfElements;
                    this.countOfElements = n + 1;
                    break;
                }
                case 3: {
                    int n = this.countOfDelimiters;
                    this.countOfDelimiters = n + 1;
                    break;
                }
                case 4: {
                    int n = this.countOfLineComments;
                    this.countOfLineComments = n + 1;
                    break;
                }
                case 5: {
                    int n = this.countOfAmendments;
                    this.countOfAmendments = n + 1;
                }
            }
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected int userCommaSetting() {
            return 0;
        }

        protected final int getCommaPlace() {
            return this.commaPlace;
        }

        protected final void setCommaPlace(int n) {
            this.commaPlace = n;
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected static /* synthetic */ void getCommaPlace$annotations() {
        }

        protected boolean getComma1st() {
            return this.commaPlace == 1;
        }

        protected boolean getCommaLast() {
            return this.commaPlace == 2;
        }

        @Override
        protected void analyseOriginalCodeStyle() {
            super.analyseOriginalCodeStyle();
            SqlBlock p2 = this.prefix;
            if (p2 != null) {
                p2.analyze();
                this.setPrefixLength$intellij_database_sql_core_impl(p2.getMinLength());
                if (p2 instanceof SqlSingleNodeBlock) {
                    this.setPrefixSize$intellij_database_sql_core_impl(1);
                    this.setFirstWord$intellij_database_sql_core_impl(SqlFormattingModelFun.primaryElementType(p2));
                    this.setFirstWordLength$intellij_database_sql_core_impl(this.getPrefixLength$intellij_database_sql_core_impl());
                } else {
                    SqlBlock firstWordBlock;
                    List<SqlBlock> pBlocks = p2.getNestedBlocks();
                    this.setPrefixSize$intellij_database_sql_core_impl(pBlocks.size());
                    SqlBlock sqlBlock = firstWordBlock = (SqlBlock)CollectionsKt.firstOrNull(pBlocks);
                    this.setFirstWord$intellij_database_sql_core_impl((IElementType)(sqlBlock != null ? SqlFormattingModelFun.primaryElementType(sqlBlock) : null));
                    SqlBlock sqlBlock2 = firstWordBlock;
                    this.setFirstWordLength$intellij_database_sql_core_impl(sqlBlock2 != null ? sqlBlock2.getRange().getLength() : 0);
                }
            }
            if (this.countOfDelimiters > 0) {
                this.commaPlace = this.userCommaSetting();
                if (this.commaPlace == -1) {
                    this.commaPlace = this.getContext().getSql().QUERY_EL_COMMA;
                }
                if (this.commaPlace == 0) {
                    this.commaPlace = SqlCommonHandlersKt.autodetectDelimiter(this.getContext(), (Iterable<? extends SqlBlock>)this.getNestedBlocks());
                }
                if (this.commaPlace == -1 || this.commaPlace == 0) {
                    this.commaPlace = 2;
                }
            } else {
                this.commaPlace = 0;
            }
            int wrapSetting = this.userWrapSetting();
            if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) <= 0 && this.countOfElements >= 2 && (wrapSetting == 0 || wrapSetting == 3 || wrapSetting == 1) && this.getContext().getKlb() && this.getHasUserBreaks()) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            SqlCodeStyleSettings s = this.getContext().getSql();
            boolean firstIsAllOrDistinct = false;
            boolean wrapFirst = this.determineWrapFirstElement();
            if (this.commaPlace != 4) {
                WrapType wt = switch (WhenMappings.$EnumSwitchMapping$1[this.getShape().ordinal()]) {
                    case 1 -> {
                        switch (this.userWrapSetting()) {
                            case 1: 
                            case 2: {
                                yield WrapType.CHOP_DOWN_IF_LONG;
                            }
                            case 3: {
                                yield WrapType.NORMAL;
                            }
                        }
                        if (this.countOfElements <= this.userNumberOfElementsToKeepCollapsed()) {
                            yield null;
                        }
                        yield WrapType.NORMAL;
                    }
                    case 2 -> {
                        switch (this.userWrapSetting()) {
                            case 1: 
                            case 2: {
                                yield WrapType.ALWAYS;
                            }
                        }
                        yield WrapType.NORMAL;
                    }
                    default -> null;
                };
                Wrap w = SqlFlowBlock.makeWrap$default(this, wt, false, 2, null);
                Wrap wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                Intrinsics.checkNotNull((Object)wrap);
                Wrap dontWrap = wrap;
                Wrap amendmentWrap1 = this.countOfAmendments >= 1 ? Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true) : null;
                Wrap amendmentWrap2 = this.countOfAmendments >= 2 ? Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true) : null;
                boolean usedWrap1 = false;
                int k = 0;
                for (SqlBlock b : this.getNestedBlocks()) {
                    block11 : switch (WhenMappings.$EnumSwitchMapping$0[b.getRole().ordinal()]) {
                        case 2: {
                            switch (++k) {
                                case 1: {
                                    b.setMyWrap(wrapFirst ? w : dontWrap);
                                    if (SqlFormattingModelFun.primaryElementType(b) != SqlCompositeElementTypes.SQL_SELECT_OPTION) break block11;
                                    firstIsAllOrDistinct = true;
                                    break;
                                }
                                case 2: {
                                    if (firstIsAllOrDistinct && this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT) {
                                        b.setMyWrap(w);
                                        break;
                                    }
                                    b.setMyWrap(this.getCommaLast() ? w : dontWrap);
                                    break;
                                }
                                default: {
                                    b.setMyWrap(this.getCommaLast() ? w : dontWrap);
                                    break;
                                }
                            }
                            break;
                        }
                        case 5: {
                            b.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                            b.setMyWrap(usedWrap1 ? amendmentWrap2 : amendmentWrap1);
                            usedWrap1 = true;
                            break;
                        }
                        case 3: {
                            b.setMyWrap(this.getComma1st() ? w : dontWrap);
                        }
                    }
                }
            }
            if (this.commaPlace == 1) {
                if (wrapFirst) {
                    if (s.QUERY_ALIGN_ELEMENTS) {
                        int indentSize = this.getContext().getIndentSize();
                        Indent iE = Indent.getNormalIndent((boolean)s.QUERY_TRUE_INDENT);
                        Indent iD = indentSize >= 2 ? Indent.getSpaceIndent((int)(indentSize - 2), (boolean)s.QUERY_TRUE_INDENT) : SqlFormattingFunKt.getNONE_INDENT();
                        SqlBlock sqlBlock = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                        if (sqlBlock != null) {
                            SqlBlock usedWrap1;
                            SqlBlock it = usedWrap1 = sqlBlock;
                            boolean bl = false;
                            it.setMyIndent(iE);
                        }
                        Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            SqlBlock it = (SqlBlock)element$iv;
                            boolean bl = false;
                            it.setMyIndent(iD);
                        }
                    } else {
                        Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                        boolean $i$f$forEach = false;
                        for (Iterator<Object> element$iv : $this$forEach$iv) {
                            SqlBlock it = (SqlBlock)((Object)element$iv);
                            boolean bl = false;
                            it.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT_ETC());
                        }
                        $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                        $i$f$forEach = false;
                        for (Iterator<Object> element$iv : $this$forEach$iv) {
                            SqlBlock it = (SqlBlock)((Object)element$iv);
                            boolean bl = false;
                            it.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                        }
                    }
                } else {
                    i = this.userElementsLineSetting() == 1 ? Indent.getSpaceIndent((int)(this.getPrefixLength$intellij_database_sql_core_impl() - this.getDelimiterLength()), (boolean)true) : Indent.getNormalIndent((boolean)true);
                    $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        boolean bl = false;
                        it.setMyIndent(i);
                    }
                }
            } else {
                i = Indent.getNormalIndent((s.QUERY_TRUE_INDENT && this.countOfElements + this.countOfDelimiters > 1 ? 1 : 0) != 0);
                $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT, BlockRole.LINE_COMMENT);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it = (SqlBlock)element$iv;
                    boolean bl = false;
                    it.setMyIndent(i);
                }
                Indent i2 = Indent.getContinuationIndent();
                Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it = (SqlBlock)element$iv;
                    boolean bl = false;
                    it.setMyIndent(i2);
                }
            }
            if (this.toAlignElements()) {
                Iterable $this$forEach$iv;
                if (this.getComma1st()) {
                    if (wrapFirst || firstIsAllOrDistinct) {
                        alignForDelimiter = SqlFormattingModelFun.makeRightAlignment();
                        Alignment alignForElements = SqlFormattingModelFun.makeLeftAlignmentBS();
                        for (SqlBlock b : this.getNestedBlocks()) {
                            switch (WhenMappings.$EnumSwitchMapping$0[b.getRole().ordinal()]) {
                                case 3: {
                                    SqlLeafBlock sqlLeafBlock = b.getLastLeafBlock();
                                    if (sqlLeafBlock != null) {
                                        sqlLeafBlock.setMyAlign(alignForDelimiter);
                                    }
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    b.setMyAlign(alignForElements);
                                }
                            }
                        }
                    } else {
                        Alignment alignment;
                        if (this.getPrefixSize$intellij_database_sql_core_impl() == 1) {
                            alignment = this.getThisQuery$intellij_database_sql_core_impl().getCommonFirstWordRightAlign();
                            if (alignment == null) {
                                alignment = SqlFormattingModelFun.makeRightAlignment();
                            }
                        } else {
                            alignment = SqlFormattingModelFun.makeRightAlignment();
                        }
                        alignForDelimiter = alignment;
                        $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.PREFIX, BlockRole.DELIMITER);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            SqlBlock it = (SqlBlock)element$iv;
                            boolean bl = false;
                            SqlLeafBlock sqlLeafBlock = it.getLastLeafBlock();
                            if (sqlLeafBlock == null) continue;
                            sqlLeafBlock.setMyAlign(alignForDelimiter);
                        }
                    }
                } else {
                    SqlBlock b;
                    Alignment a = null;
                    a = SqlFormattingModelFun.makeLeftAlignment();
                    if (this.countOfLineComments > 0 && this.countOfElements > 0 && this.getNestedBlocks().size() >= 3 && (b = this.getNestedBlocks().get(1)) instanceof SqlLineCommentBlock) {
                        a = SqlFormattingModelFun.makeLeftAlignmentBS();
                        b.setMyAlign(a);
                    }
                    $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        boolean bl = false;
                        it.setMyAlign(a);
                    }
                    Iterable $this$filter$iv = this.getNestedBlocks();
                    boolean $i$f$filter = false;
                    Iterable $this$jbi$iv$iv = $this$filter$iv;
                    boolean $i$f$getJbi = false;
                    JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                    JBIterable jBIterable2 = jBIterable.filter(SqlLineCommentBlock.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                    JBIterable jBIterable3 = jBIterable2.filter(arg_0 -> WordAndListSection.configureFormattingAttributes$lambda$9(configureFormattingAttributes.10.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
                    $this$forEach$iv = (Iterable)jBIterable3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlLineCommentBlock it = (SqlLineCommentBlock)element$iv;
                        boolean bl = false;
                        it.setMyAlign(a);
                    }
                }
                if (this.countOfAmendments >= 2) {
                    Alignment aa = SqlFormattingModelFun.makeLeftAlignment();
                    $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.AMENDMENT);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlBlock it = (SqlBlock)element$iv;
                        boolean bl = false;
                        it.setMyAlign(aa);
                    }
                }
            }
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().QUERY_ALIGN_LINE_COMMENTS) {
                Alignment a = SqlFormattingModelFun.makeLeftAlignmentBS();
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterable $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(SqlLineCommentBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                JBIterable jBIterable3 = jBIterable2.filter(arg_0 -> WordAndListSection.patchFormattingAttributesForChildren$lambda$1(WordAndListSection::patchFormattingAttributesForChildren$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlLineCommentBlock it = (SqlLineCommentBlock)element$iv;
                    boolean bl = false;
                    if (it.getMyAlign() != null) continue;
                    it.setMyAlign(a);
                }
            }
        }

        protected boolean determineWrapFirstElement() {
            return this.userElementsLineSetting() == 101;
        }

        protected boolean toAlignElements() {
            return this.getContext().getSql().QUERY_ALIGN_ELEMENTS;
        }

        public int userNumberOfElementsToKeepCollapsed() {
            return this.userElementsLineSetting() >= 101 ? 0 : 1;
        }

        @Override
        protected boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_core_impl().allowedToCollapse()) {
                return false;
            }
            return this.countOfElements > this.userNumberOfElementsToKeepCollapsed() && this.userWrapSetting() == 1 || this.countOfElements >= 1 && this.userElementsLineSetting() >= 101;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            boolean y1 = block1 instanceof SectionElement && ((SectionElement)((Object)block1)).isEgyptian();
            boolean y2 = block2 instanceof SectionElement && ((SectionElement)((Object)block2)).isEgyptian();
            if (r1 == BlockRole.PREFIX && this.determineWrapFirstElement() && this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS) {
                SqlLeafBlock sqlLeafBlock = block2.getFirstLeafBlock();
                if (!Intrinsics.areEqual((Object)(sqlLeafBlock != null ? sqlLeafBlock.getElementType() : null), (Object)SqlTokens.SQL_ASTERISK) && !y2) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
            }
            if (r1 == BlockRole.ELEMENT && block1.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && !y1 && this.getComma1st()) {
                return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
            }
            if (r2 == BlockRole.ELEMENT && block2.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && !y2 && this.getCommaLast() && r1 != BlockRole.PREFIX) {
                return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
            }
            if (block1 instanceof SqlComma) {
                int wrapSetting = this.userWrapSetting();
                return this.getComma1st() ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : (this.getCommaLast() ? SqlFormattingContext.makeSpace$default(this.getContext(), false, (wrapSetting == 0 || wrapSetting == 3) && this.getContext().getKlb(), 1, null) : SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null));
            }
            if (block2 instanceof SqlComma) {
                if (this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && this.getComma1st() && SqlFormattingModelFun.isAlways(block2.getMyWrap())) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
                return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
            }
            return super.decideSpacing(block1, block2);
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributesForNewElementAtTheEnd() {
            Object newIndent = SqlFormattingFunKt.getNONE_INDENT();
            Alignment newAlignment = null;
            if (this.countOfElements + this.countOfDelimiters == 0 && this.userBreakFirstElement()) {
                newIndent = SqlFormattingFunKt.getNORMAL_INDENT();
            } else if (this.countOfDelimiters >= this.countOfElements && this.countOfElements > 1) {
                SqlBlock b;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2;
                block5: {
                    List<SqlBlock> list = this.getNestedBlocks();
                    ListIterator<SqlBlock> listIterator = list.listIterator(list.size());
                    while (listIterator.hasPrevious()) {
                        SqlBlock sqlBlock3;
                        SqlBlock it = sqlBlock3 = listIterator.previous();
                        boolean bl = false;
                        if (!(it.getRole() == BlockRole.ELEMENT)) continue;
                        sqlBlock2 = sqlBlock3;
                        break block5;
                    }
                    sqlBlock2 = null;
                }
                if ((sqlBlock = (b = (SqlBlock)sqlBlock2)) == null || (sqlBlock = sqlBlock.getIndent()) == null) {
                    sqlBlock = SqlFormattingFunKt.getNONE_INDENT();
                }
                newIndent = sqlBlock;
                SqlBlock sqlBlock4 = b;
                newAlignment = sqlBlock4 != null ? sqlBlock4.getAlignment() : null;
            }
            return new ChildAttributes(newIndent, newAlignment);
        }

        @Override
        @Nullable
        public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
            String string;
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            this.analyze();
            SqlBlock b1 = blocks.getBlock1();
            SqlBlock b2 = blocks.getBlock2();
            if (b1 instanceof SqlCommentBlock) {
                int k;
                SqlBlock p2 = ((SqlCommentBlock)b1).getParent();
                for (k = p2.getNestedBlocks().indexOf(b1); k > 0 && p2.getNestedBlocks().get(k) instanceof SqlCommentBlock; --k) {
                }
                b1 = p2.getNestedBlocks().get(k);
            }
            SqlBlock $this$role$iv = b1;
            boolean $i$f$getRole = false;
            Object object = $this$role$iv;
            if (object == null || (object = ((SqlBlock)object).getRole()) == null) {
                object = BlockRole.NOTHING;
            }
            Object r1 = object;
            SqlBlock $this$role$iv2 = b2;
            boolean $i$f$getRole2 = false;
            Object object2 = $this$role$iv2;
            if (object2 == null || (object2 = object2.getRole()) == null) {
                object2 = BlockRole.NOTHING;
            }
            Object r2 = object2;
            boolean trueIndent = this.getContext().getSql().QUERY_TRUE_INDENT;
            if (r2 == BlockRole.NOTHING) {
                switch (WhenMappings.$EnumSwitchMapping$0[((Enum)r1).ordinal()]) {
                    case 1: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, true, false, 8, null);
                        break;
                    }
                    case 2: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, false, false, 12, null);
                        break;
                    }
                    case 3: {
                        string = this.computeElementIndent(this.getRange().getEndOffset(), trueIndent);
                        break;
                    }
                    default: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, false, false, 12, null);
                        break;
                    }
                }
            } else if (r2 == BlockRole.ELEMENT || r1 == BlockRole.DELIMITER) {
                SqlBlock sqlBlock = b1;
                string = this.computeElementIndent(sqlBlock != null && (sqlBlock = sqlBlock.getRange()) != null ? sqlBlock.getStartOffset() : this.getRange().getEndOffset(), trueIndent);
            } else if (r2 == BlockRole.DELIMITER) {
                if (this.getComma1st()) {
                    int plusSpaces = Math.max(this.getPrefixLength$intellij_database_sql_core_impl() - this.getDelimiterLength(), 0);
                    string = this.getContext().currIndentOf(this, trueIndent, plusSpaces);
                } else {
                    string = this.userElementsLineSetting() == 1 ? this.getContext().currIndentOf(this, trueIndent, this.getPrefixLength$intellij_database_sql_core_impl() + 1) : SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, true, false, 8, null);
                }
            } else {
                string = r1 == BlockRole.AMENDMENT ? (b1 != null ? SqlFormattingContext.currIndentOf$default(this.getContext(), b1, true, false, false, 12, null) : null) : (r2 == BlockRole.AMENDMENT ? SqlFormattingContext.currIndentOf$default(this.getContext(), this.getParent(), false, true, false, 10, null) : null);
            }
            return string;
        }

        private final String computeElementIndent(int offset, boolean trueIndent) {
            int x = offset;
            if (this.getContext().getText().charAt(x) == '\n') {
                --x;
            }
            if (this.getContext().getText().charAt(x) == '\r') {
                --x;
            }
            SqlBlock firstElementOnThisLine = SqlFormattingModelFun.findFirstInnerBlockOnTheSameLine(this, x, (Function1<? super SqlBlock, Boolean>)((Function1)WordAndListSection::computeElementIndent$lambda$0));
            return firstElementOnThisLine != null ? SqlFormattingContext.currIndentOf$default(this.getContext(), firstElementOnThisLine, true, false, false, 12, null) : SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, true, false, 8, null);
        }

        private static final boolean configureFormattingAttributes$lambda$9(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean patchFormattingAttributesForChildren$lambda$0(SqlLineCommentBlock it) {
            return !it.isWholeString();
        }

        private static final boolean patchFormattingAttributesForChildren$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean computeElementIndent$lambda$0(SqlBlock it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getRole() == BlockRole.ELEMENT;
        }

        static {
            Object[] objectArray = new FlowPattern[4];
            SqlTokenType sqlTokenType = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LINE_COMMENT");
            objectArray[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
            Byte by = 0;
            Byte by2 = 1;
            Object[] objectArray2 = new NodeMatcher[2];
            objectArray2[0] = NodeMatcherKt.matchAnyKeyword();
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_BY, (String)"SQL_BY");
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_WITH, (String)"SQL_WITH");
            objectArray2[1] = NodeMatcherKt.matchType(iElementTypeArray);
            objectArray[1] = new RowPattern(by, by2, CollectionsKt.listOf((Object[])objectArray2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
            objectArray[2] = new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchAnyKeyword(), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
            Byte by3 = 1;
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_COMMA");
            objectArray[3] = new SingletonPattern(by3, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
            commonPatterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection$Companion;", "", "<init>", "()V", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getCommonPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        protected static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getCommonPatterns() {
                return commonPatterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.PREFIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.ELEMENT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.DELIMITER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.LINE_COMMENT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.AMENDMENT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[BlockShape.values().length];
                try {
                    nArray[BlockShape.DECIDE_LATER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockShape.DECIDED_TO_MULTI_ROWS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

