/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.PsiColumnWithSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.stubs.StubBuildCachedValuesManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlColumnDetailsClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlObjectAttributeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlTableElementListImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.elementStubs.SqlTableStub;
import com.intellij.sql.psi.stubs.elementTypes.SqlTableKeyElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SqlCreateTableStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateTableStatement {
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<List<PsiColumnWithSymbol>, SqlCreateTableStatementImpl> COLUMNS_PROVIDER = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("sql.createTable.columns", statement -> CachedValueProvider.Result.create(statement.calcColumns(), SqlFileImpl.getMaximalDependencies((PsiElement)statement)));
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<List<PsiColumnWithSymbol>, SqlCreateTableStatementImpl> QUERY_COLUMNS_PROVIDER = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("sql.queryColumns", statement -> CachedValueProvider.Result.create(statement.calcQueryColumns(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));

    public SqlCreateTableStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateTableStatementImpl(SqlTableStub stub) {
        super(stub);
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    public SqlExpression getQueryExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getQueryExpression();
        }
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE), SqlExpression.class);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateTableStatement((SqlCreateTableStatement)this);
    }

    public DasDataSource getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable result = JBIterable.empty();
        boolean all = kind == null || kind == ObjectKind.NONE;
        boolean processed = false;
        if (kind == ObjectKind.COLUMN || all) {
            result = result.append(this.getColumns());
            processed = true;
        }
        if (kind == ObjectKind.KEY || all) {
            result = result.append(this.getDeclaredKeys());
            processed = true;
        }
        if (kind == ObjectKind.FOREIGN_KEY || all) {
            result = result.append(this.getDeclaredForeignKeys());
            processed = true;
        }
        if (kind == ObjectKind.INDEX || all) {
            result = result.append(this.getDeclaredIndices());
            processed = true;
        }
        if (kind == ObjectKind.CHECK || all) {
            result = result.append(this.getDeclaredChecks());
            processed = true;
        }
        if (kind == ObjectKind.DEFAULT || all) {
            result = result.append(this.getDeclaredDefaults());
            processed = true;
        }
        if (!processed || all) {
            JBIterable children = this.getDefinitions();
            children = all ? children.filter(o -> !(o instanceof DasConstraint) && !(o instanceof DasColumn)) : children.filter(DasUtil.byKind((ObjectKind)kind));
            result = result.append((Iterable)children);
        }
        JBIterable jBIterable = result;
        if (jBIterable == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    private JBIterable<PsiObject> getDefinitions() {
        SqlTableStub stub = (SqlTableStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.from((Iterable)stub.getChildrenStubs()).filter(PsiObject.class);
        }
        JBIterable direct = SqlImplUtil.childrenIt((PsiElement)this).filter(PsiObject.class);
        SqlTableElementListImpl list = this.getElementList();
        return list == null ? direct : SqlImplUtil.childrenIt((PsiElement)list).filter(PsiObject.class).append((Iterable)direct);
    }

    @NotNull
    public List<PsiColumnWithSymbol> getColumns() {
        List cached = (List)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, () -> (List)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)this, COLUMNS_PROVIDER));
        List list = (List)ObjectUtils.notNull((Object)cached, Collections.emptyList());
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected @Unmodifiable List<PsiColumnWithSymbol> calcColumns() {
        List list = ContainerUtil.concat((List[])new List[]{this.getDeclaredColumns(), this.getAdditionalColumns(), this.calcQueryColumns()});
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    private <Psi extends PsiElement> Psi @NotNull [] getStubOrPsiTableElements(@NotNull IElementType elementType, @NotNull ArrayFactory<Psi> f) {
        SqlTableStub stub;
        if (elementType == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(4);
        }
        if (f == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(5);
        }
        if ((stub = (SqlTableStub)this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, f);
            if (psiElementArray == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(6);
            }
            return psiElementArray;
        }
        SqlTableElementListImpl elements = this.getElementList();
        if (elements == null) {
            PsiElement[] psiElementArray = (PsiElement[])f.create(0);
            if (psiElementArray == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(7);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = elements.getChildrenAsPsiElements(elementType, f);
        if (psiElementArray == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    @NotNull
    public List<SqlColumnDefinition> getDeclaredColumns() {
        List<SqlColumnDefinition> list = Arrays.asList((SqlColumnDefinition[])this.getStubOrPsiTableElements((IElementType)SqlCompositeElementTypes.SQL_COLUMN_DEFINITION, SqlColumnDefinition.ARRAY_FACTORY));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<SqlColumnDetailsClause> getColumnDetails() {
        List<SqlColumnDetailsClause> list = Arrays.asList((SqlColumnDetailsClause[])this.getStubOrPsiTableElements((IElementType)SqlCompositeElementTypes.SQL_COLUMN_DETAILS_CLAUSE, SqlColumnDetailsClause[]::new));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<SqlTableKeyDefinition> getDeclaredKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<SqlConstraintDefinition> getDeclaredChecks() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredChecks(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<SqlConstraintDefinition> getDeclaredDefaults() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredDefaults(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<SqlForeignKeyDefinition> getDeclaredForeignKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredForeignKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private List<SqlForeignKeyDefinition> calcDeclaredForeignKeys() {
        ArrayList<SqlForeignKeyDefinition> result = new ArrayList<SqlForeignKeyDefinition>();
        for (SqlColumnDefinition column : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull(result, (Object)column.getForeignKey());
        }
        ContainerUtil.addAll(result, (Object[])((SqlForeignKeyDefinition[])this.getStubOrPsiTableElements((IElementType)SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION, SqlForeignKeyDefinition.ARRAY_FACTORY)));
        ArrayList<SqlForeignKeyDefinition> arrayList = result;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlTableKeyDefinition> calcDeclaredKeys() {
        ArrayList<SqlTableKeyDefinition> result = new ArrayList<SqlTableKeyDefinition>();
        for (SqlColumnDefinition sqlColumnDefinition : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull(result, (Object)sqlColumnDefinition.getPrimaryKey());
        }
        SqlTableKeyElementType<?> pkType = SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION;
        ContainerUtil.addAll(result, (Object[])((SqlTableKeyDefinition[])this.getStubOrPsiTableElements((IElementType)pkType, SqlTableKeyDefinition.ARRAY_FACTORY)));
        for (SqlColumnDefinition column : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull(result, (Object)column.getUniqueKey());
        }
        SqlTableKeyElementType<?> sqlTableKeyElementType = SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION;
        Collections.addAll(result, (SqlTableKeyDefinition[])this.getStubOrPsiTableElements((IElementType)sqlTableKeyElementType, SqlTableKeyDefinition.ARRAY_FACTORY));
        ArrayList<SqlTableKeyDefinition> arrayList = result;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlConstraintDefinition> calcDeclaredChecks() {
        return this.calcConstraints(SqlConstraintDefinition.Type.CHECK);
    }

    @NotNull
    private List<SqlConstraintDefinition> calcConstraints(SqlConstraintDefinition.Type type) {
        ArrayList<SqlConstraintDefinition> result = new ArrayList<SqlConstraintDefinition>();
        for (SqlColumnDefinition sqlColumnDefinition : this.getDeclaredColumns()) {
            for (SqlConstraintDefinition definition : sqlColumnDefinition.getConstraints()) {
                if (definition.getConstraintType() != type) continue;
                result.add(definition);
            }
        }
        for (SqlColumnDetailsClause sqlColumnDetailsClause : this.getColumnDetails()) {
            for (SqlConstraintDefinition definition : SqlImplUtil.childrenIt((PsiElement)sqlColumnDetailsClause).filter(SqlConstraintDefinition.class)) {
                if (definition.getConstraintType() != type) continue;
                result.add(definition);
            }
        }
        SqlImplUtil.childrenIt((PsiElement)(this.getStub() == null ? this.getElementList() : this)).filter(SqlConstraintDefinition.class).filter(c -> c.getConstraintType() == type).addAllTo(result);
        ArrayList<SqlConstraintDefinition> arrayList = result;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlConstraintDefinition> calcDeclaredDefaults() {
        return this.calcConstraints(SqlConstraintDefinition.Type.DEFAULT);
    }

    protected SqlTableElementListImpl getElementList() {
        return (SqlTableElementListImpl)PsiTreeUtil.getChildOfType((PsiElement)this, SqlTableElementListImpl.class);
    }

    @NotNull
    public List<SqlIndexDefinition> getDeclaredIndices() {
        SqlTableKeyElementType idxType = SqlCompositeElementTypes.SQL_INDEX_DEFINITION;
        List<SqlIndexDefinition> list = Arrays.asList((SqlIndexDefinition[])this.getStubOrPsiTableElements((IElementType)idxType, SqlIndexDefinition.ARRAY_FACTORY));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> getAdditionalColumns() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> getQueryColumns() {
        List list = (List)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)this, QUERY_COLUMNS_PROVIDER);
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> calcQueryColumns() {
        DasType type;
        if (SqlImplUtil.isRecursive((SqlTableDefinition)this)) {
            List<PsiColumnWithSymbol> list = Collections.emptyList();
            if (list == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(21);
            }
            return list;
        }
        SqlExpression expression = this.getQueryExpression();
        DasType dasType = type = expression == null ? null : expression.getDasType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumnWithSymbol> list = Collections.emptyList();
            if (list == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(22);
            }
            return list;
        }
        SqlTableType tableType2 = (SqlTableType)type;
        SqlColumnAliasDefinition[] aliases = this.getColumnAliases();
        if (aliases.length != 0) {
            tableType2 = tableType2.aliasByDefs(null, (PsiElement)this, Arrays.asList(aliases));
        }
        List<PsiColumnWithSymbol> list = SqlImplUtil.createColumnInfos((SqlTableDefinition)this, tableType2);
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public SqlColumnAliasDefinition[] getColumnAliases() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = (SqlColumnAliasDefinition[])stub.getChildrenByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION, SqlColumnAliasDefinition.ARRAY_FACTORY);
            if (sqlColumnAliasDefinitionArray == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(24);
            }
            return sqlColumnAliasDefinitionArray;
        }
        SqlColumnAliasListImpl list = (SqlColumnAliasListImpl)((Object)this.findChildByClass(SqlColumnAliasListImpl.class));
        SqlColumnAliasDefinition[] aliases = (SqlColumnAliasDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)list, SqlColumnAliasDefinition.class);
        SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = aliases == null ? SqlColumnAliasDefinition.EMPTY_ARRAY : aliases;
        if (sqlColumnAliasDefinitionArray == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(25);
        }
        return sqlColumnAliasDefinitionArray;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.findChildByType(SqlCommonKeywords.SQL_TEMP_KEYWORDS) != null;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
        if (c == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(26);
            }
            return set;
        }
        String name = c.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).isAutoIncrementColumn(c)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        for (SqlTableKeyDefinition sqlTableKeyDefinition : this.getDeclaredKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)sqlTableKeyDefinition.getColumnsRef())) continue;
            set.add(sqlTableKeyDefinition.isPrimary() ? DasColumn.Attribute.PRIMARY_KEY : DasColumn.Attribute.CANDIDATE_KEY);
        }
        for (DasForeignKey dasForeignKey : this.getDeclaredForeignKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasForeignKey.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DasIndex dasIndex : this.getDeclaredIndices()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasIndex.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(27);
        }
        return enumSet;
    }

    protected boolean isColumnsCaseSensitive() {
        return DasUtil.isCaseSensitive((Casing)SqlImplUtil.getSqlDialectSafe((PsiElement)this).getCasing(ObjectKind.COLUMN, (DasObject)this));
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(28);
        }
        if (state == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(29);
        }
        if (place == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(30);
        }
        if (lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)true)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (state == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(31);
        }
        if (SqlImplUtil.isProcessingChildOf(processor, this.getKind())) {
            if (!PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)false)) {
                for (PsiColumnWithSymbol column : this.getQueryColumns()) {
                    if (processor.execute((DasSymbol)column, state)) continue;
                    return false;
                }
            }
            for (PsiColumnWithSymbol column : this.getAdditionalColumns()) {
                if (processor.execute((DasSymbol)column, state)) continue;
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    protected List<PsiColumnWithSymbol> extractColumns(PsiObject element) {
        SqlTableType tableType2 = element instanceof DasTable ? SqlTableTypeBase.createType((DasTable)element, (PsiElement)element, (PsiElement)this) : SqlTableTypeBase.createObjectTypeType((DasObject)element, (PsiElement)element, (PsiElement)this);
        List columns = ((TableBasedSqlTableTypeImpl)tableType2).getColumns();
        SmartList result = new SmartList();
        int count = 0;
        for (int i = 0; i < columns.size(); ++i) {
            Object column = columns.get(i);
            if (column instanceof PsiColumnWithSymbol) {
                result.add((PsiColumnWithSymbol)column);
            } else {
                if (!(column instanceof SqlObjectAttributeDefinitionImpl)) continue;
                result.add(new TypeAttributeBasedColumn((SqlObjectAttributeDefinitionImpl)((Object)column), (short)(count + 1)));
            }
            ++count;
        }
        SmartList smartList = result;
        if (smartList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(32);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumns";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiTableElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredColumns";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnDetails";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredKeys";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredChecks";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredDefaults";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredForeignKeys";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredForeignKeys";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredKeys";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcConstraints";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredIndices";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalColumns";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryColumns";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calcQueryColumns";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliases";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extractColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTableElements";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitContextDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 32 -> new IllegalStateException(string);
        };
    }

    private class TypeAttributeBasedColumn
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition,
    PsiColumnWithSymbol {
        private final SqlObjectAttributeDefinitionImpl myAttribute;
        private final short myPosition;

        private TypeAttributeBasedColumn(SqlObjectAttributeDefinitionImpl attribute, short position) {
            super((PsiElement)SqlCreateTableStatementImpl.this);
            this.myAttribute = attribute;
            this.myPosition = position;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this.myAttribute);
            if (dbms == null) {
                TypeAttributeBasedColumn.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        public PsiColumn getDasObject() {
            TypeAttributeBasedColumn typeAttributeBasedColumn = this;
            if (typeAttributeBasedColumn == null) {
                TypeAttributeBasedColumn.$$$reportNull$$$0(1);
            }
            return typeAttributeBasedColumn;
        }

        public boolean isNameQuoted() {
            return this.myAttribute.isNameQuoted();
        }

        public DasTable getTable() {
            return SqlCreateTableStatementImpl.this;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                TypeAttributeBasedColumn.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = this.myAttribute.getName();
            if (string == null) {
                TypeAttributeBasedColumn.$$$reportNull$$$0(3);
            }
            return string;
        }

        public DasObject getDasParent() {
            return this.getTable();
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return this.myAttribute.getTypeElement();
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myAttribute.getDasType();
            if (dasType == null) {
                TypeAttributeBasedColumn.$$$reportNull$$$0(4);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return this.myAttribute.isNotNull();
        }

        public String getDefault() {
            return this.myAttribute.getDefault();
        }

        public String getTypeName() {
            return DbPresentationCore.getPresentableName((ObjectKind)this.getKind(), (Dbms)this.getDbms());
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlObjectAttributeDefinitionImpl sqlObjectAttributeDefinitionImpl = this.myAttribute;
            if (sqlObjectAttributeDefinitionImpl == null) {
                TypeAttributeBasedColumn.$$$reportNull$$$0(5);
            }
            return sqlObjectAttributeDefinitionImpl;
        }

        public short getPosition() {
            return this.myPosition;
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return this.myAttribute.getNameElement();
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.myAttribute.getNameIdentifier();
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (!(another instanceof TypeAttributeBasedColumn)) {
                return false;
            }
            TypeAttributeBasedColumn col = (TypeAttributeBasedColumn)another;
            return this.myAttribute.isEquivalentTo((PsiElement)col.myAttribute);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl$TypeAttributeBasedColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

