/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlMatchDefineClause;
import com.intellij.sql.psi.SqlMatchMeasuresClause;
import com.intellij.sql.psi.SqlMatchPartitionClause;
import com.intellij.sql.psi.SqlMatchPatternClause;
import com.intellij.sql.psi.SqlMatchRecognizeExpression;
import com.intellij.sql.psi.SqlMatchRowClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlMatchRecognizeExpressionImpl$Companion$processPatternReferencesAsDefinitions$;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.symbols.DasSymbolUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/psi/impl/SqlMatchRecognizeExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlExpressionImpl;", "Lcom/intellij/sql/psi/SqlMatchRecognizeExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "sourceExpression", "Lcom/intellij/sql/psi/SqlExpression;", "getSourceExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "processDeclarations", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "computeDasType", "Lcom/intellij/database/types/DasType;", "Companion", "intellij.database.sql.core.impl"})
public class SqlMatchRecognizeExpressionImpl
extends SqlExpressionImpl
implements SqlMatchRecognizeExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlMatchRecognizeExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public SqlExpression getSourceExpression() {
        SqlExpression sqlExpression = this.findNotNullChildByClass(SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"findNotNullChildByClass(...)");
        return sqlExpression;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if (!Companion.processDeclarations(this, processor, state, lastParent, place)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        return (DasType)Companion.computeDasType(this);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/psi/impl/SqlMatchRecognizeExpressionImpl$Companion;", "", "<init>", "()V", "computeDasType", "Lcom/intellij/sql/psi/SqlTableType;", "expression", "Lcom/intellij/sql/psi/SqlMatchRecognizeExpression;", "processDeclarations", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "processPatternReferencesAsDefinitions", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlMatchRecognizeExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlMatchRecognizeExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlMatchRecognizeExpressionImpl$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n223#2,2:94\n479#3:96\n*S KotlinDebug\n*F\n+ 1 SqlMatchRecognizeExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlMatchRecognizeExpressionImpl$Companion\n*L\n83#1:94,2\n83#1:96\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SqlTableType computeDasType(@NotNull SqlMatchRecognizeExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            PsiElement parent = expression.getParent();
            SqlMatchPartitionClause partitionClause = (SqlMatchPartitionClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlMatchPartitionClause.class);
            Object object = partitionClause;
            if (object == null || (object = object.getExpressions()) == null) {
                object = CollectionsKt.emptyList();
            }
            SqlTableType sqlTableType = SqlImplUtil.getSelectType((List<? extends SqlExpression>)object, parent);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"getSelectType(...)");
            SqlTableType partitionType = sqlTableType;
            SqlMatchMeasuresClause measuresClause = (SqlMatchMeasuresClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlMatchMeasuresClause.class);
            Object object2 = measuresClause;
            if (object2 == null || (object2 = object2.getExpressions()) == null) {
                object2 = CollectionsKt.emptyList();
            }
            SqlTableType sqlTableType2 = SqlImplUtil.getSelectType((List<? extends SqlExpression>)object2, parent);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType2, (String)"getSelectType(...)");
            SqlTableType measuresType = sqlTableType2;
            SqlMatchRowClause rowClause = (SqlMatchRowClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlMatchRowClause.class);
            if (rowClause != null && rowClause.isAll()) {
                DasType dasType = expression.getSourceExpression().getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                DasType sourceType = dasType;
                if (sourceType instanceof SqlTableType) {
                    SqlTableType sqlTableType3 = ((SqlTableType)sourceType).addDistinct(partitionType, (CasingProvider)SqlPsiUtilKt.getSqlDialect((PsiElement)expression)).add(measuresType);
                    Intrinsics.checkNotNullExpressionValue((Object)sqlTableType3, (String)"add(...)");
                    return sqlTableType3;
                }
            }
            SqlTableType sqlTableType4 = partitionType.add(measuresType);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType4, (String)"add(...)");
            return sqlTableType4;
        }

        public final boolean processDeclarations(@NotNull SqlMatchRecognizeExpression expression, @NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)expression), (PsiElement)place, (boolean)false)) {
                if (processor.mayAccept(ObjectKind.COLUMN) && !SqlImplUtil.processFromReferences(processor, state, expression.getSourceExpression(), place, lastParent)) {
                    return false;
                }
                if (processor.mayAccept(ObjectKind.COLUMN) || processor.mayAccept(SqlDbElementType.PATTERN_SYMBOL)) {
                    SqlMatchDefineClause defineClause = (SqlMatchDefineClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlMatchDefineClause.class);
                    if (defineClause != null && !defineClause.processDeclarations(processor, state, lastParent, place)) {
                        return false;
                    }
                    if (processor.isResultEmpty() && place instanceof SqlReferenceExpression && (Intrinsics.areEqual((Object)((SqlReferenceExpression)place).getReferenceElementType().getTargetKind(), (Object)SqlDbElementType.PATTERN_SYMBOL) || ((SqlReferenceExpression)place).getParent() instanceof SqlReferenceExpression) && !this.processPatternReferencesAsDefinitions(expression, processor, state)) {
                        return false;
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean processPatternReferencesAsDefinitions(SqlMatchRecognizeExpression expression, SqlScopeProcessor processor, ResolveState state) {
            void $this$descendantsOfType_u24default$iv;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)expression);
            Dbms dbms = dialect.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if (!(dbms2.isSnowflake() || dbms2.isOracle() || Intrinsics.areEqual((Object)dbms2, (Object)Dbms.UNKNOWN))) {
                return true;
            }
            SqlMatchPatternClause sqlMatchPatternClause = (SqlMatchPatternClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlMatchPatternClause.class);
            if (sqlMatchPatternClause == null) {
                return true;
            }
            SqlMatchPatternClause patternClause = sqlMatchPatternClause;
            PsiElement psiElement = (PsiElement)patternClause;
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)Companion$processPatternReferencesAsDefinitions$$inlined$descendantsOfType$default$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence patternRefs = SequencesKt.filter((Sequence)sequence, Companion::processPatternReferencesAsDefinitions$lambda$0);
            for (SqlReferenceExpression patternRef : patternRefs) {
                if (!processor.executeTarget(DasSymbolUtil.getInlineSymbol(patternRef.getReference()), null, null, state)) {
                    return false;
                }
                if (processor.isResultEmpty()) continue;
                break;
            }
            return true;
        }

        private static final boolean processPatternReferencesAsDefinitions$lambda$0(SqlReferenceExpression it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getReferenceElementType().getTargetKind(), (Object)SqlDbElementType.PATTERN_SYMBOL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

