/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.diff;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.lang.DiffLangSpecificProvider;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.diff.data.FileInfoHolder;
import com.intellij.lang.properties.diff.data.PropertyInfo;
import com.intellij.lang.properties.diff.data.SemiOpenLineRange;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JF\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00142\u0006\u0010#\u001a\u00020$H\u0002J,\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0002JD\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020&0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020&0-H\u0002J,\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u00020*H\u0002J,\u00101\u001a\u0002022\u0006\u00103\u001a\u00020&2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020&0-2\u0006\u00105\u001a\u00020\u0005H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\"0\u00142\f\u00107\u001a\b\u0012\u0004\u0012\u00020\"0\u0014H\u0002J\u001c\u00108\u001a\u00020\"*\u00020*2\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u000202H\u0002J6\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010<\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R%\u0010\b\u001a\u00130\t\u00a2\u0006\u000e\b\n\u0012\n\b\u000b\u0012\u0006\b\n0\f8\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006="}, d2={"Lcom/intellij/lang/properties/diff/PropertiesDiffLangSpecificProvider;", "Lcom/intellij/diff/lang/DiffLangSpecificProvider;", "<init>", "()V", "shouldPrecalculateLineFragments", "", "getShouldPrecalculateLineFragments", "()Z", "description", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getDescription", "()Ljava/lang/String;", "isApplicable", "language", "Lcom/intellij/lang/Language;", "getLineFragments", "", "Lcom/intellij/diff/fragments/LineFragment;", "project", "Lcom/intellij/openapi/project/Project;", "textLeft", "", "textRight", "ignorePolicy", "Lcom/intellij/diff/tools/util/base/IgnorePolicy;", "highlightPolicy", "Lcom/intellij/diff/tools/util/base/HighlightPolicy;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "computePropertiesRanges", "Lcom/intellij/diff/util/Range;", "fileInfoHolder", "Lcom/intellij/lang/properties/diff/data/FileInfoHolder;", "computeCommonProperties", "Lcom/intellij/lang/properties/diff/data/PropertyInfo;", "commonPropertiesKeys", "", "side", "Lcom/intellij/diff/util/Side;", "computeModifiedPropertiesRanges", "leftProperties", "", "rightProperties", "computeAddedOrDeletedPropertiesRanges", "currentSide", "extractAnchorRange", "Lcom/intellij/lang/properties/diff/data/SemiOpenLineRange;", "propertyInfo", "oppositePropertiesMap", "isEndBound", "squashRanges", "rangeList", "createRange", "first", "second", "createLineFragments", "range", "intellij.properties.backend"})
@SourceDebugExtension(value={"SMAP\nPropertiesDiffLangSpecificProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesDiffLangSpecificProvider.kt\ncom/intellij/lang/properties/diff/PropertiesDiffLangSpecificProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1391#2:186\n1480#2,5:187\n1642#2,10:206\n1915#2:216\n1916#2:218\n1652#2:219\n139#3,10:192\n221#3:202\n222#3:204\n149#3:205\n139#3,10:220\n221#3:230\n222#3:232\n149#3:233\n1#4:203\n1#4:217\n1#4:231\n*S KotlinDebug\n*F\n+ 1 PropertiesDiffLangSpecificProvider.kt\ncom/intellij/lang/properties/diff/PropertiesDiffLangSpecificProvider\n*L\n69#1:186\n69#1:187,5\n94#1:206,10\n94#1:216\n94#1:218\n94#1:219\n86#1:192,10\n86#1:202\n86#1:204\n86#1:205\n111#1:220,10\n111#1:230\n111#1:232\n111#1:233\n86#1:203\n94#1:217\n111#1:231\n*E\n"})
public final class PropertiesDiffLangSpecificProvider
implements DiffLangSpecificProvider {
    private final boolean shouldPrecalculateLineFragments;

    public boolean getShouldPrecalculateLineFragments() {
        return this.shouldPrecalculateLineFragments;
    }

    @NotNull
    public String getDescription() {
        String string = PropertiesBundle.message((String)"ignore.unchanged.properties.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isApplicable(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)PropertiesLanguage.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<List<LineFragment>> getLineFragments(@Nullable Project project, @NotNull CharSequence textLeft, @NotNull CharSequence textRight, @NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)textLeft, (String)"textLeft");
        Intrinsics.checkNotNullParameter((Object)textRight, (String)"textRight");
        Intrinsics.checkNotNullParameter((Object)ignorePolicy, (String)"ignorePolicy");
        Intrinsics.checkNotNullParameter((Object)highlightPolicy, (String)"highlightPolicy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        FileInfoHolder fileInfoHolder = (FileInfoHolder)ReadAction.compute(() -> PropertiesDiffLangSpecificProvider.getLineFragments$lambda$0(project, textLeft, textRight));
        if (fileInfoHolder == null) {
            return CollectionsKt.emptyList();
        }
        List<Range> ranges = this.computePropertiesRanges(fileInfoHolder);
        Object object = new Function1[]{PropertiesDiffLangSpecificProvider::getLineFragments$lambda$1, PropertiesDiffLangSpecificProvider::getLineFragments$lambda$2};
        object = CollectionsKt.sortedWith((Iterable)ranges, (Comparator)ComparisonsKt.compareBy((Function1[])object));
        boolean $i$f$flatMap = false;
        void var12_11 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Range range = (Range)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.createLineFragments(range, fileInfoHolder, ignorePolicy, highlightPolicy, indicator);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List lineFragmentList = (List)destination$iv$iv;
        return lineFragmentList.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)lineFragmentList);
    }

    private final List<Range> computePropertiesRanges(FileInfoHolder fileInfoHolder) {
        Map<String, PropertyInfo> leftPropertiesMap = fileInfoHolder.get(Side.LEFT).getPropertyInfoMap();
        Map<String, PropertyInfo> rightPropertiesMap = fileInfoHolder.get(Side.RIGHT).getPropertyInfoMap();
        Set commonPropertiesKeys = CollectionsKt.intersect((Iterable)leftPropertiesMap.keySet(), (Iterable)rightPropertiesMap.keySet());
        List<Range> modifiedPropertiesRanges = this.computeModifiedPropertiesRanges(commonPropertiesKeys, leftPropertiesMap, rightPropertiesMap);
        List<Range> deletedPropertiesRanges = this.computeAddedOrDeletedPropertiesRanges(commonPropertiesKeys, fileInfoHolder, Side.LEFT);
        List<Range> addedPropertiesRanges = this.computeAddedOrDeletedPropertiesRanges(commonPropertiesKeys, fileInfoHolder, Side.RIGHT);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)modifiedPropertiesRanges, (Iterable)deletedPropertiesRanges), (Iterable)addedPropertiesRanges);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PropertyInfo> computeCommonProperties(Set<String> commonPropertiesKeys, FileInfoHolder fileInfoHolder, Side side) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, PropertyInfo> $this$mapNotNull$iv = fileInfoHolder.get(side).getPropertyInfoMap();
        boolean $i$f$mapNotNull = false;
        Map<String, PropertyInfo> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            PropertyInfo it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if ((!commonPropertiesKeys.contains(it.getKey()) ? null : (PropertyInfo)it.getValue()) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Range> computeModifiedPropertiesRanges(Set<String> commonPropertiesKeys, Map<String, PropertyInfo> leftProperties, Map<String, PropertyInfo> rightProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = commonPropertiesKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Range it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            PropertyInfo propertyBefore = (PropertyInfo)MapsKt.getValue(leftProperties, (Object)key);
            PropertyInfo propertyAfter = (PropertyInfo)MapsKt.getValue(rightProperties, (Object)key);
            if ((Intrinsics.areEqual((Object)propertyBefore.getValue(), (Object)propertyAfter.getValue()) ? null : new Range(propertyBefore.getRange().getStartLine(), propertyBefore.getRange().getEndLine(), propertyAfter.getRange().getStartLine(), propertyAfter.getRange().getEndLine())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List modifiedPropertiesRangeList = (List)destination$iv$iv;
        return this.squashRanges(modifiedPropertiesRangeList);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Range> computeAddedOrDeletedPropertiesRanges(Set<String> commonPropertiesKeys, FileInfoHolder fileInfoHolder, Side currentSide) {
        void $this$mapNotNullTo$iv$iv;
        List<PropertyInfo> commonPropertiesList = this.computeCommonProperties(commonPropertiesKeys, fileInfoHolder, currentSide);
        Side oppositeSide = currentSide.other();
        Map<String, PropertyInfo> currentPropertiesMap = fileInfoHolder.get(currentSide).getPropertyInfoMap();
        Map<String, PropertyInfo> oppositePropertiesMap = fileInfoHolder.get(oppositeSide).getPropertyInfoMap();
        int anchorIndex = 0;
        Map<String, PropertyInfo> $this$mapNotNull$iv = currentPropertiesMap;
        boolean $i$f$mapNotNull = false;
        Map<String, PropertyInfo> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Range range;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            PropertyInfo propertyInfo = (PropertyInfo)entry.getValue();
            if (commonPropertiesKeys.contains(propertyInfo.getKey())) {
                range = null;
            } else {
                SemiOpenLineRange semiOpenLineRange;
                SemiOpenLineRange propertyRange = propertyInfo.getRange();
                if (commonPropertiesList.isEmpty()) {
                    semiOpenLineRange = new SemiOpenLineRange(0, 0);
                } else if (((PropertyInfo)CollectionsKt.first(commonPropertiesList)).getRange().getStartLine() > propertyRange.getStartLine()) {
                    semiOpenLineRange = this.extractAnchorRange((PropertyInfo)CollectionsKt.first(commonPropertiesList), oppositePropertiesMap, false);
                } else {
                    int nextAnchorIndex;
                    PropertyInfo nextAnchorInfo;
                    while (anchorIndex < commonPropertiesList.size() && (nextAnchorInfo = (PropertyInfo)CollectionsKt.getOrNull(commonPropertiesList, (int)(nextAnchorIndex = anchorIndex + 1))) != null && nextAnchorInfo.getRange().getStartLine() <= propertyRange.getStartLine()) {
                        anchorIndex = nextAnchorIndex;
                    }
                    semiOpenLineRange = this.extractAnchorRange(commonPropertiesList.get(anchorIndex), oppositePropertiesMap, true);
                }
                SemiOpenLineRange anchorRange = semiOpenLineRange;
                range = this.createRange(currentSide, propertyRange, anchorRange);
            }
            if (range == null) continue;
            Range it$iv$iv = range;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List addedOrDeletedPropertiesRangeList = (List)destination$iv$iv;
        return this.squashRanges(addedOrDeletedPropertiesRangeList);
    }

    private final SemiOpenLineRange extractAnchorRange(PropertyInfo propertyInfo, Map<String, PropertyInfo> oppositePropertiesMap, boolean isEndBound) {
        SemiOpenLineRange range = ((PropertyInfo)MapsKt.getValue(oppositePropertiesMap, (Object)propertyInfo.getKey())).getRange();
        int line = isEndBound ? range.getEndLine() : range.getStartLine();
        return new SemiOpenLineRange(line, line);
    }

    private final List<Range> squashRanges(List<Range> rangeList) {
        int leftIndex = 0;
        List result = new ArrayList();
        while (leftIndex < rangeList.size()) {
            int rightIndex;
            for (rightIndex = leftIndex + 1; rightIndex < rangeList.size() && rangeList.get((int)(rightIndex - 1)).end1 == rangeList.get((int)rightIndex).start1 && rangeList.get((int)(rightIndex - 1)).end2 == rangeList.get((int)rightIndex).start2; ++rightIndex) {
            }
            Range newRange = leftIndex == rightIndex - 1 ? rangeList.get(leftIndex) : new Range(rangeList.get((int)leftIndex).start1, rangeList.get((int)(rightIndex - 1)).end1, rangeList.get((int)leftIndex).start2, rangeList.get((int)(rightIndex - 1)).end2);
            result.add(newRange);
            leftIndex = rightIndex;
        }
        return result;
    }

    private final Range createRange(Side $this$createRange, SemiOpenLineRange first, SemiOpenLineRange second) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$createRange.ordinal()]) {
            case 1 -> new Range(first.getStartLine(), first.getEndLine(), second.getStartLine(), second.getEndLine());
            case 2 -> new Range(second.getStartLine(), second.getEndLine(), first.getStartLine(), first.getEndLine());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final List<LineFragment> createLineFragments(Range range, FileInfoHolder fileInfoHolder, IgnorePolicy ignorePolicy, HighlightPolicy highlightPolicy, ProgressIndicator indicator) {
        ComparisonManagerImpl comparisonManagerImpl = ComparisonManagerImpl.getInstanceImpl();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManagerImpl, (String)"getInstanceImpl(...)");
        ComparisonManagerImpl manager = comparisonManagerImpl;
        List list = manager.compareLinesInner(range, fileInfoHolder.get(Side.LEFT).getFileText(), fileInfoHolder.get(Side.RIGHT).getFileText(), fileInfoHolder.get(Side.LEFT).getLineOffsets(), fileInfoHolder.get(Side.RIGHT).getLineOffsets(), ignorePolicy.getComparisonPolicy(), highlightPolicy.getFragmentsPolicy(), indicator);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLinesInner(...)");
        return list;
    }

    private static final FileInfoHolder getLineFragments$lambda$0(Project $project, CharSequence $textLeft, CharSequence $textRight) {
        return FileInfoHolder.Companion.create$intellij_properties_backend($project, $textLeft, $textRight);
    }

    private static final Comparable getLineFragments$lambda$1(Range it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.start1);
    }

    private static final Comparable getLineFragments$lambda$2(Range it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.start2);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

