/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.mass;

import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.icons.GrazieIcons;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieReplaceTypoQuickFix;
import com.intellij.grazie.ide.ui.PaddedListCellRenderer;
import com.intellij.grazie.ide.ui.mass.Change;
import com.intellij.grazie.ide.ui.mass.CompositeChange;
import com.intellij.grazie.ide.ui.mass.DocumentChange;
import com.intellij.grazie.ide.ui.mass.DocumentUndoManager;
import com.intellij.grazie.ide.ui.mass.GrazieMassApplyDialog;
import com.intellij.grazie.ide.ui.mass.GrazieMassApplyDialogKt;
import com.intellij.grazie.ide.ui.mass.HighlightedProblems;
import com.intellij.grazie.ide.ui.mass.Highlighting;
import com.intellij.grazie.ide.ui.mass.IgnoreChange;
import com.intellij.grazie.ide.ui.mass.MassOptions;
import com.intellij.grazie.text.ProofreadingProblems;
import com.intellij.grazie.text.TextProblem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.IconUtil;
import com.intellij.util.text.StringOperation;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\rH\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\b\u0010+\u001a\u00020'H\u0002J\u0012\u0010,\u001a\u00020'2\b\u0010-\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010.\u001a\u00020'H\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000)H\u0002J(\u00101\u001a\u00020'*\u0002022\u0006\u00103\u001a\u0002042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020706H\u0002J\u000e\u00108\u001a\u00020'2\u0006\u0010\f\u001a\u000209R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006:"}, d2={"Lcom/intellij/grazie/ide/ui/mass/GrazieMassApplyDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "file", "Lcom/intellij/psi/PsiFile;", "problems", "Lcom/intellij/grazie/text/ProofreadingProblems;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/grazie/text/ProofreadingProblems;)V", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "undoManager", "Lcom/intellij/grazie/ide/ui/mass/DocumentUndoManager;", "highlightings", "Lcom/intellij/grazie/ide/ui/mass/HighlightedProblems;", "massOptionComboBox", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/grazie/ide/ui/mass/MassOptions;", "kotlin.jvm.PlatformType", "getMassOptionComboBox", "()Lcom/intellij/ui/CollectionComboBoxModel;", "massOptionComboBox$delegate", "Lkotlin/Lazy;", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createToolbarComponent", "createDoAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "isUndo", "", "createEditor", "setupFolding", "", "textRanges", "", "Lcom/intellij/openapi/util/TextRange;", "setupHighlightings", "massApply", "options", "setupMouseListener", "getHighlightings", "Lcom/intellij/grazie/ide/ui/mass/Highlighting;", "labeledIcon", "Lcom/intellij/ui/dsl/builder/Row;", "icon", "Ljavax/swing/Icon;", "problemsExtractor", "Lkotlin/Function1;", "", "apply", "Lcom/intellij/openapi/editor/Editor;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieMassApplyDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieMassApplyDialog.kt\ncom/intellij/grazie/ide/ui/mass/GrazieMassApplyDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,566:1\n1#2:567\n1586#3:568\n1661#3,3:569\n1068#3:572\n1915#3,2:573\n1915#3:575\n812#3,12:576\n1916#3:588\n1586#3:589\n1661#3,2:590\n1586#3:592\n1661#3,3:593\n1586#3:596\n1661#3,3:597\n1586#3:600\n1661#3,2:601\n1391#3:603\n1480#3,5:604\n1586#3:609\n1661#3,3:610\n1663#3:613\n1663#3:614\n1915#3,2:615\n1033#3,2:617\n1915#3,2:619\n*S KotlinDebug\n*F\n+ 1 GrazieMassApplyDialog.kt\ncom/intellij/grazie/ide/ui/mass/GrazieMassApplyDialog\n*L\n158#1:568\n158#1:569,3\n164#1:572\n193#1:573,2\n205#1:575\n207#1:576,12\n205#1:588\n247#1:589\n247#1:590,2\n249#1:592\n249#1:593,3\n250#1:596\n250#1:597,3\n251#1:600\n251#1:601,2\n253#1:603\n253#1:604,5\n254#1:609\n254#1:610,3\n251#1:613\n247#1:614\n269#1:615,2\n275#1:617,2\n277#1:619,2\n*E\n"})
public final class GrazieMassApplyDialog
extends DialogWrapper {
    @NotNull
    private final String text;
    @NotNull
    private final ProofreadingProblems problems;
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final DocumentUndoManager undoManager;
    @NotNull
    private final HighlightedProblems highlightings;
    @NotNull
    private final Lazy massOptionComboBox$delegate;

    private final CollectionComboBoxModel<MassOptions> getMassOptionComboBox() {
        Lazy lazy = this.massOptionComboBox$delegate;
        return (CollectionComboBoxModel)lazy.getValue();
    }

    public GrazieMassApplyDialog(@NotNull PsiFile file, @NotNull ProofreadingProblems problems) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        super(file.getProject());
        this.highlightings = new HighlightedProblems(null, 1, null);
        this.massOptionComboBox$delegate = LazyKt.lazy(GrazieMassApplyDialog::massOptionComboBox_delegate$lambda$0);
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.text = string;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.problems = problems.filterOutDuplicatedTypos();
        this.editor = this.createEditor();
        this.undoManager = new DocumentUndoManager();
        this.massApply(MassOptions.SINGLE);
        this.setupMouseListener();
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> GrazieMassApplyDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Action[] createActions() {
        void $this$createActions_u24lambda_u240;
        Action action2;
        Action[] actionArray = new Action[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        Action action3 = action2 = this.getOKAction();
        int n = 1;
        Action[] actionArray2 = actionArray;
        boolean bl = false;
        $this$createActions_u24lambda_u240.putValue("Name", GrazieBundle.message("grazie.mass.apply.dialog.apply", new Object[0]));
        Unit unit = Unit.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"apply(...)");
        return actionArray;
    }

    private final JComponent createToolbarComponent() {
        ActionToolbar actionToolbar;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $this$createToolbarComponent_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$createToolbarComponent_u24lambda_u240.add(this.createDoAction(true));
        $this$createToolbarComponent_u24lambda_u240.add(this.createDoAction(false));
        DefaultActionGroup actionGroup = defaultActionGroup;
        ActionToolbar $this$createToolbarComponent_u24lambda_u241 = actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup, true);
        boolean bl2 = false;
        $this$createToolbarComponent_u24lambda_u241.setTargetComponent(this.editor.getComponent());
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar2;
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final AnAction createDoAction(boolean isUndo) {
        Icon icon;
        String text;
        String string = text = isUndo ? GrazieBundle.message("grazie.mass.apply.dialog.editor.undo", new Object[0]) : GrazieBundle.message("grazie.mass.apply.dialog.editor.redo", new Object[0]);
        if (isUndo) {
            icon = AllIcons.Diff.Revert;
        } else {
            Icon icon2 = AllIcons.Diff.Revert;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Revert");
            icon = IconUtil.flip((Icon)icon2, (boolean)true);
        }
        Icon icon3 = icon;
        Intrinsics.checkNotNull((Object)icon3);
        Icon icon4 = icon3;
        AnAction undoAction2 = new AnAction(text, icon4, isUndo, this){
            final /* synthetic */ boolean $isUndo;
            final /* synthetic */ GrazieMassApplyDialog this$0;
            {
                this.$isUndo = $isUndo;
                this.this$0 = $receiver;
                super($text, null, $icon);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$isUndo) {
                    GrazieMassApplyDialog.access$getUndoManager$p(this.this$0).undo();
                } else {
                    GrazieMassApplyDialog.access$getUndoManager$p(this.this$0).redo();
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.$isUndo ? GrazieMassApplyDialog.access$getUndoManager$p(this.this$0).isUndoAvailable() : GrazieMassApplyDialog.access$getUndoManager$p(this.this$0).isRedoAvailable());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        undoAction2.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)(isUndo ? "$Undo" : "$Redo")), this.editor.getComponent(), this.getDisposable());
        return undoAction2;
    }

    private final EditorEx createEditor() {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        EditorEx editorEx = DiffUtil.createEditor((Document)document2, (Project)this.project, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
        EditorEx editor = editorEx;
        editor.getComponent().setMinimumSize((Dimension)JBUI.size((int)500, (int)500));
        editor.getComponent().setPreferredSize((Dimension)JBUI.size((int)800, (int)500));
        Disposer.register((Disposable)this.getDisposable(), () -> GrazieMassApplyDialog.createEditor$lambda$0(editor));
        return editor;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupFolding(List<? extends TextRange> textRanges) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        int lines = this.editor.getDocument().getLineCount() - 1;
        Iterable iterable = textRanges;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextRange(Math.max(0, this.editor.getDocument().getLineNumber(it.getStartOffset()) - 2), Math.min(this.editor.getDocument().getLineNumber(it.getEndOffset()) + 2, lines)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List it = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        boolean bl = false;
        List textLineRanges = TextRangeUtil.mergeRanges((List)it, (int)1);
        CustomFoldRegionRenderer renderer2 = new CustomFoldRegionRenderer(){

            public int calcWidthInPixels(CustomFoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                return 0;
            }

            public int calcHeightInPixels(CustomFoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                return 0;
            }

            public void paint(CustomFoldRegion region, Graphics2D g, Rectangle2D targetRegion, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            }
        };
        this.editor.getFoldingModel().runBatchFoldingOperation(() -> GrazieMassApplyDialog.setupFolding$lambda$3(this, lines, textLineRanges, renderer2));
    }

    private final void setupHighlightings() {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        GrazieMassApplyDialogKt.access$addRangeHighlighter((Editor)this.editor, new TextRange(0, document.getTextLength()), GrazieMassApplyDialogKt.access$getBASE_TEXT_ATTRIBUTES$p());
        List<TextRange> textRanges = this.problems.getTextRanges();
        Iterable $this$forEach$iv = textRanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange range = (TextRange)element$iv;
            boolean bl = false;
            GrazieMassApplyDialogKt.access$addRangeHighlighter((Editor)this.editor, range, GrazieMassApplyDialogKt.access$getREGULAR_TEXT_ATTRIBUTES$p());
        }
        this.highlightings.update((Editor)this.editor, this.getHighlightings());
        this.setupFolding(textRanges);
    }

    /*
     * WARNING - void declaration
     */
    private final void massApply(MassOptions options) {
        if (options == null) {
            return;
        }
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)GrazieBundle.message("grazie.mass.apply.text.do", new Object[0]), null, () -> GrazieMassApplyDialog.massApply$lambda$0(document, this), (PsiFile[])new PsiFile[0]);
        this.setupHighlightings();
        Iterable $this$forEach$iv = this.highlightings.getProblems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Highlighting highlighting = (Highlighting)element$iv;
            boolean bl = false;
            Change changes = (Change)CollectionsKt.first(highlighting.getChanges());
            if (options != MassOptions.MULTIPLE) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = highlighting.getChanges();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof DocumentChange)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (((List)destination$iv$iv).size() != 1) continue;
            }
            changes.apply();
        }
        this.undoManager.clear();
    }

    private final void setupMouseListener() {
        this.editor.addEditorMouseListener(new EditorMouseListener(this){
            final /* synthetic */ GrazieMassApplyDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Highlighting highlighting = GrazieMassApplyDialog.access$getHighlightings$p(this.this$0).findHighlighting(event.getOffset());
                if (highlighting == null) {
                    return;
                }
                Highlighting highlighting2 = highlighting;
                JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(highlighting2.getChanges()).setSelectionMode(0).setRenderer((ListCellRenderer)new PaddedListCellRenderer()).setItemChosenCallback(arg_0 -> setupMouseListener.1.mouseClicked$lambda$1(arg_0 -> setupMouseListener.1.mouseClicked$lambda$0(highlighting2, this.this$0, arg_0), arg_0)).setNamerForFiltering(arg_0 -> setupMouseListener.1.mouseClicked$lambda$3(setupMouseListener.1::mouseClicked$lambda$2, arg_0)).createPopup();
                Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
                JBPopup popup = jBPopup;
                popup.showInBestPositionFor((Editor)GrazieMassApplyDialog.access$getEditor$p(this.this$0));
            }

            private static final void mouseClicked$lambda$0$0(Integer $changeIndex, Highlighting $highlighting, Change $chosenChange, GrazieMassApplyDialog this$0) {
                Change change;
                Change change2;
                Change change3 = change2 = $changeIndex != null ? $highlighting.getChanges().get($changeIndex) : null;
                if (change2 != null) {
                    Intrinsics.checkNotNull((Object)$chosenChange);
                    change = new CompositeChange(change2, $chosenChange);
                } else {
                    change = $chosenChange;
                }
                Change appliedChange = change;
                appliedChange.apply();
                DocumentUndoManager documentUndoManager = GrazieMassApplyDialog.access$getUndoManager$p(this$0);
                Intrinsics.checkNotNull((Object)appliedChange);
                documentUndoManager.trackChange(appliedChange);
            }

            private static final Unit mouseClicked$lambda$0(Highlighting $highlighting, GrazieMassApplyDialog this$0, Change chosenChange) {
                Integer changeIndex = $highlighting.findChangeIndex();
                int chosenChangeIndex = $highlighting.getChanges().indexOf(chosenChange);
                Integer n = changeIndex;
                int n2 = chosenChangeIndex;
                if (n != null && n == n2) {
                    return Unit.INSTANCE;
                }
                WriteCommandAction.runWriteCommandAction((Project)GrazieMassApplyDialog.access$getProject$p(this$0), (String)GrazieBundle.message("grazie.mass.apply.text.do", new Object[0]), null, () -> setupMouseListener.1.mouseClicked$lambda$0$0(changeIndex, $highlighting, chosenChange, this$0), (PsiFile[])new PsiFile[0]);
                return Unit.INSTANCE;
            }

            private static final void mouseClicked$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final String mouseClicked$lambda$2(Change it) {
                return it.toString();
            }

            private static final String mouseClicked$lambda$3(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<Highlighting> getHighlightings() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.problems.getProblems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            TextRange it;
            Collection collection;
            Iterable $this$mapTo$iv$iv3;
            Iterable $this$map$iv2;
            void problem;
            TextProblem textProblem = (TextProblem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List<TextRange> list = problem.getHighlightRanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
            Iterable iterable2 = list;
            boolean $i$f$map2 = false;
            void var12_14 = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                TextRange textRange = (TextRange)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(problem.getText().textRangeToFile(it));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            $i$f$map2 = false;
            $this$mapTo$iv$iv3 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                it = (TextRange)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                Editor editor = (Editor)this.editor;
                Intrinsics.checkNotNull((Object)it);
                collection.add(GrazieMassApplyDialogKt.access$addRangeHighlighter(editor, it, GrazieMassApplyDialogKt.access$getBOLD_TEXT_ATTRIBUTES$p()));
            }
            List highlightRanges = (List)destination$iv$iv2;
            List<TextProblem.Suggestion> list2 = problem.getSuggestions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSuggestions(...)");
            Iterable $this$map$iv3 = list2;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                void $this$mapTo$iv$iv4;
                void $this$map$iv4;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                void suggestion;
                TextProblem.Suggestion bl3 = (TextProblem.Suggestion)item$iv$iv3;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                List<StringOperation> list3 = suggestion.getChanges();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getChanges(...)");
                Iterable iterable3 = list3;
                boolean $i$f$flatMap = false;
                void var24_29 = $this$flatMap$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    StringOperation it2 = (StringOperation)element$iv$iv;
                    boolean bl5 = false;
                    TextRange textRange = it2.getRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRange(...)");
                    CharSequence charSequence = it2.getReplacement();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getReplacement(...)");
                    Iterable list$iv$iv = GrazieReplaceTypoQuickFix.toRangeReplacements(textRange, charSequence, (TextProblem)problem);
                    CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv4;
                boolean $i$f$map4 = false;
                $this$flatMapTo$iv$iv = $this$map$iv4;
                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv4 : $this$mapTo$iv$iv4) {
                    Pair pair = (Pair)item$iv$iv4;
                    Collection collection3 = destination$iv$iv4;
                    boolean bl6 = false;
                    TextRange range = (TextRange)pair.component1();
                    String replacement = (String)pair.component2();
                    collection3.add(TuplesKt.to((Object)range, (Object)replacement));
                }
                List replacements = (List)destination$iv$iv4;
                String string = suggestion.getPresentableText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableText(...)");
                collection.add(new DocumentChange(string, replacements, (Editor)this.editor, this.project));
            }
            List changes = (List)destination$iv$iv3;
            collection2.add(new Highlighting((TextProblem)problem, highlightRanges, CollectionsKt.plus((Collection)changes, (Object)new IgnoreChange((TextProblem)problem, (Change)CollectionsKt.firstOrNull((List)changes)))));
        }
        return (List)destination$iv$iv;
    }

    private final void labeledIcon(Row $this$labeledIcon, Icon icon, Function1<? super HighlightedProblems, Integer> problemsExtractor) {
        int problemCount = ((Number)problemsExtractor.invoke((Object)this.highlightings)).intValue();
        $this$labeledIcon.icon(icon).gap(RightGap.SMALL).visible(problemCount > 0);
        $this$labeledIcon.label(String.valueOf(problemCount)).gap(RightGap.SMALL).visible(problemCount > 0);
    }

    public final void apply(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.getExitCode() != 0) {
            return;
        }
        List replacements = new ArrayList();
        Iterable $this$forEach$iv = this.highlightings.getProblems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Highlighting highlighting = (Highlighting)element$iv;
            boolean bl = false;
            Integer n = highlighting.findChangeIndex();
            if (n == null) {
                continue;
            }
            int changeIndex = n;
            Change change = highlighting.getChanges().get(changeIndex);
            if (!(change instanceof DocumentChange)) continue;
            replacements.addAll((Collection)((DocumentChange)change).getOriginalReplacements());
        }
        List $this$sortByDescending$iv = replacements;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((TextRange)it.getFirst()).getStartOffset());
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextRange)it.getFirst()).getStartOffset()));
                }
            });
        }
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)GrazieBundle.message("grazie.mass.apply.text.do", new Object[0]), null, () -> GrazieMassApplyDialog.apply$lambda$2(replacements, editor), (PsiFile[])new PsiFile[0]);
    }

    private static final CollectionComboBoxModel massOptionComboBox_delegate$lambda$0() {
        return new CollectionComboBoxModel((List)MassOptions.getEntries());
    }

    private static final Unit createCenterPanel$lambda$0$0$0(GrazieMassApplyDialog this$0, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.massApply((MassOptions)((Object)this$0.getMassOptionComboBox().getSelected()));
        return Unit.INSTANCE;
    }

    private static final int createCenterPanel$lambda$0$0$1(HighlightedProblems it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStyle().size();
    }

    private static final int createCenterPanel$lambda$0$0$2(HighlightedProblems it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGrammar().size();
    }

    private static final int createCenterPanel$lambda$0$0$3(HighlightedProblems it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTypos().size();
    }

    private static final Unit createCenterPanel$lambda$0$1$0(GrazieMassApplyDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(GrazieMassApplyDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.getMassOptionComboBox()), null, (int)2, null).gap(RightGap.SMALL).onChanged(arg_0 -> GrazieMassApplyDialog.createCenterPanel$lambda$0$0$0(this$0, arg_0));
        $this$row.cell(this$0.createToolbarComponent()).gap(RightGap.SMALL);
        $this$row.label("").align((Align)AlignX.FILL.INSTANCE).resizableColumn();
        Icon icon = GrazieIcons.StyleSuggestion;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StyleSuggestion");
        this$0.labeledIcon($this$row, icon, (Function1<? super HighlightedProblems, Integer>)((Function1)GrazieMassApplyDialog::createCenterPanel$lambda$0$0$1));
        Icon icon2 = AllIcons.General.InspectionsGrammar;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InspectionsGrammar");
        this$0.labeledIcon($this$row, icon2, (Function1<? super HighlightedProblems, Integer>)((Function1)GrazieMassApplyDialog::createCenterPanel$lambda$0$0$2));
        Icon icon3 = AllIcons.General.InspectionsTypos;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"InspectionsTypos");
        this$0.labeledIcon($this$row, icon3, (Function1<? super HighlightedProblems, Integer>)((Function1)GrazieMassApplyDialog::createCenterPanel$lambda$0$0$3));
        $this$row.label(GrazieBundle.message("grazie.mass.apply.dialog.suggestions", new Object[0])).gap(RightGap.SMALL);
        $this$row.label(String.valueOf(this$0.highlightings.getSuggestions())).gap(RightGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(GrazieMassApplyDialog this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> GrazieMassApplyDialog.createCenterPanel$lambda$0$1$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(GrazieMassApplyDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.setTitle(GrazieBundle.message("grazie.mass.apply.dialog.title", new Object[0]));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GrazieMassApplyDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.group$default((Panel)$this$panel, (String)GrazieBundle.message("grazie.mass.apply.dialog.editor.title", new Object[0]), (boolean)false, arg_0 -> GrazieMassApplyDialog.createCenterPanel$lambda$0$1(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void createEditor$lambda$0(EditorEx $editor) {
        EditorFactory.getInstance().releaseEditor((Editor)$editor);
    }

    private static final void setupFolding$lambda$3(GrazieMassApplyDialog this$0, int $lines, List $textLineRanges, setupFolding.renderer.1 $renderer) {
        this$0.editor.getFoldingModel().clearFoldRegions();
        for (TextRange region : TextRangeUtil.excludeRanges((TextRange)new TextRange(0, $lines), (List)$textLineRanges)) {
            this$0.editor.getFoldingModel().addCustomLinesFolding(region.getStartOffset(), region.getEndOffset(), (CustomFoldRegionRenderer)$renderer);
            FoldRegion currentRegion = FoldingModelSupport.addFolding((EditorEx)this$0.editor, (int)region.getStartOffset(), (int)region.getEndOffset(), (boolean)false);
            if (currentRegion == null) continue;
            DiffDrawUtil.createLineSeparatorHighlighter((Editor)((Editor)this$0.editor), (int)this$0.editor.getDocument().getLineStartOffset(region.getStartOffset()), (int)this$0.editor.getDocument().getLineEndOffset(region.getEndOffset()));
        }
    }

    private static final void massApply$lambda$0(DocumentEx $document, GrazieMassApplyDialog this$0) {
        $document.replaceString(0, $document.getTextLength(), (CharSequence)this$0.text);
    }

    private static final void apply$lambda$2(List $replacements, Editor $editor) {
        Iterable $this$forEach$iv = $replacements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            TextRange range = (TextRange)pair.component1();
            String text = (String)pair.component2();
            $editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
        }
    }

    public static final /* synthetic */ DocumentUndoManager access$getUndoManager$p(GrazieMassApplyDialog $this) {
        return $this.undoManager;
    }

    public static final /* synthetic */ HighlightedProblems access$getHighlightings$p(GrazieMassApplyDialog $this) {
        return $this.highlightings;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(GrazieMassApplyDialog $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Project access$getProject$p(GrazieMassApplyDialog $this) {
        return $this.project;
    }
}

