/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/text/CommitProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "<init>", "()V", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "isCasingIssue", "text", "", "range", "Lcom/intellij/openapi/util/TextRange;", "shouldIgnoreTypo", "isCommitMessage", "isSingleLowercaseSentence", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCommitProblemFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitProblemFilter.kt\ncom/intellij/grazie/text/CommitProblemFilter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,46:1\n1276#2,2:47\n*S KotlinDebug\n*F\n+ 1 CommitProblemFilter.kt\ncom/intellij/grazie/text/CommitProblemFilter\n*L\n34#1:47,2\n*E\n"})
public final class CommitProblemFilter
extends ProblemFilter {
    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!this.isCommitMessage(problem)) {
            return false;
        }
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        TextContent text = textContent;
        int stripOffset = HighlightingUtil.stripPrefix(text);
        List<TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        TextRange range = (TextRange)CollectionsKt.first(list);
        if (range.getStartOffset() < stripOffset) {
            CharSequence charSequence = text;
            Intrinsics.checkNotNull((Object)range);
            return this.isCasingIssue(charSequence, range, problem);
        }
        CharSequence strippedText = text.subSequence(stripOffset, text.length());
        TextRange textRange = range.shiftLeft(stripOffset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
        TextRange shiftedRange = textRange;
        if (!this.isSingleLowercaseSentence(strippedText, shiftedRange)) {
            return false;
        }
        return this.isCasingIssue(strippedText, shiftedRange, problem);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCasingIssue(CharSequence text, TextRange range, TextProblem problem) {
        boolean bl;
        block1: {
            void $this$any$iv;
            String phrase = ((Object)range.subSequence(text)).toString();
            List<TextProblem.Suggestion> list = problem.getSuggestions();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
            Sequence sequence2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), CommitProblemFilter::isCasingIssue$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.equals((String)it, (String)phrase, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean shouldIgnoreTypo(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        return this.shouldIgnore(problem);
    }

    private final boolean isCommitMessage(TextProblem problem) {
        return problem.getText().getDomain() == TextContent.TextDomain.PLAIN_TEXT && CommitMessage.isCommitMessage((PsiElement)((PsiElement)problem.getText().getContainingFile()));
    }

    private final boolean isSingleLowercaseSentence(CharSequence text, TextRange range) {
        CharSequence charSequence = Text.findParagraphRange(text, range).subSequence(text);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        CharSequence paragraphText = charSequence;
        return Text.isSingleSentence(paragraphText) && HighlightingUtil.isLowercase(paragraphText);
    }

    private static final String isCasingIssue$lambda$0(TextProblem.Suggestion it) {
        return it.getPresentableText();
    }
}

