/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J\n\u0010\"\u001a\u00020\u0005*\u00020\u000fJ\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/grazie/utils/Text;", "", "<init>", "()V", "isNewline", "", "char", "", "PUNCTUATIONS", "", "", "isPunctuation", "isQuote", "isSingleSentence", "text", "", "findParagraphRange", "Lcom/intellij/openapi/util/TextRange;", "range", "id", "", "assignment", "idChain", "pyFString", "call", "commonCharEscape", "keyColonValue", "cSharpTypeOrValueTuple", "cSharpGenericTypeParameter", "cSharpGenericMethod", "scalaTodo", "codeLikePattern", "Lkotlin/text/Regex;", "javaVariable", "looksLikeCode", "allOccurrences", "", "pattern", "Ljava/util/regex/Pattern;", "alignToWordBounds", "textRange", "expandToTouchWords", "Latin", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nTextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextUtils.kt\ncom/intellij/grazie/utils/Text\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,184:1\n1123#2,3:185\n1123#2,3:188\n1107#2,2:191\n*S KotlinDebug\n*F\n+ 1 TextUtils.kt\ncom/intellij/grazie/utils/Text\n*L\n38#1:185,3\n46#1:188,3\n77#1:191,2\n*E\n"})
public final class Text {
    @NotNull
    public static final Text INSTANCE = new Text();
    @NotNull
    private static final Set<Byte> PUNCTUATIONS;
    @NotNull
    private static final String id = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    @NotNull
    private static final String assignment = "= ['\"]";
    @NotNull
    private static final String idChain = "[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*";
    @NotNull
    private static final String pyFString = "\\bf\"";
    @NotNull
    private static final String call = "[a-zA-Z_$][a-zA-Z0-9_$]*\\(.*\\)";
    @NotNull
    private static final String commonCharEscape = "\\\\[ntbru]";
    @NotNull
    private static final String keyColonValue = "\n *[a-zA-Z0-9_$'\"-]+: *[a-zA-Z0-9_$'\"-]+";
    @NotNull
    private static final String cSharpTypeOrValueTuple = "([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\))";
    @NotNull
    private static final String cSharpGenericTypeParameter = "(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\)))";
    @NotNull
    private static final String cSharpGenericMethod = "[a-zA-Z_$][a-zA-Z0-9_$]*\\<(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\)))(, *(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\))))*\\>\\(";
    @NotNull
    private static final String scalaTodo = "= ?\\?\\?\\?";
    @NotNull
    private static final Regex codeLikePattern;
    @NotNull
    private static final Regex javaVariable;

    private Text() {
    }

    public final boolean isNewline(char c) {
        return c == '\n';
    }

    public final boolean isPunctuation(char c) {
        byte by = (byte)Character.getType(c);
        return PUNCTUATIONS.contains(by);
    }

    public final boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    @JvmStatic
    public static final boolean isSingleSentence(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        return !new Regex("[.?!]\\s").containsMatchIn(charSequence);
    }

    @JvmStatic
    @NotNull
    public static final TextRange findParagraphRange(@NotNull CharSequence text, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int start = range.getStartOffset();
        while (start > 0) {
            int wsStart;
            for (wsStart = start; wsStart > 0 && CharsKt.isWhitespace((char)text.charAt(wsStart - 1)); --wsStart) {
            }
            if (wsStart < start) {
                CharSequence $this$count$iv = text.subSequence(wsStart, start);
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > true) break;
            }
            start = wsStart - 1;
        }
        int end = range.getEndOffset();
        while (end < text.length()) {
            int wsEnd;
            for (wsEnd = end; wsEnd < text.length() && CharsKt.isWhitespace((char)text.charAt(wsEnd)); ++wsEnd) {
            }
            if (wsEnd > end) {
                CharSequence $this$count$iv = text.subSequence(end, wsEnd);
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > true) break;
            }
            end = wsEnd + 1;
        }
        return new TextRange(RangesKt.coerceAtLeast((int)start, (int)0), RangesKt.coerceAtMost((int)end, (int)text.length()));
    }

    public final boolean looksLikeCode(@NotNull CharSequence $this$looksLikeCode) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$looksLikeCode, (String)"<this>");
            if (Regex.find$default((Regex)codeLikePattern, (CharSequence)$this$looksLikeCode, (int)0, (int)2, null) != null) {
                return true;
            }
            MatchResult matcher = Regex.find$default((Regex)javaVariable, (CharSequence)$this$looksLikeCode, (int)0, (int)2, null);
            if (matcher != null) {
                MatchGroup matchGroup = matcher.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String string = matchGroup.getValue();
                MatchGroup matchGroup2 = matcher.getGroups().get(3);
                Intrinsics.checkNotNull((Object)matchGroup2);
                String string2 = matchGroup2.getValue().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                    return true;
                }
            }
            CharSequence $this$any$iv = $this$looksLikeCode;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(it > '\u007f')) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        int codeChars = 0;
        int textTokens = 0;
        boolean inToken = false;
        for (int i = 0; i < $this$looksLikeCode.length(); ++i) {
            char c = $this$looksLikeCode.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (inToken) continue;
                inToken = true;
                ++textTokens;
                continue;
            }
            inToken = false;
            if (!StringsKt.contains$default((CharSequence)"(){}[]<>=+-*/%|&!;,.:\\@$#^", (char)c, (boolean)false, (int)2, null)) continue;
            ++codeChars;
        }
        return codeChars > 0 && textTokens < codeChars;
    }

    @JvmStatic
    @NotNull
    public static final List<TextRange> allOccurrences(@NotNull Pattern pattern, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int start = 0;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        Matcher matcher = pattern.matcher(text);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        while (matcher2.find(start)) {
            result.add(new TextRange(matcher2.start(), matcher2.end()));
            start = RangesKt.coerceAtLeast((int)matcher2.end(), (int)(start + 1));
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final TextRange alignToWordBounds(@NotNull TextRange textRange, @NotNull CharSequence text) {
        int end;
        int start;
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        for (start = textRange.getStartOffset(); start > 0 && Text.alignToWordBounds$isWordChar(text.charAt(start - 1)); --start) {
        }
        for (end = textRange.getEndOffset(); end < text.length() && Text.alignToWordBounds$isWordChar(text.charAt(end)); ++end) {
        }
        return new TextRange(start, end);
    }

    @JvmStatic
    @NotNull
    public static final TextRange expandToTouchWords(@NotNull CharSequence text, @NotNull TextRange range) {
        int start;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int end = range.getEndOffset();
        for (start = range.getStartOffset(); start > 0 && Text.expandToTouchWords$shouldSkip(text.charAt(start - 1)); --start) {
        }
        while (end < text.length() && Text.expandToTouchWords$shouldSkip(text.charAt(end))) {
            ++end;
        }
        return new TextRange(start, end);
    }

    private static final boolean alignToWordBounds$isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '-';
    }

    private static final boolean expandToTouchWords$shouldSkip(char c) {
        return CharsKt.isWhitespace((char)c) || c == '\'' || c == '\"';
    }

    static {
        Object[] objectArray = new Byte[]{(byte)21, (byte)22, (byte)24, (byte)23, (byte)20, (byte)29, (byte)30};
        PUNCTUATIONS = SetsKt.setOf((Object[])objectArray);
        codeLikePattern = new Regex("= ['\"]|[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*|\\bf\"|[a-zA-Z_$][a-zA-Z0-9_$]*\\(.*\\)|\\\\[ntbru]|\n *[a-zA-Z0-9_$'\"-]+: *[a-zA-Z0-9_$'\"-]+|[a-zA-Z_$][a-zA-Z0-9_$]*\\<(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\)))(, *(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\))))*\\>\\(|= ?\\?\\?\\?");
        javaVariable = new Regex("\\b([A-Z])([a-zA-Z_$][a-zA-Z0-9_$]*) ([a-z])(\\2) ?[;:,)=]");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/utils/Text$Latin;", "", "<init>", "()V", "endSentence", "", "", "partSentence", "isEndPunctuation", "", "symbol", "line", "", "isPartPunctuation", "intellij.grazie.core"})
    public static final class Latin {
        @NotNull
        public static final Latin INSTANCE = new Latin();
        @NotNull
        private static final Set<Character> endSentence;
        @NotNull
        private static final Set<Character> partSentence;

        private Latin() {
        }

        public final boolean isEndPunctuation(char symbol) {
            return endSentence.contains(Character.valueOf(symbol));
        }

        public final boolean isEndPunctuation(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return CollectionsKt.contains((Iterable)endSentence, (Object)StringsKt.lastOrNull((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()));
        }

        public final boolean isPartPunctuation(char symbol) {
            return partSentence.contains(Character.valueOf(symbol));
        }

        public final boolean isPartPunctuation(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return CollectionsKt.contains((Iterable)partSentence, (Object)StringsKt.lastOrNull((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()));
        }

        static {
            Object[] objectArray = new Character[]{Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('.')};
            endSentence = SetsKt.setOf((Object[])objectArray);
            objectArray = new Character[]{Character.valueOf(','), Character.valueOf(';')};
            partSentence = SetsKt.setOf((Object[])objectArray);
        }
    }
}

