/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestsLocationProviderUtil {
    private static final int MIN_PROXIMITY_THRESHOLD = 1;

    private TestsLocationProviderUtil() {
    }

    public static List<VirtualFile> findSuitableFilesFor(String filePath, Project project) {
        VirtualFile file = TestsLocationProviderUtil.getByFullPath(filePath);
        if (file != null) {
            return Collections.singletonList(file);
        }
        LinkedList<String> folders = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(filePath, "/", false);
        String fileName = null;
        while (st.hasMoreTokens()) {
            String pathComponent = st.nextToken();
            if (st.hasMoreTokens()) {
                folders.addFirst(pathComponent);
                continue;
            }
            fileName = pathComponent;
        }
        if (fileName == null) {
            return Collections.emptyList();
        }
        return TestsLocationProviderUtil.findFilesClosestToTarget(folders, TestsLocationProviderUtil.collectCandidates(project, fileName, true), 1);
    }

    @NotNull
    public static List<VirtualFile> findFilesClosestToTarget(@NotNull List<String> targetParentFolders, @NotNull List<? extends FileInfo> candidates, int minProximityThreshold) {
        if (targetParentFolders == null) {
            TestsLocationProviderUtil.$$$reportNull$$$0(0);
        }
        if (candidates == null) {
            TestsLocationProviderUtil.$$$reportNull$$$0(1);
        }
        if (candidates.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                TestsLocationProviderUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        for (String string : targetParentFolders) {
            for (FileInfo fileInfo : candidates) {
                fileInfo.processRelativePathComponent(string);
            }
        }
        int maxProximity = 0;
        for (FileInfo fileInfo : candidates) {
            int n = fileInfo.getProximity();
            if (n <= maxProximity) continue;
            maxProximity = n;
        }
        if (maxProximity >= minProximityThreshold) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            for (FileInfo fileInfo : candidates) {
                if (fileInfo.getProximity() != maxProximity) continue;
                arrayList.add(fileInfo.getFile());
            }
            ArrayList<VirtualFile> arrayList2 = arrayList;
            if (arrayList2 == null) {
                TestsLocationProviderUtil.$$$reportNull$$$0(3);
            }
            return arrayList2;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            TestsLocationProviderUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static List<FileInfo> collectCandidates(Project project, String fileName, boolean includeNonProjectItems) {
        ArrayList<FileInfo> filesInfo = new ArrayList<FileInfo>();
        for (ChooseByNameContributor contributor : ChooseByNameContributor.FILE_EP_NAME.getExtensionList()) {
            NavigationItem[] navigationItems;
            for (NavigationItem navigationItem : navigationItems = contributor.getItemsByName(fileName, fileName, project, includeNonProjectItems)) {
                if (!(navigationItem instanceof PsiFile)) continue;
                VirtualFile itemFile = ((PsiFile)navigationItem).getVirtualFile();
                assert (itemFile != null);
                filesInfo.add(new FileInfo(itemFile));
            }
        }
        return filesInfo;
    }

    @Nullable
    private static VirtualFile getByFullPath(String filePath) {
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (fileByPath != null) {
            return fileByPath;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(filePath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetParentFolders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/TestsLocationProviderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/TestsLocationProviderUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesClosestToTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFilesClosestToTarget";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class FileInfo {
        private final VirtualFile myFile;
        private VirtualFile myCurrentFolder;
        private int myProximity = 0;

        public FileInfo(VirtualFile file) {
            this.myFile = file;
            this.myCurrentFolder = this.myFile.getParent();
        }

        public void processRelativePathComponent(String folderName) {
            if (this.myCurrentFolder == null) {
                return;
            }
            if (!folderName.equals(this.myCurrentFolder.getName())) {
                this.myCurrentFolder = null;
                return;
            }
            ++this.myProximity;
            this.myCurrentFolder = this.myCurrentFolder.getParent();
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getProximity() {
            return this.myProximity;
        }
    }
}

