/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a7\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\rH\u0000\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"putWcDbFilesToVfs", "", "infos", "", "Lorg/jetbrains/idea/svn/RootUrlInfo;", "computeAfterUpdateChanges", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lkotlinx/coroutines/CoroutineScope;", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.vcs.svn"})
public final class SvnUtilKtKt {
    public static final void putWcDbFilesToVfs(@NotNull Collection<RootUrlInfo> infos) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        List wcDbFiles = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)infos), SvnUtilKtKt::putWcDbFilesToVfs$lambda$0), SvnUtilKtKt::putWcDbFilesToVfs$lambda$1), SvnUtilKtKt::putWcDbFilesToVfs$lambda$2));
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)wcDbFiles, true, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <T> T computeAfterUpdateChanges(@NotNull Project project, @NotNull CoroutineScope parent, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AsyncPromise promise = new AsyncPromise();
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        AtomicBoolean afterUpdateStarted = new AtomicBoolean();
        Function0 afterUpdateTracker = () -> SvnUtilKtKt.computeAfterUpdateChanges$lambda$0(promise, indicator, afterUpdateStarted);
        DisposableHandle handle = JobKt.getJob((CoroutineContext)parent.getCoroutineContext()).invokeOnCompletion(arg_0 -> SvnUtilKtKt.computeAfterUpdateChanges$lambda$1(afterUpdateTracker, arg_0));
        try {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(false, () -> SvnUtilKtKt.computeAfterUpdateChanges$lambda$2(afterUpdateStarted, indicator, promise, block));
            Object object = promise.get();
            return (T)object;
        }
        finally {
            handle.dispose();
        }
    }

    private static final boolean putWcDbFilesToVfs$lambda$0(RootUrlInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
    }

    private static final boolean putWcDbFilesToVfs$lambda$1(RootUrlInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NestedCopyType.switched != it.getType();
    }

    private static final File putWcDbFilesToVfs$lambda$2(RootUrlInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SvnUtil.getWcDb(it.getIoFile());
    }

    private static final void computeAfterUpdateChanges$lambda$2$0(AsyncPromise $promise, Function0 $block) {
        $promise.setResult($block.invoke());
    }

    private static final Unit computeAfterUpdateChanges$lambda$0(AsyncPromise $promise, DelegatingProgressIndicator $indicator, AtomicBoolean $afterUpdateStarted) {
        if ($promise.isDone()) {
            return Unit.INSTANCE;
        }
        if ($indicator.isRunning()) {
            $indicator.cancel();
        }
        if (!$afterUpdateStarted.get()) {
            $promise.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final Unit computeAfterUpdateChanges$lambda$1(Function0 $afterUpdateTracker, Throwable it) {
        $afterUpdateTracker.invoke();
        return Unit.INSTANCE;
    }

    private static final void computeAfterUpdateChanges$lambda$2(AtomicBoolean $afterUpdateStarted, DelegatingProgressIndicator $indicator, AsyncPromise $promise, Function0 $block) {
        try {
            $afterUpdateStarted.set(true);
            $indicator.checkCanceled();
            ProgressManager.getInstance().runProcess(() -> SvnUtilKtKt.computeAfterUpdateChanges$lambda$2$0($promise, $block), (ProgressIndicator)$indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
            $promise.cancel();
        }
        catch (Throwable e) {
            $promise.setError(e);
        }
    }
}

