/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.ConflictAction;
import org.jetbrains.idea.svn.conflict.ConflictOperation;
import org.jetbrains.idea.svn.conflict.ConflictReason;
import org.jetbrains.idea.svn.conflict.ConflictVersion;
import org.jetbrains.idea.svn.conflict.ConflictVersionWithSide;
import org.jetbrains.idea.svn.conflict.TreeConflictDescriptionKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0007R\u0016\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription;", "Lorg/jetbrains/idea/svn/api/BaseNodeDescription;", "builder", "Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription$Builder;", "base", "Ljava/io/File;", "<init>", "(Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription$Builder;Ljava/io/File;)V", "path", "Lorg/jetbrains/annotations/NotNull;", "getPath", "()Ljava/io/File;", "conflictAction", "Lorg/jetbrains/idea/svn/conflict/ConflictAction;", "getConflictAction", "()Lorg/jetbrains/idea/svn/conflict/ConflictAction;", "conflictReason", "Lorg/jetbrains/idea/svn/conflict/ConflictReason;", "getConflictReason", "()Lorg/jetbrains/idea/svn/conflict/ConflictReason;", "operation", "Lorg/jetbrains/idea/svn/conflict/ConflictOperation;", "getOperation", "()Lorg/jetbrains/idea/svn/conflict/ConflictOperation;", "sourceLeftVersion", "Lorg/jetbrains/idea/svn/conflict/ConflictVersion;", "getSourceLeftVersion", "()Lorg/jetbrains/idea/svn/conflict/ConflictVersion;", "sourceRightVersion", "getSourceRightVersion", "toPresentableString", "", "Builder", "intellij.vcs.svn"})
public final class TreeConflictDescription
extends BaseNodeDescription {
    @NotNull
    private final File path;
    @NotNull
    private final ConflictAction conflictAction;
    @NotNull
    private final ConflictReason conflictReason;
    @NotNull
    private final ConflictOperation operation;
    @Nullable
    private final ConflictVersion sourceLeftVersion;
    @Nullable
    private final ConflictVersion sourceRightVersion;

    private TreeConflictDescription(Builder builder, File base) {
        super(builder.getKind());
        File file = SvnUtil.resolvePath(base, builder.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolvePath(...)");
        this.path = file;
        this.conflictAction = builder.getAction();
        this.conflictReason = builder.getReason();
        this.operation = builder.getOperation();
        this.sourceLeftVersion = builder.getSourceLeftVersion();
        this.sourceRightVersion = builder.getSourceRightVersion();
    }

    @NotNull
    public final File getPath() {
        return this.path;
    }

    @NotNull
    public final ConflictAction getConflictAction() {
        return this.conflictAction;
    }

    @NotNull
    public final ConflictReason getConflictReason() {
        return this.conflictReason;
    }

    @NotNull
    public final ConflictOperation getOperation() {
        return this.operation;
    }

    @Nullable
    public final ConflictVersion getSourceLeftVersion() {
        return this.sourceLeftVersion;
    }

    @Nullable
    public final ConflictVersion getSourceRightVersion() {
        return this.sourceRightVersion;
    }

    @Nls
    @NotNull
    public final String toPresentableString() {
        Object[] objectArray = new Object[]{TreeConflictDescriptionKt.access$getDisplayName(this.conflictReason), TreeConflictDescriptionKt.access$getDisplayName(this.conflictAction), TreeConflictDescriptionKt.access$getDisplayName(this.operation)};
        String string = SvnBundle.message("tree.conflict.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public /* synthetic */ TreeConflictDescription(Builder builder, File base, DefaultConstructorMarker $constructor_marker) {
        this(builder, base);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="tree-conflict")
    @XmlRootElement(name="tree-conflict")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010%\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(\u00a8\u00060"}, d2={"Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription$Builder;", "", "<init>", "()V", "path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "kind", "Lorg/jetbrains/idea/svn/api/NodeKind;", "getKind", "()Lorg/jetbrains/idea/svn/api/NodeKind;", "setKind", "(Lorg/jetbrains/idea/svn/api/NodeKind;)V", "operation", "Lorg/jetbrains/idea/svn/conflict/ConflictOperation;", "getOperation", "()Lorg/jetbrains/idea/svn/conflict/ConflictOperation;", "setOperation", "(Lorg/jetbrains/idea/svn/conflict/ConflictOperation;)V", "action", "Lorg/jetbrains/idea/svn/conflict/ConflictAction;", "getAction", "()Lorg/jetbrains/idea/svn/conflict/ConflictAction;", "setAction", "(Lorg/jetbrains/idea/svn/conflict/ConflictAction;)V", "reason", "Lorg/jetbrains/idea/svn/conflict/ConflictReason;", "getReason", "()Lorg/jetbrains/idea/svn/conflict/ConflictReason;", "setReason", "(Lorg/jetbrains/idea/svn/conflict/ConflictReason;)V", "versions", "", "Lorg/jetbrains/idea/svn/conflict/ConflictVersionWithSide;", "sourceLeftVersion", "Lorg/jetbrains/idea/svn/conflict/ConflictVersion;", "getSourceLeftVersion", "()Lorg/jetbrains/idea/svn/conflict/ConflictVersion;", "sourceRightVersion", "getSourceRightVersion", "build", "Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription;", "base", "Ljava/io/File;", "Companion", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nTreeConflictDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeConflictDescription.kt\norg/jetbrains/idea/svn/conflict/TreeConflictDescription$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @XmlAttribute(name="victim")
        @NotNull
        private String path = "";
        @XmlAttribute
        @NotNull
        private NodeKind kind = NodeKind.UNKNOWN;
        @XmlAttribute
        @NotNull
        private ConflictOperation operation = ConflictOperation.NONE;
        @XmlAttribute
        @NotNull
        private ConflictAction action = ConflictAction.ADD;
        @XmlAttribute
        @NotNull
        private ConflictReason reason = ConflictReason.ADDED;
        @XmlElement(name="version")
        @NotNull
        private final List<ConflictVersionWithSide> versions = new ArrayList();
        @NonNls
        @NotNull
        private static final String SOURCE_LEFT_SIDE = "source-left";
        @NonNls
        @NotNull
        private static final String SOURCE_RIGHT_SIDE = "source-right";

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final NodeKind getKind() {
            return this.kind;
        }

        public final void setKind(@NotNull NodeKind nodeKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)nodeKind), (String)"<set-?>");
            this.kind = nodeKind;
        }

        @NotNull
        public final ConflictOperation getOperation() {
            return this.operation;
        }

        public final void setOperation(@NotNull ConflictOperation conflictOperation) {
            Intrinsics.checkNotNullParameter((Object)((Object)conflictOperation), (String)"<set-?>");
            this.operation = conflictOperation;
        }

        @NotNull
        public final ConflictAction getAction() {
            return this.action;
        }

        public final void setAction(@NotNull ConflictAction conflictAction) {
            Intrinsics.checkNotNullParameter((Object)((Object)conflictAction), (String)"<set-?>");
            this.action = conflictAction;
        }

        @NotNull
        public final ConflictReason getReason() {
            return this.reason;
        }

        public final void setReason(@NotNull ConflictReason conflictReason) {
            Intrinsics.checkNotNullParameter((Object)((Object)conflictReason), (String)"<set-?>");
            this.reason = conflictReason;
        }

        @Nullable
        public final ConflictVersion getSourceLeftVersion() {
            Object v0;
            block1: {
                Iterable iterable = this.versions;
                for (Object t : iterable) {
                    ConflictVersionWithSide it = (ConflictVersionWithSide)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSide(), (Object)SOURCE_LEFT_SIDE)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            ConflictVersionWithSide conflictVersionWithSide = v0;
            return conflictVersionWithSide != null ? conflictVersionWithSide.build() : null;
        }

        @Nullable
        public final ConflictVersion getSourceRightVersion() {
            Object v0;
            block1: {
                Iterable iterable = this.versions;
                for (Object t : iterable) {
                    ConflictVersionWithSide it = (ConflictVersionWithSide)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSide(), (Object)SOURCE_RIGHT_SIDE)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            ConflictVersionWithSide conflictVersionWithSide = v0;
            return conflictVersionWithSide != null ? conflictVersionWithSide.build() : null;
        }

        @NotNull
        public final TreeConflictDescription build(@NotNull File base) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            return new TreeConflictDescription(this, base, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/svn/conflict/TreeConflictDescription$Builder$Companion;", "", "<init>", "()V", "SOURCE_LEFT_SIDE", "", "SOURCE_RIGHT_SIDE", "intellij.vcs.svn"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

