/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.javaee.el.ImplicitVariableWithCustomResolve;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.el.SpringElContextVariable;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringIntegrationELContextVariables
extends SpringElContextsExtension {
    private static final List<String> ANNOTATIONS = List.of("org.springframework.messaging.handler.annotation.Payload", "org.springframework.integration.annotation.Payload");

    SpringIntegrationELContextVariables() {
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement psiElement) {
        PsiElement context;
        if (psiElement == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(0);
        }
        if ((context = psiElement.getContext()) == null || !SpringIntegrationELContextVariables.isIntegrationAnnotation(context)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringIntegrationELContextVariables.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList variables = new SmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        if (method != null) {
            variables.addAll(Arrays.asList(method.getParameterList().getParameters()));
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)context, PsiAnnotation.class);
            if (annotation != null) {
                SpringIntegrationELContextVariables.addPayloadVariables(annotation, (Collection<? super PsiVariable>)variables, method);
            }
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static void addPayloadVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<? super PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(3);
        }
        if (variables == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(4);
        }
        if (method == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(5);
        }
        if (ANNOTATIONS.contains(annotation.getQualifiedName())) {
            PsiType returnType = method.getReturnType();
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnType != null && returnTypeElement != null) {
                variables.add((PsiVariable)new SpringElContextVariable("return", returnType, (PsiElement)returnTypeElement));
                PsiType mapType = PsiTypeUtil.getInstance((Project)method.getProject()).findType(Map.class);
                if (mapType != null) {
                    variables.add((PsiVariable)new ArgsImplicitVariable(method, mapType));
                }
            }
        }
    }

    private static boolean isIntegrationAnnotation(@NotNull PsiElement context) {
        UElement element;
        if (context == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(6);
        }
        if ((element = UastContextKt.toUElement((PsiElement)context)) == null) {
            return false;
        }
        UAnnotation annotation = (UAnnotation)UastUtils.getParentOfType((UElement)element, UAnnotation.class);
        return annotation != null && ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/injection/el/SpringIntegrationELContextVariables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/injection/el/SpringIntegrationELContextVariables";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPayloadVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIntegrationAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class ArgsImplicitVariable
    extends SpringElContextVariable
    implements ImplicitVariableWithCustomResolve {
        private final PsiMethod myMethod;

        ArgsImplicitVariable(@NotNull PsiMethod method, @NotNull PsiType mapType) {
            if (method == null) {
                ArgsImplicitVariable.$$$reportNull$$$0(0);
            }
            if (mapType == null) {
                ArgsImplicitVariable.$$$reportNull$$$0(1);
            }
            super("args", mapType, (PsiElement)method.getParameterList());
            this.myMethod = method;
        }

        public boolean process(ELExpression element, ELElementProcessor processor) {
            for (PsiParameter variable : this.myMethod.getParameterList().getParameters()) {
                if (!processor.processVariable((PsiVariable)variable)) break;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/integration/injection/el/SpringIntegrationELContextVariables$ArgsImplicitVariable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

