/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.editor.fonts.AppFontOptionsPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u0006\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0016\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0014J\b\u0010\u0011\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel;", "Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "restoreDefaults", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/ActionLink;", "createCustomComponent", "Ljavax/swing/JComponent;", "", "updateFontPreferences", "createBoldFontHint", "Lkotlin/Pair;", "", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "navigateToColorSchemeTextSettings", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AppEditorFontOptionsPanel
extends AppFontOptionsPanel {
    private Cell<? extends ActionLink> restoreDefaults;

    public AppEditorFontOptionsPanel(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        super(scheme);
    }

    @Override
    @NotNull
    protected JComponent createCustomComponent() {
        return (JComponent)BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> AppEditorFontOptionsPanel.createCustomComponent$lambda$0(this, arg_0)));
    }

    private final void restoreDefaults() {
        FontPreferences fontPreferences = this.getFontPreferences();
        Intrinsics.checkNotNull((Object)fontPreferences, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.ModifiableFontPreferences");
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)((ModifiableFontPreferences)fontPreferences));
        this.updateOnChangedFont();
    }

    @Override
    public void updateFontPreferences() {
        Cell<? extends ActionLink> cell = this.restoreDefaults;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"restoreDefaults");
            cell = null;
        }
        cell.enabled(!Intrinsics.areEqual((Object)this.getDefaultPreferences(), (Object)this.getFontPreferences()));
        super.updateFontPreferences();
    }

    @Override
    @NotNull
    protected Pair<String, HyperlinkEventAction> createBoldFontHint() {
        return new Pair((Object)ApplicationBundle.message((String)"settings.editor.font.bold.weight.hint", (Object[])new Object[0]), arg_0 -> AppEditorFontOptionsPanel.createBoldFontHint$lambda$0(this, arg_0));
    }

    private final void navigateToColorSchemeTextSettings() {
        Configurable generalSettings;
        Configurable colorSchemeConfigurable;
        String string = OptionsBundle.message((String)"options.general.attribute.descriptor.default.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String defaultTextOption = string;
        String separator = "//";
        int separatorPos = StringsKt.lastIndexOf$default((CharSequence)defaultTextOption, (String)separator, (int)0, (boolean)false, (int)6, null);
        if (separatorPos > 0) {
            String string2 = defaultTextOption.substring(separatorPos + separator.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            defaultTextOption = string2;
        }
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Settings allSettings = (Settings)Settings.KEY.getData(dataContext2);
        if (allSettings != null && (colorSchemeConfigurable = allSettings.find("reference.settingsdialog.IDE.editor.colors")) instanceof ColorAndFontOptions && (generalSettings = (Configurable)((ColorAndFontOptions)colorSchemeConfigurable).findSubConfigurable(GeneralColorsPage.Companion.getDisplayNameText())) != null) {
            allSettings.select(generalSettings, defaultTextOption);
        }
    }

    private static final void createCustomComponent$lambda$0$0$0(HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AbstractFontOptionsPanel.goToReaderMode();
    }

    private static final Unit createCustomComponent$lambda$0$1$0(AppEditorFontOptionsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.restoreDefaults();
        return Unit.INSTANCE;
    }

    private static final Unit createCustomComponent$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"comment.use.ligatures.with.reader.mode", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default($this$row, string, 0, AppEditorFontOptionsPanel::createCustomComponent$lambda$0$0$0, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCustomComponent$lambda$0$1(AppEditorFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"settings.editor.font.restored.defaults", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.restoreDefaults = $this$row.link(string, (Function1<? super ActionEvent, Unit>)((Function1)arg_0 -> AppEditorFontOptionsPanel.createCustomComponent$lambda$0$1$0(this$0, arg_0)));
        $this$row.label(" ");
        return Unit.INSTANCE;
    }

    private static final Unit createCustomComponent$lambda$0(AppEditorFontOptionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, AppEditorFontOptionsPanel::createCustomComponent$lambda$0$0, 1, null);
        Panel.row$default($this$panel, null, arg_0 -> AppEditorFontOptionsPanel.createCustomComponent$lambda$0$1(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final void createBoldFontHint$lambda$0(AppEditorFontOptionsPanel this$0, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.navigateToColorSchemeTextSettings();
    }
}

