/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.CommonBundle;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemeActions<T extends Scheme> {
    @NotNull
    protected final AbstractSchemesPanel<T, ?> mySchemesPanel;

    protected AbstractSchemeActions(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        if (schemesPanel == null) {
            AbstractSchemeActions.$$$reportNull$$$0(0);
        }
        this.mySchemesPanel = schemesPanel;
    }

    @NotNull
    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (SchemeImporterEP<T> importerEP : SchemeImporterEP.getExtensions(this.getSchemeType())) {
            importersNames.add(importerEP.getLocalizedName());
        }
        ArrayList<String> arrayList = importersNames;
        if (arrayList == null) {
            AbstractSchemeActions.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private Collection<String> getSchemeExporterNames() {
        ArrayList<String> exporterNames = new ArrayList<String>();
        for (SchemeExporterEP<T> exporterEP : SchemeExporterEP.getExtensions(this.getSchemeType())) {
            exporterNames.add(exporterEP.getLocalizedName());
        }
        ArrayList<String> arrayList = exporterNames;
        if (arrayList == null) {
            AbstractSchemeActions.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public Collection<AnAction> getActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            actions.add((AnAction)new CopyToProjectAction());
            actions.add((AnAction)new CopyToIDEAction());
            actions.add((AnAction)new Separator());
        }
        actions.add((AnAction)new CopyAction());
        actions.add((AnAction)new RenameAction());
        this.addAdditionalActions(actions);
        actions.add((AnAction)new ResetAction());
        actions.add((AnAction)new DeleteAction());
        actions.addAll(this.getExportImportActions(true));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            AbstractSchemeActions.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected List<AnAction> getExportImportActions(boolean withSeparator) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        @NotNull Collection<String> schemeImportersNames = this.getSchemeImportersNames();
        @NotNull Collection<String> schemeExporterNames = this.getSchemeExporterNames();
        if (!schemeExporterNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.export", (Object[])new Object[0]), schemeExporterNames, (x$0, x$1) -> new ExportAction((String)x$0, (String)x$1), null));
        }
        if (withSeparator) {
            actions.add((AnAction)new Separator());
        }
        if (!schemeImportersNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.import", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), schemeImportersNames, (x$0, x$1) -> new ImportAction((String)x$0, (String)x$1), (Computable<Boolean>)((Computable)() -> this.mySchemesPanel.isEnabled())));
        }
        return actions;
    }

    protected void addAdditionalActions(@NotNull List<? super AnAction> defaultActions) {
        if (defaultActions == null) {
            AbstractSchemeActions.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    protected static AnAction createImportExportAction(@NotNull @NlsActions.ActionText String groupName, @NotNull Collection<@NlsActions.ActionText String> actionNames, final @NotNull BiFunction<? super String, ? super @NlsActions.ActionText String, ? extends AnAction> createActionByName, final @Nullable Computable<Boolean> isEnabledComputable) {
        if (groupName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(5);
        }
        if (actionNames == null) {
            AbstractSchemeActions.$$$reportNull$$$0(6);
        }
        if (createActionByName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(7);
        }
        if (actionNames.size() == 1) {
            AnAction anAction = createActionByName.apply((String)ContainerUtil.getFirstItem(actionNames), groupName + "...");
            if (anAction == null) {
                AbstractSchemeActions.$$$reportNull$$$0(8);
            }
            return anAction;
        }
        return new ImportExportActionGroup(groupName, actionNames){

            @Override
            @NotNull
            protected AnAction createAction(@NotNull String actionName) {
                if (actionName == null) {
                    1.$$$reportNull$$$0(0);
                }
                AnAction anAction = (AnAction)createActionByName.apply(actionName, actionName);
                if (anAction == null) {
                    1.$$$reportNull$$$0(1);
                }
                return anAction;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.update(e);
                if (isEnabledComputable != null) {
                    e.getPresentation().setEnabled(((Boolean)isEnabledComputable.compute()).booleanValue());
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(3);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAction";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAction";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    protected void importScheme(@NotNull String importerName) {
        if (importerName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(9);
        }
    }

    protected abstract void resetScheme(@NotNull T var1);

    protected abstract void duplicateScheme(@NotNull T var1, @NotNull String var2);

    private void deleteScheme(@NotNull T scheme) {
        if (scheme == null) {
            AbstractSchemeActions.$$$reportNull$$$0(10);
        }
        if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"message.do.you.want.to.delete.0.1", (Object[])new Object[]{scheme.getName(), StringUtil.toLowerCase((String)this.mySchemesPanel.getSchemeTypeName())}), (String)IdeBundle.message((String)"dialog.title.delete.0", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), (String)IdeBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
            this.mySchemesPanel.getModel().removeScheme(scheme);
        }
    }

    protected void exportScheme(@Nullable Project project2, @NotNull T scheme, @NotNull String exporterName) {
        SchemeExporter<T> exporter;
        if (scheme == null) {
            AbstractSchemeActions.$$$reportNull$$$0(11);
        }
        if (exporterName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(12);
        }
        if ((exporter = SchemeExporterEP.getExporter(exporterName, this.getSchemeType())) != null) {
            Object config = null;
            if (exporter instanceof ConfigurableSchemeExporter && (config = ((ConfigurableSchemeExporter)exporter).getConfiguration(this.mySchemesPanel, scheme)) == null) {
                return;
            }
            String ext = exporter.getExtension();
            FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.title", (Object[])new Object[0]), ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.message", (Object[])new Object[0]), ext), this.getSchemesPanel());
            VirtualFileWrapper target = saver.save(exporter.getDefaultDir(project2), exporter.getDefaultFileName(scheme.getDisplayName()) + "." + ext);
            if (target != null) {
                MessageType messageType;
                String message;
                VirtualFile targetFile = target.getVirtualFile(true);
                if (targetFile != null) {
                    try {
                        Object finalConfig = config;
                        WriteAction.run(() -> {
                            try (OutputStream outputStream = targetFile.getOutputStream((Object)this);){
                                if (exporter instanceof ConfigurableSchemeExporter) {
                                    ((ConfigurableSchemeExporter)exporter).exportScheme(scheme, outputStream, finalConfig);
                                }
                                exporter.exportScheme(project2, scheme, outputStream);
                            }
                        });
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.scheme.exported.message", (Object[])new Object[]{scheme.getName(), this.getSchemesPanel().getSchemeTypeName(), targetFile.getPresentableUrl()});
                        messageType = MessageType.INFO;
                    }
                    catch (Exception e) {
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e.getMessage()});
                        messageType = MessageType.ERROR;
                    }
                } else {
                    message = ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
                    messageType = MessageType.ERROR;
                }
                this.getSchemesPanel().showStatus(message, messageType);
            }
        }
    }

    protected abstract void onSchemeChanged(@Nullable T var1);

    protected abstract void renameScheme(@NotNull T var1, @NotNull String var2);

    protected void copyToProject(@NotNull T scheme) {
        if (scheme == null) {
            AbstractSchemeActions.$$$reportNull$$$0(13);
        }
    }

    protected void copyToIDE(@NotNull T scheme) {
        if (scheme == null) {
            AbstractSchemeActions.$$$reportNull$$$0(14);
        }
    }

    @NotNull
    protected SchemesModel<T> getModel() {
        SchemesModel<T> schemesModel = this.mySchemesPanel.getModel();
        if (schemesModel == null) {
            AbstractSchemeActions.$$$reportNull$$$0(15);
        }
        return schemesModel;
    }

    @Nullable
    protected final T getCurrentScheme() {
        return this.mySchemesPanel.getSelectedScheme();
    }

    @NotNull
    protected abstract Class<T> getSchemeType();

    @NotNull
    public final AbstractSchemesPanel<T, ?> getSchemesPanel() {
        AbstractSchemesPanel<T, ?> abstractSchemesPanel = this.mySchemesPanel;
        if (abstractSchemesPanel == null) {
            AbstractSchemeActions.$$$reportNull$$$0(16);
        }
        return abstractSchemesPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createActionByName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerName";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeImportersNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeExporterNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportExportAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalActions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "importScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteScheme";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exportScheme";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyToProject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyToIDE";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 15, 16 -> new IllegalStateException(string);
        };
    }

    private final class CopyToProjectAction
    extends DumbAwareAction {
        CopyToProjectAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.copy.to.project", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                CopyToProjectAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToProject(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToProjectAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyToProjectAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyToProjectAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyToProjectAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class CopyToIDEAction
    extends DumbAwareAction {
        CopyToIDEAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.copy.to.ide", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                CopyToIDEAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToIDE(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToIDEAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyToIDEAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyToIDEAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyToIDEAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class CopyAction
    extends DumbAwareAction {
        CopyAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.copy", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.editNewSchemeName(currentScheme.getDisplayName(), AbstractSchemeActions.this.mySchemesPanel.supportsProjectSchemes() && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme), newName -> AbstractSchemeActions.this.duplicateScheme(currentScheme, (String)newName));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            boolean isAvailable = scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDuplicateScheme(scheme);
            p.setVisible(isAvailable);
            p.setEnabled(isAvailable && AbstractSchemeActions.this.mySchemesPanel.isEnabled());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class RenameAction
    extends DumbAwareAction {
        RenameAction() {
            super(ActionsBundle.messagePointer((String)"action.RenameAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameAction.$$$reportNull$$$0(0);
            }
            AbstractSchemeActions.this.mySchemesPanel.editCurrentSchemeName((currentScheme, newName) -> AbstractSchemeActions.this.renameScheme(currentScheme, (String)newName));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canRenameScheme(scheme));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RenameAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$RenameAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$RenameAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ResetAction
    extends DumbAwareAction {
        ResetAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.reset", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                ResetAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.resetScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            if (scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canResetScheme(scheme)) {
                p.setVisible(true);
                p.setEnabled(AbstractSchemeActions.this.mySchemesPanel.getModel().differsFromDefault(scheme));
            } else {
                p.setEnabledAndVisible(false);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ResetAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$ResetAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ResetAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class DeleteAction
    extends DumbAwareAction {
        DeleteAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.delete", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                DeleteAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.deleteScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeleteAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            boolean isAvailable = scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDeleteScheme(scheme);
            boolean isEnabled = isAvailable && AbstractSchemeActions.this.mySchemesPanel.isEnabled();
            p.setEnabled(isEnabled);
            if (AbstractSchemeActions.this.mySchemesPanel.hideDeleteActionIfUnavailable()) {
                p.setVisible(isAvailable);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                DeleteAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$DeleteAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$DeleteAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ImportAction
    extends DumbAwareAction {
        private final String myImporterName;

        ImportAction(@NotNull @NlsActions.ActionText String importerName, String importerText) {
            if (importerName == null) {
                ImportAction.$$$reportNull$$$0(0);
            }
            if (importerText == null) {
                ImportAction.$$$reportNull$$$0(1);
            }
            super(importerText);
            this.myImporterName = importerName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportAction.$$$reportNull$$$0(2);
            }
            AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
            AbstractSchemeActions.this.importScheme(this.myImporterName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importerName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importerText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ImportAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ExportAction
    extends DumbAwareAction {
        private final String myExporterName;

        ExportAction(@NotNull @NlsActions.ActionText String exporterName, String exporterText) {
            if (exporterName == null) {
                ExportAction.$$$reportNull$$$0(0);
            }
            if (exporterText == null) {
                ExportAction.$$$reportNull$$$0(1);
            }
            super(exporterText);
            this.myExporterName = exporterName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                ExportAction.$$$reportNull$$$0(2);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                Project project2 = e.getProject();
                AbstractSchemeActions.this.exportScheme(project2, currentScheme, this.myExporterName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporterName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporterText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ExportAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ImportExportActionGroup
    extends ActionGroup {
        private final Collection<@NlsActions.ActionText String> myActionNames;

        ImportExportActionGroup(@NotNull @NlsActions.ActionText String groupName, @NotNull Collection<@NlsActions.ActionText String> actionNames) {
            if (groupName == null) {
                ImportExportActionGroup.$$$reportNull$$$0(0);
            }
            if (actionNames == null) {
                ImportExportActionGroup.$$$reportNull$$$0(1);
            }
            super(groupName, true);
            this.myActionNames = actionNames;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            ArrayList<AnAction> namedActions = new ArrayList<AnAction>();
            for (String actionName : this.myActionNames) {
                namedActions.add(this.createAction(actionName));
            }
            AnAction[] anActionArray = namedActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ImportExportActionGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        @NotNull
        protected abstract AnAction createAction(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$ImportExportActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ImportExportActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

