/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.diagnostic.JsonLogHandler;
import com.intellij.util.ExceptionUtil;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diagnostic/JsonLogHandler;", "Ljava/util/logging/StreamHandler;", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "formatter", "com/intellij/diagnostic/JsonLogHandler$formatter$1", "Lcom/intellij/diagnostic/JsonLogHandler$formatter$1;", "publish", "", "record", "Ljava/util/logging/LogRecord;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class JsonLogHandler
extends StreamHandler {
    @NotNull
    private final Lazy objectMapper$delegate = LazyKt.lazy(JsonLogHandler::objectMapper_delegate$lambda$0);
    @NotNull
    private final formatter.1 formatter = new Formatter(){

        public String format(LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            String string = this.formatMessage(record);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatMessage(...)");
            return string;
        }
    };

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    @Override
    public void publish(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"time", (Object)record.getMillis()), TuplesKt.to((Object)"threadID", (Object)record.getLongThreadID()), TuplesKt.to((Object)"loggerName", (Object)record.getLoggerName()), TuplesKt.to((Object)"level", (Object)record.getLevel().getName()), TuplesKt.to((Object)"message", (Object)(record.getThrown() != null ? ExceptionUtil.getThrowableText((Throwable)record.getThrown()) : this.formatter.format(record)))};
        System.out.println((Object)this.getObjectMapper().writeValueAsString((Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        return new ObjectMapper();
    }
}

