/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.WindowsDefenderChecker;
import com.intellij.diagnostic.WindowsDefenderCheckerActivity;
import com.intellij.diagnostic.WindowsDefenderStatisticsCollector;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.utils.JEelUtils;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.io.ProcessKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0019\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diagnostic/WindowsDefenderCheckerActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkDefenderStatus", "checker", "Lcom/intellij/diagnostic/WindowsDefenderChecker;", "isOnWindows", "", "projectDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Ljava/lang/Boolean;", "updateDefenderConfig", "paths", "", "showInstructions", "suppressCheck", "globally", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWindowsDefenderCheckerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsDefenderCheckerActivity.kt\ncom/intellij/diagnostic/WindowsDefenderCheckerActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,160:1\n70#2,6:161\n1#3:167\n13#4:168\n*S KotlinDebug\n*F\n+ 1 WindowsDefenderCheckerActivity.kt\ncom/intellij/diagnostic/WindowsDefenderCheckerActivity\n*L\n78#1:161,6\n34#1:168\n*E\n"})
public final class WindowsDefenderCheckerActivity
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public WindowsDefenderCheckerActivity() {
        Application app = ApplicationManager.getApplication();
        if (app.isCommandLine() || app.isUnitTestMode() || !Registry.Companion.is("ide.check.windows.defender.rules", false)) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ WindowsDefenderCheckerActivity this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$serviceAsync = 0;
                v0 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                $this$serviceAsync$iv$iv = (ComponentManager)v0;
                $i$f$serviceAsync = 0;
                $continuation.L$0 = project;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.I$1 = $i$f$serviceAsync;
                $continuation.label = 1;
                v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(WindowsDefenderChecker.class, (Continuation)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$1;
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                checker = (WindowsDefenderChecker)v1;
                projectStatus = checker.isAlreadyProcessed(project);
                if (projectStatus == WindowsDefenderChecker.ProjectStatus.SKIPPED) {
                    WindowsDefenderCheckerActivity.LOG.info("status check is skipped for this run");
                    return Unit.INSTANCE;
                }
                if (projectStatus == WindowsDefenderChecker.ProjectStatus.SUCCEED || projectStatus == WindowsDefenderChecker.ProjectStatus.FAILED) {
                    WindowsDefenderCheckerActivity.LOG.info("requested from the \"trust project\" dialog; status=" + projectStatus);
                    com.intellij.diagnostic.WindowsDefenderCheckerActivity$Companion.access$notify(WindowsDefenderCheckerActivity.Companion, project, projectStatus == WindowsDefenderChecker.ProjectStatus.SUCCEED);
                    return Unit.INSTANCE;
                }
                if (checker.isStatusCheckIgnored(project)) {
                    WindowsDefenderCheckerActivity.LOG.info("status check is disabled");
                    WindowsDefenderStatisticsCollector.protectionCheckSkipped(project);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)checker);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectStatus);
                $continuation.label = 2;
                v2 = ProcessKt.computeDetached$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, checker, null){
                    int label;
                    final /* synthetic */ WindowsDefenderCheckerActivity this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ WindowsDefenderChecker $checker;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$checker = $checker;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                WindowsDefenderCheckerActivity.access$checkDefenderStatus(this.this$0, this.$project, this.$checker);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)1, null);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl62
            }
            case 2: {
                projectStatus = (WindowsDefenderChecker.ProjectStatus)$continuation.L$2;
                checker = (WindowsDefenderChecker)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl62:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void checkDefenderStatus(Project project2, WindowsDefenderChecker checker) {
        Notification notification2;
        Path projectDir;
        Boolean protection = checker.isRealTimeProtectionEnabled();
        WindowsDefenderStatisticsCollector.protectionCheckStatus(project2, protection);
        if (!Intrinsics.areEqual((Object)protection, (Object)true)) {
            LOG.info("real-time protection: " + protection);
            return;
        }
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            v1 = it.getFileSystem().getNioPath(it);
        } else {
            v1 = projectDir = null;
        }
        if (Intrinsics.areEqual((Object)this.isOnWindows(projectDir), (Object)false)) {
            return;
        }
        if (projectDir != null && checker.isUntrustworthyLocation(projectDir)) {
            LOG.info("untrustworthy location: " + projectDir);
            return;
        }
        List<Path> list2 = checker.filterDevDrivePaths(checker.getPathsToExclude(project2));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"filterDevDrivePaths(...)");
        List<Path> paths = list2;
        if (paths.isEmpty()) {
            LOG.info("all paths are on a DevDrive");
            return;
        }
        String pathList = CollectionsKt.joinToString$default((Iterable)paths, (CharSequence)"<br>&nbsp;&nbsp;", (CharSequence)"<br>&nbsp;&nbsp;", null, (int)0, null, null, (int)60, null);
        String string = DiagnosticBundle.message("exclude.folders", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String auto = string;
        String string2 = DiagnosticBundle.message("defender.config.manual", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String manual = string2;
        Object[] objectArray = new Object[]{pathList, auto, manual};
        String string3 = DiagnosticBundle.message("defender.config.prompt", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String content2 = string3;
        Notification $this$checkDefenderStatus_u24lambda_u245 = notification2 = new Notification("WindowsDefender", DiagnosticBundle.message("notification.group.defender.config", new Object[0]), content2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)auto, () -> WindowsDefenderCheckerActivity.checkDefenderStatus$lambda$1(this, checker, project2, paths))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DiagnosticBundle.message("defender.config.suppress1", new Object[0]), () -> WindowsDefenderCheckerActivity.checkDefenderStatus$lambda$2(this, checker, project2))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DiagnosticBundle.message("defender.config.suppress2", new Object[0]), () -> WindowsDefenderCheckerActivity.checkDefenderStatus$lambda$3(this, checker, project2))).addAction((AnAction)Separator.getInstance()).addAction((AnAction)NotificationAction.createSimple((String)manual, () -> WindowsDefenderCheckerActivity.checkDefenderStatus$lambda$4(this, checker, project2))).setSuggestionType(true).setImportantSuggestion(true);
        boolean bl = false;
        $this$checkDefenderStatus_u24lambda_u245.setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification2.notify(project2);
    }

    private final Boolean isOnWindows(Path projectDir) {
        Boolean bl;
        Path path = projectDir;
        if (path != null) {
            Path it = path;
            boolean bl2 = false;
            EelPath eelPath = JEelUtils.toEelPath((Path)it);
            bl = eelPath != null && (eelPath = eelPath.getDescriptor()) != null && (eelPath = eelPath.getOsFamily()) != null ? Boolean.valueOf(EelPlatformKt.isWindows((EelOsFamily)eelPath)) : null;
        } else {
            bl = null;
        }
        return bl;
    }

    private final void updateDefenderConfig(WindowsDefenderChecker checker, Project project2, List<? extends Path> paths) {
        Companion.runAndNotify(project2, (Function0<Boolean>)((Function0)() -> WindowsDefenderCheckerActivity.updateDefenderConfig$lambda$0(checker, project2, paths)));
        WindowsDefenderStatisticsCollector.auto(project2);
    }

    private final void showInstructions(WindowsDefenderChecker checker, Project project2) {
        BrowserUtil.browse((String)checker.getConfigurationInstructionsUrl());
        WindowsDefenderStatisticsCollector.manual(project2);
    }

    private final void suppressCheck(WindowsDefenderChecker checker, Project project2, boolean globally) {
        checker.ignoreStatusCheck(globally ? null : project2, true);
        WindowsDefenderStatisticsCollector.suppressed(project2, globally);
    }

    private static final void checkDefenderStatus$lambda$1(WindowsDefenderCheckerActivity this$0, WindowsDefenderChecker $checker, Project $project, List $paths) {
        this$0.updateDefenderConfig($checker, $project, $paths);
    }

    private static final void checkDefenderStatus$lambda$2(WindowsDefenderCheckerActivity this$0, WindowsDefenderChecker $checker, Project $project) {
        this$0.suppressCheck($checker, $project, false);
    }

    private static final void checkDefenderStatus$lambda$3(WindowsDefenderCheckerActivity this$0, WindowsDefenderChecker $checker, Project $project) {
        this$0.suppressCheck($checker, $project, true);
    }

    private static final void checkDefenderStatus$lambda$4(WindowsDefenderCheckerActivity this$0, WindowsDefenderChecker $checker, Project $project) {
        this$0.showInstructions($checker, $project);
    }

    private static final boolean updateDefenderConfig$lambda$0(WindowsDefenderChecker $checker, Project $project, List $paths) {
        return $checker.excludeProjectPaths($project, $paths);
    }

    public static final /* synthetic */ void access$checkDefenderStatus(WindowsDefenderCheckerActivity $this, Project project2, WindowsDefenderChecker checker) {
        $this.checkDefenderStatus(project2, checker);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(WindowsDefenderCheckerActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/WindowsDefenderCheckerActivity$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "runAndNotify", "", "project", "Lcom/intellij/openapi/project/Project;", "process", "Lkotlin/Function0;", "", "notify", "success", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nWindowsDefenderCheckerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsDefenderCheckerActivity.kt\ncom/intellij/diagnostic/WindowsDefenderCheckerActivity$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,160:1\n42#2,3:161\n*S KotlinDebug\n*F\n+ 1 WindowsDefenderCheckerActivity.kt\ncom/intellij/diagnostic/WindowsDefenderCheckerActivity$Companion\n*L\n37#1:161,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void runAndNotify(@Nullable Project project2, @NotNull Function0<Boolean> process2) {
            Intrinsics.checkNotNullParameter(process2, (String)"process");
            boolean $i$f$service = false;
            Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, process2, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ Function0<Boolean> $process;
                {
                    this.$project = $project;
                    this.$process = $process;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    block6: {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$project == null) break;
                                v0 = DiagnosticBundle.message("defender.config.progress", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(...)");
                                this.label = 1;
                                v1 = TasksKt.withBackgroundProgress((Project)this.$project, (String)v0, (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$process, null){
                                    int label;
                                    final /* synthetic */ Function0<Boolean> $process;
                                    {
                                        this.$process = $process;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                return this.$process.invoke();
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl16:
                                // 2 sources

                                v2 = (Boolean)v1;
                                break block6;
                            }
                        }
                        v2 = (Boolean)this.$process.invoke();
                    }
                    success = v2;
                    WindowsDefenderStatisticsCollector.configured(this.$project, success != false);
                    if (this.$project != null) {
                        com.intellij.diagnostic.WindowsDefenderCheckerActivity$Companion.access$notify(WindowsDefenderCheckerActivity.Companion, this.$project, success != false);
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void notify(Project project2, boolean success2) {
            if (success2) {
                new Notification("WindowsDefender", DiagnosticBundle.message("defender.config.success", new Object[0]), NotificationType.INFORMATION).notify(project2);
            } else {
                new Notification("WindowsDefender", DiagnosticBundle.message("defender.config.failed", new Object[0]), NotificationType.ERROR).addAction((AnAction)ShowLogAction.notificationAction()).notify(project2);
            }
        }

        public static final /* synthetic */ void access$notify(Companion $this, Project project2, boolean success2) {
            $this.notify(project2, success2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

