/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.opentelemetry;

import com.intellij.diagnostic.PlatformMemoryUtil;
import com.intellij.diagnostic.opentelemetry.SafepointBean;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.io.IOUtil;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ReportingService", "AvgMemoryUsageProvider", "AllocatedMemoryProvider", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nJVMStatsToOTelReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMStatsToOTelReporter.kt\ncom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,364:1\n70#2,6:365\n*S KotlinDebug\n*F\n+ 1 JVMStatsToOTelReporter.kt\ncom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter\n*L\n32#1:365,6\n*E\n"})
public final class JVMStatsToOTelReporter
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$serviceAsync = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)application;
        boolean $i$f$serviceAsync2 = false;
        Object object = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ReportingService.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AllocatedMemoryProvider;", "", "threadMXBean", "Lcom/sun/management/ThreadMXBean;", "<init>", "(Lcom/sun/management/ThreadMXBean;)V", "previouslyAliveThreadsIds", "", "allocatedByPreviouslyAliveThreads", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "totalBytesAllocatedByTerminatedThreads", "", "isAvailable", "", "totalBytesAllocatedSinceStartup", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nJVMStatsToOTelReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMStatsToOTelReporter.kt\ncom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AllocatedMemoryProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,364:1\n14165#2,3:365\n*S KotlinDebug\n*F\n+ 1 JVMStatsToOTelReporter.kt\ncom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AllocatedMemoryProvider\n*L\n281#1:365,3\n*E\n"})
    public static final class AllocatedMemoryProvider {
        @NotNull
        private final com.sun.management.ThreadMXBean threadMXBean;
        @NotNull
        private long[] previouslyAliveThreadsIds;
        @NotNull
        private Long2LongOpenHashMap allocatedByPreviouslyAliveThreads;
        private long totalBytesAllocatedByTerminatedThreads;

        public AllocatedMemoryProvider(@NotNull com.sun.management.ThreadMXBean threadMXBean) {
            Intrinsics.checkNotNullParameter((Object)threadMXBean, (String)"threadMXBean");
            this.threadMXBean = threadMXBean;
            this.previouslyAliveThreadsIds = new long[0];
            this.allocatedByPreviouslyAliveThreads = new Long2LongOpenHashMap();
        }

        public final boolean isAvailable() {
            return this.threadMXBean.isThreadAllocatedMemorySupported() && this.threadMXBean.isThreadAllocatedMemoryEnabled();
        }

        /*
         * WARNING - void declaration
         */
        public final long totalBytesAllocatedSinceStartup() {
            long l;
            if (!this.isAvailable()) {
                return 0L;
            }
            long[] currentlyAliveThreadIds = this.threadMXBean.getAllThreadIds();
            long[] perThreadAllocatedBytes = this.threadMXBean.getThreadAllocatedBytes(currentlyAliveThreadIds);
            Long2LongOpenHashMap allocatedMemoryByThreadId = new Long2LongOpenHashMap();
            Intrinsics.checkNotNull((Object)currentlyAliveThreadIds);
            long[] $this$forEachIndexed$iv = currentlyAliveThreadIds;
            boolean $i$f$forEachIndexed = false;
            int index$iv22 = 0;
            for (long item$iv : $this$forEachIndexed$iv) {
                void threadId;
                int n = index$iv22++;
                l = item$iv;
                int index = n;
                boolean bl = false;
                ((Map)allocatedMemoryByThreadId).put((long)threadId, perThreadAllocatedBytes[index]);
            }
            long[] index$iv22 = this.previouslyAliveThreadsIds;
            long l2 = 0L;
            int n = index$iv22.length;
            for (int j = 0; j < n; ++j) {
                void previousThreadId;
                long index = l = index$iv22[j];
                long l3 = l2;
                boolean bl = false;
                long previouslyAllocatedByThread = this.allocatedByPreviouslyAliveThreads.get((long)previousThreadId);
                long currentlyAllocatedByThread = allocatedMemoryByThreadId.get((long)previousThreadId);
                long l4 = currentlyAllocatedByThread < previouslyAllocatedByThread ? previouslyAllocatedByThread : 0L;
                l2 = l3 + l4;
            }
            long bytesAllocatedByTerminatedThreads = l2;
            this.totalBytesAllocatedByTerminatedThreads += bytesAllocatedByTerminatedThreads;
            Intrinsics.checkNotNull((Object)perThreadAllocatedBytes);
            long totalBytesAllocatedByAllThreads = ArraysKt.sum((long[])perThreadAllocatedBytes) + this.totalBytesAllocatedByTerminatedThreads;
            this.previouslyAliveThreadsIds = currentlyAliveThreadIds;
            this.allocatedByPreviouslyAliveThreads = allocatedMemoryByThreadId;
            return totalBytesAllocatedByAllThreads;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "counters", "Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$Counters;", "provider", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "Lcom/intellij/diagnostic/PlatformMemoryUtil;", "getAvgCurrentProcessMemoryStats", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "Counters", "AvgCounter", "intellij.platform.ide.impl"})
    private static final class AvgMemoryUsageProvider {
        @NotNull
        private volatile Counters counters;
        @NotNull
        private final PlatformMemoryUtil.MemoryStatsProvider provider;

        public AvgMemoryUsageProvider(@NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.counters = new Counters(null, null, null, null, 15, null);
            this.provider = PlatformMemoryUtil.Companion.getInstance().newMemoryStatsProvider();
            BuildersKt.launch$default((CoroutineScope)cs, (CoroutineContext)((CoroutineContext)new CoroutineName("JVMStatsToOTelReporter.AvgMemoryUsageProvider")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ AvgMemoryUsageProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
lbl6:
                            // 3 sources

                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                memStats = AvgMemoryUsageProvider.access$getProvider$p(this.this$0).getCurrentProcessMemoryStats();
                                if (memStats != null) {
                                    prev = AvgMemoryUsageProvider.access$getCounters$p(this.this$0);
                                    AvgMemoryUsageProvider.access$setCounters$p(this.this$0, new Counters(prev.getRam().add(memStats.getRam() / (long)1024), prev.getRamMinusFileMappings().add(memStats.getRamMinusFileMappings() / (long)1024), prev.getRamPlusSwapMinusFileMappings().add(memStats.getRamPlusSwapMinusFileMappings() / (long)1024), prev.getFileMappingsRam().add(memStats.getFileMappingsRam() / (long)1024)));
                                }
                                this.L$0 = $this$launch;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)memStats);
                                this.label = 1;
                                v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                if (v0 != var5_3) continue;
                                return var5_3;
                            }
                            break;
                        }
                        case 1: {
                            memStats = (PlatformMemoryUtil.MemoryStats)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl6
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        @Nullable
        public final PlatformMemoryUtil.MemoryStats getAvgCurrentProcessMemoryStats() {
            if (this.counters.getRam().getAvg() == 0L) {
                return null;
            }
            return new PlatformMemoryUtil.MemoryStats(this.counters.getRam().getAvg() * (long)1024, this.counters.getRamMinusFileMappings().getAvg() * (long)1024, this.counters.getRamPlusSwapMinusFileMappings().getAvg() * (long)1024, this.counters.getFileMappingsRam().getAvg() * (long)1024);
        }

        public static final /* synthetic */ PlatformMemoryUtil.MemoryStatsProvider access$getProvider$p(AvgMemoryUsageProvider $this) {
            return $this.provider;
        }

        public static final /* synthetic */ Counters access$getCounters$p(AvgMemoryUsageProvider $this) {
            return $this.counters;
        }

        public static final /* synthetic */ void access$setCounters$p(AvgMemoryUsageProvider $this, Counters counters) {
            $this.counters = counters;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;", "", "count", "", "total", "<init>", "(JJ)V", "add", "value", "getAvg", "intellij.platform.ide.impl"})
        private static final class AvgCounter {
            private final long count;
            private final long total;

            public AvgCounter(long count, long total) {
                this.count = count;
                this.total = total;
            }

            public /* synthetic */ AvgCounter(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = 0L;
                }
                if ((n & 2) != 0) {
                    l2 = 0L;
                }
                this(l, l2);
            }

            @NotNull
            public final AvgCounter add(long value) {
                long l;
                if (this.total == Long.MAX_VALUE) {
                    return this;
                }
                try {
                    l = Math.addExact(this.total, value);
                }
                catch (ArithmeticException arithmeticException) {
                    l = Long.MAX_VALUE;
                }
                long newTotal = l;
                return new AvgCounter(this.count + 1L, newTotal);
            }

            public final long getAvg() {
                return this.count == 0L ? 0L : this.total / this.count;
            }

            public AvgCounter() {
                this(0L, 0L, 3, null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$Counters;", "", "ram", "Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;", "ramMinusFileMappings", "ramPlusSwapMinusFileMappings", "fileMappingsRam", "<init>", "(Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;)V", "getRam", "()Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$AvgMemoryUsageProvider$AvgCounter;", "getRamMinusFileMappings", "getRamPlusSwapMinusFileMappings", "getFileMappingsRam", "intellij.platform.ide.impl"})
        private static final class Counters {
            @NotNull
            private final AvgCounter ram;
            @NotNull
            private final AvgCounter ramMinusFileMappings;
            @NotNull
            private final AvgCounter ramPlusSwapMinusFileMappings;
            @NotNull
            private final AvgCounter fileMappingsRam;

            public Counters(@NotNull AvgCounter ram, @NotNull AvgCounter ramMinusFileMappings, @NotNull AvgCounter ramPlusSwapMinusFileMappings, @NotNull AvgCounter fileMappingsRam) {
                Intrinsics.checkNotNullParameter((Object)ram, (String)"ram");
                Intrinsics.checkNotNullParameter((Object)ramMinusFileMappings, (String)"ramMinusFileMappings");
                Intrinsics.checkNotNullParameter((Object)ramPlusSwapMinusFileMappings, (String)"ramPlusSwapMinusFileMappings");
                Intrinsics.checkNotNullParameter((Object)fileMappingsRam, (String)"fileMappingsRam");
                this.ram = ram;
                this.ramMinusFileMappings = ramMinusFileMappings;
                this.ramPlusSwapMinusFileMappings = ramPlusSwapMinusFileMappings;
                this.fileMappingsRam = fileMappingsRam;
            }

            public /* synthetic */ Counters(AvgCounter avgCounter, AvgCounter avgCounter2, AvgCounter avgCounter3, AvgCounter avgCounter4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    avgCounter = new AvgCounter(0L, 0L, 3, null);
                }
                if ((n & 2) != 0) {
                    avgCounter2 = new AvgCounter(0L, 0L, 3, null);
                }
                if ((n & 4) != 0) {
                    avgCounter3 = new AvgCounter(0L, 0L, 3, null);
                }
                if ((n & 8) != 0) {
                    avgCounter4 = new AvgCounter(0L, 0L, 3, null);
                }
                this(avgCounter, avgCounter2, avgCounter3, avgCounter4);
            }

            @NotNull
            public final AvgCounter getRam() {
                return this.ram;
            }

            @NotNull
            public final AvgCounter getRamMinusFileMappings() {
                return this.ramMinusFileMappings;
            }

            @NotNull
            public final AvgCounter getRamPlusSwapMinusFileMappings() {
                return this.ramPlusSwapMinusFileMappings;
            }

            @NotNull
            public final AvgCounter getFileMappingsRam() {
                return this.fileMappingsRam;
            }

            public Counters() {
                this(null, null, null, null, 15, null);
            }
        }
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/opentelemetry/JVMStatsToOTelReporter$ReportingService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "batchCallback", "Lio/opentelemetry/api/metrics/BatchCallback;", "intellij.platform.ide.impl"})
    private static final class ReportingService {
        @Nullable
        private BatchCallback batchCallback;

        public ReportingService(@NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            Meter otelMeter = TelemetryManager.Companion.getMeter(PlatformScopesKt.JVM);
            ObservableLongMeasurement ramGauge = otelMeter.gaugeBuilder("MEM.ramBytes").ofLongs().buildObserver();
            ObservableLongMeasurement ramMinusFileMappingsGauge = otelMeter.gaugeBuilder("MEM.ramMinusFileMappingsBytes").ofLongs().buildObserver();
            ObservableLongMeasurement ramPlusSwapMinusFileMappingsGauge = otelMeter.gaugeBuilder("MEM.ramPlusSwapMinusFileMappingsBytes").ofLongs().buildObserver();
            ObservableLongMeasurement fileMappingsRamGauge = otelMeter.gaugeBuilder("MEM.fileMappingsRamBytes").ofLongs().buildObserver();
            ObservableLongMeasurement usedHeapMemoryGauge = otelMeter.gaugeBuilder("JVM.usedHeapBytes").ofLongs().buildObserver();
            ObservableLongMeasurement committedHeapMemoryGauge = otelMeter.gaugeBuilder("JVM.committedHeapBytes").ofLongs().buildObserver();
            ObservableLongMeasurement maxHeapMemoryGauge = otelMeter.gaugeBuilder("JVM.maxHeapBytes").ofLongs().buildObserver();
            ObservableLongMeasurement usedNativeMemoryGauge = otelMeter.gaugeBuilder("JVM.usedNativeBytes").ofLongs().buildObserver();
            ObservableLongMeasurement totalDirectByteBuffersGauge = otelMeter.gaugeBuilder("JVM.totalDirectByteBuffersBytes").ofLongs().buildObserver();
            ObservableLongMeasurement threadCountGauge = otelMeter.gaugeBuilder("JVM.threadCount").ofLongs().buildObserver();
            ObservableLongMeasurement threadCountMaxGauge = otelMeter.gaugeBuilder("JVM.maxThreadCount").ofLongs().buildObserver();
            ObservableLongMeasurement newThreadsCounter = otelMeter.counterBuilder("JVM.newThreadsCount").buildObserver();
            ObservableDoubleMeasurement osLoadAverageGauge = otelMeter.gaugeBuilder("OS.loadAverage").buildObserver();
            ObservableLongMeasurement gcCollectionsCounter = otelMeter.counterBuilder("JVM.GC.collections").buildObserver();
            ObservableLongMeasurement gcCollectionTimesCounterMs = otelMeter.counterBuilder("JVM.GC.collectionTimesMs").buildObserver();
            ObservableLongMeasurement totalBytesAllocatedCounter = otelMeter.counterBuilder("JVM.totalBytesAllocated").buildObserver();
            ObservableLongMeasurement totalCpuTimeCounterMs = otelMeter.counterBuilder("JVM.totalCpuTimeMs").buildObserver();
            ObservableLongMeasurement totalSafepointCounter = otelMeter.counterBuilder("JVM.totalSafepointCount").buildObserver();
            ObservableLongMeasurement totalTimeAtSafepointsCounterMs = otelMeter.counterBuilder("JVM.totalTimeAtSafepointsMs").buildObserver();
            ObservableLongMeasurement totalTimeToSafepointsCounterMs = otelMeter.counterBuilder("JVM.totalTimeToSafepointsMs").buildObserver();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            Intrinsics.checkNotNull((Object)threadMXBean, (String)"null cannot be cast to non-null type com.sun.management.ThreadMXBean");
            com.sun.management.ThreadMXBean threadMXBean2 = (com.sun.management.ThreadMXBean)threadMXBean;
            AllocatedMemoryProvider allocatedMemoryProvider = new AllocatedMemoryProvider(threadMXBean2);
            List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            Intrinsics.checkNotNull((Object)operatingSystemMXBean, (String)"null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
            com.sun.management.OperatingSystemMXBean osMXBean = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
            SafepointBean safepointBean = SafepointBean.INSTANCE;
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{ramMinusFileMappingsGauge, ramPlusSwapMinusFileMappingsGauge, fileMappingsRamGauge, usedHeapMemoryGauge, committedHeapMemoryGauge, maxHeapMemoryGauge, usedNativeMemoryGauge, totalDirectByteBuffersGauge, threadCountGauge, threadCountMaxGauge, newThreadsCounter, gcCollectionsCounter, gcCollectionTimesCounterMs, totalBytesAllocatedCounter, totalCpuTimeCounterMs, osLoadAverageGauge, totalSafepointCounter, totalTimeToSafepointsCounterMs, totalTimeAtSafepointsCounterMs};
            this.batchCallback = otelMeter.batchCallback(() -> ReportingService._init_$lambda$0(ramGauge, ramMinusFileMappingsGauge, ramPlusSwapMinusFileMappingsGauge, fileMappingsRamGauge, memoryMXBean, usedHeapMemoryGauge, committedHeapMemoryGauge, maxHeapMemoryGauge, usedNativeMemoryGauge, totalDirectByteBuffersGauge, threadCountGauge, threadMXBean2, threadCountMaxGauge, newThreadsCounter, gcBeans, gcCollectionsCounter, gcCollectionTimesCounterMs, allocatedMemoryProvider, totalBytesAllocatedCounter, totalSafepointCounter, safepointBean, totalTimeToSafepointsCounterMs, totalTimeAtSafepointsCounterMs, osLoadAverageGauge, osMXBean, totalCpuTimeCounterMs), (ObservableMeasurement)ramGauge, observableMeasurementArray);
            if (ApplicationManagerEx.isInIntegrationTest()) {
                ObservableLongMeasurement avgRamGauge = otelMeter.gaugeBuilder("MEM.avgRamBytes").ofLongs().buildObserver();
                ObservableLongMeasurement avgRamMinusFileMappingsGauge = otelMeter.gaugeBuilder("MEM.avgRamMinusFileMappingsBytes").ofLongs().buildObserver();
                ObservableLongMeasurement avgRamPlusSwapMinusFileMappingsGauge = otelMeter.gaugeBuilder("MEM.avgRamPlusSwapMinusFileMappingsBytes").ofLongs().buildObserver();
                ObservableLongMeasurement avgFileMappingsRamGauge = otelMeter.gaugeBuilder("MEM.avgFileMappingsRamBytes").ofLongs().buildObserver();
                AvgMemoryUsageProvider avgMemUsageProvider = new AvgMemoryUsageProvider(cs);
                ObservableMeasurement[] observableMeasurementArray2 = new ObservableMeasurement[]{avgRamMinusFileMappingsGauge, avgRamPlusSwapMinusFileMappingsGauge, avgFileMappingsRamGauge};
                otelMeter.batchCallback(() -> ReportingService._init_$lambda$1(avgMemUsageProvider, avgRamGauge, avgRamMinusFileMappingsGauge, avgRamPlusSwapMinusFileMappingsGauge, avgFileMappingsRamGauge), (ObservableMeasurement)avgRamGauge, observableMeasurementArray2);
            }
        }

        private static final void _init_$lambda$0(ObservableLongMeasurement $ramGauge, ObservableLongMeasurement $ramMinusFileMappingsGauge, ObservableLongMeasurement $ramPlusSwapMinusFileMappingsGauge, ObservableLongMeasurement $fileMappingsRamGauge, MemoryMXBean $memoryMXBean, ObservableLongMeasurement $usedHeapMemoryGauge, ObservableLongMeasurement $committedHeapMemoryGauge, ObservableLongMeasurement $maxHeapMemoryGauge, ObservableLongMeasurement $usedNativeMemoryGauge, ObservableLongMeasurement $totalDirectByteBuffersGauge, ObservableLongMeasurement $threadCountGauge, com.sun.management.ThreadMXBean $threadMXBean, ObservableLongMeasurement $threadCountMaxGauge, ObservableLongMeasurement $newThreadsCounter, List $gcBeans, ObservableLongMeasurement $gcCollectionsCounter, ObservableLongMeasurement $gcCollectionTimesCounterMs, AllocatedMemoryProvider $allocatedMemoryProvider, ObservableLongMeasurement $totalBytesAllocatedCounter, ObservableLongMeasurement $totalSafepointCounter, SafepointBean $safepointBean, ObservableLongMeasurement $totalTimeToSafepointsCounterMs, ObservableLongMeasurement $totalTimeAtSafepointsCounterMs, ObservableDoubleMeasurement $osLoadAverageGauge, com.sun.management.OperatingSystemMXBean $osMXBean, ObservableLongMeasurement $totalCpuTimeCounterMs) {
            PlatformMemoryUtil.MemoryStats memStats = PlatformMemoryUtil.Companion.getInstance().getCurrentProcessMemoryStats();
            if (memStats != null) {
                $ramGauge.record(memStats.getRam());
                $ramMinusFileMappingsGauge.record(memStats.getRamMinusFileMappings());
                $ramPlusSwapMinusFileMappingsGauge.record(memStats.getRamPlusSwapMinusFileMappings());
                $fileMappingsRamGauge.record(memStats.getFileMappingsRam());
            }
            MemoryUsage heapUsage = $memoryMXBean.getHeapMemoryUsage();
            MemoryUsage nonHeapUsage = $memoryMXBean.getNonHeapMemoryUsage();
            $usedHeapMemoryGauge.record(heapUsage.getUsed());
            $committedHeapMemoryGauge.record(heapUsage.getCommitted());
            $maxHeapMemoryGauge.record(heapUsage.getMax());
            $usedNativeMemoryGauge.record(nonHeapUsage.getUsed());
            $totalDirectByteBuffersGauge.record(IOUtil.directBuffersTotalAllocatedSize());
            $threadCountGauge.record((long)$threadMXBean.getThreadCount());
            $threadCountMaxGauge.record((long)$threadMXBean.getPeakThreadCount());
            $newThreadsCounter.record($threadMXBean.getTotalStartedThreadCount());
            long gcCount = 0L;
            long gcTimeMs = 0L;
            for (GarbageCollectorMXBean gcBean : $gcBeans) {
                gcCount += gcBean.getCollectionCount();
                gcTimeMs += gcBean.getCollectionTime();
            }
            $gcCollectionsCounter.record(gcCount);
            $gcCollectionTimesCounterMs.record(gcTimeMs);
            if ($allocatedMemoryProvider.isAvailable()) {
                $totalBytesAllocatedCounter.record($allocatedMemoryProvider.totalBytesAllocatedSinceStartup());
            }
            Long l = $safepointBean.safepointCount();
            $totalSafepointCounter.record(l != null ? l : -1L);
            Long l2 = $safepointBean.totalTimeToSafepointMs();
            $totalTimeToSafepointsCounterMs.record(l2 != null ? l2 : -1L);
            Long l3 = $safepointBean.totalTimeAtSafepointMs();
            $totalTimeAtSafepointsCounterMs.record(l3 != null ? l3 : -1L);
            $osLoadAverageGauge.record($osMXBean.getSystemLoadAverage());
            long processCpuTimeNs = $osMXBean.getProcessCpuTime();
            if (processCpuTimeNs != -1L) {
                $totalCpuTimeCounterMs.record(TimeUnit.NANOSECONDS.toMillis(processCpuTimeNs));
            }
        }

        private static final void _init_$lambda$1(AvgMemoryUsageProvider $avgMemUsageProvider, ObservableLongMeasurement $avgRamGauge, ObservableLongMeasurement $avgRamMinusFileMappingsGauge, ObservableLongMeasurement $avgRamPlusSwapMinusFileMappingsGauge, ObservableLongMeasurement $avgFileMappingsRamGauge) {
            PlatformMemoryUtil.MemoryStats avgMemStats = $avgMemUsageProvider.getAvgCurrentProcessMemoryStats();
            if (avgMemStats != null) {
                $avgRamGauge.record(avgMemStats.getRam());
                $avgRamMinusFileMappingsGauge.record(avgMemStats.getRamMinusFileMappings());
                $avgRamPlusSwapMinusFileMappingsGauge.record(avgMemStats.getRamPlusSwapMinusFileMappings());
                $avgFileMappingsRamGauge.record(avgMemStats.getFileMappingsRam());
            }
        }
    }
}

