/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.util.io.FileUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB#\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u0003H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/execution/wsl/WslPath;", "", "prefix", "", "distributionId", "linuxPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getDistributionId", "()Ljava/lang/String;", "getLinuxPath", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "distribution$delegate", "Lkotlin/Lazy;", "wslRoot", "getWslRoot", "toWindowsUncPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.ide.impl"})
public final class WslPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prefix;
    @NotNull
    private final String distributionId;
    @NotNull
    private final String linuxPath;
    @NotNull
    private final Lazy distribution$delegate;

    public WslPath(@NotNull String prefix, @NotNull String distributionId, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        this.prefix = prefix;
        this.distributionId = distributionId;
        this.linuxPath = linuxPath;
        if (!StringsKt.endsWith$default((String)this.prefix, (String)"\\", (boolean)false, (int)2, null)) {
            throw new AssertionError((Object)(this.prefix + " should end with \\"));
        }
        this.distribution$delegate = LazyKt.lazy(() -> WslPath.distribution_delegate$lambda$0(this));
    }

    public /* synthetic */ WslPath(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\\\\wsl$\\";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getDistributionId() {
        return this.distributionId;
    }

    @NotNull
    public final String getLinuxPath() {
        return this.linuxPath;
    }

    public WslPath(@NotNull String distributionId, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        this("\\\\wsl$\\", distributionId, linuxPath);
    }

    @NotNull
    public final WSLDistribution getDistribution() {
        Lazy lazy = this.distribution$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (WSLDistribution)object;
    }

    @NotNull
    public final String getWslRoot() {
        return this.prefix + this.distributionId;
    }

    @NotNull
    public final String toWindowsUncPath() {
        return this.prefix + this.distributionId + FileUtil.toSystemDependentName((String)this.linuxPath);
    }

    private final String component1() {
        return this.prefix;
    }

    @NotNull
    public final String component2() {
        return this.distributionId;
    }

    @NotNull
    public final String component3() {
        return this.linuxPath;
    }

    @NotNull
    public final WslPath copy(@NotNull String prefix, @NotNull String distributionId, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        return new WslPath(prefix, distributionId, linuxPath);
    }

    public static /* synthetic */ WslPath copy$default(WslPath wslPath, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = wslPath.prefix;
        }
        if ((n & 2) != 0) {
            string2 = wslPath.distributionId;
        }
        if ((n & 4) != 0) {
            string3 = wslPath.linuxPath;
        }
        return wslPath.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "WslPath(prefix=" + this.prefix + ", distributionId=" + this.distributionId + ", linuxPath=" + this.linuxPath + ")";
    }

    public int hashCode() {
        int result2 = this.prefix.hashCode();
        result2 = result2 * 31 + this.distributionId.hashCode();
        result2 = result2 * 31 + this.linuxPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WslPath)) {
            return false;
        }
        WslPath wslPath = (WslPath)other;
        if (!Intrinsics.areEqual((Object)this.prefix, (Object)wslPath.prefix)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.distributionId, (Object)wslPath.distributionId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.linuxPath, (Object)wslPath.linuxPath);
    }

    private static final WSLDistribution distribution_delegate$lambda$0(WslPath this$0) {
        return WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this$0.distributionId);
    }

    @JvmStatic
    @Nullable
    public static final WslPath parseWindowsUncPath(@NotNull String windowsUncPath) {
        return Companion.parseWindowsUncPath(windowsUncPath);
    }

    @JvmStatic
    @Nullable
    public static final WSLDistribution getDistributionByWindowsUncPath(@NotNull String windowsUncPath) {
        return Companion.getDistributionByWindowsUncPath(windowsUncPath);
    }

    @JvmStatic
    public static final boolean isWslUncPath(@NotNull String windowsUncPath) {
        return Companion.isWslUncPath(windowsUncPath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/wsl/WslPath$Companion;", "", "<init>", "()V", "parseWindowsUncPath", "Lcom/intellij/execution/wsl/WslPath;", "windowsUncPath", "", "path", "prefix", "getDistributionByWindowsUncPath", "Lcom/intellij/execution/wsl/WSLDistribution;", "isWslUncPath", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final WslPath parseWindowsUncPath(@NotNull String windowsUncPath) {
            Intrinsics.checkNotNullParameter((Object)windowsUncPath, (String)"windowsUncPath");
            if (!WSLUtil.isSystemCompatible()) {
                return null;
            }
            String string = FileUtil.toSystemDependentName((String)windowsUncPath, (char)'\\');
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            String path = string;
            String legacyWslPrefix = "\\\\wsl$\\";
            String modernWslPrefix = "\\\\wsl.localhost\\";
            WslPath wslPath = this.parseWindowsUncPath(path, legacyWslPrefix);
            if (wslPath == null) {
                wslPath = this.parseWindowsUncPath(path, modernWslPrefix);
            }
            return wslPath;
        }

        private final WslPath parseWindowsUncPath(String path, String prefix) {
            int slashIndex;
            if (StringsKt.startsWith((String)path, (String)prefix, (boolean)true) && (slashIndex = StringsKt.indexOf$default((CharSequence)path, (char)'\\', (int)prefix.length(), (boolean)false, (int)4, null)) > prefix.length()) {
                String string = path.substring(prefix.length(), slashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = path.substring(slashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String string3 = FileUtil.toSystemIndependentName((String)string2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
                return new WslPath(prefix, string, string3);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final WSLDistribution getDistributionByWindowsUncPath(@NotNull String windowsUncPath) {
            Intrinsics.checkNotNullParameter((Object)windowsUncPath, (String)"windowsUncPath");
            WslPath wslPath = this.parseWindowsUncPath(windowsUncPath);
            return wslPath != null ? wslPath.getDistribution() : null;
        }

        @JvmStatic
        public final boolean isWslUncPath(@NotNull String windowsUncPath) {
            Intrinsics.checkNotNullParameter((Object)windowsUncPath, (String)"windowsUncPath");
            return this.parseWindowsUncPath(windowsUncPath) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

