/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProbablyIncreasingLowerboundAlgorithm<T extends AbstractBlockWrapper> {
    private List<T> myBlocks;
    private int myLastCalculatedOffset;
    private int myLastCalculatedAnswerIndex;

    ProbablyIncreasingLowerboundAlgorithm(@NotNull List<T> blocks) {
        if (blocks == null) {
            ProbablyIncreasingLowerboundAlgorithm.$$$reportNull$$$0(0);
        }
        this.myLastCalculatedOffset = -1;
        this.myLastCalculatedAnswerIndex = -1;
        this.myBlocks = blocks;
    }

    public void reset() {
        this.myLastCalculatedAnswerIndex = -1;
        this.myLastCalculatedOffset = -1;
    }

    public List<T> getLeftSubList(@Nullable AbstractBlockWrapper block) {
        return this.myBlocks.subList(0, this.getLeftRespNeighborIndex(block) + 1);
    }

    public void setBlocksList(List<T> blocks) {
        this.myBlocks = blocks;
        this.reset();
    }

    @Nullable
    public AbstractBlockWrapper getLeftRespNeighbor(@NotNull AbstractBlockWrapper block) {
        int index;
        if (block == null) {
            ProbablyIncreasingLowerboundAlgorithm.$$$reportNull$$$0(1);
        }
        if ((index = this.getLeftRespNeighborIndex(block)) == -1) {
            return null;
        }
        return (AbstractBlockWrapper)this.myBlocks.get(index);
    }

    private int getLeftRespNeighborIndex(@Nullable AbstractBlockWrapper block) {
        if (block == null) {
            return this.myBlocks.size() - 1;
        }
        int offset = block.getStartOffset();
        if (this.myLastCalculatedOffset != -1) {
            if (offset >= this.myLastCalculatedOffset) {
                this.myLastCalculatedAnswerIndex = this.calcLeftRespNeighborIndexLinear(this.myLastCalculatedAnswerIndex, offset);
                this.myLastCalculatedOffset = offset;
                return this.myLastCalculatedAnswerIndex;
            }
            this.myLastCalculatedOffset = -1;
        }
        this.myLastCalculatedOffset = offset;
        this.myLastCalculatedAnswerIndex = this.calcLeftRespNeighborIndex(offset);
        return this.myLastCalculatedAnswerIndex;
    }

    private int calcLeftRespNeighborIndexLinear(int lastAnswerIndex, int blockOffset) {
        int index = lastAnswerIndex;
        while (index + 1 < this.myBlocks.size() && blockOffset > ((AbstractBlockWrapper)this.myBlocks.get(index + 1)).getStartOffset()) {
            ++index;
        }
        return index;
    }

    private int calcLeftRespNeighborIndex(int blockOffset) {
        int i2 = ObjectUtils.binarySearch((int)0, (int)this.myBlocks.size(), m -> ((AbstractBlockWrapper)this.myBlocks.get(m)).getStartOffset() < blockOffset ? -1 : 1);
        return -i2 - 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/ProbablyIncreasingLowerboundAlgorithm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftRespNeighbor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

