/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageBlock
extends AbstractBlock
implements BlockWithParent {
    private final TemplateLanguageBlockFactory myBlockFactory;
    private final CodeStyleSettings mySettings;
    private List<DataLanguageBlockWrapper> myForeignChildren;
    private boolean myChildrenBuilt;
    private BlockWithParent myParent;

    protected TemplateLanguageBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (blockFactory == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(1);
        }
        if (node == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(2);
        }
        this(node, null, null, blockFactory, settings, foreignChildren);
    }

    protected TemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap2, @Nullable Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (node == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(3);
        }
        if (blockFactory == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(5);
        }
        super(node, wrap2, alignment);
        this.myChildrenBuilt = false;
        this.myBlockFactory = blockFactory;
        this.myForeignChildren = foreignChildren;
        this.mySettings = settings;
    }

    @Override
    protected List<Block> buildChildren() {
        this.myChildrenBuilt = true;
        if (this.isLeaf()) {
            return EMPTY;
        }
        ArrayList<Block> tlChildren = new ArrayList<Block>(5);
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(childNode) || !this.shouldBuildBlockFor(childNode)) continue;
            TemplateLanguageBlock childBlock = this.myBlockFactory.createTemplateLanguageBlock(childNode, this.createChildWrap(childNode), this.createChildAlignment(childNode), null, this.mySettings);
            childBlock.setParent(this);
            tlChildren.add((Block)childBlock);
        }
        ArrayList<Block> children2 = this.myForeignChildren == null ? tlChildren : BlockUtil.mergeBlocks(tlChildren, this.myForeignChildren);
        return BlockUtil.setParent(children2, this);
    }

    protected boolean shouldBuildBlockFor(ASTNode childNode) {
        return childNode.getElementType() != this.getTemplateTextElementType() || this.noForeignChildren();
    }

    private boolean noForeignChildren() {
        return this.myForeignChildren == null || this.myForeignChildren.isEmpty();
    }

    void addForeignChild(@NotNull DataLanguageBlockWrapper foreignChild) {
        if (foreignChild == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(6);
        }
        this.initForeignChildren();
        this.myForeignChildren.add(foreignChild);
    }

    void addForeignChildren(List<? extends DataLanguageBlockWrapper> foreignChildren) {
        this.initForeignChildren();
        this.myForeignChildren.addAll(foreignChildren);
    }

    private void initForeignChildren() {
        assert (!this.myChildrenBuilt);
        if (this.myForeignChildren == null) {
            this.myForeignChildren = new ArrayList<DataLanguageBlockWrapper>(5);
        }
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(7);
        }
        if (child1 instanceof DataLanguageBlockWrapper && child2 instanceof DataLanguageBlockWrapper) {
            return ((DataLanguageBlockWrapper)child1).getRightHandSpacing((DataLanguageBlockWrapper)child2);
        }
        return null;
    }

    @Nullable
    public Spacing getRightNeighborSpacing(@NotNull Block rightNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        if (rightNeighbor == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    public Spacing getLeftNeighborSpacing(@Nullable Block leftNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        if (parent == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(10);
        }
        return null;
    }

    public boolean isLeaf() {
        return this.noForeignChildren() && this.getNode().getFirstChildNode() == null;
    }

    protected abstract IElementType getTemplateTextElementType();

    @Override
    public BlockWithParent getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(BlockWithParent newParent) {
        this.myParent = newParent;
    }

    public boolean isRequiredRange(TextRange range) {
        return true;
    }

    protected Wrap createChildWrap(ASTNode child) {
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    }

    protected Alignment createChildAlignment(ASTNode child) {
        return null;
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public List<DataLanguageBlockWrapper> getForeignChildren() {
        return this.myForeignChildren;
    }

    @Nullable
    public Wrap substituteTemplateChildWrap(@NotNull DataLanguageBlockWrapper child, @Nullable Wrap childWrap) {
        if (child == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(11);
        }
        return childWrap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockFactory";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreignChild";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightNeighbor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/templateLanguages/TemplateLanguageBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addForeignChild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getRightNeighborSpacing";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftNeighborSpacing";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteTemplateChildWrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

