/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.IdeEventQueueKt;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;

final class FrameStateManagerAppListener
implements ApplicationActivationListener {
    private final FrameStateListener publisher = (FrameStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(FrameStateListener.TOPIC);

    private FrameStateManagerAppListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(e -> {
            if (e.getID() != 205 && e.getID() != 206) {
                return;
            }
            if (IdeEventQueueKt.getSkipWindowDeactivationEvents()) {
                Logger.getInstance(FrameStateManagerAppListener.class).warn("Skipped " + String.valueOf(e));
                return;
            }
            WindowEvent windowEvent = (WindowEvent)e;
            IdeFrame frame = ProjectUtil.getRootFrameForWindow(windowEvent.getWindow());
            if (frame == null) {
                return;
            }
            IdeFrame otherFrame = ProjectUtil.getRootFrameForWindow(windowEvent.getOppositeWindow());
            if (frame == otherFrame) {
                return;
            }
            if (FrameStateManagerAppListener.isDisposed()) {
                return;
            }
            if (e.getID() == 205) {
                this.publisher.onFrameActivated(frame);
            } else {
                this.publisher.onFrameDeactivated(frame);
            }
        }, 64L);
    }

    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            FrameStateManagerAppListener.$$$reportNull$$$0(0);
        }
        if (FrameStateManagerAppListener.isDisposed()) {
            return;
        }
        this.publisher.onFrameActivated();
        if (ideFrame instanceof IdeFrameImpl) {
            LifecycleUsageTriggerCollector.onFrameActivated(ideFrame.getProject());
        }
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            FrameStateManagerAppListener.$$$reportNull$$$0(1);
        }
        if (FrameStateManagerAppListener.isDisposed()) {
            return;
        }
        if (ideFrame instanceof IdeFrameImpl) {
            LifecycleUsageTriggerCollector.onFrameDeactivated(ideFrame.getProject());
        }
        this.publisher.onFrameDeactivated();
    }

    private static boolean isDisposed() {
        Application app = ApplicationManager.getApplication();
        return app == null || app.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "ideFrame";
        objectArray2[1] = "com/intellij/ide/FrameStateManagerAppListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applicationActivated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applicationDeactivated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

