/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectNameListener;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/ProjectWindowCustomizerIconCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "cachedIcon", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Ljavax/swing/Icon;", "getIconRaw", "intellij.platform.ide.impl"})
@ApiStatus.Internal
final class ProjectWindowCustomizerIconCache {
    @NotNull
    private final Project project;
    @JvmField
    @NotNull
    public final SynchronizedClearableLazy<Icon> cachedIcon;

    public ProjectWindowCustomizerIconCache(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.cachedIcon = new SynchronizedClearableLazy(() -> ProjectWindowCustomizerIconCache.cachedIcon$lambda$0(this));
        SimpleMessageBusConnection projectConnection = this.project.getMessageBus().connect(coroutineScope);
        SimpleMessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect(coroutineScope);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        projectConnection.subscribe(topic, arg_0 -> ProjectWindowCustomizerIconCache._init_$lambda$0(this, arg_0));
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        appConnection.subscribe(topic2, arg_0 -> ProjectWindowCustomizerIconCache._init_$lambda$1(this, arg_0));
        projectConnection.subscribe(ProjectNameListener.TOPIC, (Object)new ProjectNameListener(){

            @Override
            public void nameChanged(String newName) {
                cachedIcon.drop();
            }
        });
    }

    private final Icon getIconRaw() {
        Object object = ProjectWindowCustomizerService.Companion.projectPath(this.project);
        if (object == null || (object = PathsKt.getInvariantSeparatorsPathString((Path)object)) == null) {
            object = "";
        }
        Object path = object;
        int size2 = JBUI.CurrentTheme.Toolbar.recentProjectAvatarIconSize();
        return RecentProjectsManagerBase.Companion.getInstanceEx().getProjectIcon((String)path, true, size2, this.project.getName());
    }

    private static final Icon cachedIcon$lambda$0(ProjectWindowCustomizerIconCache this$0) {
        return this$0.getIconRaw();
    }

    private static final void _init_$lambda$0(ProjectWindowCustomizerIconCache this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cachedIcon.drop();
    }

    private static final void _init_$lambda$1(ProjectWindowCustomizerIconCache this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cachedIcon.drop();
    }
}

