/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProject;
import com.intellij.ide.RecentProjectIconHelperKt;
import com.intellij.ide.RecentProjectStatus;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.wm.impl.headertoolbar.ProjectStatus;
import com.intellij.openapi.wm.impl.headertoolbar.ProjectToolbarWidgetPresentable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u001b\u0010\u000f\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u001b\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001b\u0010\u0013\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0019\u0010#\u001a\u00070\u0003\u00a2\u0006\u0002\b\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\t\u00a8\u0006%"}, d2={"Lcom/intellij/ide/RemoteRecentProjectWidgetActionHelper;", "Lcom/intellij/openapi/wm/impl/headertoolbar/ProjectToolbarWidgetPresentable;", "projectId", "", "project", "Lcom/intellij/ide/RecentProject;", "<init>", "(Ljava/lang/String;Lcom/intellij/ide/RecentProject;)V", "getProjectId", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/ide/RecentProject;", "projectNameToDisplay", "Lcom/intellij/openapi/util/NlsSafe;", "getProjectNameToDisplay", "providerPathToDisplay", "getProviderPathToDisplay", "projectPathToDisplay", "getProjectPathToDisplay", "branchName", "getBranchName", "projectIcon", "Ljavax/swing/Icon;", "getProjectIcon", "()Ljavax/swing/Icon;", "providerIcon", "getProviderIcon", "activationTimestamp", "", "getActivationTimestamp", "()Ljava/lang/Long;", "status", "Lcom/intellij/openapi/wm/impl/headertoolbar/ProjectStatus;", "getStatus", "()Lcom/intellij/openapi/wm/impl/headertoolbar/ProjectStatus;", "nameToDisplayAsText", "getNameToDisplayAsText", "intellij.platform.ide.impl"})
final class RemoteRecentProjectWidgetActionHelper
implements ProjectToolbarWidgetPresentable {
    @NotNull
    private final String projectId;
    @NotNull
    private final RecentProject project;
    @NotNull
    private final String projectNameToDisplay;
    @Nullable
    private final String projectPathToDisplay;
    @Nullable
    private final String branchName;

    public RemoteRecentProjectWidgetActionHelper(@NotNull String projectId, @NotNull RecentProject project2) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.projectId = projectId;
        this.project = project2;
        this.projectNameToDisplay = this.project.getDisplayName();
        this.projectPathToDisplay = this.project.getProjectPath();
        this.branchName = this.project.getBranchName();
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final RecentProject getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getProjectNameToDisplay() {
        return this.projectNameToDisplay;
    }

    @Override
    @Nullable
    public String getProviderPathToDisplay() {
        return this.project.getProviderPath();
    }

    @Override
    @Nullable
    public String getProjectPathToDisplay() {
        return this.projectPathToDisplay;
    }

    @Override
    @Nullable
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    @NotNull
    public Icon getProjectIcon() {
        Icon icon2 = this.project.getIcon();
        if (icon2 == null) {
            icon2 = RecentProjectsManagerBase.Companion.getInstanceEx().getNonLocalProjectIcon(this.projectId, true, RecentProjectIconHelperKt.unscaledProjectIconSize(), this.project.getDisplayName());
        }
        return icon2;
    }

    @Override
    @Nullable
    public Icon getProviderIcon() {
        return this.project.getProviderIcon();
    }

    @Override
    @Nullable
    public Long getActivationTimestamp() {
        return this.project.getActivationTimestamp();
    }

    @Override
    @NotNull
    public ProjectStatus getStatus() {
        RecentProjectStatus status2 = this.project.getStatus();
        return new ProjectStatus(status2.isOpened(), status2.getStatusText(), status2.getProgressText());
    }

    @Override
    @NotNull
    public String getNameToDisplayAsText() {
        Object text2 = this.project.getDisplayName();
        if (this.project.getProviderName() != null) {
            text2 = (String)text2 + " [" + this.project.getProviderName() + "]";
        }
        if (this.project.getBranchName() != null) {
            text2 = (String)text2 + " [" + this.project.getBranchName() + "]";
        }
        return text2;
    }
}

