/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.FilePageCacheLockFree;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.Component;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ActivityMonitorAction
extends DumbAwareAction {
    @NonNls
    private static final String[] MEANINGLESS_PREFIXES_1 = new String[]{"com.intellij.", "com.jetbrains.", "org.jetbrains.", "org.intellij."};
    @NonNls
    private static final String[] MEANINGLESS_PREFIXES_2 = new String[]{"util.", "openapi.", "plugins.", "extapi."};
    @NonNls
    private static final String[] INFRASTRUCTURE_PREFIXES = new String[]{"sun.", "com.sun.", "com.yourkit.", "com.fasterxml.jackson.", "net.sf.cglib.", "org.jetbrains.org.objectweb.asm.", "org.picocontainer.", "net.jpountz.lz4.", "net.n3.nanoxml.", "org.apache.", "one.util.streamex", "java.", "gnu.", "kotlin.", "groovy.", "org.codehaus.groovy.", "org.gradle.", "com.google.common.", "com.google.gson.", "com.intellij.openapi.application.impl.", "com.intellij.psi.impl.", "com.intellij.extapi.psi.", "com.intellij.psi.util.Cached", "com.intellij.openapi.extensions.", "com.intellij.openapi.util.", "com.intellij.facet.", "com.intellij.util.", "com.intellij.concurrency.", "com.intellij.semantic.", "com.intellij.serviceContainer.", "com.intellij.jam.", "com.intellij.psi.stubs.", "com.intellij.openapi.progress.impl.", "com.intellij.ide.IdeEventQueue", "com.intellij.openapi.fileTypes.", "com.intellij.openapi.vfs.newvfs.persistent.PersistentFS", "com.intellij.openapi.vfs.newvfs.persistent.FSRecords", "com.intellij.util.io.pagecache", FilePageCacheLockFree.class.getName(), "com.intellij.openapi.roots.impl", "javax."};

    ActivityMonitorAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ActivityMonitorAction.$$$reportNull$$$0(0);
        }
        final JTextArea textArea = new JTextArea(12, 100);
        textArea.setText(CommonBundle.getLoadingTreeNodeText());
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        final CompilationMXBean jitBean = ManagementFactory.getCompilationMXBean();
        final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        final Method getProcessCpuTime = Objects.requireNonNull(ReflectionUtil.getMethod(osBean.getClass().getInterfaces()[0], (String)"getProcessCpuTime", (Class[])new Class[0]));
        ScheduledFuture<?> future = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){
            final Long2LongMap lastThreadTimes = new Long2LongOpenHashMap();
            final Object2LongMap<String> subsystemToSamples = new Object2LongOpenHashMap();
            long lastGcTime = this.totalGcTime();
            long lastProcessTime = this.totalProcessTime();
            long lastJitTime = jitBean.getTotalCompilationTime();
            long lastUiUpdate = System.currentTimeMillis();
            private final Map<String, String> classToSubsystem = new HashMap<String, String>();

            @NotNull
            private String calcSubSystemName(String className) {
                IdeaPluginDescriptor plugin;
                String prefix;
                Object pkg = StringUtil.getPackageName((String)className);
                if (((String)pkg).isEmpty()) {
                    pkg = className;
                }
                if (!(prefix = this.getMeaninglessPrefix((String)pkg)).isEmpty()) {
                    pkg = ((String)pkg).substring(prefix.length()) + " (in " + StringUtil.trimEnd((String)prefix, (String)".") + ")";
                }
                Object object = (plugin = PluginManagerCore.getPlugin((PluginId)PluginManager.getPluginByClassNameAsNoAccessToClass((String)className))) == null ? pkg : "Plugin " + plugin.getName() + ": " + (String)pkg;
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                return object;
            }

            private String getMeaninglessPrefix(String qname) {
                Object result2 = 1.findPrefix(qname, MEANINGLESS_PREFIXES_1);
                if (!((String)result2).isEmpty()) {
                    result2 = (String)result2 + 1.findPrefix(qname.substring(((String)result2).length()), MEANINGLESS_PREFIXES_2);
                }
                return result2;
            }

            private static String findPrefix(String qname, String[] prefixes) {
                for (String prefix : prefixes) {
                    if (!qname.startsWith(prefix)) continue;
                    return prefix;
                }
                return "";
            }

            private long totalGcTime() {
                return gcBeans.stream().mapToLong(GarbageCollectorMXBean::getCollectionTime).sum();
            }

            private long totalProcessTime() {
                try {
                    return (Long)getProcessCpuTime.invoke((Object)osBean, new Object[0]);
                }
                catch (Exception ex) {
                    return 0L;
                }
            }

            @NotNull
            private String getSubsystemName(long threadId) {
                boolean runnable2;
                if (threadId == Thread.currentThread().getId()) {
                    return "<Activity Monitor>";
                }
                ThreadInfo info = threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                if (info == null) {
                    return "<unidentified: thread finished>";
                }
                boolean bl = runnable2 = info.getThreadState() == Thread.State.RUNNABLE;
                if (runnable2) {
                    for (StackTraceElement element : info.getStackTrace()) {
                        String className = element.getClassName();
                        if (1.isInfrastructureClass(className)) continue;
                        String string = this.classToSubsystem.computeIfAbsent(className, this::calcSubSystemName);
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                }
                String string = (runnable2 ? "<infrastructure: " : "<unidentified: ") + 1.getCommonThreadName(info) + ">";
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static String getCommonThreadName(ThreadInfo info) {
                String name2 = info.getThreadName();
                if (ThreadDumper.isEDT((String)name2)) {
                    return "UI thread";
                }
                int numberStart = CharArrayUtil.shiftBackward((CharSequence)name2, (int)(name2.length() - 1), (String)"0123456789/ ") + 1;
                if (numberStart > 0) {
                    return name2.substring(0, numberStart);
                }
                return name2;
            }

            private static boolean isInfrastructureClass(String className) {
                return ContainerUtil.exists((Object[])INFRASTRUCTURE_PREFIXES, className::startsWith);
            }

            @Override
            public void run() {
                for (long id2 : threadBean.getAllThreadIds()) {
                    long cpuTime = threadBean.getThreadCpuTime(id2);
                    long prev = this.lastThreadTimes.put(id2, cpuTime);
                    if (prev == 0L || cpuTime <= prev) continue;
                    String subsystem = this.getSubsystemName(id2);
                    this.subsystemToSamples.put((Object)subsystem, this.subsystemToSamples.getLong((Object)subsystem) + cpuTime - prev);
                }
                long now = System.currentTimeMillis();
                long sinceLastUpdate = now - this.lastUiUpdate;
                if (sinceLastUpdate > 2000L) {
                    this.lastUiUpdate = now;
                    this.scheduleUiUpdate(sinceLastUpdate);
                }
            }

            private void scheduleUiUpdate(long sinceLastUpdate) {
                List<Pair<String, Long>> times = this.takeSnapshot();
                String text2 = " %CPU  Subsystem\n\n" + ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(times).filter(p -> (Long)p.second > 10L)).sorted(Comparator.comparing(p -> (Long)p.second).reversed())).limit(8L)).map(p -> String.format("%5.1f  %s", (double)((Long)p.second).longValue() * 100.0 / (double)sinceLastUpdate, p.first)).joining((CharSequence)"\n");
                ApplicationManager.getApplication().invokeLater(() -> {
                    textArea.setText(text2);
                    textArea.setCaretPosition(0);
                }, ModalityState.any());
            }

            @NotNull
            private List<Pair<String, Long>> takeSnapshot() {
                long processTime;
                long jitTime;
                ArrayList<Pair<String, Long>> times = new ArrayList<Pair<String, Long>>();
                for (Object2LongMap.Entry entry : this.subsystemToSamples.object2LongEntrySet()) {
                    times.add(new Pair((Object)((String)entry.getKey()), (Object)TimeUnit.NANOSECONDS.toMillis(entry.getLongValue())));
                }
                this.subsystemToSamples.clear();
                long gcTime = this.totalGcTime();
                if (gcTime != this.lastGcTime) {
                    times.add(Pair.create((Object)"<Garbage collection>", (Object)(gcTime - this.lastGcTime)));
                    this.lastGcTime = gcTime;
                }
                if ((jitTime = jitBean.getTotalCompilationTime()) != this.lastJitTime) {
                    times.add(Pair.create((Object)"<JIT compiler>", (Object)(jitTime - this.lastJitTime)));
                    this.lastJitTime = jitTime;
                }
                if ((processTime = this.totalProcessTime()) != this.lastProcessTime) {
                    times.add((Pair<String, Long>)Pair.create((Object)"<Process total CPU usage>", (Object)TimeUnit.NANOSECONDS.toMillis(processTime - this.lastProcessTime)));
                    this.lastProcessTime = processTime;
                }
                ArrayList<Pair<String, Long>> arrayList = times;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/actions/ActivityMonitorAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "calcSubSystemName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubsystemName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "takeSnapshot";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }, 0L, 20L, TimeUnit.MILLISECONDS);
        DialogWrapper dialog2 = new DialogWrapper(this, false){
            {
                super(arg0);
                this.init();
            }

            protected JComponent createCenterPanel() {
                JBScrollPane pane2 = new JBScrollPane((Component)textArea);
                pane2.setPreferredSize(textArea.getPreferredSize());
                return pane2;
            }

            protected String getDimensionServiceKey() {
                return "Performance.Activity.Monitor";
            }

            protected Action @NotNull [] createActions() {
                Action[] actionArray = new Action[]{this.getOKAction()};
                if (actionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ActivityMonitorAction$2", "createActions"));
            }
        };
        dialog2.setTitle(IdeBundle.message((String)"dialog.title.activity.monitor", (Object[])new Object[0]));
        dialog2.setModal(false);
        Disposer.register((Disposable)dialog2.getDisposable(), () -> future.cancel(false));
        dialog2.show();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ActivityMonitorAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ActivityMonitorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ActivityMonitorAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

