/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowTypeExtensionsKt;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/actions/HideToolWindowAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Manager", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHideToolWindowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HideToolWindowAction.kt\ncom/intellij/ide/actions/HideToolWindowAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class HideToolWindowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        ToolWindowManagerImpl toolWindowManager2 = (ToolWindowManagerImpl)toolWindowManager;
        String string = toolWindowManager2.getActiveToolWindowId();
        if (string == null && (string = toolWindowManager2.getLastActiveToolWindowId()) == null) {
            return;
        }
        String id2 = string;
        ToolWindowManagerImpl.hideToolWindow$default(toolWindowManager2, id2, false, false, false, ToolWindowEventSource.HideToolWindowAction, 14, null);
    }

    public void update(@NotNull AnActionEvent event) {
        ToolWindow window;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation2 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        Project project2 = event.getProject();
        if (project2 == null) {
            presentation3.setEnabled(false);
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        String string = toolWindowManager.getActiveToolWindowId();
        if (string == null) {
            string = toolWindowManager.getLastActiveToolWindowId();
        }
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            v2 = toolWindowManager.getToolWindow(p0);
        } else {
            v2 = window = null;
        }
        if (window == null) {
            presentation3.setEnabled(false);
        } else if (window.isVisible() && UIUtil.isDescendingFrom((Component)IdeFocusManager.getGlobalInstance().getFocusOwner(), (Component)window.getComponent())) {
            presentation3.setEnabled(true);
        } else {
            presentation3.setEnabled(Manager.INSTANCE.shouldBeHiddenByShortCut$intellij_platform_ide_impl(window));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/HideToolWindowAction$Manager;", "", "<init>", "()V", "shouldBeHiddenByShortCut", "", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "shouldBeHiddenByShortCut$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean shouldBeHiddenByShortCut$intellij_platform_ide_impl(@NotNull ToolWindow window) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            if (!window.isVisible()) return false;
            ToolWindowType toolWindowType = window.getType();
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowType, (String)"getType(...)");
            if (!ToolWindowTypeExtensionsKt.isInternal(toolWindowType)) return false;
            return true;
        }
    }
}

