/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.idea.ActionsBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.OS;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevealFileAction
extends DumbAwareAction
implements LightEditCompatible,
ActionRemoteBehaviorSpecification.Disabled {
    private static final Logger LOG = Logger.getInstance(RevealFileAction.class);
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
            URL url;
            if (notification2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((url = e.getURL()) != null) {
                try {
                    RevealFileAction.openFile(Path.of(url.toURI()));
                }
                catch (URISyntaxException | InvalidPathException ex) {
                    LOG.warn("invalid URL: " + String.valueOf(url), (Throwable)ex);
                }
            }
            notification2.hideBalloon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/RevealFileAction$1";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public RevealFileAction() {
        this.getTemplatePresentation().setText(RevealFileAction.getActionName(true));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevealFileAction.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        e.getPresentation().setEnabledAndVisible(RevealFileAction.isSupported() && RevealFileAction.getFile(e) != null && (!e.isFromContextMenu() || editor2 == null || !editor2.getSelectionModel().hasSelection() || EditorUtil.contextMenuInvokedOutsideOfSelection(e)));
        e.getPresentation().setText(RevealFileAction.getActionName(e.getPlace()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RevealFileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            RevealFileAction.$$$reportNull$$$0(2);
        }
        if ((file2 = RevealFileAction.getFile(e)) != null) {
            RevealFileAction.openFile(file2.toNioPath());
        }
    }

    @Nullable
    private static VirtualFile getFile(AnActionEvent e) {
        return RevealFileAction.findLocalFile((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    public static boolean isSupported() {
        return OS.CURRENT == OS.Windows || OS.CURRENT == OS.macOS || Holder.fileManagerApp != null;
    }

    public static boolean isDirectoryOpenSupported() {
        return OS.CURRENT == OS.Windows || OS.CURRENT == OS.macOS || Holder.fileManagerApp != null;
    }

    @NlsActions.ActionText
    @NotNull
    public static String getActionName() {
        return RevealFileAction.getActionName(null);
    }

    @NlsActions.ActionText
    @NotNull
    public static String getActionName(@Nullable String place) {
        boolean shortName = "RevealInPopup".equals(place);
        String string = shortName ? RevealFileAction.getFileManagerName() : RevealFileAction.getActionName(false);
        if (string == null) {
            RevealFileAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsActions.ActionText
    private static String getActionName(boolean skipDetection) {
        return OS.CURRENT == OS.macOS ? ActionsBundle.message((String)"action.RevealIn.name.mac", (Object[])new Object[0]) : ActionsBundle.message((String)"action.RevealIn.name.other", (Object[])new Object[]{RevealFileAction.getFileManagerName(skipDetection)});
    }

    public void applyTextOverride(@NotNull String place, @NotNull Presentation presentation2) {
        if (place == null) {
            RevealFileAction.$$$reportNull$$$0(4);
        }
        if (presentation2 == null) {
            RevealFileAction.$$$reportNull$$$0(5);
        }
        if ("RevealInPopup".equals(place)) {
            presentation2.setText(RevealFileAction.getActionName(place));
        } else {
            super.applyTextOverride(place, presentation2);
        }
    }

    @NotNull
    @NlsActions.ActionText
    public static String getFileManagerName() {
        return RevealFileAction.getFileManagerName(false);
    }

    @NotNull
    @NlsActions.ActionText
    public static String getFileManagerName(boolean skipDetection) {
        String string = OS.CURRENT == OS.Windows ? IdeBundle.message((String)"action.explorer.text", (Object[])new Object[0]) : (OS.CURRENT == OS.macOS ? IdeBundle.message((String)"action.finder.text", (Object[])new Object[0]) : (skipDetection ? IdeBundle.message((String)"action.file.manager.text", (Object[])new Object[0]) : Objects.requireNonNullElseGet(Holder.fileManagerName, () -> IdeBundle.message((String)"action.file.manager.text", (Object[])new Object[0]))));
        if (string == null) {
            RevealFileAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isInLocalFileSystem()) {
            return file2;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof ArchiveFileSystem && file2.getParent() == null) {
            return ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return null;
    }

    @ApiStatus.Obsolete
    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            RevealFileAction.$$$reportNull$$$0(7);
        }
        RevealFileAction.openFile(file2.toPath());
    }

    public static void openFile(@NotNull Path file2) {
        Path parent;
        if (file2 == null) {
            RevealFileAction.$$$reportNull$$$0(8);
        }
        if ((parent = RevealFileAction.canonicalize(file2).getParent()) != null) {
            RevealFileAction.doOpen(parent, file2);
        } else {
            RevealFileAction.doOpen(file2, null);
        }
    }

    @ApiStatus.Obsolete
    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            RevealFileAction.$$$reportNull$$$0(9);
        }
        RevealFileAction.doOpen(directory.toPath(), null);
    }

    public static void openDirectory(@NotNull Path directory) {
        if (directory == null) {
            RevealFileAction.$$$reportNull$$$0(10);
        }
        RevealFileAction.doOpen(directory, null);
    }

    private static void doOpen(@NotNull Path _dir, @Nullable Path _toSelect) {
        String toSelect;
        if (_dir == null) {
            RevealFileAction.$$$reportNull$$$0(11);
        }
        String dir = RevealFileAction.canonicalize(_dir).normalize().toString();
        String string = toSelect = _toSelect != null ? RevealFileAction.canonicalize(_toSelect).normalize().toString() : null;
        if (OS.CURRENT == OS.Windows) {
            if (JnaLoader.isLoaded()) {
                RevealFileAction.openViaShellApi(dir, toSelect);
            } else {
                RevealFileAction.openViaExplorerCall(dir, toSelect);
            }
        } else if (OS.CURRENT == OS.macOS) {
            if (toSelect != null) {
                RevealFileAction.spawn("open", "-R", toSelect);
            } else {
                RevealFileAction.spawn("open", dir);
            }
        } else {
            String fmApp = Holder.fileManagerApp;
            if (fmApp != null) {
                if (toSelect != null && fmApp.endsWith("dolphin")) {
                    RevealFileAction.spawn(fmApp, "--select", toSelect);
                } else if (toSelect != null && fmApp.endsWith("dde-file-manager")) {
                    RevealFileAction.spawn(fmApp, "--show-item", toSelect);
                } else {
                    RevealFileAction.spawn(fmApp, toSelect != null ? toSelect : dir);
                }
            } else if (toSelect == null && PathEnvironmentVariableUtil.isOnPath((String)"xdg-open")) {
                RevealFileAction.spawn("xdg-open", dir);
            } else {
                String message = IdeBundle.message((String)"reveal.unsupported.message", (Object[])new Object[]{Objects.requireNonNullElse(toSelect, dir)});
                new Notification("System Messages", message, NotificationType.WARNING).notify(null);
            }
        }
    }

    private static void openViaShellApi(String dir, @Nullable String toSelect) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shell open: dir=" + dir + " toSelect=" + toSelect);
        }
        ProcessIOExecutorService.INSTANCE.execute(() -> {
            Ole32.INSTANCE.CoInitializeEx(null, 2);
            if (toSelect == null) {
                WinDef.INT_PTR res = Shell32.INSTANCE.ShellExecute(null, "explore", dir, null, null, 1);
                if (res.intValue() <= 32) {
                    LOG.warn("ShellExecute(" + dir + "): " + res.intValue() + " GetLastError=" + Kernel32.INSTANCE.GetLastError());
                    RevealFileAction.openViaExplorerCall(dir, null);
                }
            } else {
                Pointer pIdl = Shell32Ex.INSTANCE.ILCreateFromPath(dir);
                Pointer[] apIdl = new Pointer[]{Shell32Ex.INSTANCE.ILCreateFromPath(toSelect)};
                WinDef.UINT cIdl = new WinDef.UINT((long)apIdl.length);
                try {
                    WinNT.HRESULT res = Shell32Ex.INSTANCE.SHOpenFolderAndSelectItems(pIdl, cIdl, apIdl, new WinDef.DWORD(0L));
                    if (!WinError.S_OK.equals((Object)res)) {
                        LOG.warn("SHOpenFolderAndSelectItems(" + dir + "," + toSelect + "): 0x" + Integer.toHexString(res.intValue()));
                        RevealFileAction.openViaExplorerCall(dir, toSelect);
                    }
                }
                finally {
                    Shell32Ex.INSTANCE.ILFree(pIdl);
                    Shell32Ex.INSTANCE.ILFree(apIdl[0]);
                }
            }
        });
    }

    private static Path canonicalize(@NotNull Path path) {
        if (path == null) {
            RevealFileAction.$$$reportNull$$$0(12);
        }
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            LOG.info("Could not convert " + String.valueOf(path) + " to canonical path", (Throwable)e);
            return path.toAbsolutePath();
        }
    }

    private static void openViaExplorerCall(String dir, @Nullable String toSelect) {
        RevealFileAction.spawn(toSelect != null ? "explorer /select,\"" + toSelect + "\"" : "explorer /root,\"" + dir + "\"");
    }

    private static void spawn(String ... command) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Arrays.toString(command));
        }
        ProcessIOExecutorService.INSTANCE.execute(() -> {
            try {
                Process process2 = OS.CURRENT == OS.Windows ? Runtime.getRuntime().exec(command[0]) : new ProcessBuilder(command).start();
                new CapturingProcessHandler.Silent(process2, null, command[0]).runProcess(10000, false).checkSuccess(LOG);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RevealFileAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RevealFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManagerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyTextOverride";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doOpen";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        @Nullable
        private static final String fileManagerApp;
        @Nullable
        @NlsSafe
        private static final String fileManagerName;

        private Holder() {
        }

        private static String getXdgDataDirectories() {
            return (String)((Object)Objects.requireNonNullElse(System.getenv("XDG_DATA_HOME"), SystemProperties.getUserHome() + "/.local/share")) + ":" + Objects.requireNonNullElse(System.getenv("XDG_DATA_DIRS"), "/usr/local/share:/usr/share");
        }

        private static String getExecCommand(String value) {
            int p;
            if (value.startsWith("\"") && (p = value.lastIndexOf(34)) > 1) {
                return value.substring(1, p);
            }
            return value.split(" ")[0];
        }

        static {
            String fmApp = null;
            String fmName = null;
            if (PathEnvironmentVariableUtil.isOnPath((String)"xdg-mime")) {
                try (BufferedReader reader = new ProcessBuilder("xdg-mime", "query", "default", "inode/directory").start().inputReader();){
                    Optional<Path> desktopFile;
                    String desktopEntryName = reader.readLine();
                    if (desktopEntryName != null && desktopEntryName.endsWith(".desktop") && (desktopFile = Stream.of(Holder.getXdgDataDirectories().split(":")).map(dir -> Path.of(dir, "applications", desktopEntryName)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst()).isPresent()) {
                        List<String> lines = Files.readAllLines(desktopFile.get());
                        fmApp = lines.stream().filter(line -> line.startsWith("Exec=")).map(line -> Holder.getExecCommand(line.substring(5))).findFirst().orElse(null);
                        fmName = lines.stream().filter(line -> line.startsWith("Name=")).map(line -> line.substring(5)).findFirst().orElse(null);
                    }
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            fileManagerApp = fmApp;
            fileManagerName = fmName;
        }
    }

    private static interface Shell32Ex
    extends StdCallLibrary {
        public static final Shell32Ex INSTANCE = (Shell32Ex)Native.load((String)"shell32", Shell32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public Pointer ILCreateFromPath(String var1);

        public void ILFree(Pointer var1);

        public WinNT.HRESULT SHOpenFolderAndSelectItems(Pointer var1, WinDef.UINT var2, Pointer[] var3, WinDef.DWORD var4);
    }
}

