/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.ide.actions.SwitcherRenderingKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0019\u0010\u0015\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u001b\u0010\u0018\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/intellij/ide/actions/SwitcherToolWindow;", "Lcom/intellij/ide/actions/SwitcherListItem;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "shortcut", "", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;Z)V", "getWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "actionId", "", "Lorg/jetbrains/annotations/NonNls;", "mnemonic", "getMnemonic", "()Ljava/lang/String;", "setMnemonic", "(Ljava/lang/String;)V", "mainText", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "getMainText", "statusText", "Lorg/jetbrains/annotations/Nls;", "getStatusText", "shortcutText", "Lcom/intellij/openapi/util/NlsSafe;", "getShortcutText", "navigate", "", "switcher", "Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "mode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "close", "prepareMainRenderer", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "intellij.platform.ide.impl"})
public final class SwitcherToolWindow
implements SwitcherListItem {
    @NotNull
    private final ToolWindow window;
    @NotNull
    private final String actionId;
    @Nullable
    private String mnemonic;
    @NotNull
    private final String mainText;
    @NotNull
    private final String statusText;
    @Nullable
    private final String shortcutText;

    public SwitcherToolWindow(@NotNull ToolWindow window, boolean shortcut) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.window = window;
        String string = this.window.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.actionId = ActivateToolWindowAction.Manager.getActionIdForToolWindow(string);
        String string2 = this.window.getStripeTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStripeTitle(...)");
        this.mainText = string2;
        Object[] objectArray = new Object[]{this.getMainText()};
        String string3 = IdeBundle.message((String)"recent.files.accessible.show.tool.window", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.statusText = string3;
        this.shortcutText = shortcut ? SwitcherRenderingKt.access$shortcutText(this.actionId) : null;
    }

    @NotNull
    public final ToolWindow getWindow() {
        return this.window;
    }

    @Override
    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(@Nullable String string) {
        this.mnemonic = string;
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.mainText;
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return this.shortcutText;
    }

    @Override
    public void navigate(@NotNull Switcher.SwitcherPanel switcher, @NotNull FileEditorManagerImpl.OpenMode mode) {
        ToolWindowManagerImpl manager2;
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(switcher.getProject());
        ToolWindowManagerImpl toolWindowManagerImpl = manager2 = toolWindowManager instanceof ToolWindowManagerImpl ? (ToolWindowManagerImpl)toolWindowManager : null;
        if (toolWindowManagerImpl != null) {
            String string = this.window.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            toolWindowManagerImpl.activateToolWindow(string, null, true, switcher.isSpeedSearchPopupActive() ? ToolWindowEventSource.SwitcherSearch : ToolWindowEventSource.Switcher);
        } else {
            this.window.activate(null, true);
        }
    }

    @Override
    public void close(@NotNull Switcher.SwitcherPanel switcher) {
        ToolWindowManagerImpl manager2;
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(switcher.getProject());
        ToolWindowManagerImpl toolWindowManagerImpl = manager2 = toolWindowManager instanceof ToolWindowManagerImpl ? (ToolWindowManagerImpl)toolWindowManager : null;
        if (toolWindowManagerImpl != null) {
            String string = this.window.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            ToolWindowManagerImpl.hideToolWindow$default(toolWindowManagerImpl, string, false, false, false, ToolWindowEventSource.CloseFromSwitcher, 10, null);
        } else {
            this.window.hide();
        }
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component2, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Icon defaultIcon = ExperimentalUI.Companion.isNewUI() ? EmptyIcon.ICON_16 : EmptyIcon.ICON_13;
        component2.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
        Icon icon2 = ExperimentalUI.Companion.isNewUI() ? this.window.getIcon() : RenderingUtil.getIcon((Icon)this.window.getIcon(), (boolean)selected);
        Intrinsics.checkNotNull((Object)defaultIcon);
        component2.setIcon(IconUtil.scaleByIconWidth((Icon)icon2, null, (Icon)defaultIcon));
        component2.append(this.getMainText());
    }
}

