/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Supplier<? extends Iterable<? extends JComponent>> myProducer;

    @NotNull
    public static DefaultActionGroup createToggleToolbarGroup(@NotNull Project project2, @NotNull ToolWindow toolWindow2) {
        if (project2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(0);
        }
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(1);
        }
        return new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow2), ToggleToolbarAction.createToolWindowAction(toolWindow2, PropertiesComponent.getInstance((Project)project2))});
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id2, @NotNull PropertiesComponent properties, @NotNull Supplier<? extends Iterable<? extends JComponent>> components) {
        if (id2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(3);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(4);
        }
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(id2), components);
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow2, final @NotNull PropertiesComponent properties) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(6);
        }
        ToggleToolbarAction.updateToolbarsVisibility(toolWindow2, properties);
        toolWindow2.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                JComponent component2 = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible(Collections.singletonList(component2), ToggleToolbarAction.isToolbarVisible(toolWindow2, properties));
                ContentManager contentManager = ContentManagerImpl.getContentManager(component2);
                if (contentManager != null) {
                    contentManager.addContentManagerListener((ContentManagerListener)this);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getOperation() != ContentManagerEvent.ContentOperation.remove) {
                    ToggleToolbarAction.updateToolbarsVisibility(toolWindow2, properties);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow2), () -> {
            ContentManager manager2 = toolWindow2.getContentManagerIfCreated();
            return ContainerUtil.createMaybeSingletonList((Object)(manager2 == null ? null : manager2.getComponent()));
        });
    }

    private static void updateToolbarsVisibility(@NotNull ToolWindow toolWindow2, @NotNull PropertiesComponent properties) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(8);
        }
        if (toolWindow2.getContentManagerIfCreated() == null) {
            return;
        }
        ToggleToolbarAction.setToolbarVisible(Collections.singletonList(toolWindow2.getComponent()), ToggleToolbarAction.isToolbarVisible(toolWindow2, properties));
    }

    public static void updateToolbarVisibility(@NotNull ToolWindow toolWindow2, @NotNull ActionToolbar toolbar2, @NotNull PropertiesComponent properties) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(9);
        }
        if (toolbar2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(10);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(11);
        }
        ToggleToolbarAction.setToolbarVisible(toolbar2, ToggleToolbarAction.isToolbarVisible(toolWindow2, properties));
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow2, @NotNull PropertiesComponent properties, @Nullable Boolean visible) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(12);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(13);
        }
        boolean state2 = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow2, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow2), properties, Collections.singletonList(toolWindow2.getComponent()), state2);
    }

    public static void setToolbarVisible(@NotNull String id2, @NotNull PropertiesComponent properties, @NotNull Iterable<? extends JComponent> components, @Nullable Boolean visible) {
        if (id2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(14);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(15);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(16);
        }
        boolean state2 = visible == null ? ToggleToolbarAction.isToolbarVisible(id2, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id2), properties, components, state2);
    }

    public static void setToolbarVisible(@NotNull Iterable<? extends JComponent> roots, boolean state2) {
        if (roots == null) {
            ToggleToolbarAction.$$$reportNull$$$0(17);
        }
        for (ActionToolbar toolbar2 : ToggleToolbarAction.iterateToolbars(roots)) {
            ToggleToolbarAction.setToolbarVisible(toolbar2, state2);
        }
    }

    private static void setToolbarVisible(ActionToolbar toolbar2, boolean state2) {
        JComponent c = toolbar2.getComponent();
        c.setVisible(state2);
        Container parent = c.getParent();
        if (parent instanceof EditorHeaderComponent) {
            parent.setVisible(state2);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(18);
        }
        return ToggleToolbarAction.isToolbarVisible(property, PropertiesComponent.getInstance());
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull Project project2) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(20);
        }
        return ToggleToolbarAction.isToolbarVisible(property, PropertiesComponent.getInstance((Project)project2));
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull PropertiesComponent properties) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(21);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(22);
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(property));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow2) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(23);
        }
        return ToggleToolbarAction.isToolbarVisible(toolWindow2, PropertiesComponent.getInstance());
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow2, @NotNull Project project2) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(25);
        }
        return ToggleToolbarAction.isToolbarVisible(toolWindow2, PropertiesComponent.getInstance((Project)project2));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow2, @NotNull PropertiesComponent properties) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(26);
        }
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(27);
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow2));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property, @NotNull Supplier<? extends Iterable<? extends JComponent>> producer) {
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(28);
        }
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(29);
        }
        if (producer == null) {
            ToggleToolbarAction.$$$reportNull$$$0(30);
        }
        super(ActionsBundle.messagePointer((String)"action.ShowToolbar.text", (Object[])new Object[0]));
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property;
        this.myProducer = producer;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(31);
        }
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars(this.myProducer.get()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToggleToolbarAction.$$$reportNull$$$0(32);
        }
        return actionUpdateThread;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(33);
        }
        return this.isSelected();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(34);
        }
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, this.myProducer.get(), state2);
    }

    static void setToolbarVisibleImpl(@NotNull String property, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<? extends JComponent> components, boolean visible) {
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(35);
        }
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(36);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(37);
        }
        propertiesComponent.setValue(property, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties, @NotNull String property) {
        if (properties == null) {
            ToggleToolbarAction.$$$reportNull$$$0(38);
        }
        if (property == null) {
            ToggleToolbarAction.$$$reportNull$$$0(39);
        }
        return properties.getBoolean(property, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        if (window == null) {
            ToggleToolbarAction.$$$reportNull$$$0(40);
        }
        return ToggleToolbarAction.getShowToolbarProperty("ToolWindow." + window.getId());
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull @NonNls String s) {
        if (s == null) {
            ToggleToolbarAction.$$$reportNull$$$0(41);
        }
        String string = s + ".ShowToolbar";
        if (string == null) {
            ToggleToolbarAction.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<? extends JComponent> roots) {
        JBIterable jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots)).preOrderDfsTraversal().filter(ActionToolbar.class).filter(toolbar2 -> {
            JComponent c = toolbar2.getComponent();
            return !Boolean.TRUE.equals(c.getClientProperty("ActionToolbarImpl.importantToolbar")) && !(c instanceof FloatingToolbarComponent);
        });
        if (jBIterable == null) {
            ToggleToolbarAction.$$$reportNull$$$0(43);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 32, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 22: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 29: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 32: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowToolbarProperty";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateToolbars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToggleToolbarGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateToolbarsVisibility";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateToolbarVisibility";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisible";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isToolbarVisible";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 32: 
            case 42: 
            case 43: {
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisibleImpl";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedImpl";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getShowToolbarProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 32, 42, 43 -> new IllegalStateException(string);
        };
    }

    private static final class OptionsGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        OptionsGroup(ToolWindow toolWindow2) {
            this.getTemplatePresentation().setText(IdeBundle.message((String)"group.view.options", (Object[])new Object[0]));
            this.myToolWindow = toolWindow2;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OptionsGroup.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (e.getPresentation().isVisible()) {
                int trimmedSize = ActionGroupUtil.getVisibleActions((ActionGroup)this, e).take(4).size();
                e.getPresentation().setPopupGroup(trimmedSize > 3);
            }
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            boolean popup2;
            if (e == null) {
                if (EMPTY_ARRAY == null) {
                    OptionsGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            UpdateSession updateSession = e.getUpdateSession();
            List groups = (List)updateSession.compute((Object)this, "collectActionGroups", ActionUpdateThread.EDT, this::collectActionGroups);
            if (groups.isEmpty()) {
                if (EMPTY_ARRAY == null) {
                    OptionsGroup.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (ActionGroup group2 : groups) {
                Iterable actions = updateSession.expandedChildren(group2);
                for (AnAction action2 : actions) {
                    if (action2 instanceof ToggleAction && !result2.contains(action2)) {
                        result2.add(action2);
                        continue;
                    }
                    if (!(action2 instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem(result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean bl = popup2 = ContainerUtil.count(result2, it -> !(it instanceof Separator)) > 3;
            if (!popup2 && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            AnAction[] anActionArray = result2.toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                OptionsGroup.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private @Unmodifiable @NotNull List<ActionGroup> collectActionGroups() {
            JComponent contentComponent;
            ContentManager contentManager = this.myToolWindow.getContentManagerIfCreated();
            Content selectedContent = contentManager == null ? null : contentManager.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent == null ? null : selectedContent.getComponent();
            if (contentComponent == null) {
                List<ActionGroup> list2 = Collections.emptyList();
                if (list2 == null) {
                    OptionsGroup.$$$reportNull$$$0(4);
                }
                return list2;
            }
            List list3 = JBIterable.from(ToggleToolbarAction.iterateToolbars(Collections.singletonList(contentComponent))).filterMap(toolbar2 -> {
                JComponent c = toolbar2.getComponent();
                if (c.isVisible() || !c.isValid()) {
                    return null;
                }
                return toolbar2.getActionGroup();
            }).toList();
            if (list3 == null) {
                OptionsGroup.$$$reportNull$$$0(5);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectActionGroups";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

